/**************************************
   module : kk.c
   usage  : CvO
***************************************/
#define INCL_WIN                       /* PM function      */
#define INCL_DOSPROCESS                /* Process and thread */
#define INCL_DOSSESMGR
#define INCL_DOSMEMMGR                 /* Memory function  */
#define INCL_DOSFILEMGR                /* Files function   */
#define INCL_WIN_SHELLDATA			   /* Profile */
#define INCL_WINSTDFONT  			   /* EBhEWtHg@\     */
#include "os2.h"
#include "string.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "memory.h"
#include "kk.h"

#define  EOF_CODE		0x1a
#define  TEXT_SIZE		64000L
#define  EDMAX			50
#define  TITLE_POS      23
#define  START_FOLDER   "INBOX"
#define  MQUEUE_FOLDER  "MQUEUE"
#define  RESERVE_FOLDER "RESERVE"
#define  MODE_FOLOW     0
#define  MODE_RESERVE   1
#define  PRFAPP			"KABE"
#define  PRFKEY_DIR     "DIR"
#define  PRFKEY_SWP  	"SWP"
#define  PRFKEY_FONT    "FONT"
#define  PRFKEY_COLOR   "COLOR"
#define  PRFKEY_EXTDATA "ED"
#define  PRFKEY_EXTCNT  "EDCNT"
#define  PRFKEY_DECODE  "DECODE"
#define  PRFKEY_WIN		"WIN"

typedef struct AllSwp {
    SWP    swpMain;
    SWP    swpList;
    SWP    swpEntry;
} ASWP;

typedef struct FolderDir {
    char   szKabeFolder[256];
    char   szMqueFolder[256];
    char   szMyFrom[128];
    char   szPrefix[64];
    char   szSigFile[256];
    char   szEditor[256];
    char   szLinkApp[256];
    char   szFiller[576];
} FOLDIR;

typedef struct EntryColor {
    LONG   TextColor;
    LONG   BackColor;
} CO;

typedef struct WinSetting {
	BOOL   flgVirt;
    UINT   uTitleSize;
    BOOL   flgPopup;
    BOOL   flgReserve;
    UINT   uCurTitlePos;
} WS;

typedef struct ExtractData {
    char   szJyoken[64];
    char   szFolder[64];
} EXTDATA;

typedef struct DecodeProg {
    char   szISH[256];
    char   szUUDECODE[256];
    char   szMIME[256];
    char   szDecodeDir[256];
    char   szBINHEX[256];
} DECPROG;


/* ProtType */
MRESULT EXPENTRY subClassMleWndProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY subClassListWndProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY ClientWndProc(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY AboutDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY ReserveDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY OptionDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY OptDirDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY FolderDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY ExtractDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY MoveDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY NewfolderDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY DelfolderDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY DecodeDlg(HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY Extract2Dlg(HWND, ULONG, MPARAM, MPARAM);

VOID   AppMain(HAB);                   /* PMC */
VOID   AppTitle();                     /*  */
VOID   MoveControls(HWND);             /* Rg[ړ */
VOID   GetProfile(INT, PCHAR *);
VOID   ImportText();
VOID   LoadText();					   /* t@Cǂݍ */
VOID   LoadTitle();
INT    StripSpaceLength(PCHAR);
VOID   FolowMake(UINT);
VOID   NewPost();
VOID   ArticleFlagON(PCHAR);
VOID   ToMake(PCHAR, PCHAR);
UINT   GetNumberPms(PCHAR, PCHAR);
VOID   PutNumberPms(PCHAR, UINT);
VOID   PutFirstPms(PCHAR, UINT);
BOOL   StartEditor(PCHAR);
BOOL   iskanji(UCHAR);
BOOL   iskanji2(UCHAR);
VOID   ThreadLoadTitle();
BOOL   GetArticle(PCHAR, BOOL);
BOOL   ReadArticle(PCHAR);
BOOL   MoveArticle(PCHAR, PCHAR);
VOID   Renumber();
VOID   ThreadRenumber();
BOOL   StartLinkApp();
VOID   Folder2Listbox(HWND);
UINT   LoadED(EXTDATA *);
VOID   Extract(BOOL);
VOID   ThreadExtract();
VOID   SendAll();
VOID   EditArticle();
VOID   DeleteArticle();
VOID   BaseTitle();
BOOL   TitleSort();
BOOL   StartDecoder(PCHAR);
UINT   GetSelectIndex(UINT, UINT *);
BOOL   SetSelectIndex(UINT);

/* Grobal */
PFNWP  oldMleWndProc;
PFNWP  oldListWndProc;
HWND   hFrameWnd;                      /* Frame Window */
HWND   hClientWnd;                     /* Client Window */
HWND   hEntryWnd;                      /* ̓{bNX */
HWND   hListWnd;
TID    tidThread;		               /* ǂݍ݃XbhID */
HAB    hab;
CHAR   szCurFolder[256];
CHAR   szBaseFolder[256];
CHAR   szIniName[256];
CHAR   szProvider[256];
CHAR   szMoveArticleFile[256];
UINT   uMoveArticleIdx;
PVOID  pvText;						   /* eLXgi[obt@̃AhX */
PCHAR  pszText;
PCHAR  pszRead;
ULONG  ulTextLength;                   /* eLXg */
ASWP   as;							   /* SWP */
FATTRS fattrsEntry;					   /* FONT */
CO     co;
FOLDIR fd;
UINT   uMaxItem;
FILESTATUS3  FileInfoBuf;           /* t@Cobt@[ */
WS     ws;

EXTDATA ed[EDMAX];
UINT    ued;

DECPROG dec;
CHAR    szSubCmd[256];

BOOL   flgProfDir  = TRUE;
BOOL   flgProfSwp  = TRUE;
BOOL   flgProfFont = TRUE;
BOOL   flgProfColor= TRUE;
BOOL   flgProfDecode = TRUE;
BOOL   flgProfWin  = TRUE;

BOOL   flgFirst    = TRUE; 
BOOL   flgOptHdr   = FALSE;
BOOL   flgThread   = FALSE;
BOOL   flgVScroll  = FALSE;
BOOL   flgSelect   = TRUE;
BOOL   flgUseBuf   = FALSE;

/**************************************/
/* Jn                           */
/**************************************/
INT main(INT argc, PCHAR *argv)
{
   HMQ    hmq;
   TID    tidSub;
   APIRET rc;

   /* Av̏ */
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);
   GetProfile(argc, argv);
   									 	/* eLXgޔp̃[̊m */
   rc = DosAllocMem(&pvText, TEXT_SIZE, PAG_COMMIT | PAG_READ | PAG_WRITE); 
   if (rc != 0) {
      AppMsg("Can't Allocate Memory");
   } else {
      AppMain(hab);                     /* PMnJn */
      DosFreeMem(pvText);				/* [̊J */
   } /* endif */

   /* I */
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   return 0;
}

/**************************************/
/* vt@C̓ǂ݂             */
/**************************************/
VOID GetProfile(INT argc, PCHAR *argv)
{
   HINI  hini;
   INT   l;
   ULONG ulLen;
   PCHAR prog;

   switch (argc) {
   case 1:
      strcpy(szIniName, argv[0]);
      strcpy(szProvider, APP_TITLE);
      break;
   case 2:
      strcpy(szIniName, argv[0]);
      strcpy(szProvider, argv[1]);
      break;
   default:
      strcpy(szIniName, argv[2]);
      strcpy(szProvider, argv[1]);
      break;
   } /* endswitch */
   l = strlen(szIniName);
   strcpy(szIniName + (l - 3), "INI");

   l = strlen(argv[0]);
   strcpy(szSubCmd, argv[0]);
   strcpy(szSubCmd + (l - 4), "SUB.CMD");

   /* Profile̓ǂ݂ */
   hini = PrfOpenProfile(hab, szIniName);
   if (hini != NULLHANDLE) {
      ulLen = (ULONG)sizeof(as);
      if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_SWP, (PVOID)&as, &ulLen)) 
		 flgProfSwp = FALSE;
      ulLen = (ULONG)sizeof(fattrsEntry);
      if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_FONT, (PVOID)&fattrsEntry, &ulLen)) 
         flgProfFont = FALSE;
      ulLen = (ULONG)sizeof(co);
      if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_COLOR, (PVOID)&co, &ulLen)) 
         flgProfColor = FALSE;
      ulLen = (ULONG)sizeof(fd);
      if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_DIR, (PVOID)&fd, &ulLen)) 
         flgProfDir = FALSE;
      ulLen = (ULONG)sizeof(dec);
      if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_DECODE, (PVOID)&dec, &ulLen)) 
         flgProfDecode = FALSE;
      ulLen = (ULONG)sizeof(ws);
      if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_WIN, (PVOID)&ws, &ulLen)) 
         flgProfWin = FALSE;
      PrfCloseProfile(hini);
   }
}

/**************************************/
/* bZ[W̃[v                 */
/**************************************/
VOID AppMain(HAB hab)
{
   QMSG    qmsg;                       /* bZ[Wi[GA */
   ULONG   ulStyle;                    /* EChEX^C */

   /* t[EChENX̓o^ */
   if (!WinRegisterClass(hab, APP_FRAMECLASS, (PFNWP)ClientWndProc, CS_SIZEREDRAW, 0)){
      AppMsg("Can't Register Class  App Terminate!");
      return;
   }
   /* t[EChE̐ */
   ulStyle =  FCF_TITLEBAR   | FCF_SYSMENU       | FCF_MINMAX   |
              FCF_SIZEBORDER | FCF_SHELLPOSITION | FCF_TASKLIST |
              FCF_ICON       | /*FCF_ACCELTABLE    |*/ FCF_MENU     |
              WS_VISIBLE;
   hFrameWnd = WinCreateStdWindow(HWND_DESKTOP, WS_ANIMATE, &ulStyle, APP_FRAMECLASS,
                                  APP_TITLE, 0, NULLHANDLE, ID_FRAMEWIN, &hClientWnd);
   if (hFrameWnd == NULLHANDLE) {
      AppMsg("Can't Create Frame Window  App Terminate!");
      return;
   }

   /* Rg[쐬 */
   hListWnd  = WinCreateWindow(hClientWnd, WC_LISTBOX, NULL,
                               LS_MULTIPLESEL | LS_EXTENDEDSEL |
                               ES_LEFT | ES_AUTOSCROLL | WS_TABSTOP | WS_VISIBLE,
                               10, 140, 240, 80, hClientWnd, HWND_TOP,
                               IDC_LIST, NULL, NULL);
   if (hListWnd == NULLHANDLE) {
      AppMsg("Can't Create Controls  App Terminate!");
      return;
   }
   oldListWndProc = WinSubclassWindow(hListWnd, (PFNWP)subClassListWndProc);

   hEntryWnd = WinCreateWindow(hClientWnd, WC_MLE, NULL,
                               MLS_BORDER | MLS_WORDWRAP| MLS_IGNORETAB | MLS_READONLY |
                               ES_LEFT | ES_AUTOSCROLL | WS_TABSTOP | WS_VISIBLE,
                               10, 140, 240, 80, hClientWnd, HWND_TOP,
                               IDC_ENTRY, NULL, NULL);
   if (hEntryWnd == NULLHANDLE) {
      AppMsg("Can't Create Controls  App Terminate!");
      return;
   }
   oldMleWndProc = WinSubclassWindow(hEntryWnd, (PFNWP)subClassMleWndProc);

   /* EChEvVWJn */
   WinShowWindow(hFrameWnd, TRUE);     /* EChE\AtH[JX𓖂Ă */
   WinSetFocus(HWND_DESKTOP, hEntryWnd);

   /* WM_QUIT܂ŃbZ[W[v */
   while (WinGetMsg(hab, &qmsg, 0, 0, 0)){
      WinDispatchMsg(hab, &qmsg);
   }

   WinDestroyWindow(hFrameWnd);        /* t[EChE̔j */
}

/**************************************/
/* MLEsubClass̃R[obN֐    */
/**************************************/
MRESULT EXPENTRY subClassMleWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   SHORT  flg, key;

   switch (msg) {
   case WM_BUTTON2UP:
      if (ws.flgPopup)
         WinPostMsg(hClientWnd, msg, mp1, mp2);
      return 0;
   case WM_CHAR:
      flg = SHORT1FROMMP(mp1);
      if (flg & KC_KEYUP)                  /* L[Abv͖ */
         break;
      if ((flg & KC_VIRTUALKEY)) {
         switch (SHORT2FROMMP(mp2)) {
         case VK_DELETE:
         case VK_INSERT:
            WinPostMsg(hClientWnd, msg, mp1, mp2);
            break;
         case VK_TAB:
            WinSetFocus(hListWnd, TRUE);
            return 0;
         default :
            break;
         }
	  }
      break;
   default: 
      break;
   }
   return oldMleWndProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* ListsubClass̃R[obN֐   */
/**************************************/
MRESULT EXPENTRY subClassListWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   SHORT  flg, key;

   switch (msg) {
   case WM_CHAR:
      flg = SHORT1FROMMP(mp1);
      if (flg & KC_KEYUP)                  /* L[Abv͖ */
         break;
      if ((flg & KC_VIRTUALKEY)) {
         switch (SHORT2FROMMP(mp2)) {
         case VK_SPACE:
            WinPostMsg(hClientWnd, msg, mp1, mp2);
            return 0;
         case VK_TAB:
            WinSetFocus(hEntryWnd, TRUE);
            return 0;
         default :
            break;
         }
	  }
      WinPostMsg(hClientWnd, msg, mp1, mp2);
      break;
   default:
      break;
   }
   return oldListWndProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* NCAg̃R[obN֐     */
/**************************************/
MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   /*
      t[EChEvVWłB
   */
   HPS    hps;
   HINI   hini;
   SHORT  flg, key;
   UINT   uIdx, uIdx2;
   CHAR   buf[1024];
   /* POPUPj[ */
   HWND    hMenu;                      /* j[̃nh */
   PPOINTS ppts;                       /* }EX̃|Cg */
   ULONG   flOpt;


   switch (msg) {
   case WM_CREATE:
      WinPostMsg(hwnd, WUM_LOADTEXT, 0, 0);
      break;
   case WM_CLOSE:
      if (flgThread)
         return 0;
      break;
   case WM_ERASEBACKGROUND :           /* wi̍ĕ` */
      return MRFROMLONG(TRUE);
   case WM_SIZE :                      /* TCYύX */
      MoveControls(hwnd);
      break;
   case WM_BUTTON2UP:
      if (flgThread)
         return 0;
      ppts  = (PPOINTS)&mp1;
      flOpt = PU_SELECTITEM | PU_NONE | PU_KEYBOARD | PU_MOUSEBUTTON1 |
              PU_HCONSTRAIN | PU_VCONSTRAIN;
      if (stricmp(szCurFolder, RESERVE_FOLDER) == 0){
         hMenu = WinLoadMenu(hFrameWnd, NULLHANDLE, IDM_POPUP2);
         WinPopupMenu(hFrameWnd, hFrameWnd, hMenu, ppts->x, ppts->y, ID_EDIT_SND, flOpt);
      }
      else{
         hMenu = WinLoadMenu(hFrameWnd, NULLHANDLE, IDM_POPUP);
         WinPopupMenu(hFrameWnd, hFrameWnd, hMenu, ppts->x, ppts->y, ID_EDIT_RES, flOpt);
      }
      return 0;
   case WM_CONTROL:
      switch (SHORT1FROMMP(mp1)) {
      case IDC_LIST:
         switch (SHORT2FROMMP(mp1)) {
         case LN_SELECT:
            if (flgSelect)
               LoadText();
            break;
         default:
           break;
         } /* endswitch */
         break;
      case IDC_ENTRY:
         switch (SHORT2FROMMP(mp1)) {
         case MLN_VSCROLL:
            if (flgVScroll && (mp2 + 1) == WinSendMsg(hEntryWnd, MLM_QUERYLINECOUNT, 0, 0)){
               uIdx = (UINT)WinSendMsg(hListWnd, LM_QUERYSELECTION, 0, 0) + 1;
               while(TRUE){
                  if (uIdx >= uMaxItem){
                     AppMsg("No Message");
                     break;
                  }
                  WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 1024), (MPARAM)buf);
                  if (buf[0] == '*'){
                     WinSendMsg(hListWnd, LM_SELECTITEM,  MPFROM2SHORT(LIT_NONE,   0), 0);
                     uIdx2 = uIdx - ((flgProfWin)? ws.uCurTitlePos : 3);
                     WinSendMsg(hListWnd, LM_SETTOPINDEX, MPFROM2SHORT(uIdx2, 0), 0);
                     WinPostMsg(hListWnd, LM_SELECTITEM,  MPFROM2SHORT(uIdx, 0), MPFROM2SHORT(TRUE, 0));
     		         break;
		          }
		          uIdx++;
               }
            }
			flgVScroll = FALSE;
            break;
         default:
            break;
         } /* endswitch */
         break;
      default:
        break;
      } /* endswitch */
      break;
   case WM_CHAR:
      flg = SHORT1FROMMP(mp1);
      if (flg & KC_KEYUP)                  /* L[Abv͖ */
         break;
      if ((flg & KC_VIRTUALKEY)) {
         switch (SHORT2FROMMP(mp2)) {
         case VK_SPACE:
            flgVScroll = TRUE;
            WinPostMsg(hEntryWnd, WM_VSCROLL, 0, MPFROM2SHORT(0, SB_PAGEDOWN));
            break;
         case VK_DELETE:
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_DELETE, 0), 0);
            break;
         case VK_INSERT:
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_MOVE, 0), 0);
            break;
         default :
            break;
         }
	  }
	  else {
         key = toupper(SHORT1FROMMP(mp2));
         switch (key) {
         case 'F':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_RES, 0), 0);
            break;
         case 'R':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_RSV, 0), 0);
            break;
         case 'H':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_HDR, 0), 0);
            break;
         case 'N':
            uIdx = GetSelectIndex(0, &uIdx2);
            uIdx++;
            if (uIdx < uMaxItem){
               SetSelectIndex(uIdx);
            }
            break;
         case 'P':
            uIdx = GetSelectIndex(0, &uIdx2);
            if (uIdx > 0){
               uIdx--;
               SetSelectIndex(uIdx);
            }
            break;
         case 'T':
            SetSelectIndex(0);
            break;
         case 'B':
            SetSelectIndex(uMaxItem - 1);
            break;
         case 'Q':
            AppClose();
            break;
         case 'O':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_FILE_FOLDER, 0), 0);
            break;
         case 'L':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_FILE_LINK, 0), 0);
            break;
         case 'D':
            WinPostMsg(hListWnd, WM_VSCROLL, MPFROM2SHORT(FID_VERTSCROLL, 0), MPFROM2SHORT(0, SB_PAGEDOWN));
            break;
         case 'U':
            WinPostMsg(hListWnd, WM_VSCROLL, 0, MPFROM2SHORT(0, SB_PAGEUP));
            break;
         case 'E':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_EDIT, 0), 0);
            break;
         case 'S':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_EDIT_SND, 0), 0);
            break;
         case 'I':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_FILE_LOAD, 0), 0);
            break;
         case 'M':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_FILE_MQUE, 0), 0);
            break;
         case 'Z':
            WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_FILE_RESV, 0), 0);
            break;
         default: 
           break;
         } /* endswitch */
      }
      break;
   case WM_COMMAND :
      switch (SHORT1FROMMP(mp1)) {
      case ID_FILE_LOAD:
         if (!flgThread){
            strcpy(szCurFolder, START_FOLDER);
            LoadTitle();
         }
         return 0;
      case ID_FILE_RESV:
         if (!flgThread){
            strcpy(szCurFolder, RESERVE_FOLDER);
            LoadTitle();
         }
         return 0;
      case ID_FILE_MQUE:
         if (!flgThread){
            strcpy(szCurFolder, MQUEUE_FOLDER);
            LoadTitle();
         }
         return 0;
      case ID_FILE_QUITN:              /* ʏ̏I */
         AppClose();
         return 0;
      case ID_FILE_CATCH:
         uIdx  = 0;
         uIdx2 = (UINT)WinSendMsg(hListWnd, LM_QUERYSELECTION, 0, 0) + 1;
         while(TRUE){
           if (uIdx >= uIdx2)
              break;
           WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 1024), (MPARAM)buf);
           if (buf[0] == '*'){
              SetSelectIndex(uIdx);
		   }
		   uIdx++;
         }
         return 0;
      case ID_FILE_FOLDER:
         if (flgThread)
            return 0;
         if (WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)FolderDlg, NULLHANDLE, IDD_FOLDER, NULL)
		     == DID_OK){
            LoadTitle();
         }
		 return 0;
	  case ID_FILE_RENUM:
		 Renumber();		 
         return 0;
      case ID_FILE_EXTRACT:
         Extract(TRUE);
         return 0;
      case ID_FILE_LINK:
         if (!(strlen(fd.szLinkApp) > 0 && StartLinkApp()))
            AppMsg("Invalid LinkApp");
         return 0;
      case ID_FILE_SORT:
         if (!flgThread && TitleSort())
            LoadTitle();
         return 0;
      case ID_FILE_NEWFOLDER:
         WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)NewfolderDlg, NULLHANDLE, IDD_NEWFOLDER, NULL);
         return 0;
      case ID_FILE_DELFOLDER:
         WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)DelfolderDlg, NULLHANDLE, IDD_DELFOLDER, NULL);
         return 0;
      case ID_FILE_EXTRACT2:
         if (WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)Extract2Dlg, 
         			   NULLHANDLE, IDD_EXTRACT2, NULL) == DID_OK)
            Extract(FALSE);
         return 0;
      case ID_EDIT_COPY:
         WinSendMsg(hEntryWnd, MLM_COPY, 0L, 0L);
         return 0;
      case ID_EDIT_HDR:
         flgOptHdr = !flgOptHdr;
         ImportText();
         return 0;
      case ID_EDIT_RES:
         FolowMake(MODE_FOLOW);
         return 0;
      case ID_EDIT_RSV:
         if (ws.flgReserve)
            FolowMake(MODE_RESERVE);
         else
            AppMsg("U[u͎g܂");
         return 0;
      case ID_EDIT_NEW:
         NewPost();
         return 0;
      case ID_EDIT_EDIT:
         EditArticle();
         return 0;
      case ID_EDIT_DELETE:
         DeleteArticle();
         return 0;
      case ID_EDIT_MOVE:
         uIdx = GetSelectIndex(0, &uIdx2);
         if (uIdx == LIT_NONE){
            AppMsg("No Select Article!");
            return;
         }
         sprintf(szMoveArticleFile, "%s%d", szBaseFolder, uIdx2);
         uMoveArticleIdx = uIdx;
         WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)MoveDlg, NULLHANDLE, IDD_MOVE, NULL);
         return 0;
      case ID_EDIT_SND:
         if (stricmp(szCurFolder, RESERVE_FOLDER) == 0){
            uIdx = GetSelectIndex(0, &uIdx2);
            if (uIdx == LIT_NONE){
               AppMsg("No Select Article!");
               return;
            }
            sprintf(szMoveArticleFile, "%s%d", szBaseFolder, uIdx2);
            if (MoveArticle(szMoveArticleFile, fd.szMqueFolder)){
               WinSendMsg(hListWnd, LM_DELETEITEM, MPFROM2SHORT(uMoveArticleIdx, 0), 0);
               BaseTitle();
               if (!SetSelectIndex(uMoveArticleIdx))
                  WinSetWindowText(hEntryWnd, "");
            }
            else
               AppMsg("Can't Move Article");
         }
         return 0;
      case ID_EDIT_SNDALL:
         SendAll();
         return 0;
      case ID_EDIT_ISH:
         StartDecoder(dec.szISH);
         return 0;
      case ID_EDIT_UUDECODE:
         StartDecoder(dec.szUUDECODE);
         return 0;
      case ID_EDIT_MIME:
         StartDecoder(dec.szMIME);
         return 0;
      case ID_EDIT_BINHEX:
         StartDecoder(dec.szBINHEX);
         return 0;
      case ID_OPTIONS_SET:
         if (WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)OptionDlg, NULLHANDLE, IDD_OPTIONS, NULL)
             == DID_OK) {
             hini = PrfOpenProfile(hab, szIniName);
             if (hini != NULLHANDLE) {
                 PrfWriteProfileData(hini, PRFAPP, PRFKEY_WIN, (PVOID)&ws, sizeof(ws));
                 PrfCloseProfile(hini);
                 flgProfWin = TRUE;
             }
             WinSendMsg(hwnd, WM_SIZE, 0, 0);
             WinShowWindow(hwnd, FALSE);
             WinShowWindow(hwnd, TRUE);
             WinSendMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_OPTIONS_POS, 0), 0);
		 }
/*
         WinSendMsg(hEntryWnd, MLM_QUERYFONT, &fattrsEntry, 0);
         co.TextColor = (LONG)WinSendMsg(hEntryWnd, MLM_QUERYTEXTCOLOR, 0, 0);
         co.BackColor = (LONG)WinSendMsg(hEntryWnd, MLM_QUERYBACKCOLOR, 0, 0);
         if (WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)OptionDlg, NULLHANDLE, IDD_OPTIONS, NULL)
             == DID_OK) {
             WinSendMsg(hEntryWnd, MLM_SETFONT, &fattrsEntry, 0);
             WinSendMsg(hEntryWnd, MLM_SETTEXTCOLOR, (MPARAM)co.TextColor, 0);
             WinSendMsg(hEntryWnd, MLM_SETBACKCOLOR, (MPARAM)co.BackColor, 0);
             hini = PrfOpenProfile(hab, szIniName);
             if (hini != NULLHANDLE) {
                 PrfWriteProfileData(hini, PRFAPP, PRFKEY_FONT, (PVOID)&fattrsEntry, sizeof(fattrsEntry));
                 PrfWriteProfileData(hini, PRFAPP, PRFKEY_COLOR, (PVOID)&co, sizeof(co));
                 PrfCloseProfile(hini);
                 AppMsg("Success(^^");
             }
   		 }
*/
         return 0;
      case ID_OPTIONS_DIR:
         if (WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)OptDirDlg, NULLHANDLE, IDD_OPTDIR, NULL)
             == DID_OK) {
            hini = PrfOpenProfile(hab, szIniName);
            if (hini != NULLHANDLE) {
      		   PrfWriteProfileData(hini, PRFAPP, PRFKEY_DIR, (PVOID)&fd, sizeof(fd));
               PrfCloseProfile(hini);
               flgProfDir = TRUE;
            }
            LoadTitle();
         }
         return 0;
      case ID_OPTIONS_POS:
         WinQueryWindowPos(hFrameWnd, (PSWP)&as.swpMain);
         WinQueryWindowPos(hListWnd, (PSWP)&as.swpList);
         WinQueryWindowPos(hEntryWnd, (PSWP)&as.swpEntry);
         hini = PrfOpenProfile(hab, szIniName);
         if (hini != NULLHANDLE) {
      		PrfWriteProfileData(hini, PRFAPP, PRFKEY_SWP, (PVOID)&as, sizeof(as));
            PrfCloseProfile(hini);
            AppMsg("Success(^^");
         }
         return 0;
      case ID_OPTIONS_EXT:
         WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)ExtractDlg, NULLHANDLE, IDD_EXTRACT, NULL);
         return 0;
      case ID_OPTIONS_DECODE:
         if (WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)DecodeDlg, NULLHANDLE, IDD_DECODE, NULL)
             == DID_OK) {
            hini = PrfOpenProfile(hab, szIniName);
            if (hini != NULLHANDLE) {
      		   PrfWriteProfileData(hini, PRFAPP, PRFKEY_DECODE, (PVOID)&dec, sizeof(dec));
               PrfCloseProfile(hini);
               flgProfDecode = TRUE;
            }
         }
         return 0;
      case ID_HELP_VER:                /* o[W\ */
         WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)AboutDlg, NULLHANDLE, IDD_ABOUT, NULL);
         return 0;
      case ID_HELP_KEY:
         WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)AboutDlg, NULLHANDLE, IDD_KEYHELP, NULL);
         return 0;
      default:
        break;
      } /* endswitch */
      break;
   case WUM_LOADTEXT:
	  if (flgProfDir) {
         WinSendMsg(hListWnd, WM_PAINT, 0, 0);
         WinSendMsg(hEntryWnd, WM_PAINT, 0, 0);
         WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_FILE_LOAD, 0), 0);
      }
      else {
         WinPostMsg(hwnd, WM_COMMAND, MPFROM2SHORT(ID_OPTIONS_DIR, 0), 0);
      }
      strcpy(szCurFolder, START_FOLDER);
      return 0;
   default: 
      break;
   } /* endswitch */

    return WinDefWindowProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* {̃^Cg\           */
/**************************************/
VOID BaseTitle()
{
   CHAR   buf[256];

   uMaxItem = (UINT)WinSendMsg(hListWnd, LM_QUERYITEMCOUNT, 0, 0);
   sprintf(buf, "%s <%s>   %d articles", szProvider, szCurFolder, uMaxItem);
   WinSetWindowText(hFrameWnd, buf);
}

/**************************************/
/* IꂽCfbNXԂ       */
/**************************************/
UINT GetSelectIndex(UINT uStartIndex, UINT *puFileIndex)
{
   CHAR buf[256];
   UINT uIdx;

   if (uStartIndex == 0)
      uStartIndex = LIT_FIRST;
   uIdx = (UINT)WinSendMsg(hListWnd, LM_QUERYSELECTION, MPFROM2SHORT(uStartIndex, 0), 0);
   if (uIdx == LIT_NONE)
      return LIT_NONE;

   WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)buf);
   buf[6] = 0;
   *puFileIndex = atoi(buf + 1);

   return uIdx;
}

/**************************************/
/* PI                       */
/**************************************/
BOOL SetSelectIndex(UINT uIndex)
{
  UINT uTopIdx;

   WinSendMsg(hListWnd, LM_SELECTITEM,  MPFROM2SHORT(LIT_NONE,   0), 0);
   if (flgProfWin)
      uTopIdx = uIndex - ws.uCurTitlePos;
   else
      uTopIdx = uIndex - 3;
   WinSendMsg(hListWnd, LM_SETTOPINDEX, MPFROM2SHORT(uTopIdx, 0), 0);
   return (BOOL)WinSendMsg(hListWnd, LM_SELECTITEM, MPFROM2SHORT(uIndex, 0), MPFROM2SHORT(TRUE, 0));
}

/**************************************/
/* Rg[ړ             */
/**************************************/
VOID MoveControls(HWND hwnd)
{
   RECTL  ClientRect;
   ULONG  ulX, ulY;

   if (flgProfFont) {
      WinSendMsg(hEntryWnd, MLM_SETFONT, &fattrsEntry, 0);
      flgProfFont = FALSE;
   }
   if (flgProfColor) {
      WinSendMsg(hEntryWnd, MLM_SETTEXTCOLOR, (MPARAM)co.TextColor, 0);
      WinSendMsg(hEntryWnd, MLM_SETBACKCOLOR, (MPARAM)co.BackColor, 0);
      flgProfColor = FALSE;
   }
   if (flgProfSwp) {						/* ʒuLĂꍇ */
      WinSetWindowPos(hFrameWnd, HWND_TOP,
                      as.swpMain.x, as.swpMain.y, as.swpMain.cx, as.swpMain.cy,
                      SWP_SIZE | SWP_MOVE | SWP_SHOW);
      WinSetWindowPos(hEntryWnd, HWND_TOP,
                      as.swpEntry.x, as.swpEntry.y, as.swpEntry.cx, as.swpEntry.cy,
                      SWP_SIZE | SWP_MOVE | SWP_SHOW);
      WinSetWindowPos(hListWnd, HWND_TOP,
                      as.swpList.x, as.swpList.y, as.swpList.cx, as.swpList.cy,
                      SWP_SIZE | SWP_MOVE | SWP_SHOW);
      flgProfSwp = FALSE;
   }
   else {									/* LĂȂꍇ */
      if (!flgProfWin) {
         ws.flgVirt    = FALSE;
         ws.uTitleSize = 35;
	  }
      WinQueryWindowRect(hClientWnd, &ClientRect);
      if (ws.flgVirt) {
         ulX = (ClientRect.xRight - 15) *  ws.uTitleSize / 100;
         WinSetWindowPos(hEntryWnd, HWND_TOP,
                         ulX + 10, 5,
                         ClientRect.xRight - (ulX + 15), ClientRect.yTop - 10,
                         SWP_SIZE | SWP_MOVE | SWP_SHOW);

         WinSetWindowPos(hListWnd, HWND_TOP,
                         5, 5,
                         ulX, ClientRect.yTop - 10,
                         SWP_SIZE | SWP_MOVE | SWP_SHOW);
      }
      else {
         ulY = (ClientRect.yTop - 15) * (100 - ws.uTitleSize) / 100;
         WinSetWindowPos(hEntryWnd, HWND_TOP,
                         5, 5,
                         ClientRect.xRight - 10, ulY,
                         SWP_SIZE | SWP_MOVE | SWP_SHOW);
         WinSetWindowPos(hListWnd, HWND_TOP,
                         5, ulY + 10,
                         ClientRect.xRight - 10, ClientRect.yTop - (ulY + 15),
                         SWP_SIZE | SWP_MOVE | SWP_SHOW);
      }
   }
}

/**************************************/
/* ^Cg̓ǂ݂@@@@@@@   */
/**************************************/
VOID LoadTitle()
{
   if (flgThread)
      return;
   WinSetWindowText(hEntryWnd, "");
   sprintf(szBaseFolder, "%s%s", fd.szKabeFolder, szCurFolder);
   if (szBaseFolder[strlen(szBaseFolder) - 1] != '\\')
      strcat(szBaseFolder, "\\");
   DosCreateThread(&tidThread, ThreadLoadTitle, 0, 0, 65536);
}

/**************************************/
/*^Cgǂݍ݃Xbh            */
/**************************************/
VOID ThreadLoadTitle()
{
   HAB   hab;
   HMQ   hmq;
   BOOL  rc;
   UINT	 uFcnt, uIdx, uPms, uPar;
   INT   nTop;
   BOOL  flgSubj, flgFrom, flgInbox, flgNextSubj, flgHdr;
   CHAR  c;
   CHAR  szFName[256], buf[1024];
   CHAR  szSubj[256], szFrom[256];

   /* PMAv̏ */
   flgThread = TRUE;
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);

   if (stricmp(szCurFolder, START_FOLDER)   == 0 ||
       stricmp(szCurFolder, RESERVE_FOLDER) == 0)
      flgInbox = TRUE;
   else
      flgInbox = FALSE;
   /* ^Cg̓ǂݍݏ */
   WinSendMsg(hListWnd, LM_DELETEALL, 0, 0);
   uIdx   = 0;
   nTop   = -1;
   uPms   = GetNumberPms(szBaseFolder, buf);
   for (uFcnt = 1; uFcnt < uPms; uFcnt++) {
      sprintf(szFName, "%s%d", szBaseFolder, uFcnt);
      if (GetArticle(szFName, FALSE)) {
         flgSubj = flgFrom = FALSE;
         flgNextSubj = FALSE;
         StrEmpty(szSubj);
         StrEmpty(szFrom);
         while(ReadArticle(buf)){
            if (flgNextSubj){
               flgNextSubj = FALSE;
               flgSubj     = TRUE;
               if (buf[0] == ' ')
                  strcat(szSubj, buf + 1);
            }
            if (strnicmp(buf, "SUBJECT: ", 9) == 0){
               strcpy(szSubj, buf + 9);
               flgNextSubj = TRUE;
            }
            if (strnicmp(buf, "FROM: ", 6) == 0){
               strcpy(szFrom, buf + 6);
               flgFrom = TRUE;
            }
            if (flgSubj && flgFrom)
               break;
         }
         if (FileInfoBuf.ftimeCreation.twosecs == 0 && FileInfoBuf.ftimeLastWrite.twosecs == 29){
            c = ' ';
            if (stricmp(szCurFolder, RESERVE_FOLDER) == 0)
               c = '#';
         }
         else {
            if (nTop == -1 && !flgInbox)
               nTop = uIdx;
            c = '*';
            if (stricmp(szCurFolder, RESERVE_FOLDER) == 0)
               c = ' ';
         }
         sprintf(buf, "%c%5d %-15.15s %s", c, uFcnt, szFrom, szSubj);
         WinSendMsg(hListWnd, LM_INSERTITEM, MPFROM2SHORT(uIdx++, 0), (MPARAM)buf);
         if (nTop > -1){
            SetSelectIndex(nTop);
/*
            WinPostMsg(hListWnd, LM_SELECTITEM, MPFROM2SHORT(nTop, 0), MPFROM2SHORT(TRUE, 0));
*/
            nTop = -2;
         }
	  }
      uPar = uFcnt * 100 / uPms;
      if ((uPar % 5) == 0) {
         sprintf(buf, "%s Loading %d %%", szProvider,  uPar);
         WinSetWindowText(hFrameWnd, buf);
      }
   }
   uMaxItem = (UINT)WinSendMsg(hListWnd, LM_QUERYITEMCOUNT, 0, 0);
   if (nTop == -1 && !flgInbox){
      SetSelectIndex(uMaxItem - 1);
   }
   BaseTitle();
   LoadText();
   /* I */
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   flgThread = FALSE;
   DosExit(EXIT_THREAD, 0L);
}

/**************************************/
/* t@Cǂݍ                 */
/**************************************/
VOID LoadText()
{
   UINT	   uFcnt, uIdx;
   CHAR    szFName[256], buf[1024];
   BOOL    flgHdr, flgEA;
									   /* t@CI[v */
   uIdx = GetSelectIndex(0, &uFcnt);
   if (uIdx == LIT_NONE) {
      WinSetWindowText(hEntryWnd, "");
      return;
   }
   WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 1024), (MPARAM)buf);
   if (buf[0] == '*') {
      buf[0] = ' ';
      WinSendMsg(hListWnd, LM_SETITEMTEXT, MPFROM2SHORT(uIdx, 0), (MPARAM)buf);
   }
   sprintf(szFName, "%s%d", szBaseFolder, uFcnt);

   if (stricmp(szCurFolder, RESERVE_FOLDER) == 0)
      flgEA = FALSE;
   else
      flgEA = TRUE;

   if (GetArticle(szFName, flgEA)) {
      flgHdr  = FALSE;
      while(ReadArticle(buf)) {
         if (strlen(buf) > 0) {
            if (flgHdr){
               if (StripSpaceLength(buf) == 0)
                  break;
			}
            else
		       flgHdr = TRUE;
         }
         else {
            if (flgHdr)
               break;
         }
      }
      pszText = pszRead;
   }
   ImportText();
}


/**************************************/
/* Xy[XȊO̕Ԃ         */
/**************************************/
INT StripSpaceLength(PCHAR pszStr)
{
   PCHAR ps;
   INT   len;

   len = 0;
   ps = pszStr;
   while(*ps != 0){
      if (*ps != ' ')
         len++;
      ps++;
   }
   return len;
}


/**************************************/
/* TextBufferMLEɎ荞        */
/**************************************/
VOID ImportText()
{
   IPT  ipt = -1;

   WinSetWindowText(hEntryWnd, "");
   if (flgOptHdr){
      WinSendMsg(hEntryWnd, MLM_SETIMPORTEXPORT, (MPARAM)pvText, (MPARAM)TEXT_SIZE);
      WinSendMsg(hEntryWnd, MLM_IMPORT, (MPARAM)&ipt, MPFROMLONG(ulTextLength));
   }
   else {
      WinSendMsg(hEntryWnd, MLM_SETIMPORTEXPORT, (MPARAM)pszText, (MPARAM)TEXT_SIZE);
      WinSendMsg(hEntryWnd, MLM_IMPORT, (MPARAM)&ipt, MPFROMLONG(ulTextLength - (pszText - (PCHAR)pvText)));
   }
   /*
   WinSetFocus(HWND_DESKTOP, hEntryWnd);
   */
}

/**************************************/
/* tH[t@C̍쐬             */
/**************************************/
VOID FolowMake(UINT FolowMode)
{
   PCHAR   pszFolowFolder, pszT;
   CHAR    szReserveFolder[256];
   CHAR    szFOLOW[256], buf[512], buf2[512], buf3[512];
   CHAR    szYourFrom[256], szYourReplyto[256], szSubject[256];
   CHAR    szMessageID[128];
   BOOL    flgHdr, flgBody, flgNextSubj;
   FILE    *fp, *fpsig;

   if (flgThread)
      return;

   /* tH[t@C̃I[v */
   if (FolowMode == MODE_FOLOW){
      pszFolowFolder = fd.szMqueFolder;
   }
   else {
      sprintf(szReserveFolder, "%s%s\\", fd.szKabeFolder, RESERVE_FOLDER);
      pszFolowFolder = szReserveFolder;
   }
   PutNumberPms(pszFolowFolder, GetNumberPms(pszFolowFolder, szFOLOW) + 1);
   if ((fp = fopen(szFOLOW, "wt")) == NULL){
      AppMsg("Can't Create Folow File");
      return;
   }

   pszRead = (PCHAR)pvText;
   flgHdr  = FALSE;
   flgBody = FALSE;
   StrEmpty(szYourFrom);
   StrEmpty(szYourReplyto);
   StrEmpty(szSubject);
   StrEmpty(szMessageID);
   /* ev[g̍쐬 */
   while(ReadArticle(buf)){
      if (strlen(buf) > 0){							/*** 󔒍słȂ̏ ***/
         if (!flgHdr)								/* wb_Jn */
            flgHdr = TRUE;
         if (flgBody) {                             /* BodysȂPrefixtďo */
            sprintf(buf2, "%s%s\n", fd.szPrefix, buf);
            fputs(buf2, fp);
         }
         else if (flgHdr) {                         /* HeadersȂf[^ۊ */
            if (flgNextSubj){
               flgNextSubj = FALSE;
               if (buf[0] == ' '){
                  strcat(szSubject, buf + 1);
               }
            }
            if (strnicmp(buf, "FROM: ", 6) == 0){
               strcpy(szYourFrom, buf + 6);
            }
            else if (strnicmp(buf, "REPLY-TO: ", 10) == 0){
               strcpy(szYourReplyto, buf + 10);
            }
            else if (strnicmp(buf, "SUBJECT: ", 9) == 0){
               strcpy(szSubject, buf + 9);
               flgNextSubj = TRUE;
            }
            else if (strnicmp(buf, "MESSAGE-ID: ", 12) == 0){
               strcpy(szMessageID, buf + 12);
            }
         }
      }
      else {										/*** 󔒍s̎̏ **/
         if (flgHdr && !flgBody){                   /* {fBJn̎wb_̏o */
            flgBody = TRUE;                         /* {fBJn */
            if (strlen(szYourReplyto) > 0)			/* ReplytoΗD */
               ToMake(szYourReplyto, buf2);
            else
               ToMake(szYourFrom, buf2);
            sprintf(buf, "To: %s\n", buf2);
            fputs(buf, fp);
            fputs("Cc: \nBcc: \nFcc: outbox\n", fp);
            sprintf(buf, "From: %s\n", fd.szMyFrom);
            fputs(buf, fp);
            sprintf(buf, "Subject: Re:%s\n", szSubject);
            fputs(buf, fp);
			if (strlen(szMessageID) > 0) {
               sprintf(buf, "In-Reply-To: %s\n", szMessageID);
               fputs(buf, fp);
			}
            sprintf(buf, "X-Mailer: %s %s\n\n", APP_TITLE, APP_VERSION);
            fputs(buf, fp);
            sprintf(buf, "%s said :\n\n", szYourFrom);
            fputs(buf, fp);
         }
      }
   }

   if (strlen(fd.szSigFile) > 0) {					/* Sign̐ݒ肪鎞 */
      if ((fpsig = fopen(fd.szSigFile, "rt")) != NULL) {
         while (fgets(buf, 512, fpsig) != NULL) {
            fputs(buf, fp);
         }
         fclose(fpsig);
      }
   }
   fclose(fp);

   ArticleFlagON(szFOLOW);
   if (FolowMode == MODE_RESERVE){
      if (WinDlgBox(HWND_DESKTOP, hClientWnd, (PFNWP)ReserveDlg, NULLHANDLE, IDD_RESERVE, NULL)
		     == DID_CANCEL){
         if (!StartEditor(szFOLOW))
            AppMsg("Can't Execute Editor");
      }
   }
   else{ 
     if (!StartEditor(szFOLOW))
        AppMsg("Can't Execute Editor");
   }
}

/**************************************/
/* VK|Xgt@C̍쐬           */
/**************************************/
VOID NewPost()
{
   CHAR    szFOLOW[256], buf[512];
   FILE    *fp, *fpsig;

   if (flgThread)
      return;

   /* tH[t@C̃I[v */
   PutNumberPms(fd.szMqueFolder, GetNumberPms(fd.szMqueFolder, szFOLOW) + 1);
   if ((fp = fopen(szFOLOW, "wt")) == NULL){
      AppMsg("Can't Create Folow File");
      return;
   }
   sprintf(buf, "To: \nBcc: \nFcc: outbox\nFrom: %s\nSubject: \n", fd.szMyFrom);
   fputs(buf, fp);
   sprintf(buf, "X-Mailer: %s %s\n\n", APP_TITLE, APP_VERSION);
   fputs(buf, fp);

   if (strlen(fd.szSigFile) > 0) {					/* Sign̐ݒ肪鎞 */
      if ((fpsig = fopen(fd.szSigFile, "rt")) != NULL) {
         while (fgets(buf, 512, fpsig) != NULL) {
            fputs(buf, fp);
         }
         fclose(fpsig);
      }
   }
   fclose(fp);

   ArticleFlagON(szFOLOW);
   if (!StartEditor(szFOLOW))
      AppMsg("Can't Execute Editor");
}

/**************************************/
/* ArticletOI                  */
/**************************************/
VOID ArticleFlagON(PCHAR pszFile)
{
   APIRET      rc;           /* ߂R[h */
   HFILE       hFile;
   ULONG       Action;

   /* t@CtOItɂ */
   rc = DosOpen(pszFile, &hFile, &Action,  0L, FILE_NORMAL,
                   FILE_OPEN, OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, 0L );
   if (rc != 0)
      return;
   DosQueryFileInfo(hFile, 1, &FileInfoBuf, sizeof(FILESTATUS3));
   FileInfoBuf.ftimeCreation.twosecs  = 0;
   FileInfoBuf.ftimeLastWrite.twosecs = 29;
   rc = DosSetFileInfo(hFile, 1, &FileInfoBuf, sizeof(FILESTATUS3));
   DosClose(hFile);
}

/**************************************/
/* number.pms擾                     */
/**************************************/
UINT GetNumberPms(PCHAR pszFolder, PCHAR pszFile)
{
   CHAR    szPMS[512], buf[256];
   UINT    uNum = 1;
   HFILE   hFile;
   APIRET  rc;
   ULONG   Action;
   FILESTATUS3 fs3;

   sprintf(szPMS, "%s%s", pszFolder, "number.pms");
   rc = DosOpen(szPMS, &hFile, &Action,  0L, FILE_NORMAL,
                FILE_OPEN, OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, 0L );
   if (rc == 0){ 
      DosQueryFileInfo(hFile, 1, &fs3, sizeof(FILESTATUS3));
      DosRead(hFile, buf, fs3.cbFile, &Action );
      DosClose(hFile);
      *(buf + fs3.cbFile) = 0;
      uNum = atoi(buf);
   }
   sprintf(pszFile, "%s%d", pszFolder, uNum);

   return uNum;
}

/**************************************/
/* number.pmsXV                     */
/**************************************/
VOID PutNumberPms(PCHAR pszFolder, UINT uNum)
{
   HFILE   hFile;
   APIRET  rc;
   ULONG   Action, ulWrote;
   CHAR    szPMS[512], buf[256];

   sprintf(szPMS, "%s%s", pszFolder, "number.pms");
   rc = DosOpen(szPMS, &hFile, &Action,  0L, FILE_NORMAL,
			    OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS,          
				OPEN_FLAGS_FAIL_ON_ERROR  | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
        		0L);
   sprintf(buf, "%d", uNum);
   DosWrite(hFile, buf, strlen(buf), &ulWrote);   
   DosClose(hFile);						/* t@CN[Y */
}

/**************************************/
/* first.pmsXV                      */
/**************************************/
VOID PutFirstPms(PCHAR pszFolder, UINT uNum)
{
   HFILE   hFile;
   APIRET  rc;
   ULONG   Action, ulWrote;
   CHAR    szPMS[512], buf[256];

   sprintf(szPMS, "%s%s", pszFolder, "first.pms");
   rc = DosOpen(szPMS, &hFile, &Action,  0L, FILE_NORMAL,
			    OPEN_ACTION_CREATE_IF_NEW | OPEN_ACTION_REPLACE_IF_EXISTS,          
				OPEN_FLAGS_FAIL_ON_ERROR  | OPEN_SHARE_DENYREADWRITE | OPEN_ACCESS_READWRITE,
        		0L);
   sprintf(buf, "%d", uNum);
   DosWrite(hFile, buf, strlen(buf), &ulWrote);   
   DosClose(hFile);						/* t@CN[Y */
}

/**************************************/
/* FromTo쐬               */
/**************************************/
VOID ToMake(PCHAR pszFrom, PCHAR pszTo)
{
   PCHAR  pszF, pszFs, pszFe, pszT;

   strcpy(pszTo, pszFrom);
   pszF = pszFrom;
   while(*pszF != 0){
      if (*pszF == '@')
         break;
      pszF++;
   }
   if (*pszF == 0)              /* unknown */
      return;

   pszFe = pszF;
   while(*pszFe != 0){
      if (*pszFe == '>' || *pszFe == '"' || *pszFe == ' ')
         break;
      pszFe++;
   }

   pszFs = pszF;
   while(pszFs >= pszFrom){
      if (*pszFs == '<' || *pszFs == '"' || *pszFs == ' '){
         pszFs++;
         break;
      }
      pszFs--;
   }
   if (pszFs < pszFrom)
      pszFs++;

   pszT = pszTo;
   pszF = pszFs;
   while(pszF < pszFe){
      *(pszT++) = *(pszF++);
   }
   *pszT = 0;
}

/**************************************/
/* GfB^ZbV̊Jn           */
/**************************************/
BOOL StartEditor(PCHAR pszEditFile)
{
   STARTDATA   StartData;    /* JnZbVEf[^\ */
   ULONG       SessID;       /* ZbVID(߂) */
   PID         PID;          /* vZXID(߂) */
   UCHAR       ObjBuf[100];  /* IuWFNgEobt@[ */
   APIRET      rc;           /* ߂R[h */

   /*  ẽZbVJnp[^[w肷 */
   StartData.Length	    = sizeof(STARTDATA);		/* STARTDATA\̒ */
   StartData.Related	= SSF_RELATED_INDEPENDENT;	/* ƗZbV */
   StartData.FgBg	    = SSF_FGBG_FORE;		    /* OiŊJn */
   StartData.TraceOpt	= SSF_TRACEOPT_NONE;		/* g[XȂ */
   StartData.PgmTitle	= "";		           		/* ^Cg */
   StartData.PgmName	= fd.szEditor;			    /* vOEpX */
   StartData.PgmInputs	= pszEditFile;			    /*  */
   StartData.TermQ	    = 0;		           		/* I҂sȂƑz */
   StartData.Environment= 0;				        /* XgOȂƑz */
   StartData.InheritOpt = SSF_INHERTOPT_SHELL;		/* ep */
   StartData.SessionType= SSF_TYPE_DEFAULT; 		/* ZbVE^Cv */
   StartData.IconFile	= 0;          				/* ACREt@C͂Ȃ */
   StartData.PgmHandle	= 0;				        /* t@CgpȂ */
   StartData.PgmControl = SSF_CONTROL_VISIBLE;		/* vO͉ */
   StartData.InitXPos 	= 30;
   StartData.InitYPos 	= 40;
   StartData.InitXSize	= 200;
   StartData.InitYSize	= 140;
   StartData.Reserved	= 0;			           	/* \ς */
   StartData.ObjectBuffer = ObjBuf;			        /* Object Buffer */
   StartData.ObjectBuffLen = 100;			        /* Object Buffer Size */
   rc = DosStartSession(&StartData, &SessID, &PID);
                                       /* Ė߂ꍇAϐSessID͐V */
                                       /*   ZbVID܂݁AϐPID͐V*/
                                       /*   vZX̃vZXID܂      */
   if (rc != 0)
      return FALSE;
   return TRUE;
}

/**************************************/
/* PoCgڂ`FbN       */
/**************************************/
BOOL iskanji(UCHAR c)
{
   /*
     0x81-0x9f or 0xe0-0xff
   */
   if (c < 0x81 || (c > 0x9f && c < 0xe0)) {
      return FALSE;
   }
   return TRUE;
}

/**************************************/
/* QoCgڂ`FbN       */
/**************************************/
BOOL iskanji2(UCHAR c)
{
   /*
     0x40-0xff
   */
   if (c < 0x40) {
      return FALSE;
   }
}

/**************************************/
/* A[eBNǂ݂             */
/**************************************/
BOOL GetArticle(PCHAR pszArticle, BOOL flgEA)
{
   APIRET  rc;
   HFILE   hFile;
   ULONG   Action;

   rc = DosOpen(pszArticle, &hFile, &Action,  0L, FILE_NORMAL,
                FILE_OPEN, OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYNONE, 0L );
   if (rc != 0) 
      return FALSE;
   memset((PCHAR)pvText, 0, TEXT_SIZE); /* [GȀ */
   										/* t@C̓eCɓǂݍ */
   DosQueryFileInfo(hFile, 1, &FileInfoBuf, sizeof(FILESTATUS3));
   ulTextLength = FileInfoBuf.cbFile;
   if (ulTextLength > TEXT_SIZE) {
      DosClose(hFile);
      return FALSE;
   }
   DosRead(hFile, pvText, ulTextLength, &Action );
   if (flgEA){ 
      FileInfoBuf.ftimeCreation.twosecs  = 0;
      FileInfoBuf.ftimeLastWrite.twosecs = 29;
      rc = DosSetFileInfo(hFile, 1, &FileInfoBuf, sizeof(FILESTATUS3));
   }
   DosClose(hFile);
   pszRead = (PCHAR)pvText;

   return TRUE;
}

/**************************************/
/* A[eBN1s݂          */
/**************************************/
BOOL ReadArticle(PCHAR pszArticle)
{
   BOOL   flg = FALSE;

   while ((PCHAR)(pvText + ulTextLength) > pszRead) {
      flg = TRUE;
      if (*pszRead == 0x0a) {                       /* sR[h */
         *pszArticle = 0;
         pszRead++;
         break;
      }
      else {
         if (iskanji(*pszRead)) {
            *(pszArticle++) = *(pszRead++);
            *(pszArticle++) = *pszRead;
         }
         else if (*pszRead >= 0x20 || *pszRead == 0x09){
            *(pszArticle++) = *pszRead;
         }
      }
      pszRead++;
   } /* endwhile */
   *pszArticle = 0;

   return flg;
}

/**************************************/
/* io[                     */
/**************************************/
VOID Renumber()
{
   if (flgThread)
      return;
   DosCreateThread(&tidThread, ThreadRenumber, 0, 0, 65536);
}

/**************************************/
/* io[Xbh                 */
/**************************************/
VOID ThreadRenumber()
{
   HAB   hab;
   HMQ   hmq;
   APIRET rc;
   UINT	 uFcnt, uIdx, uPms, uPar;
   INT   nTop;
   BOOL  flgSubj, flgFrom;
   CHAR  c;
   CHAR  szOldName[256], szNewName[256], szTitle[256], buf[1024];

   /* PMAv̏ */
   flgThread = TRUE;
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);

   /* ^Cg̓ǂݍݏ */
   uIdx   = 0;
   nTop   = -1;
   uPms   = GetNumberPms(szBaseFolder, buf);
   for (uIdx = 0; uIdx < uMaxItem; uIdx++) {
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)szTitle);
      strncpy(buf, szTitle + 1, 5);
      buf[5] = 0;
      uFcnt = atoi(buf);
      sprintf(szOldName, "%s%d", szBaseFolder, uFcnt);
      sprintf(szNewName, "%s%d", szBaseFolder, uIdx + 1);
      if (stricmp(szOldName, szNewName) != 0){
         rc = DosMove(szOldName, szNewName);
         sprintf(buf, "%5d", uIdx + 1);
         strncpy(szTitle + 1, buf, 5);
         WinSendMsg(hListWnd, LM_SETITEMTEXT, MPFROM2SHORT(uIdx, 0), (MPARAM)szTitle);
      }
      uPar = uIdx * 100 / uMaxItem;
      if ((uPar % 5) == 0) {
         sprintf(buf, "%s Renaming %d %%", szProvider,  uPar);
         WinSetWindowText(hFrameWnd, buf);
      }
   }
   PutNumberPms(szBaseFolder, uIdx + 1);
   PutFirstPms(szBaseFolder, 0);
   BaseTitle();

   /* I */
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   flgThread = FALSE;
   DosExit(EXIT_THREAD, 0L);
}

/**************************************/
/* LinkApp̊Jn                      */
/**************************************/
BOOL StartLinkApp()
{
   STARTDATA   StartData;    /* JnZbVEf[^\ */
   ULONG       SessID;       /* ZbVID(߂) */
   PID         PID;          /* vZXID(߂) */
   UCHAR       ObjBuf[100];  /* IuWFNgEobt@[ */
   CHAR		   szAppName[256], szAppParam[256], buf[64];
   PCHAR	   pszLinkApp, pszAppName, pszAppParam;
   BOOL        flgParam = FALSE;
   APIRET      rc;           /* ߂R[h */

   pszLinkApp  = fd.szLinkApp;
   pszAppName  = szAppName;
   pszAppParam = szAppParam;
   while(*pszLinkApp != 0){
      if (*pszLinkApp == ' '){
         flgParam = TRUE;
      }
      else {
         if (flgParam)
            *(pszAppParam++) = *pszLinkApp;
         else
            *(pszAppName++)  = *pszLinkApp;
      }
      pszLinkApp++;
   }
   *pszAppName  = 0;
   *pszAppParam = 0;
   /* *.cmdȂcmd.exeoRŃR[ */
   strcpy(buf, szAppName + (strlen(szAppName) - 3));
   if (stricmp(buf, "CMD") == 0){
      strcpy(szAppName, "cmd.exe");
      sprintf(szAppParam, "/c %s", fd.szLinkApp);
   }

   /*  ẽZbVJnp[^[w肷 */
   StartData.Length	    = sizeof(STARTDATA);		/* STARTDATA\̒ */
   StartData.Related	= SSF_RELATED_INDEPENDENT;	/* ƗZbV */
   StartData.FgBg	    = SSF_FGBG_FORE;		    /* OiŊJn */
   StartData.TraceOpt	= SSF_TRACEOPT_NONE;		/* g[XȂ */
   StartData.PgmTitle	= "";		           		/* ^Cg */
   StartData.PgmName	= szAppName;			    /* vOEpX */
   StartData.PgmInputs	= szAppParam;			    /*  */
   StartData.TermQ	    = 0;		           		/* I҂sȂƑz */
   StartData.Environment= 0;				        /* XgOȂƑz */
   StartData.InheritOpt = SSF_INHERTOPT_SHELL;		/* ep */
   StartData.SessionType= SSF_TYPE_DEFAULT; 		/* ZbVE^Cv */
   StartData.IconFile	= 0;          				/* ACREt@C͂Ȃ */
   StartData.PgmHandle	= 0;				        /* t@CgpȂ */
   StartData.PgmControl = SSF_CONTROL_VISIBLE;		/* vO͉ */
   StartData.InitXPos 	= 30;
   StartData.InitYPos 	= 40;
   StartData.InitXSize	= 200;
   StartData.InitYSize	= 140;
   StartData.Reserved	= 0;			           	/* \ς */
   StartData.ObjectBuffer = ObjBuf;			        /* Object Buffer */
   StartData.ObjectBuffLen = 100;			        /* Object Buffer Size */
   rc = DosStartSession(&StartData, &SessID, &PID);
                                       /* Ė߂ꍇAϐSessID͐V */
                                       /*   ZbVID܂݁AϐPID͐V*/
                                       /*   vZX̃vZXID܂      */
   if (rc != 0)
      return FALSE;
   return TRUE;
}

/**************************************/
/* U蕪                       */
/**************************************/
VOID Extract(BOOL flgLoad)
{
   if (flgThread)
      return;
   if (flgLoad)
      ued = LoadED(ed);
   DosCreateThread(&tidThread, ThreadExtract, 0, 0, 65536);
}

/**************************************/
/* U蕪Xbh                   */
/**************************************/
VOID ThreadExtract()
{
   HAB   hab;
   HMQ   hmq;
   APIRET rc;
   UINT	 uFcnt, uCnt, uIdx, uIdx2, uPar;
   BOOL  flgMove;
   CHAR  szOldName[256], szNewFolder[256], szTitle[256], buf[256], buf2[256];

   /* PMAv̏ */
   flgThread = TRUE;
   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 0);

   /* ^Cg̓ǂݍݏ */
   uIdx   = 0;
   uCnt   = 0;
   while (uIdx < (UINT)WinSendMsg(hListWnd, LM_QUERYITEMCOUNT, 0, 0)) {
      flgMove = FALSE;
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)szTitle);
      strcpy(buf, szTitle + TITLE_POS);
      for (uIdx2 = 0; uIdx2 < ued; uIdx2++){
         if ((strnicmp(buf, ed[uIdx2].szJyoken, strlen(ed[uIdx2].szJyoken)) == 0
              || strcmp(ed[uIdx2].szJyoken, "*") == 0)
           && (stricmp(szCurFolder, ed[uIdx2].szFolder) != 0)){
            strcpy(buf2, szTitle + 1);
            buf2[5] = 0;
            uFcnt = atoi(buf2);
            sprintf(szOldName, "%s%d", szBaseFolder, uFcnt);
            sprintf(szNewFolder, "%s%s\\", fd.szKabeFolder, ed[uIdx2].szFolder);
            if (MoveArticle(szOldName, szNewFolder)){
               flgMove = TRUE;
            }
            break;
         }
      }
      uPar = (++uCnt) * 100 / uMaxItem;
      if ((uPar % 5) == 0) {
         sprintf(buf, "%s Moving %d %%", szProvider,  uPar);
         WinSetWindowText(hFrameWnd, buf);
      }
      if (flgMove) 
         WinSendMsg(hListWnd, LM_DELETEITEM, MPFROM2SHORT(uIdx, 0), 0);
      else
         uIdx++;
   }
   uMaxItem = (UINT)WinSendMsg(hListWnd, LM_QUERYITEMCOUNT, 0, 0);
   if (uMaxItem == 0){
      PutNumberPms(szBaseFolder, 1);
      PutFirstPms(szBaseFolder, 0);
      WinSetWindowText(hEntryWnd, "");
   }
   else {
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uMaxItem - 1, 256), (MPARAM)szTitle);
      szTitle[6] = 0;
      uFcnt = atoi(szTitle + 1);
      PutNumberPms(szBaseFolder, uFcnt + 1);
      SetSelectIndex(uIdx);
   }
   BaseTitle();

   /* I */
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
   flgThread = FALSE;
   DosExit(EXIT_THREAD, 0L);
}

/**************************************/
/* ꊇM                           */
/**************************************/
VOID SendAll()
{
   APIRET rc;
   UINT	  uIdx;
   CHAR   szOldName[256], buf[256];

   /* ^Cg̓ǂݍݏ */
   uIdx   = 0;
   while (uIdx < (UINT)WinSendMsg(hListWnd, LM_QUERYITEMCOUNT, 0, 0)) {
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)buf);
      if (buf[0] != '#'){
         buf[6] = 0;
         sprintf(szOldName, "%s%d", szBaseFolder, atoi(buf + 1));
         if (MoveArticle(szOldName, fd.szMqueFolder))
            WinSendMsg(hListWnd, LM_DELETEITEM, MPFROM2SHORT(uIdx, 0), 0);
         else
            uIdx++;
      }
      else
         uIdx++;
   }
   uMaxItem = (UINT)WinSendMsg(hListWnd, LM_QUERYITEMCOUNT, 0, 0);
   if (uMaxItem == 0){
      PutNumberPms(szBaseFolder, 1);
      PutFirstPms(szBaseFolder, 0);
      WinSetWindowText(hEntryWnd, "");
   }
   else {
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uMaxItem - 1, 256), (MPARAM)buf);
      buf[6] = 0;
      PutNumberPms(szBaseFolder, atoi(buf + 1) + 1);
      SetSelectIndex(uIdx);
   }
   BaseTitle();
}

/**************************************/
/* A[eBNړ             */
/**************************************/
BOOL MoveArticle(PCHAR pszOldArticle, PCHAR pszNewFolder)
{
   UINT   uPms;
   APIRET rc;
   CHAR   buf[256], szNewArticle[256];

   PutNumberPms(pszNewFolder, GetNumberPms(pszNewFolder, szNewArticle) + 1);
   rc = DosMove(pszOldArticle, szNewArticle);
   if (rc != 0)
      return FALSE;
   return TRUE;
} 

/**************************************/
/* A[eBNҏW             */
/**************************************/
VOID EditArticle()
{
   UINT   uIdx, uFcnt;
   CHAR   buf[256], szFName[256];

   uIdx = GetSelectIndex(0, &uFcnt);
   if (uIdx == LIT_NONE){
      AppMsg("No Select Article!");
      return;
   }
   if (stricmp(szCurFolder, RESERVE_FOLDER) == 0){
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)buf);
      buf[0] = ' ';
      WinSendMsg(hListWnd, LM_SETITEMTEXT, MPFROM2SHORT(uIdx, 0), (MPARAM)buf);
   }
   sprintf(szFName, "%s%d", szBaseFolder, uFcnt);

   if (!StartEditor(szFName)){
      AppMsg("Can't Execute Editor");
   }
}

/**************************************/
/* A[eBN폜             */
/**************************************/
VOID DeleteArticle()
{
   UINT   uIdx, uOldIdx, uFcnt;
   CHAR   szFName[256];

   uIdx = GetSelectIndex(0, &uFcnt);
   if (uIdx == LIT_NONE){
      AppMsg("No Select Article!");
      return;
   }
   if (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, "Delete OK?", APP_TITLE, 0, 
                     MB_OKCANCEL | MB_ICONQUESTION) == MBID_OK){
      flgSelect = FALSE;
      while (TRUE) {
         uOldIdx = uIdx;
         sprintf(szFName, "%s%d", szBaseFolder, uFcnt);
         if (DosDelete(szFName) == 0)
            WinSendMsg(hListWnd, LM_DELETEITEM, MPFROM2SHORT(uIdx, 0), 0);
         else
            AppMsg("Can't Delete");
         uIdx = GetSelectIndex(0, &uFcnt);
         if (uIdx == LIT_NONE)
            break;
      }
      flgSelect = TRUE;
      BaseTitle();
      if (!SetSelectIndex(uOldIdx)) 
         WinSetWindowText(hEntryWnd, "");
   }
}

/**************************************/
/* TitleŃ\[g                  */
/**************************************/
BOOL TitleSort()
{
   CHAR     buf[256], buf2[256];
   APIRET   rc;
   PVOID    pvTbl;
   UINT     *puTbl, *puTbl2;
   UINT     uIdx, uIdx2, i, j, uFcnt, uPms, uPar;
   ULONG    ulSize;
   
   /* Ɨp[̃AP[V */
   ulSize = uMaxItem * sizeof(UINT);
   rc = DosAllocMem(&pvTbl, ulSize * 2, PAG_COMMIT | PAG_READ | PAG_WRITE); 
   if (rc != 0) {
      AppMsg("Can't Allocate Memory");
      return FALSE;
   }
   puTbl  = (UINT *)pvTbl;
   puTbl2 = (UINT *)(pvTbl + ulSize);

   /* \[g */
   for (uIdx = 0; uIdx < uMaxItem; uIdx++){
      *(puTbl + uIdx) = uIdx;
      WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx,  256), (MPARAM)buf);
      buf[6] = 0;
      *(puTbl2 + uIdx) = atoi(buf + 1);
   }
   for (i = 0; i < uMaxItem - 1; i++){   
      for (j = i + 1; j < uMaxItem; j++){
         uIdx  = *(puTbl + i);
         uIdx2 = *(puTbl + j);
         WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx,  256), (MPARAM)buf);
         WinSendMsg(hListWnd, LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx2, 256), (MPARAM)buf2);
         if (stricmp(buf + TITLE_POS, buf2 + TITLE_POS) > 0){
            *(puTbl + i) = uIdx2;
            *(puTbl + j) = uIdx;
            uFcnt = *(puTbl2 + i);
            *(puTbl2 + i) = *(puTbl2 + j);
            *(puTbl2 + j) = uFcnt;
         }
      }
      uPar = i * 100 / uMaxItem;
      if ((uPar % 5) == 0) {
         sprintf(buf, "%s Sorting %d %%", szProvider,  uPar);
         WinSetWindowText(hFrameWnd, buf);
      }
   }

   /* t@C̕tւ */
   uPms   = GetNumberPms(szBaseFolder, buf);
   for (uIdx = 0; uIdx < uMaxItem; uIdx++) {
      sprintf(buf,  "%s%d", szBaseFolder, *(puTbl2 + uIdx));
      sprintf(buf2, "%s%d", szBaseFolder, uPms);
      *(puTbl2 + uIdx) = uPms++;
      rc = DosMove(buf, buf2);
      uPar = uIdx * 100 / uMaxItem;
      if ((uPar % 5) == 0) {
         sprintf(buf, "%s Renaming Leve1 %d %%", szProvider,  uPar);
         WinSetWindowText(hFrameWnd, buf);
      }
   }
   PutNumberPms(szBaseFolder, uPms);

   /* t@C̕tւ */
   for (uIdx = 0; uIdx < uMaxItem; uIdx++) {
      sprintf(buf,  "%s%d", szBaseFolder, *(puTbl2 + uIdx));
      sprintf(buf2, "%s%d", szBaseFolder, uIdx + 1);
      rc = DosMove(buf, buf2);
      uPar = uIdx * 100 / uMaxItem;
      if ((uPar % 5) == 0) {
         sprintf(buf, "%s Renaming Level2 %d %%", szProvider,  uPar);
         WinSetWindowText(hFrameWnd, buf);
      }
   }
   PutNumberPms(szBaseFolder, uIdx + 1);
   PutFirstPms(szBaseFolder, 0);
   DosFreeMem(pvTbl);

   return TRUE;   
}

/**************************************/
/* DecodeJn                   */
/**************************************/
BOOL StartDecoder(PCHAR pszProg)
{
   STARTDATA   StartData;    /* JnZbVEf[^\ */
   ULONG       SessID;       /* ZbVID(߂) */
   PID         PID;          /* vZXID(߂) */
   UCHAR       ObjBuf[100];  /* IuWFNgEobt@[ */
   APIRET      rc;           /* ߂R[h */
   CHAR		   szParam[1024], szOutDir[256], szOutDrv[4], buf[256];
   UINT        uIdx, uIdx2;

   uIdx = GetSelectIndex(0, &uIdx2);
   if (uIdx == LIT_NONE){
       AppMsg("No Select Article!");
       return;
   }

   /*  ẽZbVJnp[^[w肷 */
   StartData.Length	    = sizeof(STARTDATA);		/* STARTDATA\̒ */
   StartData.Related	= SSF_RELATED_INDEPENDENT;	/* ƗZbV */
   StartData.FgBg	    = SSF_FGBG_FORE;		    /* OiŊJn */
   StartData.TraceOpt	= SSF_TRACEOPT_NONE;		/* g[XȂ */
   StartData.PgmTitle	= "";		           		/* ^Cg */
   StartData.PgmName	= "cmd.exe";			    /* vOEpX */
   strcpy(szOutDir, dec.szDecodeDir);
   if (strlen(szOutDir) > 3)
      szOutDir[strlen(szOutDir) - 1] = 0;
   strncpy(szOutDrv, dec.szDecodeDir, 2);
   szOutDrv[2] = 0;
   sprintf(szParam, "/c %s %s %s %s %s%d",
           szSubCmd, szOutDrv, szOutDir, pszProg, szBaseFolder, uIdx2);
   StartData.PgmInputs  = szParam;
   StartData.TermQ	    = 0;		           		/* I҂sȂƑz */
   StartData.Environment= 0;				        /* XgOȂƑz */
   StartData.InheritOpt = SSF_INHERTOPT_SHELL;		/* ep */
   StartData.SessionType= SSF_TYPE_DEFAULT; 		/* ZbVE^Cv */
   StartData.IconFile	= 0;          				/* ACREt@C͂Ȃ */
   StartData.PgmHandle	= 0;				        /* t@CgpȂ */
   StartData.PgmControl = SSF_CONTROL_VISIBLE;		/* vO͉ */
   StartData.InitXPos 	= 30;
   StartData.InitYPos 	= 40;
   StartData.InitXSize	= 200;
   StartData.InitYSize	= 140;
   StartData.Reserved	= 0;			           	/* \ς */
   StartData.ObjectBuffer = ObjBuf;			        /* Object Buffer */
   StartData.ObjectBuffLen = 100;			        /* Object Buffer Size */
   rc = DosStartSession(&StartData, &SessID, &PID);
                                       /* Ė߂ꍇAϐSessID͐V */
                                       /*   ZbVID܂݁AϐPID͐V*/
                                       /*   vZX̃vZXID܂      */
   if (rc != 0){
      AppMsg("Can't Start Decode Program !");
      return FALSE;
   }
   
   return TRUE;
}

/**************************************/
/* about_CAÕR[obN֐  */
/**************************************/
MRESULT EXPENTRY AboutDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* Reserve_CAÕR[obN֐*/
/**************************************/
MRESULT EXPENTRY ReserveDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* option_CAÕR[obN֐ */
/**************************************/
MRESULT EXPENTRY OptionDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   CHAR   buf[256];
   USHORT check, check2, check3, size, size2;

   switch (msg) {
   case WM_INITDLG:
      if (flgProfWin) {
         check  = (ws.flgVirt)? 1 : 0;
         check2 = (ws.flgPopup)? 1 : 0;
         check3 = (ws.flgReserve)? 1 : 0;
         size   = ws.uTitleSize;
         size2  = ws.uCurTitlePos;
	  }
      else {
         check  = 0;
         check2 = 0;
         check3 = 0;
         size   = 35;
         size2  = 3;
      }
      WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON), BM_SETCHECK,
        		 MPFROM2SHORT(check, 0), 0);
      WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON2), BM_SETCHECK,
        		 MPFROM2SHORT(check2, 0), 0);
      WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON3), BM_SETCHECK,
        		 MPFROM2SHORT(check3, 0), 0);
      sprintf(buf, "%d", size);
      WinSetDlgItemText(hwnd, IDC_OPT_ENTRY, buf);
      sprintf(buf, "%d", size2);
      WinSetDlgItemText(hwnd, IDC_OPT_ENTRY4, buf);
/*
      WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_ENTRY1), MLM_SETBACKCOLOR, (MPARAM)co.TextColor, 0);
      WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_ENTRY2), MLM_SETBACKCOLOR, (MPARAM)co.BackColor, 0);
      WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_ENTRY3), MLM_SETFONT, &fattrsEntry, 0);
*/
      break;
   case WM_CONTROL:
      switch (SHORT1FROMMP(mp1)) {
      case IDC_OPT_BUTTON:
         if (SHORT2FROMMP(mp1) == BN_CLICKED){
            check = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON),
				                            BM_QUERYCHECK, 0, 0));
		    check = (check == 0)? 1: 0;
            WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON), BM_SETCHECK,
                	   MPFROM2SHORT(check, 0), 0);
		 }
         break;
      case IDC_OPT_BUTTON2:
         if (SHORT2FROMMP(mp1) == BN_CLICKED){
            check2 = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON2),
				                            BM_QUERYCHECK, 0, 0));
		    check2 = (check2 == 0)? 1: 0;
            WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON2), BM_SETCHECK,
                	   MPFROM2SHORT(check2, 0), 0);
		 }
         break;
      case IDC_OPT_BUTTON3:
         if (SHORT2FROMMP(mp1) == BN_CLICKED){
            check3 = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON3),
				                            BM_QUERYCHECK, 0, 0));
		    check3 = (check3 == 0)? 1: 0;
            WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON3), BM_SETCHECK,
                	   MPFROM2SHORT(check3, 0), 0);
		 }
         break;
      default :
         break;
      }
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          WinQueryDlgItemText(hwnd, IDC_OPT_ENTRY, 256, buf);
          size = atoi(buf);
          if (size < 10 || size > 90)
             return 0;
          ws.uTitleSize = size;
          WinQueryDlgItemText(hwnd, IDC_OPT_ENTRY4, 256, buf);
          ws.uCurTitlePos = atoi(buf);
          check = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON),
				                          BM_QUERYCHECK, 0, 0));
          ws.flgVirt  = (check == 0)? FALSE: TRUE;
          check2 = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON2),
				                          BM_QUERYCHECK, 0, 0));
          ws.flgPopup  = (check2 == 0)? FALSE: TRUE;
          check3 = SHORT1FROMMR(WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_BUTTON3),
				                          BM_QUERYCHECK, 0, 0));
          ws.flgReserve = (check3 == 0)? FALSE: TRUE;
/*
          co.TextColor = (LONG)WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_ENTRY1), MLM_QUERYBACKCOLOR, 0, 0);
          co.BackColor = (LONG)WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_ENTRY2), MLM_QUERYBACKCOLOR, 0, 0);
          WinSendMsg(WinWindowFromID(hwnd, IDC_OPT_ENTRY3), MLM_QUERYFONT, &fattrsEntry, 0);
*/
          break;
       default:
          break;
      }
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* Dir_CAÕR[obN֐    */
/**************************************/
MRESULT EXPENTRY OptDirDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   FOLDIR wk;
   ULONG  ulLen1, ulLen2, ulLen3, ulLen4, ulLen5, ulLen6, ulLen7;

   switch (msg) {
   case WM_INITDLG:
      if (flgProfDir) {
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY1), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY2), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY3), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY4), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY5), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY6), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DIR_ENTRY7), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY1, fd.szKabeFolder);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY2, fd.szMqueFolder);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY3, fd.szMyFrom);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY4, fd.szPrefix);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY5, fd.szSigFile);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY6, fd.szEditor);
         WinSetDlgItemText(hwnd, IDC_DIR_ENTRY7, fd.szLinkApp);
      }
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          ulLen1 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY1, 256, wk.szKabeFolder);
          ulLen2 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY2, 256, wk.szMqueFolder);
          ulLen3 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY3, 128, wk.szMyFrom);
          ulLen4 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY4, 64 , wk.szPrefix);
          ulLen5 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY5, 256, wk.szSigFile);
          ulLen6 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY6, 256, wk.szEditor);
          ulLen7 = WinQueryDlgItemText(hwnd, IDC_DIR_ENTRY7, 256, wk.szLinkApp);
          if (ulLen1 == 0 || ulLen2 == 0 || ulLen3 == 0 ||
              ulLen4 == 0 || ulLen5 == 0 || ulLen6 == 0) {
             AppMsg("Invalid Data!!");
             return 0;
          }
          if (wk.szKabeFolder[ulLen1 - 1] != '\\')
             strcat(wk.szKabeFolder, "\\");
          if (wk.szMqueFolder[ulLen2 - 1] != '\\')
             strcat(wk.szMqueFolder, "\\");
          memcpy(&fd, &wk, sizeof(wk));
          break;
       default:
          break;
      }
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* Folder_CAÕR[obN֐ */
/**************************************/
MRESULT EXPENTRY FolderDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   UINT          uIdx;

   switch (msg) {
   case WM_INITDLG:
	  Folder2Listbox(WinWindowFromID(hwnd, IDC_FOL_LIST));
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          uIdx = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_FOL_LIST), LM_QUERYSELECTION, 0, 0);
          if (uIdx == LIT_NONE) {
             return 0;
          }
          WinSendMsg(WinWindowFromID(hwnd, IDC_FOL_LIST),
					 LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)szCurFolder);
          break;
       default:
          break;
      }
      break;
   case WM_BUTTON1DBLCLK:
      WinSendMsg(hwnd, WM_COMMAND, MPFROM2SHORT(DID_OK, 0), 0);
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* Extract_CAÕR[obN֐*/
/**************************************/
MRESULT EXPENTRY ExtractDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   UINT        uIdx, uIdx2, uMax;
   ULONG	   ulLen;
   CHAR        buf[256], szJyoken[256], szFolder[256];
   PCHAR       pszFormat = "%-30s %s";
   HINI		   hini;

   switch (msg) {
   case WM_INITDLG:
	  Folder2Listbox(WinWindowFromID(hwnd, IDC_EXT_LIST2));
      ued = LoadED(ed);
      for (uIdx = 0; uIdx < ued; uIdx++){
         sprintf(buf, pszFormat, ed[uIdx].szJyoken, ed[uIdx].szFolder);
         WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
 					LM_INSERTITEM, MPFROM2SHORT(LIT_END, 0), (MPARAM)buf);
      }
      break;
   case WM_CONTROL:
      switch (SHORT1FROMMP(mp1)) {
      case IDC_EXT_LIST1:
         switch (SHORT2FROMMP(mp1)) {
         case LN_SELECT:
            uIdx2 = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
      							     LM_QUERYSELECTION, 0, 0);
            uMax  = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
      							     LM_QUERYITEMCOUNT, 0, 0);
            for (uIdx = 0; uIdx < uMax; uIdx++){ 
               WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
 				 	      LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)buf);
               if (stricmp(ed[uIdx2].szFolder, buf) == 0){
                  WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
 				 	         LM_SELECTITEM, MPFROM2SHORT(uIdx, 0), MPFROM2SHORT(TRUE, 0));
                  break;
               }
            }
            WinSetDlgItemText(hwnd, IDC_EXT_ENTRY, ed[uIdx2].szJyoken);
            return 0;
         default:
           break;
         } /* endswitch */
         break;
      default:
        break;
      } /* endswitch */
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case IDC_EXT_BUTTON1: /* add */
          if (ued == EDMAX){
             AppMsg("Over Flow");
             return 0;
          }
          ulLen = WinQueryDlgItemText(hwnd, IDC_EXT_ENTRY, 256, szJyoken);
          uIdx  = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
      							   LM_QUERYSELECTION, 0, 0);
          if (ulLen == 0 || uIdx == LIT_NONE){
             AppMsg("Invalid Data");
             return 0;
          }
          WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
					 LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)szFolder);
          sprintf(buf, pszFormat, szJyoken, szFolder);
          WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
 				 	 LM_INSERTITEM, MPFROM2SHORT(LIT_END, 0), (MPARAM)buf);
          WinSetDlgItemText(hwnd, IDC_EXT_ENTRY, "");
          strcpy(ed[ued].szJyoken, szJyoken);
          strcpy(ed[ued++].szFolder, szFolder);
          return 0;
      case IDC_EXT_BUTTON2: /* upd */
          uIdx2 = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
      							   LM_QUERYSELECTION, 0, 0);
          if (uIdx2 == LIT_NONE){
             AppMsg("No Selected");
             return 0;
          }
          ulLen = WinQueryDlgItemText(hwnd, IDC_EXT_ENTRY, 256, szJyoken);
          uIdx  = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
      							   LM_QUERYSELECTION, 0, 0);
          if (ulLen == 0 || uIdx == LIT_NONE){
             AppMsg("Invalid Data");
             return 0;
          }
          WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST2),
					 LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)szFolder);
          sprintf(buf, pszFormat, szJyoken, szFolder);
          WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
 				 	 LM_SETITEMTEXT, MPFROM2SHORT(uIdx2, 0), (MPARAM)buf);
          WinSetDlgItemText(hwnd, IDC_EXT_ENTRY, "");
          strcpy(ed[uIdx2].szJyoken, szJyoken);
          strcpy(ed[uIdx2].szFolder, szFolder);
          return 0;
      case IDC_EXT_BUTTON3: /* del */
          uIdx2 = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
      							   LM_QUERYSELECTION, 0, 0);
          if (uIdx2 == LIT_NONE){
             AppMsg("No Selected");
             return 0;
          }
          WinSendMsg(WinWindowFromID(hwnd, IDC_EXT_LIST1),
 				 	 LM_DELETEITEM, MPFROM2SHORT(uIdx2, 0), 0);
          WinSetDlgItemText(hwnd, IDC_EXT_ENTRY, "");
          for (uIdx = uIdx2 + 1; uIdx < ued; uIdx++){
             strcpy(ed[uIdx - 1].szJyoken, ed[uIdx].szJyoken);
             strcpy(ed[uIdx - 1].szFolder, ed[uIdx].szFolder);
          }
          ued--;
          return 0;
      case DID_OK:
          hini = PrfOpenProfile(hab, szIniName);
          if (hini != NULLHANDLE) {
      		 PrfWriteProfileData(hini, PRFAPP, PRFKEY_EXTCNT, (PVOID)&ued, sizeof(UINT));
      		 PrfWriteProfileData(hini, PRFAPP, PRFKEY_EXTDATA, (PVOID)ed, sizeof(EXTDATA) * ued);
             PrfCloseProfile(hini);
          }
          else {
             AppMsg("Save Error");
          }
          break;
       default:
          break;
      }
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* Folder̃XgListbox          */
/**************************************/
VOID Folder2Listbox(HWND hList)
{
   HDIR          FindHandle;
   FILEFINDBUF3  FindBuffer;
   ULONG         FindCount;
   CHAR		     szSearch[512];
   APIRET        rc;           /* ߂R[h */

   FindHandle = 0x0001;
   FindCount = 1;

   sprintf(szSearch, "%s*.*", fd.szKabeFolder);
   rc = DosFindFirst(szSearch, &FindHandle, FILE_DIRECTORY, (PVOID) &FindBuffer, sizeof(FindBuffer),
                     &FindCount, FIL_STANDARD);
   while(rc == 0){
      if ((FindBuffer.attrFile & FILE_DIRECTORY)
            && !(strcmp(FindBuffer.achName, ".") == 0 || strcmp(FindBuffer.achName, "..") == 0)){
         WinSendMsg(hList, LM_INSERTITEM, MPFROM2SHORT(LIT_END, 0), (MPARAM)FindBuffer.achName);
      }
      rc = DosFindNext(FindHandle, (PVOID)&FindBuffer, sizeof(FindBuffer), &FindCount);
   }
   DosFindClose(FindHandle);
}

/**************************************/
/* U蕪f[^̃[h             */
/**************************************/
UINT LoadED(EXTDATA *ped)
{
   HINI  hini;
   UINT  uedcnt = 0;
   ULONG ulLen;

   /* Profile̓ǂ݂ */
   hini = PrfOpenProfile(hab, szIniName);
   if (hini != NULLHANDLE) {
      ulLen = (ULONG)sizeof(UINT);					/* ̓ǂ݂ */
      if (PrfQueryProfileData(hini, PRFAPP, PRFKEY_EXTCNT, (PVOID)&uedcnt, &ulLen)) {
         ulLen = (ULONG)sizeof(EXTDATA) * uedcnt;
         if (!PrfQueryProfileData(hini, PRFAPP, PRFKEY_EXTDATA, (PVOID)ped, &ulLen)) 
            uedcnt = 0;
      }
      else {
         uedcnt = 0;
      }
      PrfCloseProfile(hini);
   }
   return uedcnt;
}

/**************************************/
/* Move_CAÕR[obN֐ */
/**************************************/
MRESULT EXPENTRY MoveDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   UINT          uIdx, uOldIdx, uFcnt;
   CHAR          buf[256], szNewFolder[256];

   switch (msg) {
   case WM_INITDLG:
	  Folder2Listbox(WinWindowFromID(hwnd, IDC_MOV_LIST));
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          uIdx = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_MOV_LIST), LM_QUERYSELECTION, 0, 0);
          if (uIdx == LIT_NONE) 
             return 0;
          WinSendMsg(WinWindowFromID(hwnd, IDC_MOV_LIST),
					 LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)buf);
          if (stricmp(szCurFolder, buf) == 0){
             AppMsg("Same Folder! Can't Move Article")
             return 0;
          }
          sprintf(szNewFolder, "%s%s\\", fd.szKabeFolder, buf);
          flgSelect = FALSE;
          while (TRUE) {
             uOldIdx  = uMoveArticleIdx;
             if (MoveArticle(szMoveArticleFile, szNewFolder))
                WinSendMsg(hListWnd, LM_DELETEITEM, MPFROM2SHORT(uMoveArticleIdx, 0), 0);
             else
                AppMsg("Can't Move Article");
             uMoveArticleIdx = GetSelectIndex(0, &uFcnt);
             if (uMoveArticleIdx == LIT_NONE)
                break;
             sprintf(szMoveArticleFile, "%s%d", szBaseFolder, uFcnt);
          }
          flgSelect = TRUE;
          BaseTitle();
          if (!SetSelectIndex(uOldIdx)) 
             WinSetWindowText(hEntryWnd, "");
          break;
       default:
          break;
      }
      break;
   case WM_BUTTON1DBLCLK:
      WinSendMsg(hwnd, WM_COMMAND, MPFROM2SHORT(DID_OK, 0), 0);
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* New_CAÕR[obN֐    */
/**************************************/
MRESULT EXPENTRY NewfolderDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   APIRET        rc;
   PEAOP2		 EABuf;
   ULONG		 ulLen;
   CHAR          buf[256], szNewFolder[256];

   switch (msg) {
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          ulLen = WinQueryDlgItemText(hwnd, IDC_NEW_ENTRY, 256, buf);
          if (ulLen == 0)
             return 0;
          sprintf(szNewFolder, "%s%s", fd.szKabeFolder, buf);
          EABuf = 0;
          if (DosCreateDir(szNewFolder, EABuf) != 0)
             AppMsg("Can't Create New Folder");
          break;
       default:
          break;
      }
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);


}

/**************************************/
/* Del_CAÕR[obN֐    */
/**************************************/
MRESULT EXPENTRY DelfolderDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   APIRET		 rc;
   HDIR          FindHandle;
   FILEFINDBUF3  FindBuffer;
   ULONG         FindCount;
   UINT          uIdx;
   BOOL			 flgDelFile;
   CHAR          buf[256], buf2[256], szDelFolder[256];

   switch (msg) {
   case WM_INITDLG:
	  Folder2Listbox(WinWindowFromID(hwnd, IDC_DEL_LIST));
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          uIdx = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_DEL_LIST), LM_QUERYSELECTION, 0, 0);
          if (uIdx == LIT_NONE) 
             return 0;
          WinSendMsg(WinWindowFromID(hwnd, IDC_DEL_LIST),
					 LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)buf);
          if (stricmp(szCurFolder, buf) == 0){
             AppMsg("Can't Delete Current Folder")
             return 0;
          }
          sprintf(buf2, "<%s> Delete OK?", buf);
          if (WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, buf2, APP_TITLE, 0, 
                            MB_OKCANCEL | MB_ICONQUESTION) == MBID_OK){
             sprintf(szDelFolder, "%s%s", fd.szKabeFolder, buf);
             sprintf(buf2, "%s\\*.*", szDelFolder);
             flgDelFile = TRUE;
             FindHandle = 0x0001;
             FindCount = 1;
             rc = DosFindFirst(buf2, &FindHandle, FILE_DIRECTORY,
                               (PVOID)&FindBuffer, sizeof(FindBuffer),
                               &FindCount, FIL_STANDARD);
             if (rc != 0){
                sprintf(buf2, "%d", rc); AppMsg(buf2);
			 }
             while(rc == 0){
                if (!(strcmp(FindBuffer.achName, ".") == 0 || strcmp(FindBuffer.achName, "..") == 0)){
                   if (FindBuffer.attrFile & FILE_DIRECTORY){
                      AppMsg("Exist Sub Directory. Can't Delete This Folder");
                      flgDelFile = FALSE;
                      break;
                   }
                   sprintf(buf2, "%s\\%s", szDelFolder, FindBuffer.achName);
                   if (DosDelete(buf2) != 0){
                      AppMsg("Can't Delete File. Folder Delete is Faild");
                      flgDelFile = FALSE;
                      break;
                   }
                }
                rc = DosFindNext(FindHandle, (PVOID)&FindBuffer,
								 sizeof(FindBuffer), &FindCount);
             }
             DosFindClose(FindHandle);
             if (flgDelFile){
                if (DosDeleteDir(szDelFolder) == 0){
                   AppMsg("Delete is Complete");
                }
                else {
                   AppMsg("Can't Delete This Folder");
                }
             }
          }
          break;
       default:
          break;
      }
      break;
   case WM_BUTTON1DBLCLK:
      WinSendMsg(hwnd, WM_COMMAND, MPFROM2SHORT(DID_OK, 0), 0);
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* decode_CAÕR[obN֐ */
/**************************************/
MRESULT EXPENTRY DecodeDlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   ULONG     ulLen;

   switch (msg) {
   case WM_INITDLG:
      if (flgProfDir) {
         WinSendMsg(WinWindowFromID(hwnd, IDC_DEC_ENTRY1), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DEC_ENTRY2), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DEC_ENTRY3), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DEC_ENTRY4), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSendMsg(WinWindowFromID(hwnd, IDC_DEC_ENTRY5), EM_SETTEXTLIMIT, MPFROM2SHORT(256, 0), 0);
         WinSetDlgItemText(hwnd, IDC_DEC_ENTRY1, dec.szISH);
         WinSetDlgItemText(hwnd, IDC_DEC_ENTRY2, dec.szUUDECODE);
         WinSetDlgItemText(hwnd, IDC_DEC_ENTRY3, dec.szMIME);
         WinSetDlgItemText(hwnd, IDC_DEC_ENTRY4, dec.szDecodeDir);
         WinSetDlgItemText(hwnd, IDC_DEC_ENTRY5, dec.szBINHEX);
      }
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          WinQueryDlgItemText(hwnd, IDC_DEC_ENTRY1, 256, dec.szISH);
          WinQueryDlgItemText(hwnd, IDC_DEC_ENTRY2, 256, dec.szUUDECODE);
          WinQueryDlgItemText(hwnd, IDC_DEC_ENTRY3, 256, dec.szMIME);
          WinQueryDlgItemText(hwnd, IDC_DEC_ENTRY5, 256, dec.szBINHEX);
          ulLen = WinQueryDlgItemText(hwnd, IDC_DEC_ENTRY4, 256, dec.szDecodeDir);
          if (ulLen > 0){ 
             if (dec.szDecodeDir[ulLen - 1] != '\\')
                strcat(dec.szDecodeDir, "\\");
          }
          break;
       default:
          break;
      }
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/**************************************/
/* Extract_CAÕR[obN֐*/
/**************************************/
MRESULT EXPENTRY Extract2Dlg(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   UINT        uIdx;
   ULONG	   ulLen;

   switch (msg) {
   case WM_INITDLG:
	  Folder2Listbox(WinWindowFromID(hwnd, IDC_EX2_LIST));
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mp1)) {
      case DID_OK:
          ulLen = WinQueryDlgItemText(hwnd, IDC_EX2_ENTRY, 256, ed[0].szJyoken);
          uIdx  = (UINT)WinSendMsg(WinWindowFromID(hwnd, IDC_EX2_LIST),
      							   LM_QUERYSELECTION, 0, 0);
          if (ulLen == 0 || uIdx == LIT_NONE){
             AppMsg("Invalid Data");
             return 0;
          }
          WinSendMsg(WinWindowFromID(hwnd, IDC_EX2_LIST),
					 LM_QUERYITEMTEXT, MPFROM2SHORT(uIdx, 256), (MPARAM)ed[0].szFolder);
          ued = 1;
          break;
       default:
          break;
      }
      break;
   default: 
      break;
   }
   return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


