/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.util;

import borland.jbcl.util.Res;
import borland.jbcl.util.VariantException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class Variant
implements Cloneable {
    public static final int UNASSIGNED_NULL = 0;
    public static final int ASSIGNED_NULL = 1;
    public static final int NULL_TYPES = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIGDECIMAL = 10;
    public static final int BOOLEAN = 11;
    public static final int BINARY_STREAM = 12;
    public static final int DATE = 13;
    public static final int TIME = 14;
    public static final int TIMESTAMP = 15;
    public static final int STRING = 16;
    public static final int OBJECT = 17;
    public static final int BYTE_ARRAY = 18;
    public static final String AssignedNull_S = "ASSIGNED_NULL";
    public static final String UnassignedNull_S = "UNASSIGNED_NULL";
    public static final String ByteType_S = "BYTE";
    public static final String ShortType_S = "SHORT";
    public static final String IntType_S = "INT";
    public static final String LongType_S = "LONG";
    public static final String FloatType_S = "FLOAT";
    public static final String DoubleType_S = "DOUBLE";
    public static final String BigDecimalType_S = "BIGDECIMAL";
    public static final String BooleanType_S = "BOOLEAN";
    public static final String BinaryStreamType_S = "BINARY_STREAM";
    public static final String DateType_S = "DATE";
    public static final String TimeType_S = "TIME";
    public static final String TimestampType_S = "TIMESTAMP";
    public static final String ByteArrayType_S = "BYTE_ARRAY";
    public static final String StringType_S = "STRING";
    public static final String ObjectType_S = "OBJECT";
    public static final String UnknownType_S = "UNKNOWN";
    public static final Variant nullVariant = new Variant(0);
    public static final int MaxTypes = 18;
    private int setType;
    private int type;
    private boolean booleanVal;
    private int intVal;
    private long longVal;
    private double doubleVal;
    private String stringVal;
    private byte[] byteArrayVal;
    private BigDecimal bigDecimalVal;
    private Object objectVal;
    private java.sql.Date dateVal;
    private Time timeVal;
    private Timestamp timestampVal;
    private static String zeroString;
    private static char[] zeroCharArray;
    private static BigDecimal zeroBIGDECIMAL;
    private static ByteArrayInputStream zeroBinary;
    private static byte[] zeroByteArray;

    public Variant(int n) {
        this.setType = n;
    }

    public Variant() {
    }

    public static String typeName(int n) {
        switch (n) {
            case 1: {
                return AssignedNull_S;
            }
            case 0: {
                return UnassignedNull_S;
            }
            case 2: {
                return ByteType_S;
            }
            case 3: {
                return ShortType_S;
            }
            case 4: {
                return IntType_S;
            }
            case 5: {
                return LongType_S;
            }
            case 6: {
                return FloatType_S;
            }
            case 7: {
                return DoubleType_S;
            }
            case 10: {
                return BigDecimalType_S;
            }
            case 11: {
                return BooleanType_S;
            }
            case 12: {
                return BinaryStreamType_S;
            }
            case 13: {
                return DateType_S;
            }
            case 14: {
                return TimeType_S;
            }
            case 15: {
                return TimestampType_S;
            }
            case 16: {
                return StringType_S;
            }
            case 18: {
                return ByteArrayType_S;
            }
            case 17: {
                return ObjectType_S;
            }
        }
        return UnknownType_S;
    }

    public static int typeOf(String string) {
        if (string.equals(StringType_S)) {
            return 16;
        }
        if (string.equals(DateType_S)) {
            return 13;
        }
        if (string.equals(TimeType_S)) {
            return 14;
        }
        if (string.equals(TimestampType_S)) {
            return 15;
        }
        if (string.equals(IntType_S)) {
            return 4;
        }
        if (string.equals(BigDecimalType_S)) {
            return 10;
        }
        if (string.equals(AssignedNull_S)) {
            return 1;
        }
        if (string.equals(UnassignedNull_S)) {
            return 0;
        }
        if (string.equals(ByteType_S)) {
            return 2;
        }
        if (string.equals(ShortType_S)) {
            return 3;
        }
        if (string.equals(LongType_S)) {
            return 5;
        }
        if (string.equals(DoubleType_S)) {
            return 7;
        }
        if (string.equals(FloatType_S)) {
            return 6;
        }
        if (string.equals(BooleanType_S)) {
            return 11;
        }
        if (string.equals(BinaryStreamType_S)) {
            return 12;
        }
        if (string.equals(ByteArrayType_S)) {
            return 18;
        }
        if (string.equals(ObjectType_S)) {
            return 17;
        }
        VariantException.fire(Res.format(3, new String[]{string}));
        return 0;
    }

    public static int typeId(String string) {
        for (int i = 2; i <= 18; ++i) {
            if (!string.equals(Variant.typeName(i))) continue;
            return i;
        }
        return 0;
    }

    public final Object getDisplayValue() {
        switch (this.type) {
            case 0: 
            case 1: {
                return "";
            }
            case 12: 
            case 17: {
                return this.objectVal;
            }
        }
        return this.toString();
    }

    private boolean setZeroValue(int n) {
        if (zeroString == null) {
            zeroString = "";
            zeroCharArray = new char[0];
            zeroBIGDECIMAL = new BigDecimal(0.0);
            zeroByteArray = new byte[0];
            zeroBinary = new ByteArrayInputStream(zeroByteArray);
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                this.intVal = 0;
                break;
            }
            case 15: {
                this.setTimestamp(0L, 0);
                break;
            }
            case 14: {
                this.setTime(0L);
                break;
            }
            case 13: {
                this.setDate(0L);
                break;
            }
            case 5: {
                this.longVal = 0L;
                break;
            }
            case 11: {
                this.booleanVal = false;
                break;
            }
            case 6: 
            case 7: {
                this.doubleVal = 0.0;
                break;
            }
            case 16: 
            case 17: {
                this.stringVal = zeroString;
                break;
            }
            case 10: {
                this.bigDecimalVal = zeroBIGDECIMAL;
                this.booleanVal = false;
                break;
            }
            case 12: {
                this.objectVal = zeroBinary;
                break;
            }
            case 18: {
                this.objectVal = zeroByteArray;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private void typeProblem(int n, int n2) {
        if (n <= 1 && this.setZeroValue(n2)) {
            return;
        }
        VariantException.fire(Res.format(1, new String[]{Variant.typeName(n), Variant.typeName(n2)}));
    }

    public final int getInt() {
        if (this.type != 4) {
            this.typeProblem(this.type, 4);
        }
        return this.intVal;
    }

    public final short getShort() {
        if (this.type != 3) {
            this.typeProblem(this.type, 3);
        }
        return (short)this.intVal;
    }

    public final byte getByte() {
        if (this.type != 2) {
            this.typeProblem(this.type, 2);
        }
        return (byte)this.intVal;
    }

    public final long getLong() {
        if (this.type != 5) {
            this.typeProblem(this.type, 5);
        }
        return this.longVal;
    }

    public final boolean getBoolean() {
        if (this.type != 11) {
            this.typeProblem(this.type, 11);
        }
        return this.booleanVal;
    }

    public final double getDouble() {
        if (this.type != 7) {
            this.typeProblem(this.type, 7);
        }
        return this.doubleVal;
    }

    public final float getFloat() {
        if (this.type != 6) {
            this.typeProblem(this.type, 6);
        }
        return (float)this.doubleVal;
    }

    public final String getString() {
        if (this.type != 16) {
            this.typeProblem(this.type, 16);
        }
        return this.stringVal;
    }

    public final BigDecimal getBigDecimal() {
        if (this.type != 10) {
            this.typeProblem(this.type, 10);
        }
        if (this.booleanVal) {
            this.bigDecimalVal = new BigDecimal(this.stringVal);
            this.booleanVal = false;
        }
        return this.bigDecimalVal;
    }

    public final java.sql.Date getDate() {
        if (this.type != 13) {
            this.typeProblem(this.type, 13);
        }
        return this.dateVal;
    }

    public final Time getTime() {
        if (this.type != 14) {
            this.typeProblem(this.type, 14);
        }
        return this.timeVal;
    }

    public final Timestamp getTimestamp() {
        if (this.type != 15) {
            this.typeProblem(this.type, 15);
        }
        return this.timestampVal;
    }

    public final byte[] getByteArray() {
        if (this.type != 18) {
            this.typeProblem(this.type, 18);
        }
        return this.byteArrayVal;
    }

    public final int getArrayLength() {
        return this.intVal;
    }

    public final InputStream getBinaryStream() {
        if (this.type != 12) {
            this.typeProblem(this.type, 12);
        }
        return (InputStream)this.objectVal;
    }

    public final void setInt(int n) {
        if (this.setType != 0 && this.setType != 4) {
            this.typeProblem(this.setType, 4);
        }
        this.type = 4;
        this.intVal = n;
    }

    public final void setShort(short s) {
        if (this.setType != 0 && this.setType != 3) {
            this.typeProblem(this.setType, 2);
        }
        this.type = 3;
        this.intVal = s;
    }

    public final void setByte(int n) {
        if (this.setType != 0 && this.setType != 2) {
            this.typeProblem(this.setType, 2);
        }
        this.type = 2;
        this.intVal = n;
    }

    public final void setAsInt(int n) {
        switch (this.type) {
            case 2: {
                this.setByte(n);
                return;
            }
            case 3: {
                this.setShort((short)n);
                return;
            }
        }
        this.setInt(n);
    }

    public final void setAsInt(int n, int n2) {
        switch (n) {
            case 2: {
                this.setByte(n2);
                return;
            }
            case 3: {
                this.setShort((short)n2);
                return;
            }
        }
        this.setInt(n2);
    }

    public final void setLong(long l) {
        if (this.setType != 0 && (this.setType < 2 || this.setType > 5)) {
            this.typeProblem(this.setType, 5);
        }
        this.type = 5;
        this.longVal = l;
    }

    public final void setBoolean(boolean bl) {
        if (this.setType != 0 && this.setType != 11) {
            this.typeProblem(this.setType, 11);
        }
        this.type = 11;
        this.booleanVal = bl;
    }

    public final void setDouble(double d) {
        if (this.setType != 0 && this.setType != 7) {
            this.typeProblem(this.setType, 7);
        }
        this.type = 7;
        this.doubleVal = d;
    }

    public final void setFloat(float f) {
        if (this.setType != 0 && this.setType != 6) {
            this.typeProblem(this.setType, 6);
        }
        this.type = 6;
        this.doubleVal = f;
    }

    public final void setAsDouble(double d) {
        switch (this.setType) {
            case 6: {
                this.setFloat((float)d);
                return;
            }
            case 7: {
                this.setDouble(d);
                return;
            }
        }
        this.typeProblem(this.setType, 7);
    }

    public final void setAsDouble(int n, double d) {
        switch (n) {
            case 6: {
                this.setFloat((float)d);
                return;
            }
        }
        this.setDouble(d);
    }

    public final void setString(String string) {
        if (this.setType != 16 && this.setType != 0) {
            this.typeProblem(this.setType, 16);
        }
        this.type = 16;
        this.stringVal = string;
    }

    public final void setBigDecimal(BigDecimal bigDecimal) {
        if (this.setType != 10 && this.setType != 0) {
            this.typeProblem(this.setType, 10);
        }
        this.type = 10;
        this.bigDecimalVal = bigDecimal;
        this.booleanVal = false;
    }

    public final void setBigDecimal(String string) {
        if (this.setType != 10 && this.setType != 0) {
            this.typeProblem(this.setType, 10);
        }
        this.type = 10;
        this.bigDecimalVal = null;
        this.stringVal = string;
        this.booleanVal = true;
    }

    public final void setDate(java.sql.Date date) {
        if (this.setType != 13 && this.setType != 0) {
            this.typeProblem(this.setType, 13);
        }
        this.type = 13;
        if (this.dateVal == null) {
            this.dateVal = new java.sql.Date(date.getTime());
        } else {
            this.dateVal.setTime(date.getTime());
        }
    }

    public final void setTime(Time time) {
        if (this.setType != 14 && this.setType != 0) {
            this.typeProblem(this.setType, 14);
        }
        this.type = 14;
        if (this.timeVal == null) {
            this.timeVal = new Time(time.getTime());
        } else {
            this.timeVal.setTime(time.getTime());
        }
    }

    public final void setTimestamp(Timestamp timestamp) {
        if (this.setType != 15 && this.setType != 0) {
            this.typeProblem(this.setType, 15);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(((Date)timestamp).getTime());
        } else {
            ((Date)this.timestampVal).setTime(((Date)timestamp).getTime());
        }
        this.timestampVal.setNanos(timestamp.getNanos());
    }

    public final void setDate(long l) {
        if (this.setType != 13 && this.setType != 0) {
            this.typeProblem(this.setType, 13);
        }
        this.type = 13;
        if (this.dateVal == null) {
            this.dateVal = new java.sql.Date(System.currentTimeMillis());
        }
        this.dateVal.setTime(l);
    }

    public final void setTime(long l) {
        if (this.setType != 14 && this.setType != 0) {
            this.typeProblem(this.setType, 14);
        }
        this.type = 14;
        if (this.timeVal == null) {
            this.timeVal = new Time(System.currentTimeMillis());
        }
        this.timeVal.setTime(l);
    }

    public final void setTimestamp(long l, int n) {
        if (this.setType != 15 && this.setType != 0) {
            this.typeProblem(this.setType, 15);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(System.currentTimeMillis());
        }
        ((Date)this.timestampVal).setTime(l);
        this.timestampVal.setNanos(n);
    }

    public final void setTimestamp(long l) {
        if (this.setType != 15 && this.setType != 0) {
            this.typeProblem(this.setType, 15);
        }
        this.type = 15;
        if (this.timestampVal == null) {
            this.timestampVal = new Timestamp(System.currentTimeMillis());
        }
        ((Date)this.timestampVal).setTime(l / (long)1000 * (long)1000);
        int n = (int)(l % (long)1000 * (long)1000000);
        if (n < 0) {
            n = 1000000000 + n;
            ((Date)this.timestampVal).setTime((l / (long)1000 - (long)1) * (long)1000);
        }
        this.timestampVal.setNanos(n);
    }

    public final void setByteArray(byte[] byArray, int n) {
        if (this.setType != 18 && this.setType != 0) {
            this.typeProblem(this.setType, 18);
        }
        this.type = 18;
        this.byteArrayVal = byArray;
        this.intVal = n;
    }

    public final void setArrayLength(int n) {
        this.intVal = n;
    }

    public final void setBinaryStream(InputStream inputStream) {
        if (this.setType != 12 && this.setType != 0) {
            this.typeProblem(this.setType, this.setType);
        }
        this.type = 12;
        this.objectVal = inputStream;
    }

    public final void setVariant(Variant variant) {
        switch (variant.type) {
            case 16: {
                this.setString(variant.stringVal);
                break;
            }
            case 2: {
                this.setByte(variant.intVal);
                break;
            }
            case 3: {
                this.setShort((short)variant.intVal);
                break;
            }
            case 4: {
                this.setInt(variant.intVal);
                break;
            }
            case 11: {
                this.setBoolean(variant.booleanVal);
                break;
            }
            case 15: {
                this.setTimestamp(variant.getTimestamp());
                break;
            }
            case 13: {
                this.setDate(variant.getDate());
                break;
            }
            case 14: {
                this.setTime(variant.getTime());
                break;
            }
            case 5: {
                this.setLong(variant.longVal);
                break;
            }
            case 6: {
                this.setFloat((float)variant.doubleVal);
                break;
            }
            case 7: {
                this.setDouble(variant.doubleVal);
                break;
            }
            case 10: {
                if (variant.booleanVal) {
                    this.setBigDecimal(variant.stringVal);
                    break;
                }
                this.setBigDecimal(variant.bigDecimalVal);
                break;
            }
            case 12: {
                this.setBinaryStream((InputStream)variant.objectVal);
                break;
            }
            case 18: {
                this.setByteArray(variant.byteArrayVal, variant.intVal);
                break;
            }
            case 0: 
            case 1: {
                if (this.setType != variant.type && this.setType != 0) {
                    this.typeProblem(variant.type, this.setType);
                }
                this.type = variant.type;
                break;
            }
            default: {
                VariantException.fire(Res.format(2, new String[]{Variant.typeName(this.type)}));
            }
        }
    }

    public final void setObject(Object object) {
        if (this.setType != 17 && this.setType != 0) {
            this.typeProblem(this.setType, 17);
        }
        this.type = 17;
        this.objectVal = object;
    }

    public final Object getObject() {
        if (this.type != 17) {
            this.typeProblem(this.type, 17);
        }
        return this.objectVal;
    }

    public final int getAsInt() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return (int)this.longVal;
            }
            case 6: 
            case 7: {
                return (int)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().intValue();
            }
            case 0: 
            case 1: {
                return 0;
            }
        }
        this.typeProblem(this.type, 4);
        return 0;
    }

    public final long getAsLong() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: 
            case 7: {
                return (long)this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().longValue();
            }
            case 0: 
            case 1: {
                return 0L;
            }
        }
        this.typeProblem(this.type, 5);
        return 0L;
    }

    public final double getAsDouble() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal;
            }
            case 5: {
                return this.longVal;
            }
            case 6: 
            case 7: {
                return this.doubleVal;
            }
            case 10: {
                return this.getBigDecimal().doubleValue();
            }
            case 0: 
            case 1: {
                return 0.0;
            }
        }
        this.typeProblem(this.type, 7);
        return 0.0;
    }

    public final BigDecimal getAsBigDecimal() {
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return new BigDecimal((double)this.intVal);
            }
            case 5: {
                return new BigDecimal((double)this.longVal);
            }
            case 6: 
            case 7: {
                return new BigDecimal(this.doubleVal);
            }
            case 10: {
                return this.getBigDecimal();
            }
            case 0: 
            case 1: {
                return new BigDecimal(0.0);
            }
        }
        this.typeProblem(this.type, 10);
        return null;
    }

    public final void setNull(int n) {
        this.type = n == 0 ? 0 : 1;
    }

    public final void setAssignedNull() {
        this.type = 1;
    }

    public final void setUnassignedNull() {
        this.type = 0;
    }

    public final boolean isAssignedNull() {
        return this.type == 1;
    }

    public final boolean isUnassignedNull() {
        return this.type == 0;
    }

    public final boolean isNull() {
        return this.type <= 1;
    }

    public final int getType() {
        return this.type;
    }

    public final int getSetType() {
        return this.setType;
    }

    public final String toString() {
        switch (this.type) {
            case 0: 
            case 1: {
                return "";
            }
            case 2: 
            case 3: 
            case 4: {
                return Integer.toString(this.intVal, 10);
            }
            case 6: 
            case 7: {
                return Double.toString(this.doubleVal);
            }
            case 5: {
                return Long.toString(this.longVal, 10);
            }
            case 10: {
                if (this.booleanVal) {
                    return this.stringVal;
                }
                if (this.bigDecimalVal == null) {
                    return "";
                }
                return this.bigDecimalVal.toString();
            }
            case 11: {
                return this.booleanVal ? "true" : "false";
            }
            case 16: {
                if (this.stringVal == null) {
                    return "";
                }
                return this.stringVal;
            }
            case 13: {
                return this.dateVal.toString();
            }
            case 14: {
                return this.timeVal.toString();
            }
            case 15: {
                return this.timestampVal.toString();
            }
            case 18: {
                if (this.byteArrayVal == null) {
                    return "";
                }
                return new String(this.byteArrayVal, 0, 0, this.intVal);
            }
            case 12: 
            case 17: {
                if (this.objectVal == null) {
                    return "";
                }
                return this.objectVal.toString();
            }
        }
        return "";
    }

    public final boolean equals(Variant variant) {
        if (this.type != variant.type) {
            if (this.type <= 1 || variant.type <= 1) {
                return false;
            }
            this.typeProblem(variant.type, this.type);
        }
        switch (this.type) {
            case 0: 
            case 1: {
                return variant.type == this.type;
            }
            case 2: 
            case 3: 
            case 4: {
                return this.intVal == variant.intVal;
            }
            case 11: {
                return this.booleanVal == variant.booleanVal;
            }
            case 6: 
            case 7: {
                return this.doubleVal == variant.doubleVal;
            }
            case 15: {
                if (this.timestampVal.getNanos() != variant.getTimestamp().getNanos()) {
                    return false;
                }
                return ((Date)this.timestampVal).getTime() == ((Date)variant.getTimestamp()).getTime();
            }
            case 13: {
                return this.dateVal.getTime() == variant.getDate().getTime();
            }
            case 14: {
                return this.timeVal.getTime() == variant.getTime().getTime();
            }
            case 5: {
                return this.longVal == variant.longVal;
            }
            case 10: {
                if (this.booleanVal && variant.booleanVal && this.stringVal == variant.stringVal) {
                    return true;
                }
                if (this.getBigDecimal() == variant.getBigDecimal()) {
                    return true;
                }
                return this.bigDecimalVal.compareTo(variant.bigDecimalVal) == 0;
            }
            case 16: {
                if (this.stringVal == variant.stringVal) {
                    return true;
                }
                return this.stringVal.equals(variant.stringVal);
            }
            case 18: {
                int n;
                if (this.intVal != variant.intVal) {
                    return false;
                }
                if (this.byteArrayVal == variant.byteArrayVal) {
                    return true;
                }
                for (n = 0; this.byteArrayVal[n] == variant.byteArrayVal[n] && n < this.intVal; ++n) {
                }
                return n == this.intVal;
            }
            case 12: {
                return this.equals((InputStream)this.objectVal, (InputStream)variant.objectVal);
            }
            case 17: {
                if (this.objectVal == variant.objectVal) {
                    return true;
                }
                return this.objectVal.equals(variant.objectVal);
            }
        }
        return false;
    }

    private boolean equals(char[] cArray, char[] cArray2) {
        int n = cArray.length;
        if (n != cArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean equals(InputStream inputStream, InputStream inputStream2) {
        if (inputStream == inputStream2) {
            return true;
        }
        if (inputStream == null || inputStream2 == null) {
            return false;
        }
        try {
            inputStream.reset();
            inputStream2.reset();
            int n = 0;
            while (n != -1) {
                int n2;
                n = inputStream.read();
                if (n == (n2 = inputStream2.read())) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private final int compareLong(long l, long l2) {
        if (l < l2) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return 0;
    }

    private final int compareDouble(double d, double d2) {
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    private final int compareTimestamp(Timestamp timestamp, Timestamp timestamp2) {
        int n = this.compareLong(((Date)timestamp).getTime(), ((Date)timestamp2).getTime());
        if (n == 0) {
            return timestamp.getNanos() - timestamp2.getNanos();
        }
        return n;
    }

    private final int compareBoolean(boolean bl, boolean bl2) {
        if (bl == bl2) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Variant variant) {
        if (this.isNull()) {
            return variant.isNull() ? 0 : -1;
        }
        if (variant.isNull()) {
            return 1;
        }
        switch (this.type) {
            case 2: 
            case 3: 
            case 4: {
                return this.intVal - variant.getAsInt();
            }
            case 5: {
                return this.compareLong(this.longVal, variant.getAsLong());
            }
            case 6: 
            case 7: {
                return this.compareDouble(this.doubleVal, variant.getAsDouble());
            }
            case 10: {
                return this.getBigDecimal().compareTo(variant.getAsBigDecimal());
            }
            case 13: {
                return this.compareLong(this.dateVal.getTime(), variant.getDate().getTime());
            }
            case 14: {
                return this.compareLong(this.timeVal.getTime(), variant.getTime().getTime());
            }
            case 15: {
                return this.compareTimestamp(this.timestampVal, variant.getTimestamp());
            }
            case 11: {
                return this.compareBoolean(this.booleanVal, variant.getBoolean());
            }
            case 16: {
                return this.stringVal.compareTo(variant.getString());
            }
        }
        return 0;
    }

    public void add(Variant variant, Variant variant2) {
        if (variant.isNull() && this.isNull()) {
            variant2.setVariant(this);
        } else {
            switch (this.type) {
                case 4: {
                    variant2.setInt(this.intVal + variant.getAsInt());
                    break;
                }
                case 5: {
                    variant2.setLong(this.longVal + variant.getAsLong());
                    break;
                }
                case 7: {
                    variant2.setDouble(this.doubleVal + variant.getDouble());
                    break;
                }
                case 10: {
                    variant2.setBigDecimal(this.getBigDecimal().add(variant.getAsBigDecimal()));
                    break;
                }
                case 0: 
                case 1: {
                    variant2.setVariant(variant);
                    break;
                }
            }
        }
    }

    public void subtract(Variant variant, Variant variant2) {
        if (variant.isNull() && this.isNull()) {
            variant2.setVariant(this);
        } else {
            switch (this.type) {
                case 4: {
                    variant2.setInt(this.intVal - variant.getAsInt());
                    break;
                }
                case 5: {
                    variant2.setLong(this.longVal - variant.getAsLong());
                    break;
                }
                case 7: {
                    variant2.setDouble(this.doubleVal - variant.getAsDouble());
                    break;
                }
                case 10: {
                    variant2.setBigDecimal(this.getBigDecimal().subtract(variant.getAsBigDecimal()));
                    break;
                }
                case 0: 
                case 1: {
                    variant2.setVariant(variant);
                    break;
                }
            }
        }
    }

    public Object clone() {
        Variant variant = new Variant();
        variant.setVariant(this);
        return variant;
    }
}

