/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.model;

import borland.jbcl.model.ItemEditMask;
import borland.jbcl.model.ItemEditMaskRegion;
import borland.jbcl.model.ItemEditMaskRegionAMPM;
import borland.jbcl.model.ItemEditMaskRegionAny;
import borland.jbcl.model.ItemEditMaskRegionChar;
import borland.jbcl.model.ItemEditMaskRegionDayInMonth;
import borland.jbcl.model.ItemEditMaskRegionDayInWeek;
import borland.jbcl.model.ItemEditMaskRegionDayInYear;
import borland.jbcl.model.ItemEditMaskRegionERA;
import borland.jbcl.model.ItemEditMaskRegionHour11;
import borland.jbcl.model.ItemEditMaskRegionHour12;
import borland.jbcl.model.ItemEditMaskRegionHour23;
import borland.jbcl.model.ItemEditMaskRegionHour24;
import borland.jbcl.model.ItemEditMaskRegionLiteral;
import borland.jbcl.model.ItemEditMaskRegionMillisecond;
import borland.jbcl.model.ItemEditMaskRegionMinute;
import borland.jbcl.model.ItemEditMaskRegionMonthInYear;
import borland.jbcl.model.ItemEditMaskRegionNumeric;
import borland.jbcl.model.ItemEditMaskRegionSecond;
import borland.jbcl.model.ItemEditMaskRegionSign;
import borland.jbcl.model.ItemEditMaskRegionText;
import borland.jbcl.model.ItemEditMaskRegionTimeZone;
import borland.jbcl.model.ItemEditMaskRegionWeekInMonth;
import borland.jbcl.model.ItemEditMaskRegionWeekInYear;
import borland.jbcl.model.ItemEditMaskRegionYear;
import borland.jbcl.model.ItemEditMaskState;
import borland.jbcl.model.ItemEditMaskStrData;
import borland.jbcl.model.Res;
import borland.jbcl.model.SystemResourceBundle;
import borland.jbcl.model.VariantFormatStr;
import borland.jbcl.model.VariantFormatter;
import borland.jbcl.util.BooleanFormat;
import borland.jbcl.util.FastStringBuffer;
import borland.jbcl.util.InvalidFormatException;
import borland.jbcl.util.Variant;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class ItemEditMaskStr
implements ItemEditMask,
ItemEditMaskRegionChar {
    VariantFormatter formatter;
    char blankChar = (char)95;
    String editMask;
    String trueEditMask = null;
    Vector editRegions;
    Locale locale;
    int variantType;
    int formatterType;
    char decimalSign;
    char thousandsSign;
    int decimalAt = -1;
    int decimalDigits;
    char replaceBlanksWith = '\u0000';
    char autoSkipLiteral = '\u0000';
    byte[] regionMap = null;
    int startCursor = -1;
    boolean makeSymbolsLocal = false;
    int lastEditPos = 0;
    int signPrefixOffset = -1;
    int signSuffixOffset = -1;
    boolean noPattern = false;
    boolean allowLeftShift;

    /*
     * Enabled aggressive block sorting
     */
    public ItemEditMaskStr(String string, VariantFormatter variantFormatter, int n, Locale locale) {
        this.editMask = string;
        this.variantType = n;
        this.formatterType = VariantFormatStr.formatTypeFromVariantType(n);
        if (string != null) {
            this.trueEditMask = VariantFormatStr.buildTrueFormatMask(string);
        }
        if (variantFormatter == null) {
            this.formatter = new VariantFormatStr(this.trueEditMask, n, locale);
            if (this.formatter != null) {
                // empty if block
            }
        } else {
            this.formatter = variantFormatter;
        }
        this.locale = locale == null ? this.formatter.getLocale() : locale;
        this.editMask = string == null || string.length() == 0 ? this.formatter.getPattern() : string;
        this.localizeSymbols();
        this.trueEditMask = VariantFormatStr.buildTrueFormatMask(this.editMask);
        this.variantType = n < 1 ? this.formatter.getVariantType() : n;
        this.formatterType = VariantFormatStr.formatTypeFromVariantType(n);
        this.editRegions = new Vector(0);
        if (this.editMask == null || this.editMask.length() == 0) {
            this.noPattern = true;
            this.editRegions.addElement(new ItemEditMaskRegionAny(this));
        }
        switch (this.formatterType) {
            case 1: 
            case 2: {
                this.makeSymbolsLocal = true;
                this.buildNumericRegions();
                break;
            }
            case 3: {
                this.buildDateTimeRegions();
                break;
            }
            case 4: {
                Character c = (Character)this.formatter.getSpecialObject(2);
                this.replaceBlanksWith = c == null ? (char)'\u0000' : c.charValue();
                this.makeSymbolsLocal = true;
                this.buildTextRegions();
                break;
            }
            case 5: {
                this.buildBooleanRegions();
                break;
            }
            default: {
                return;
            }
        }
        this.buildRegionMap();
    }

    public ItemEditMaskStr(String string, VariantFormatter variantFormatter, int n) {
        this(string, variantFormatter, n, null);
    }

    public ItemEditMaskState prepare(Variant variant) {
        if (this.startCursor < 0) {
            this.startCursor = 0;
        }
        this.allowLeftShift = false;
        ItemEditMaskState itemEditMaskState = this.noPattern ? new ItemEditMaskState(0, 0) : new ItemEditMaskState(this.regionMap.length, this.startCursor < 0 ? this.regionMap.length - 1 : this.startCursor);
        ItemEditMaskStrData itemEditMaskStrData = new ItemEditMaskStrData(itemEditMaskState);
        itemEditMaskState.cursorPos = this.moveCursorOffLiteral(itemEditMaskState.cursorPos);
        if (variant == null || variant.isNull()) {
            this.buildEmptyEditString(itemEditMaskState);
        } else {
            this.buildVariantEditString(itemEditMaskState, variant);
        }
        return itemEditMaskState;
    }

    public boolean move(ItemEditMaskState itemEditMaskState, int n) {
        this.allowLeftShift = false;
        return this.internalMove(itemEditMaskState, n);
    }

    public boolean insert(ItemEditMaskState itemEditMaskState, char c) {
        char c2 = c;
        if (itemEditMaskState.cursorPos < 0) {
            itemEditMaskState.cursorPos = 0;
        }
        if (this.decimalAt > 0 && c == this.decimalSign) {
            return this.decimalAlign(itemEditMaskState);
        }
        if (!this.noPattern && this.allowLeftShift && itemEditMaskState.cursorPos >= this.lastEditPos) {
            this.shiftLeft(itemEditMaskState);
            itemEditMaskState.cursorPos = this.lastEditPos;
        } else if (itemEditMaskState.cursorPos >= this.lastEditPos && (this.formatterType == 2 || this.formatterType == 1)) {
            this.allowLeftShift = true;
        }
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(itemEditMaskState.cursorPos);
        if (itemEditMaskRegion instanceof ItemEditMaskRegionSign) {
            if (this.isValid(itemEditMaskState.cursorPos, c)) {
                this.setCharAt(itemEditMaskState.displayString, itemEditMaskState.cursorPos, c);
                for (int i = this.getBufferLength(itemEditMaskState.displayString) - 1; i > itemEditMaskState.cursorPos; --i) {
                    itemEditMaskRegion = this.getRegionFromPosition(i);
                    if (!(itemEditMaskRegion instanceof ItemEditMaskRegionSign)) continue;
                    ItemEditMaskRegionSign itemEditMaskRegionSign = (ItemEditMaskRegionSign)itemEditMaskRegion;
                    if (itemEditMaskRegionSign.prefix) break;
                    this.setCharAt(itemEditMaskState.displayString, i, c == ' ' ? (char)' ' : (char)itemEditMaskRegionSign.c);
                    break;
                }
                this.internalMove(itemEditMaskState, 39);
                return true;
            }
            this.internalMove(itemEditMaskState, 39);
        }
        if (this.isValid(itemEditMaskState.cursorPos, c)) {
            this.setCharAt(itemEditMaskState.displayString, itemEditMaskState.cursorPos, c);
            this.internalMove(itemEditMaskState, 39);
            return true;
        }
        if (this.autoSkipLiteral == c) {
            this.autoSkipLiteral = '\u0000';
            return true;
        }
        if (this.autoSkipLiteral != c) {
            for (int i = itemEditMaskState.cursorPos; i <= this.lastEditPos; ++i) {
                if (!this.isLiteral(i)) continue;
                ItemEditMaskRegionLiteral itemEditMaskRegionLiteral = (ItemEditMaskRegionLiteral)this.getRegionFromPosition(i);
                if (itemEditMaskRegionLiteral.capacity != 1) continue;
                if (c == itemEditMaskRegionLiteral.literal.charAt(0)) {
                    itemEditMaskState.cursorPos = i;
                    this.internalMove(itemEditMaskState, 39);
                    return true;
                }
                c2 = itemEditMaskRegionLiteral.literal.charAt(0);
            }
        }
        return false;
    }

    public boolean delete(ItemEditMaskState itemEditMaskState, int n, int n2) {
        boolean bl = false;
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i <= this.lastEditPos && n2 > 0; ++i, --n2) {
            if (this.isLiteral(i)) continue;
            this.deleteCharAt(itemEditMaskState.displayString, i, this.blankChar);
            this.setLastEditPosition(itemEditMaskState.displayString);
            bl = true;
        }
        return bl;
    }

    public boolean isComplete(ItemEditMaskState itemEditMaskState) {
        for (int i = 0; i < this.editRegions.size(); ++i) {
            if (this.isRegionComplete(itemEditMaskState, i)) continue;
            return false;
        }
        return true;
    }

    public void getFinalValue(ItemEditMaskState itemEditMaskState, Variant variant) throws InvalidFormatException {
        this.getVariantFromString(itemEditMaskState, variant, this.variantType);
    }

    public void getFinalValue(ItemEditMaskState itemEditMaskState, Variant variant, int n) throws InvalidFormatException {
        this.getVariantFromString(itemEditMaskState, variant, n);
    }

    public boolean isValid(int n, char c) {
        if (this.noPattern) {
            return true;
        }
        if (n < 0 || n > this.lastEditPos) {
            return false;
        }
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        return itemEditMaskRegion.isValid(n, c);
    }

    public boolean isOptional(int n) {
        if (this.noPattern) {
            return true;
        }
        boolean bl = false;
        if (n < 0 || n >= this.lastEditPos) {
            bl = true;
        } else {
            ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
            bl = itemEditMaskRegion.isOptional(n);
        }
        return bl;
    }

    public char setCharAt(StringBuffer stringBuffer, int n, char c) {
        if (n < 0 || n > this.lastEditPos) {
            return c;
        }
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        return itemEditMaskRegion.setCharAt(stringBuffer, n, c);
    }

    public char getCharAt(StringBuffer stringBuffer, int n) {
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        return itemEditMaskRegion.getCharAt(stringBuffer, n);
    }

    public boolean isLiteral(int n) {
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        return itemEditMaskRegion.isLiteral(n);
    }

    public void deleteCharAt(StringBuffer stringBuffer, int n, char c) {
        if (n < 0 || n > this.lastEditPos) {
            return;
        }
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        itemEditMaskRegion.deleteCharAt(stringBuffer, n, c);
    }

    public boolean isPassword(int n) {
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        if (itemEditMaskRegion instanceof ItemEditMaskRegionText) {
            ItemEditMaskRegionText itemEditMaskRegionText = (ItemEditMaskRegionText)itemEditMaskRegion;
            return itemEditMaskRegionText.password;
        }
        return false;
    }

    public char literalAt(int n) {
        ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(n);
        if (itemEditMaskRegion instanceof ItemEditMaskRegionLiteral) {
            return ((ItemEditMaskRegionLiteral)itemEditMaskRegion).literal.charAt(n - itemEditMaskRegion.offset);
        }
        return this.blankChar;
    }

    private ItemEditMaskRegion getRegionFromPosition(int n) {
        byte by = this.noPattern ? (byte)0 : this.regionMap[n];
        return (ItemEditMaskRegion)this.editRegions.elementAt(by);
    }

    private int getBufferLength(StringBuffer stringBuffer) {
        return this.noPattern ? stringBuffer.length() : this.regionMap.length;
    }

    int setLastEditPosition(StringBuffer stringBuffer) {
        if (this.noPattern) {
            this.lastEditPos = stringBuffer.length();
        }
        return this.lastEditPos;
    }

    private final String DateTimeFormat(java.util.Date date, String string) {
        this.formatter.setPattern(string);
        Variant variant = new Variant();
        switch (this.variantType) {
            case 14: {
                variant.setTime(date.getTime());
                break;
            }
            case 15: {
                variant.setTimestamp(date.getTime());
                break;
            }
            default: {
                variant.setDate(new Date(date.getTime()));
            }
        }
        String string2 = this.formatter.format(variant);
        return string2;
    }

    private final boolean DateTimeParse(String string, String string2, Variant variant, int n) {
        this.formatter.setPattern(string2);
        try {
            this.formatter.parse(string, variant, n);
        }
        catch (InvalidFormatException invalidFormatException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    private final String NumericFormat(double d, String string) {
        this.formatter.setPattern(string);
        Variant variant = new Variant();
        variant.setDouble(d);
        return this.formatter.format(variant);
    }

    private final Number NumericParse(String string, String string2, ItemEditMaskState itemEditMaskState) {
        Variant variant = new Variant();
        variant.setDouble(0.0);
        this.formatter.setPattern(string2);
        try {
            this.formatter.parse(string, variant, 7);
        }
        catch (InvalidFormatException invalidFormatException) {
            variant = null;
        }
        if (variant != null) {
            return new Double(variant.getDouble());
        }
        return null;
    }

    private final String TextFormat(String string, char c) {
        Character c2 = null;
        if (c != '\uffff') {
            c2 = (Character)this.formatter.setSpecialObject(1, new Character(c));
        }
        Variant variant = new Variant();
        variant.setString(string);
        String string2 = this.formatter.format(variant);
        if (c != '\uffff') {
            this.formatter.setSpecialObject(1, c2);
        }
        return string2;
    }

    private final String TextParse(String string, char c, char c2) {
        Object object = null;
        Object object2 = null;
        Variant variant = new Variant();
        if (c != '\uffff') {
            object = this.formatter.setSpecialObject(1, new Character(c));
        }
        if (c2 != '\uffff') {
            object2 = this.formatter.setSpecialObject(2, new Character(c2));
        }
        try {
            this.formatter.parse(string, variant, 16);
        }
        catch (InvalidFormatException invalidFormatException) {
            variant = null;
        }
        if (c != '\uffff') {
            this.formatter.setSpecialObject(1, object);
        }
        if (c2 != '\uffff') {
            this.formatter.setSpecialObject(2, object2);
        }
        return variant == null ? null : variant.getString();
    }

    private final String BooleanFormat(Boolean bl) {
        try {
            String string;
            Variant variant = new Variant();
            if (bl != null) {
                variant.setBoolean(bl);
            } else {
                variant.setAssignedNull();
            }
            String string2 = string = this.formatter.format(variant);
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            String string = null;
            return string;
        }
    }

    private final Boolean BooleanParse(String string) throws InvalidFormatException {
        Variant variant = new Variant();
        this.formatter.parse(string, variant, 11);
        return variant == null || variant.isNull() ? null : new Boolean(variant.getBoolean());
    }

    private boolean isRegionComplete(ItemEditMaskState itemEditMaskState, int n) {
        StringBuffer stringBuffer = itemEditMaskState.displayString;
        ItemEditMaskRegion itemEditMaskRegion = (ItemEditMaskRegion)this.editRegions.elementAt(n);
        if (itemEditMaskRegion instanceof ItemEditMaskRegionLiteral) {
            return true;
        }
        if (itemEditMaskRegion.optional) {
            return true;
        }
        int n2 = 0;
        for (int i = itemEditMaskRegion.offset; i < itemEditMaskRegion.offset + itemEditMaskRegion.capacity; ++i) {
            if (stringBuffer.charAt(i) != this.blankChar) continue;
            ++n2;
            if (itemEditMaskRegion.isOptional(i) || itemEditMaskRegion.minRequired != 0) continue;
            itemEditMaskState.cursorPos = i;
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        if (itemEditMaskRegion.capacity - n2 >= itemEditMaskRegion.minRequired) {
            return true;
        }
        itemEditMaskState.cursorPos = itemEditMaskRegion.rightToLeft ? itemEditMaskRegion.offset + itemEditMaskRegion.capacity - itemEditMaskRegion.minRequired : itemEditMaskRegion.offset + (itemEditMaskRegion.minRequired - n2);
        return false;
    }

    protected boolean shiftLeft(ItemEditMaskState itemEditMaskState) {
        StringBuffer stringBuffer = itemEditMaskState.displayString;
        int n = stringBuffer.length();
        if (this.noPattern) {
            return false;
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = 0;
        }
        int n2 = itemEditMaskState.cursorPos;
        boolean bl = false;
        if (n2 > this.lastEditPos) {
            n2 = this.lastEditPos;
        }
        while (n2 > 0) {
            int n3;
            int n4;
            for (n4 = n2; n4 > 0 && this.isLiteral(n4); --n4) {
            }
            if (n4 <= 0 || stringBuffer.charAt(n4) == this.blankChar) break;
            for (n3 = n4 - 1; n3 >= 0 && this.isLiteral(n3); --n3) {
            }
            if (n3 < 0) break;
            if (!this.isValid(n3, this.getCharAt(stringBuffer, n4))) {
                return false;
            }
            sArray[n3] = (short)n4;
            bl = true;
            n2 = n4;
            --n2;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                if (sArray[i] == 0) continue;
                char c = this.getCharAt(stringBuffer, sArray[i]);
                this.setCharAt(itemEditMaskState.displayString, i, c);
            }
        }
        if ((n2 = itemEditMaskState.cursorPos) > this.lastEditPos) {
            n2 = this.lastEditPos;
        }
        stringBuffer.setCharAt(n2, this.blankChar);
        return bl;
    }

    private final void localizeSymbols() {
        try {
            ResourceBundle resourceBundle = SystemResourceBundle.getBundle("java.text.resources.LocaleElements", this.locale);
            String[] stringArray = resourceBundle.getStringArray("NumberElements");
            this.decimalSign = stringArray[0].charAt(0);
            this.thousandsSign = stringArray[1].charAt(0);
        }
        catch (MissingResourceException missingResourceException) {
            this.decimalSign = (char)46;
            this.thousandsSign = (char)44;
        }
    }

    private final int moveCursorOffLiteral(int n) {
        int n2 = this.lastEditPos;
        if (n >= n2) {
            n = n2;
        }
        if (n < 0) {
            n = 0;
        }
        if (!this.isLiteral(n)) {
            return n;
        }
        int n3 = n + 1;
        for (int i = n - 1; n3 < n2 || i >= 0; ++n3, --i) {
            if (n3 < n2 && !this.isLiteral(n3)) {
                return n3;
            }
            if (i <= 0 || this.isLiteral(i)) continue;
            return i;
        }
        return n;
    }

    private final int charPositionsToHere(int n) {
        int n2 = 0;
        if (n >= this.editRegions.size()) {
            n = this.editRegions.size() - 1;
        }
        if (n >= 0) {
            ItemEditMaskRegion itemEditMaskRegion = (ItemEditMaskRegion)this.editRegions.elementAt(n);
            n2 = itemEditMaskRegion.offset + itemEditMaskRegion.capacity;
        }
        return n2;
    }

    private final void buildDateTimeRegions() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.editMask);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(fastStringBuffer.length());
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000') {
            block0 : switch (c) {
                case '{': {
                    bl = true;
                    break;
                }
                case '}': {
                    bl = false;
                    break;
                }
                case '^': {
                    this.startCursor = this.charPositionsToHere(this.editRegions.size()) + n2 - 1;
                    break;
                }
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'K': 
                case 'M': 
                case 'N': 
                case 'S': 
                case 'W': 
                case 'a': 
                case 'd': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'y': 
                case 'z': {
                    char c2;
                    if (n2 > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
                        n2 = 0;
                        fastStringBuffer2.empty();
                    }
                    n = 1;
                    while ((c2 = fastStringBuffer.nextChar()) == c) {
                        ++n;
                    }
                    if (c2 != '\u0000') {
                        fastStringBuffer.priorChar();
                    }
                    switch (c) {
                        case 'G': {
                            this.editRegions.addElement(new ItemEditMaskRegionERA(this, c, bl));
                            break block0;
                        }
                        case 'y': {
                            this.editRegions.addElement(new ItemEditMaskRegionYear(this, c, n, bl));
                            break block0;
                        }
                        case 'N': {
                            this.editRegions.addElement(new ItemEditMaskRegionMonthInYear(this, c, n, bl));
                            break block0;
                        }
                        case 'd': {
                            this.editRegions.addElement(new ItemEditMaskRegionDayInMonth(this, c, n, bl));
                            break block0;
                        }
                        case 'h': {
                            this.editRegions.addElement(new ItemEditMaskRegionHour12(this, c, n, bl));
                            break block0;
                        }
                        case 'H': {
                            this.editRegions.addElement(new ItemEditMaskRegionHour23(this, c, n, bl));
                            break block0;
                        }
                        case 'm': {
                            this.editRegions.addElement(new ItemEditMaskRegionMinute(this, c, n, bl));
                            break block0;
                        }
                        case 'M': {
                            this.editRegions.addElement(new ItemEditMaskRegionMonthInYear(this, c, n, bl));
                            break block0;
                        }
                        case 's': {
                            this.editRegions.addElement(new ItemEditMaskRegionSecond(this, c, n, bl));
                            break block0;
                        }
                        case 'S': {
                            this.editRegions.addElement(new ItemEditMaskRegionMillisecond(this, c, n, bl));
                            break block0;
                        }
                        case 'E': {
                            this.editRegions.addElement(new ItemEditMaskRegionDayInWeek(this, c, n, true));
                            break block0;
                        }
                        case 'D': {
                            this.editRegions.addElement(new ItemEditMaskRegionDayInYear(this, c, n, bl));
                            break block0;
                        }
                        case 'F': {
                            this.editRegions.addElement(new ItemEditMaskRegionWeekInMonth(this, c, n, bl));
                            break block0;
                        }
                        case 'w': {
                            this.editRegions.addElement(new ItemEditMaskRegionWeekInYear(this, c, n, bl));
                            break block0;
                        }
                        case 'W': {
                            this.editRegions.addElement(new ItemEditMaskRegionWeekInMonth(this, c, n, bl));
                            break block0;
                        }
                        case 'a': {
                            this.editRegions.addElement(new ItemEditMaskRegionAMPM(this, c, bl));
                            break block0;
                        }
                        case 'k': {
                            this.editRegions.addElement(new ItemEditMaskRegionHour24(this, c, n, bl));
                            break block0;
                        }
                        case 'K': {
                            this.editRegions.addElement(new ItemEditMaskRegionHour11(this, c, n, bl));
                            break block0;
                        }
                        case 'z': {
                            this.editRegions.addElement(new ItemEditMaskRegionTimeZone(this, c, n, bl));
                            break block0;
                        }
                    }
                    break;
                }
                case '\'': {
                    fastStringBuffer2.empty();
                    FastStringBuffer fastStringBuffer3 = fastStringBuffer.parseLiteral(c, true);
                    fastStringBuffer2.append(fastStringBuffer3.value(), 0, fastStringBuffer3.length());
                    this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
                    fastStringBuffer2.empty();
                    n2 = 0;
                    break;
                }
                case '\\': {
                    fastStringBuffer2.append(fastStringBuffer.parseBackSlash());
                    ++n2;
                    break;
                }
                default: {
                    fastStringBuffer2.append(c);
                    ++n2;
                }
            }
            c = fastStringBuffer.nextChar();
        }
        if (n2 > 0) {
            this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
        }
    }

    private final void buildNumericRegions() {
        block14: {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(this.editMask);
            FastStringBuffer fastStringBuffer2 = new FastStringBuffer(fastStringBuffer.length());
            int n = 0;
            int n2 = 0;
            this.decimalDigits = 0;
            this.decimalAt = -1;
            DecimalFormat decimalFormat = (DecimalFormat)this.formatter.getFormatObj();
            String string = decimalFormat.getNegativePrefix();
            if (decimalFormat != null && string.length() > 0) {
                this.signPrefixOffset = 0;
                this.editRegions.addElement(new ItemEditMaskRegionSign(this, string.charAt(0), true));
            }
            char c = fastStringBuffer.firstChar();
            while (c != '\u0000') {
                switch (c) {
                    case ';': {
                        fastStringBuffer.lastChar();
                        break;
                    }
                    case '^': {
                        this.startCursor = this.charPositionsToHere(this.editRegions.size()) + n + n2 - 1;
                        break;
                    }
                    case '#': 
                    case '0': 
                    case '{': 
                    case '}': {
                        if (n2 > 0) {
                            this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
                            n2 = 0;
                            fastStringBuffer2.empty();
                        }
                        fastStringBuffer2.append(c);
                        ++n;
                        break;
                    }
                    default: {
                        if (n > 0) {
                            this.editRegions.addElement(new ItemEditMaskRegionNumeric(this, fastStringBuffer2));
                            fastStringBuffer2.empty();
                            if (this.decimalAt >= 0) {
                                this.decimalDigits += n;
                            }
                            n = 0;
                        }
                        if ((c = this.localizeChar(c, true)) == this.decimalSign) {
                            this.decimalAt = this.charPositionsToHere(this.editRegions.size()) + n + n2;
                        }
                        fastStringBuffer2.append(c);
                        ++n2;
                        break;
                    }
                }
                c = fastStringBuffer.nextChar();
            }
            if (n2 > 0) {
                this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
            }
            if (n > 0) {
                this.editRegions.addElement(new ItemEditMaskRegionNumeric(this, fastStringBuffer2));
            }
            if (this.decimalAt >= 0) {
                this.decimalDigits += n;
            }
            string = decimalFormat.getNegativeSuffix();
            if (decimalFormat == null || string.length() <= 0 || string.length() <= n2) break block14;
            this.signSuffixOffset = this.editRegions.size();
            this.editRegions.addElement(new ItemEditMaskRegionSign(this, string.charAt(string.length() - 1), false));
        }
    }

    private final boolean internalMove(ItemEditMaskState itemEditMaskState, int n) {
        this.setLastEditPosition(itemEditMaskState.displayString);
        int n2 = itemEditMaskState.cursorPos;
        int n3 = 1;
        this.autoSkipLiteral = '\u0000';
        switch (n) {
            case 36: {
                n2 = 0;
                break;
            }
            case 35: {
                n2 = this.lastEditPos;
                n3 = -1;
                break;
            }
            case 37: {
                n3 = -1;
            }
            case 39: {
                n2 += n3;
                break;
            }
            case 500: 
            case 501: {
                break;
            }
            default: {
                return false;
            }
        }
        if (n2 > this.lastEditPos) {
            n2 = this.lastEditPos;
        }
        while (n2 >= 0 && n2 <= this.lastEditPos) {
            if (n2 < this.lastEditPos && this.isLiteral(n2)) {
                ItemEditMaskRegionLiteral itemEditMaskRegionLiteral = (ItemEditMaskRegionLiteral)this.getRegionFromPosition(n2);
                this.autoSkipLiteral = itemEditMaskRegionLiteral != null && itemEditMaskRegionLiteral.capacity == 1 ? itemEditMaskRegionLiteral.literal.charAt(0) : (char)'\u0000';
            } else {
                itemEditMaskState.cursorPos = n2;
                return true;
            }
            n2 += n3;
        }
        if (n == 500 || n == 501) {
            n2 = itemEditMaskState.cursorPos;
            n3 = -1;
            if (n2 > this.lastEditPos) {
                n2 = this.lastEditPos;
            }
            while (n2 >= 0 && n2 <= this.lastEditPos) {
                if (n2 >= this.lastEditPos || !this.isLiteral(n2)) {
                    itemEditMaskState.cursorPos = n2;
                    this.autoSkipLiteral = '\u0000';
                    return true;
                }
                n2 += n3;
            }
        }
        return false;
    }

    private final void buildTextRegions() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.editMask);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(fastStringBuffer.length());
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        boolean bl2 = false;
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000' && c != ';') {
            block0 : switch (c) {
                case '{': 
                case '}': {
                    if (n2 > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
                    }
                    if (n > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionText(this, fastStringBuffer2, n3, bl, bl2));
                    }
                    bl2 = c == '{';
                    n2 = 0;
                    n = 0;
                    fastStringBuffer2.empty();
                    break;
                }
                case '!': 
                case '*': 
                case '<': 
                case '>': 
                case '^': {
                    if (n2 > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
                        n2 = 0;
                    }
                    if (n > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionText(this, fastStringBuffer2, n3, bl, bl2));
                        n = 0;
                    }
                    fastStringBuffer2.empty();
                    switch (c) {
                        case '^': {
                            this.startCursor = this.charPositionsToHere(this.editRegions.size()) + n2 + n - 1;
                            break;
                        }
                        case '<': {
                            n3 = -1;
                            break;
                        }
                        case '>': {
                            n3 = 1;
                            break;
                        }
                        case '!': {
                            break;
                        }
                        case '*': {
                            bl = !bl;
                        }
                    }
                    break;
                }
                case '#': 
                case '&': 
                case '0': 
                case '9': 
                case '?': 
                case 'A': 
                case 'C': 
                case 'L': 
                case 'a': 
                case 'c': 
                case 'l': {
                    if (n2 > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
                        n2 = 0;
                        fastStringBuffer2.empty();
                    }
                    fastStringBuffer2.append(c);
                    ++n;
                    break;
                }
                default: {
                    if (n > 0) {
                        this.editRegions.addElement(new ItemEditMaskRegionText(this, fastStringBuffer2, n3, bl, bl2));
                        fastStringBuffer2.empty();
                        n = 0;
                    }
                    switch (c) {
                        case '\\': {
                            fastStringBuffer2.append(fastStringBuffer.parseBackSlash());
                            ++n2;
                            break block0;
                        }
                        case '\'': {
                            FastStringBuffer fastStringBuffer3 = fastStringBuffer.parseLiteral(c, true);
                            fastStringBuffer2.append(fastStringBuffer3.value(), 0, fastStringBuffer3.length());
                            n2 += fastStringBuffer3.length();
                            break block0;
                        }
                    }
                    c = this.localizeChar(c, true);
                    fastStringBuffer2.append(c);
                    ++n2;
                    break;
                }
            }
            c = fastStringBuffer.nextChar();
        }
        if (n2 > 0) {
            this.editRegions.addElement(new ItemEditMaskRegionLiteral(this, fastStringBuffer2));
        }
        if (n > 0) {
            this.editRegions.addElement(new ItemEditMaskRegionText(this, fastStringBuffer2, n3, bl, bl2));
        }
    }

    void buildBooleanRegions() {
        BooleanFormat booleanFormat = (BooleanFormat)this.formatter.getFormatObj();
        int n = booleanFormat.getTrueString().length();
        int n2 = booleanFormat.getFalseString().length();
        int n3 = booleanFormat.getNullString().length();
        if (n2 > n) {
            n = n2;
        }
        if (n3 > n) {
            n = n3;
        }
        this.editRegions.addElement(new ItemEditMaskRegionAny(this, n, true));
    }

    private final char[] buildEmptyEditCharArray() {
        int n = this.noPattern ? 0 : this.regionMap.length;
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(i);
            if (itemEditMaskRegion.isLiteral(n2)) {
                ItemEditMaskRegionLiteral itemEditMaskRegionLiteral = (ItemEditMaskRegionLiteral)itemEditMaskRegion;
                n3 = itemEditMaskRegionLiteral.capacity;
                itemEditMaskRegionLiteral.literal.getChars(0, n3, cArray, n2);
                n2 += n3;
            } else {
                for (n3 = 0; n3 < itemEditMaskRegion.capacity; ++n3) {
                    cArray[n2++] = this.blankChar;
                }
            }
            i = n2 - 1;
        }
        return cArray;
    }

    private final void buildEmptyEditString(ItemEditMaskState itemEditMaskState) {
        char[] cArray = this.buildEmptyEditCharArray();
        itemEditMaskState.displayString.setLength(0);
        itemEditMaskState.displayString.append(cArray);
    }

    private final char[] buildDateTimeEditString(java.util.Date date) {
        char[] cArray = this.buildEmptyEditCharArray();
        for (int i = 0; i < this.regionMap.length; ++i) {
            ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(i);
            if (!(itemEditMaskRegion instanceof ItemEditMaskRegionLiteral)) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(itemEditMaskRegion.c, Math.max(itemEditMaskRegion.capacity, itemEditMaskRegion.charCount));
                String string = this.DateTimeFormat(date, fastStringBuffer.toString());
                int n = string.length();
                n = Math.min(n, itemEditMaskRegion.capacity);
                string.getChars(0, n, cArray, itemEditMaskRegion.rightToLeft ? i + itemEditMaskRegion.capacity - n : i);
            }
            i += itemEditMaskRegion.capacity - 1;
        }
        return cArray;
    }

    private void buildNumericEditString(ItemEditMaskState itemEditMaskState, double d) {
        int n;
        boolean bl = d < 0.0;
        double d2 = bl ? -d : d;
        String string = this.NumericFormat(d2, this.trueEditMask);
        if (this.decimalAt >= 0 && string.indexOf(this.decimalSign) < 0) {
            string = String.valueOf(string).concat(String.valueOf(String.valueOf(this.decimalSign)));
        }
        FastStringBuffer fastStringBuffer = new FastStringBuffer(this.blankChar, this.regionMap.length);
        int n2 = this.decimalAt;
        if (n2 < 0) {
            for (n2 = this.regionMap.length - 1; n2 >= 0 && !(this.getRegionFromPosition(n2) instanceof ItemEditMaskRegionNumeric); --n2) {
            }
        }
        if ((n = string.indexOf(this.decimalSign)) < 0) {
            for (n = string.length() - 1; n >= 0 && !Character.isDigit(string.charAt(n)); --n) {
            }
        }
        int n3 = n;
        for (int i = n2; i >= 0; --i) {
            ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(i);
            if (itemEditMaskRegion instanceof ItemEditMaskRegionNumeric) {
                fastStringBuffer.setCharAt(i, n3 >= 0 && Character.isDigit(string.charAt(n3)) ? string.charAt(n3) : this.blankChar);
            } else if (itemEditMaskRegion instanceof ItemEditMaskRegionSign) {
                fastStringBuffer.setCharAt(i, bl ? ((ItemEditMaskRegionSign)itemEditMaskRegion).c : this.blankChar);
            } else if (itemEditMaskRegion.isLiteral(i)) {
                fastStringBuffer.setCharAt(i, this.literalAt(i));
            }
            --n3;
        }
        int n4 = n + 1;
        for (int i = n2 + 1; i < fastStringBuffer.length(); ++i) {
            ItemEditMaskRegion itemEditMaskRegion = this.getRegionFromPosition(i);
            if (itemEditMaskRegion instanceof ItemEditMaskRegionNumeric) {
                fastStringBuffer.setCharAt(i, n4 < string.length() && Character.isDigit(string.charAt(n4)) ? string.charAt(n4) : this.blankChar);
            } else if (itemEditMaskRegion instanceof ItemEditMaskRegionSign) {
                fastStringBuffer.setCharAt(i, bl ? ((ItemEditMaskRegionSign)itemEditMaskRegion).c : this.blankChar);
            } else if (itemEditMaskRegion.isLiteral(i)) {
                fastStringBuffer.setCharAt(i, this.literalAt(i));
            }
            ++n4;
        }
        itemEditMaskState.displayString.append(fastStringBuffer.toString());
    }

    private final void buildVariantEditString(ItemEditMaskState itemEditMaskState, Variant variant) {
        int n = variant.getType();
        itemEditMaskState.displayString.setLength(0);
        switch (this.formatterType) {
            case 1: 
            case 2: {
                double d;
                switch (n) {
                    case 6: 
                    case 7: {
                        d = variant.getAsDouble();
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        Integer n2 = new Integer(variant.getAsInt());
                        d = n2.doubleValue();
                        break;
                    }
                    case 5: {
                        Long l = new Long((int)variant.getLong());
                        d = l.doubleValue();
                        break;
                    }
                    case 10: {
                        BigDecimal bigDecimal = variant.getBigDecimal();
                        d = bigDecimal.doubleValue();
                        break;
                    }
                    default: {
                        this.buildEmptyEditString(itemEditMaskState);
                        return;
                    }
                }
                this.buildNumericEditString(itemEditMaskState, d);
                break;
            }
            case 3: {
                java.util.Date date;
                switch (n) {
                    case 5: {
                        date = new java.util.Date(variant.getLong());
                        break;
                    }
                    case 13: {
                        date = variant.getDate();
                        break;
                    }
                    case 14: {
                        Time time = variant.getTime();
                        date = new java.util.Date(time.getTime());
                        break;
                    }
                    case 15: {
                        Timestamp timestamp = variant.getTimestamp();
                        date = new java.util.Date(((java.util.Date)timestamp).getTime());
                        break;
                    }
                    default: {
                        this.buildEmptyEditString(itemEditMaskState);
                        return;
                    }
                }
                char[] cArray = this.buildDateTimeEditString(date);
                itemEditMaskState.displayString.setLength(0);
                itemEditMaskState.displayString.append(cArray);
                break;
            }
            case 4: {
                String string = variant.isNull() ? new String("") : variant.toString();
                String string2 = this.TextFormat(string, this.blankChar);
                itemEditMaskState.displayString.append(string2);
                while (itemEditMaskState.displayString.length() < this.getBufferLength(itemEditMaskState.displayString)) {
                    itemEditMaskState.displayString.append(this.blankChar);
                }
                break;
            }
            case 5: {
                String string = this.BooleanFormat(new Boolean(variant.getBoolean()));
                itemEditMaskState.displayString.append(string);
                int n3 = this.regionMap.length - string.length();
                while (n3-- > 0) {
                    itemEditMaskState.displayString.append(this.blankChar);
                }
                break;
            }
        }
    }

    private char localizeChar(char c, boolean bl) {
        if (!this.makeSymbolsLocal) {
            return c;
        }
        if (bl) {
            if (c == '.') {
                c = this.decimalSign;
            } else if (c == ',') {
                c = this.thousandsSign;
            }
        } else if (c == this.decimalSign) {
            c = (char)46;
        } else if (c == this.thousandsSign) {
            c = (char)44;
        }
        return c;
    }

    private final FastStringBuffer getFinalEditString(ItemEditMaskState itemEditMaskState) {
        StringBuffer stringBuffer = itemEditMaskState.displayString;
        int n = stringBuffer.length();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = this.getCharAt(stringBuffer, i);
            fastStringBuffer.append(c);
        }
        return fastStringBuffer;
    }

    private final FastStringBuffer stripBlanksAndLiterals(ItemEditMaskState itemEditMaskState) {
        FastStringBuffer fastStringBuffer = this.getFinalEditString(itemEditMaskState);
        char[] cArray = fastStringBuffer.value();
        int n = cArray.length;
        char c = fastStringBuffer.firstChar();
        while (c != '\u0000') {
            if (c == this.blankChar) {
                fastStringBuffer.removeChar();
            }
            c = fastStringBuffer.nextChar();
        }
        return fastStringBuffer;
    }

    private boolean isEmptyString(ItemEditMaskState itemEditMaskState) {
        for (int i = 0; i <= this.lastEditPos; ++i) {
            if (this.isLiteral(i) || this.getCharAt(itemEditMaskState.displayString, i) == this.blankChar) continue;
            return false;
        }
        return true;
    }

    private final void getVariantFromString(ItemEditMaskState itemEditMaskState, Variant variant, int n) throws InvalidFormatException {
        if (n <= 1) {
            n = this.variantType;
        }
        if (!this.isComplete(itemEditMaskState)) {
            throw new InvalidFormatException(Res.getString(18), itemEditMaskState.cursorPos);
        }
        if (itemEditMaskState.displayString.length() == 0 || this.isEmptyString(itemEditMaskState)) {
            variant.setNull(1);
            return;
        }
        switch (this.formatterType) {
            case 1: 
            case 2: {
                FastStringBuffer fastStringBuffer = this.stripBlanksAndLiterals(itemEditMaskState);
                Number number = this.NumericParse(fastStringBuffer.toString(), this.trueEditMask, itemEditMaskState);
                if (number == null) {
                    throw new InvalidFormatException(Res.getString(18), itemEditMaskState.cursorPos);
                }
                VariantFormatStr.doubleToVariant(number.doubleValue(), variant, n, this.formatter.getScale());
                break;
            }
            case 3: {
                FastStringBuffer fastStringBuffer = this.stripBlanksAndLiterals(itemEditMaskState);
                boolean bl = this.DateTimeParse(fastStringBuffer.toString(), this.trueEditMask, variant, n);
                if (bl) break;
                throw new InvalidFormatException(Res.getString(18), itemEditMaskState.cursorPos);
            }
            case 4: {
                String string = this.getFinalEditString(itemEditMaskState).toString();
                String string2 = this.TextParse(string, this.blankChar, this.replaceBlanksWith);
                VariantFormatStr.stringToVariant(string2, variant, n, this.formatter.getScale());
                break;
            }
            case 5: {
                String string = this.getFinalEditString(itemEditMaskState).toString();
                Boolean bl = this.BooleanParse(string);
                VariantFormatStr.booleanToVariant(bl, variant, n);
                break;
            }
            default: {
                variant.setNull(1);
            }
        }
    }

    private void buildRegionMap() {
        ItemEditMaskRegion itemEditMaskRegion;
        int n;
        if (this.noPattern) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.editRegions.size(); ++n) {
            itemEditMaskRegion = (ItemEditMaskRegion)this.editRegions.elementAt(n);
            n2 += itemEditMaskRegion.capacity;
        }
        this.regionMap = new byte[n2];
        for (n = 0; n < this.editRegions.size(); ++n) {
            itemEditMaskRegion = (ItemEditMaskRegion)this.editRegions.elementAt(n);
            if (itemEditMaskRegion.capacity == 0) continue;
            for (int i = 0; i < itemEditMaskRegion.capacity; ++i) {
                this.regionMap[n3++] = (byte)n;
            }
        }
        this.lastEditPos = this.regionMap.length - 1;
        while (this.lastEditPos > 0 && this.isLiteral(this.lastEditPos)) {
            --this.lastEditPos;
        }
        for (n = 0; n < n2; ++n) {
            itemEditMaskRegion = (ItemEditMaskRegion)this.editRegions.elementAt(this.regionMap[n]);
        }
    }

    private final boolean decimalAlign(ItemEditMaskState itemEditMaskState) {
        char c;
        ItemEditMaskRegion itemEditMaskRegion;
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = itemEditMaskState.displayString;
        int n4 = stringBuffer.length();
        boolean bl = false;
        if (itemEditMaskState.cursorPos == this.decimalAt + 1) {
            return false;
        }
        short[] sArray = new short[n4];
        FastStringBuffer fastStringBuffer = new FastStringBuffer(stringBuffer.toString());
        for (n3 = 0; n3 < n4; ++n3) {
            sArray[n3] = 0;
        }
        int n5 = n2 = itemEditMaskState.cursorPos == this.lastEditPos ? this.lastEditPos : itemEditMaskState.cursorPos - 1;
        while (n2 > 0 && this.isLiteral(n2)) {
            --n2;
        }
        for (n = this.decimalAt - 1; n2 >= 0 && n >= 0 && stringBuffer.charAt(n2) != this.blankChar; --n2, --n) {
            if (n2 == this.decimalAt) {
                ++n;
                continue;
            }
            itemEditMaskRegion = this.getRegionFromPosition(n2);
            c = itemEditMaskRegion instanceof ItemEditMaskRegionNumeric;
            itemEditMaskRegion = this.getRegionFromPosition(n);
            boolean bl2 = itemEditMaskRegion instanceof ItemEditMaskRegionNumeric;
            if (c == '\u0000') {
                if (!bl2) continue;
                ++n;
                continue;
            }
            if (!bl2) {
                ++n2;
                continue;
            }
            if (!this.isValid(n, this.getCharAt(stringBuffer, n2))) break;
            sArray[n] = (short)n2;
            bl = true;
        }
        if (bl) {
            for (n3 = 0; n3 < n4; ++n3) {
                if ((n3 >= n2 && n3 < this.decimalAt || n3 > this.decimalAt && n3 <= n2) && (itemEditMaskRegion = this.getRegionFromPosition(n3)) instanceof ItemEditMaskRegionNumeric) {
                    this.setCharAt(itemEditMaskState.displayString, n3, this.blankChar);
                }
                if (sArray[n3] == 0) continue;
                c = fastStringBuffer.charAt(sArray[n3]);
                this.setCharAt(itemEditMaskState.displayString, n3, c);
                if ((n2 >= n || sArray[n3] > n) && (n2 <= n || sArray[n3] < n2)) continue;
                this.setCharAt(itemEditMaskState.displayString, sArray[n3], this.blankChar);
            }
        }
        itemEditMaskState.cursorPos = this.decimalAt;
        return bl |= this.internalMove(itemEditMaskState, 39);
    }
}

