/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DirectIndex;
import borland.jbcl.dataset.IntColumn;
import borland.jbcl.dataset.InternalRow;
import borland.jbcl.dataset.MatrixData;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.dataset.RowFilterResponse;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.util.Variant;
import borland.jbcl.util.VetoException;

class MemoryIndex
extends DirectIndex {
    int[] vector;
    IntColumn statusColumn;
    int comp;
    int lastRow;
    int vectorLength;
    private DataColumn[] dataColumns;
    private InternalRow filterRow;
    private RowFilterResponse rowFilterResponse;

    public MemoryIndex(SortDescriptor sortDescriptor, RowFilterListener rowFilterListener, InternalRow internalRow, MatrixData matrixData, DataColumn[] dataColumnArray, int n, int n2, IntColumn intColumn) {
        super(matrixData);
        this.descriptor = sortDescriptor;
        this.visibleMask = n;
        this.invisibleMask = n2;
        this.statusColumn = intColumn;
        this.dataColumns = dataColumnArray;
        this.rowFilterListener = rowFilterListener;
        this.filterRow = internalRow;
        if (internalRow != null) {
            this.rowFilterResponse = new RowFilterResponse();
        }
        this.lastRow = -1;
        this.vector = new int[16];
        this.vectorLength = this.vector.length;
    }

    public final int internalRow(int n) {
        int n2;
        if (n > this.lastRow) {
            n = 0;
        }
        if ((n2 = this.vector[n]) < 1) {
            return 1;
        }
        return n2;
    }

    final boolean canAdd(int n) throws DataSetException {
        int n2 = this.statusColumn.vector[n];
        if ((n2 & this.visibleMask) == 0 || (n2 & this.invisibleMask) != 0) {
            return false;
        }
        if (this.filterRow != null) {
            this.filterRow.setInternalRow(n);
            this.rowFilterResponse.response = false;
            try {
                this.rowFilterListener.filterRow(this.filterRow, this.rowFilterResponse);
                boolean bl = this.rowFilterResponse.response;
                return bl;
            }
            catch (VetoException vetoException) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    final void vectorInsert(int n, int n2) {
        block3: {
            if (this.comp > 0 && n <= this.lastRow) {
                ++n;
            }
            if (++this.lastRow >= this.vectorLength) {
                this.growVector();
            }
            if (n > this.lastRow) break block3;
            if (n < this.lastRow) {
                System.arraycopy(this.vector, n, this.vector, n + 1, this.lastRow - n);
            }
            this.vector[n] = n2;
        }
    }

    final void growVector() {
        this.growVector(DataColumn.getNewSize(this.vectorLength));
    }

    void growVector(int n) {
        block1: {
            if (n <= this.vectorLength) break block1;
            int n2 = this.vectorLength;
            int[] nArray = new int[n];
            if (n2 > 0) {
                System.arraycopy(this.vector, 0, nArray, 0, n2);
            }
            this.vector = nArray;
            this.vectorLength = this.vector.length;
        }
    }

    protected final void vectorDelete(int n) {
        if (n <= this.lastRow) {
            if (n < this.lastRow) {
                System.arraycopy(this.vector, n + 1, this.vector, n, this.lastRow - n);
            }
            --this.lastRow;
        }
    }

    public final void load(int n) throws DataSetException {
        if (this.canAdd(n)) {
            if (++this.lastRow >= this.vectorLength) {
                this.growVector();
            }
            this.vector[this.lastRow] = n;
        }
    }

    public boolean add(int n) throws DataSetException {
        if (this.lastRow < 0 || n > this.vector[this.lastRow]) {
            this.load(n);
            return true;
        }
        if (this.canAdd(n)) {
            int n2 = this.findClosest(n);
            if (n2 < 0) {
                n2 = 0;
            }
            this.vectorInsert(n2, n);
            return true;
        }
        return false;
    }

    public void prepareReplace(int n) {
    }

    public void replace(int n) throws DataSetException {
        this.delete(n);
        this.add(n);
    }

    public final void delete(int n) {
        int n2 = this.findClosest(n);
        if (this.comp == 0) {
            this.vectorDelete(n2);
        }
    }

    protected final void printVector() {
        for (int i = 0; i <= this.lastRow; ++i) {
        }
    }

    final int vectorLength() {
        return this.vectorLength;
    }

    public final int findClosest(int n) {
        if (this.lastRow == -1) {
            return 0;
        }
        int n2 = this.lastRow;
        int n3 = 0;
        int n4 = -1;
        if (n == 0 || n >= this.statusColumn.lastRow) {
            return 0;
        }
        while (true) {
            n4 = (n3 + n2) / 2;
            this.compare(n, this.vector[n4]);
            if (this.comp > 0) {
                if (n3 >= n2) {
                    return n4;
                }
                n3 = n4 + 1;
                continue;
            }
            if (this.comp >= 0) break;
            if (n2 <= n3) {
                return n4;
            }
            n2 = n4 - 1;
        }
        return n4;
    }

    private final void checkIndex(int n) {
    }

    public final void loadSearchValues(Variant[] variantArray) throws DataSetException {
        for (int i = 0; i < this.locateColumnCount; ++i) {
            int n = this.locateColumns[i].ordinal;
            this.dataColumns[n].setVariant(0, variantArray[n]);
        }
    }

    public int locate(int n, int n2) throws DataSetException {
        if (n > this.lastRow) {
            return -1;
        }
        if ((n2 & 0x44) != 0) {
            return this.locateBackwards(n);
        }
        return this.locateForwards(n);
    }

    protected final int locateForwards(int n) {
        int n2 = this.lastRow() + 1;
        for (int i = n; i < n2; ++i) {
            if (!this.compareRow(i)) continue;
            return i;
        }
        return -1;
    }

    protected final int locateBackwards(int n) {
        for (int i = n; i > -1; --i) {
            if (!this.compareRow(i)) continue;
            return i;
        }
        return -1;
    }

    protected final boolean compareRow(int n) {
        for (int i = 0; i < this.locateColumnCount; ++i) {
            if (!(this.locatePartialIndex == i ? !this.dataColumns[this.locateColumns[i].ordinal].partialCompare(this.vector[n], 0, this.locateCaseInsensitive) : (this.locateCaseInsensitive ? this.dataColumns[this.locateColumns[i].ordinal].compareIgnoreCase(this.vector[n], 0) != 0 : this.dataColumns[this.locateColumns[i].ordinal].compare(this.vector[n], 0) != 0))) continue;
            return false;
        }
        return true;
    }

    public int lastRow() {
        return this.lastRow;
    }

    protected void compare(int n, int n2) {
        this.comp = n - n2;
    }
}

