/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.ColumnList;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.DataSetView;
import borland.jbcl.dataset.DetailIndex;
import borland.jbcl.dataset.Index;
import borland.jbcl.dataset.MasterLinkDescriptor;
import borland.jbcl.dataset.MasterNavigateEvent;
import borland.jbcl.dataset.MasterNavigateListener;
import borland.jbcl.dataset.MasterUpdateListener;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.OpenListener;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.ReadWriteRow;
import borland.jbcl.dataset.Res;
import borland.jbcl.dataset.RowFilterListener;
import borland.jbcl.dataset.RowVariant;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.dataset.StatusEvent;
import borland.jbcl.dataset.StatusListener;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.dataset.ValidationException;
import borland.jbcl.util.ErrorResponse;
import borland.jbcl.util.EventMulticaster;
import borland.jbcl.util.Variant;
import java.util.TooManyListenersException;

public abstract class DataSet
extends ReadWriteRow
implements StatusListener,
MasterNavigateListener,
AccessListener {
    private boolean open;
    private boolean editing;
    private boolean newRow;
    private boolean rowDirty;
    DataRow readRow;
    StorageDataSet dataSetStore;
    int currentRow;
    int internalRow;
    int postedRow;
    Index index;
    int invisibleMask;
    int visibleMask;
    private SortDescriptor descriptor;
    private boolean isInBounds;
    private NavigationEvent navigationEvent;
    private EventMulticaster navigationListeners;
    private EventMulticaster dataChangeListeners;
    private EventMulticaster accessListeners;
    private EventMulticaster validationErrorListeners;
    private EventMulticaster statusListeners;
    private EventMulticaster masterNavigateListeners;
    private MasterNavigateEvent masterNavigateEvent;
    private RowFilterListener rowFilterListener;
    private OpenListener openListener;
    private String lastColumnVisited;
    private MasterLinkDescriptor masterDetailDescriptor;
    private DetailIndex detailIndex;
    private boolean displayErrors;
    static EventMulticaster exceptionListeners;

    DataSet() {
        this.columnList = new ColumnList();
        this.visibleMask = 14;
        this.invisibleMask = 17;
        this.masterNavigateEvent = new MasterNavigateEvent(this);
        this.navigationEvent = new NavigationEvent(this);
        this.displayErrors = true;
    }

    public final int getRowCount() throws DataSetException {
        if (!this.open) {
            DataSetException.throwDataSetNotOpen();
        }
        if (this.index == null) {
            return 0;
        }
        if (this.editing && this.newRow) {
            return this.index.lastRow() + 2;
        }
        return this.index.lastRow() + 1;
    }

    public final int rowCount() throws DataSetException {
        return this.getRowCount();
    }

    public final boolean isEmpty() {
        return this.index.lastRow() == -1;
    }

    public final boolean atLast() throws DataSetException {
        return this.currentRow == this.rowCount() - 1;
    }

    public final boolean atFirst() {
        return this.currentRow == 0;
    }

    public final void first() throws DataSetException {
        boolean bl;
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                bl = this._goToRow(0);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
    }

    public final void last() throws DataSetException {
        boolean bl = false;
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                if (!this.editing || this._post()) {
                    bl = this._goToRow(this.rowCount() - 1);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
    }

    public final boolean next() throws DataSetException {
        boolean bl;
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                bl = this._goToRow(this.currentRow + 1);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
        return bl;
    }

    public final boolean prior() throws DataSetException {
        boolean bl;
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                bl = this._goToRow(this.currentRow - 1);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
        return bl;
    }

    final void masterNavigating() throws DataSetException {
        try {
            this.masterNavigateListeners.exceptionDispatch(this.masterNavigateEvent);
        }
        catch (Exception exception) {
            DataSetException.throwException(43, exception);
        }
    }

    public final void insertRow(boolean bl) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                if (this.masterNavigateListeners != null) {
                    this.masterNavigating();
                }
                if (!this.open) {
                    DataSetException.throwDataSetNotOpen();
                }
                if (this.dataSetStore.editListener != null) {
                    this.dataSetStore.processInserting(this);
                }
                if (!this.editing || this.rowDirty && this.post()) {
                    this.editing = true;
                    this.newRow = true;
                    this.setDefaultValues();
                    this.rowDirty = false;
                    if (!bl && this.index.lastRow() > -1) {
                        ++this.currentRow;
                    }
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
        if (!bl) {
            this.rowNavigatedDispatch();
        }
        this.rowAddedDispatch(this.currentRow);
        if (this.statusListeners != null) {
            this.notifyDataChangeStatus(63);
        }
        if (this.masterNavigateListeners != null) {
            this.masterNavigateListeners.dispatch(this.masterNavigateEvent);
        }
        if (this.dataSetStore.editListener != null) {
            this.dataSetStore.processInserted(this);
        }
    }

    public final void editRow() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (!this.editing) {
            if (this.dataSetStore.editListener != null) {
                this.dataSetStore.processModifying(this);
            }
            this.dataSetStore.editRow(this);
        }
    }

    final void _editRow() {
        if (!this.editing) {
            this.editing = true;
            this.newRow = false;
            this.rowDirty = false;
        }
    }

    public final boolean locate(ReadRow readRow, int n) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.dataSetStore.locate(this, readRow.getColumnList().getScopedColumns(), readRow, n)) {
            this.rowNavigatedDispatch();
            return true;
        }
        return false;
    }

    public final boolean lookup(ReadRow readRow, DataRow dataRow, int n) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        return this.dataSetStore.lookup(this, readRow.getColumnList().getScopedColumns(), readRow, dataRow, n);
    }

    public final boolean post() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                int n = this.currentRow;
                boolean bl = this._post();
                if (bl) {
                    this.internalRow = this.postedRow;
                    if (this.fixRowNeeded()) {
                        this._fixRowPosition();
                    }
                    if (n != this.currentRow) {
                        this.rowNavigatedDispatch();
                    }
                }
                if (bl && this.statusListeners != null) {
                    this.notifyDataChangeStatus(65);
                }
                boolean bl2 = bl;
                Object var6_5 = null;
                return bl2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    public final void cancel() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.editing) {
            StorageDataSet storageDataSet = this.dataSetStore;
            synchronized (storageDataSet) {
                try {
                    this._cancel();
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    throw throwable;
                }
            }
            this.rowDeletedDispatch(this.currentRow);
        }
    }

    public final void cancelLoading() {
        StorageDataSet storageDataSet = this.dataSetStore;
        if (storageDataSet != null) {
            storageDataSet.cancelDataSetLoading();
        }
    }

    public final void deleteRow() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.dataSetStore.editListener == null) {
            this.dataSetStore.deleteRow(this);
        } else {
            while (true) {
                try {
                    this.dataSetStore.processDeleting(this);
                    this.dataSetStore.deleteRow(this);
                }
                catch (DataSetException dataSetException) {
                    ErrorResponse errorResponse;
                    if ((errorResponse = this.dataSetStore.processDeleteError(this, dataSetException)).isRetry()) continue;
                    if (errorResponse.isAbort()) {
                        throw dataSetException;
                    }
                    return;
                }
                break;
            }
            this.dataSetStore.processDeleted(this);
        }
        if (this.statusListeners != null) {
            this.notifyDataChangeStatus(64);
        }
    }

    public final void deleteAllRows() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        this.dataSetStore.deleteAllRows(this);
    }

    public final String getTableName() {
        if (this.dataSetStore == null) {
            return null;
        }
        return this.dataSetStore.getStorageTableName();
    }

    public final String getSchemaName() {
        if (this.dataSetStore == null) {
            return null;
        }
        return this.dataSetStore.getStorageSchemaName();
    }

    public final void getVariant(String string, int n, Variant variant) throws DataSetException {
        this.getVariant(this.columnList.getOrdinal(string), n, variant);
    }

    public final void getVariant(int n, int n2, Variant variant) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.editing) {
            if (this.currentRow == n2) {
                variant.setVariant(this.getVariantStorage(n));
                return;
            }
            if (this.newRow && n2 > this.currentRow) {
                --n2;
            }
        }
        this.dataSetStore.getStorageVariant(this.index.internalRow(n2), n, variant);
    }

    final void rowEdited() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (!this.editing) {
            this.dataSetStore.startEditing();
            if (this.index.lastRow() == -1) {
                this.insertRow(true);
            } else {
                this.editRow();
            }
        }
        this.rowDirty = true;
    }

    void processColumnPost(RowVariant rowVariant) throws DataSetException {
        if (rowVariant.hasValidations) {
            rowVariant.validateAndSet(this);
        }
        if (this.notifyColumnPost) {
            this.notifyColumnPost(rowVariant);
        }
    }

    void notifyColumnPost(RowVariant rowVariant) throws DataSetException {
        if (rowVariant.column.getCalcType() == 0) {
            this.dataSetStore.calcUnpostedFields(this);
        }
        this.dataChangeListenersDispatch(new DataChangeEvent(this, 3, this.currentRow));
    }

    final Variant getVariantStorage(String string) throws DataSetException {
        if (this.editing) {
            return super.getVariantStorage(string);
        }
        if (!this.open) {
            DataSetException.throwDataSetNotOpen();
        }
        if (this.currentRow == 0 && this.rowCount() < 1) {
            return Variant.nullVariant;
        }
        return this.dataSetStore.getVariantStorage(this, string);
    }

    final Variant[] getRowValues() {
        return this.rowValues;
    }

    final Variant getVariantStorage(int n) throws DataSetException {
        if (this.editing) {
            return this.rowValues[n];
        }
        if (!this.open) {
            DataSetException.throwDataSetNotOpen();
        }
        if (this.currentRow == 0 && this.rowCount() < 1) {
            return Variant.nullVariant;
        }
        return this.dataSetStore.getVariantStorage(this, n);
    }

    public final boolean isNew(int n) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        return this.dataSetStore.isNewRow(this.index.internalRow(n));
    }

    public final int getStatus() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.editing && this.newRow) {
            return 4;
        }
        return this.dataSetStore.getStatus(this);
    }

    public final void resolvePending(boolean bl) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        this.dataSetStore.storageResolvePending(bl);
    }

    public final void markPending(boolean bl) throws DataSetException {
        this.index.markStatus(this.currentRow, 512, bl);
    }

    public final void updateRow(DataRow dataRow) throws ValidationException, DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        Column[] columnArray = dataRow.columnList.hasScopedColumns() ? dataRow.columnList.getScopedColumns() : null;
        if (this.dataSetStore.editListener == null) {
            this.updateRow(dataRow, columnArray);
        } else {
            while (true) {
                try {
                    this.updateRow(dataRow, columnArray);
                }
                catch (DataSetException dataSetException) {
                    ErrorResponse errorResponse;
                    if ((errorResponse = this.dataSetStore.processUpdateError(this, dataRow, dataSetException)).isRetry()) continue;
                    if (errorResponse.isAbort()) {
                        throw dataSetException;
                    }
                    return;
                }
                break;
            }
            this.dataSetStore.processUpdated(this);
        }
        this.dataSetStore.processRowChangePosted(this.internalRow);
    }

    private final void updateRow(DataRow dataRow, Column[] columnArray) throws DataSetException {
        if (this.editing && (this.newRow || this.rowDirty)) {
            Column[] columnArray2 = dataRow.columnList.getScopedColumns();
            for (int i = 0; i < columnArray2.length; ++i) {
                this.setVariant(columnArray2[i].getColumnName(), dataRow.getVariantStorage(i));
            }
            this.post();
        } else {
            this.dataSetStore.updateRow(this, dataRow, columnArray);
        }
    }

    public final void addRow(DataRow dataRow) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.dataSetStore.editListener == null) {
            this.dataSetStore.storageAddRow(dataRow);
        } else {
            while (true) {
                try {
                    this.dataSetStore.processAdding(this, dataRow);
                    this.dataSetStore.storageAddRow(dataRow);
                }
                catch (DataSetException dataSetException) {
                    ErrorResponse errorResponse;
                    if ((errorResponse = this.dataSetStore.processAddError(this, dataRow, dataSetException)).isRetry()) continue;
                    if (errorResponse.isAbort()) {
                        throw dataSetException;
                    }
                    return;
                }
                break;
            }
            this.dataSetStore.processAdded(this);
        }
    }

    public final void getDataRow(int n, DataRow dataRow) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        this.dataSetStore.getRowData(this, n, dataRow);
    }

    public final void getDataRow(DataRow dataRow) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        this.dataSetStore.getRowData(this, this.currentRow, dataRow);
    }

    public final void addAccessListener(AccessListener accessListener) {
        this.accessListeners = EventMulticaster.add(this.accessListeners, accessListener);
    }

    public final void removeAccessListener(AccessListener accessListener) {
        this.accessListeners = EventMulticaster.remove(this.accessListeners, accessListener);
    }

    public final void addNavigationListener(NavigationListener navigationListener) {
        this.navigationListeners = EventMulticaster.add(this.navigationListeners, navigationListener);
    }

    public final void removeNavigationListener(NavigationListener navigationListener) {
        this.navigationListeners = EventMulticaster.remove(this.navigationListeners, navigationListener);
    }

    public final void addDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners = EventMulticaster.add(this.dataChangeListeners, dataChangeListener);
        this.notifyColumnPost = this.dataChangeListeners != null;
    }

    public final void removeDataChangeListener(DataChangeListener dataChangeListener) {
        this.dataChangeListeners = EventMulticaster.remove(this.dataChangeListeners, dataChangeListener);
        this.notifyColumnPost = this.dataChangeListeners != null;
    }

    private final void notifyDataChangeStatus(int n) {
        if (this.statusListeners != null) {
            this.statusListeners.dispatch(new StatusEvent(this, 8, Res.getString(n)));
        }
    }

    public final void setDisplayErrors(boolean bl) {
        this.displayErrors = bl;
    }

    public final boolean isDisplayErrors() {
        return this.displayErrors;
    }

    public final void clearStatus() {
        if (this.statusListeners != null) {
            this.statusListeners.dispatch(new StatusEvent(this, 10, ""));
        }
    }

    boolean displayError(Exception exception) {
        if ((exception instanceof ValidationException || !this.displayErrors) && this.statusListeners != null) {
            this.statusListeners.dispatch(new StatusEvent(this, exception));
            return false;
        }
        return this.displayErrors;
    }

    public final void addStatusListener(StatusListener statusListener) throws DataSetException {
        this.statusListeners = EventMulticaster.add(this.statusListeners, statusListener);
    }

    public final void removeStatusListener(StatusListener statusListener) {
        this.statusListeners = EventMulticaster.remove(this.statusListeners, statusListener);
    }

    public final void addMasterNavigateListener(MasterNavigateListener masterNavigateListener) throws DataSetException {
        this.masterNavigateListeners = EventMulticaster.add(this.masterNavigateListeners, masterNavigateListener);
    }

    public final void removeMasterNavigateListener(MasterNavigateListener masterNavigateListener) {
        this.masterNavigateListeners = EventMulticaster.remove(this.masterNavigateListeners, masterNavigateListener);
    }

    public final void addRowFilterListener(RowFilterListener rowFilterListener) throws DataSetException, TooManyListenersException {
        if (rowFilterListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.rowFilterListener != null) {
            throw new TooManyListenersException();
        }
        this.rowFilterListener = rowFilterListener;
    }

    public final void removeRowFilterListener(RowFilterListener rowFilterListener) {
        this.rowFilterListener = null;
    }

    public final void addOpenListener(OpenListener openListener) throws TooManyListenersException {
        if (openListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.openListener != null) {
            throw new TooManyListenersException();
        }
        this.openListener = openListener;
    }

    public final void removeOpenListener(OpenListener openListener) {
        this.openListener = null;
    }

    public final RowFilterListener getRowFilterListener() {
        return this.rowFilterListener;
    }

    public final SortDescriptor getSort() {
        return this.descriptor;
    }

    String[] getSortKeys() {
        if (this.descriptor == null) {
            return null;
        }
        return this.descriptor.getKeys();
    }

    final void resetSort(SortDescriptor sortDescriptor) {
        this.descriptor = sortDescriptor;
    }

    public final synchronized void setSort(SortDescriptor sortDescriptor) throws DataSetException {
        this.failIfOpen();
        this.descriptor = sortDescriptor;
    }

    public synchronized void toggleViewOrder(String string) {
        boolean bl = false;
        String[] stringArray = this.getSortKeys();
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equals(string) && !this.descriptor.isDescending()) {
            bl = true;
        }
        try {
            int n = this.internalRow;
            boolean bl2 = this.open;
            if (this.open) {
                this.dataSetStore.closeStorage(8);
            }
            this.setSort(new SortDescriptor(new String[]{string}, false, bl));
            if (bl2) {
                this.open(new AccessEvent(this, 1, 2));
            }
            this.goToRow(this.index.findClosest(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void enableDataSetEvents(boolean bl) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        if (this.accessListeners != null) {
            if (!bl) {
                DataSet.dispatchAccessEvent(this.accessListeners, new AccessEvent(this, 2, 8));
            } else {
                DataSet.dispatchAccessEvent(this.accessListeners, new AccessEvent(this, 1, 2));
            }
        }
    }

    public final void setLastColumnVisited(String string) {
        this.lastColumnVisited = string;
    }

    public void interactiveLocate(String string, String string2, int n, boolean bl) {
        try {
            if (string2 == null) {
                string2 = this.lastColumnVisited;
            }
            if (string2 != null) {
                DataRow dataRow = new DataRow(this, string2);
                Column column = this.dataSetStore.getColumn(string2);
                if (column.getDataType() == 16) {
                    dataRow.setString(string2, string);
                    this.interactiveLocate(dataRow, n | 1);
                    if (string.length() < 1) {
                        this.statusMessage(6, Res.getString(75));
                    }
                } else if (bl || (n & 6) != 0) {
                    int n2 = column.getDataType();
                    Variant variant = new Variant(n2);
                    column.getFormatter().parse(string, variant);
                    dataRow.setVariant(string2, variant);
                    this.interactiveLocate(dataRow, n);
                    if (string.length() < 1) {
                        this.statusMessage(7, Res.getString(76));
                    }
                } else {
                    this.statusMessage(2, Res.getString(72));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void interactiveLocate(DataRow dataRow, int n) throws DataSetException {
        if (this.locate(dataRow, n)) {
            this.statusMessage(3, Res.getString(73));
        } else {
            this.statusMessage(4, Res.getString(74));
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    void failIfOpen() throws DataSetException {
        if (this.open) {
            DataSetException.throwDataSetOpen();
        }
    }

    private final void failIfNotOpen() throws DataSetException {
        if (!this.open) {
            DataSetException.throwDataSetNotOpen();
        }
    }

    public boolean close() throws DataSetException {
        return this.close(false, 7);
    }

    public void postAllDataSets() throws DataSetException {
        StorageDataSet storageDataSet = this.dataSetStore;
        if (storageDataSet != null && this != storageDataSet) {
            ((DataSet)storageDataSet).postAllDataSets();
        }
    }

    private final synchronized boolean close(boolean bl, int n) throws DataSetException {
        boolean bl2 = false;
        if (this.open && this.openListener != null) {
            this.openListener.closing(this);
        }
        if (this.open) {
            this._post();
            if (this.accessListeners != null) {
                DataSet.dispatchAccessEvent(this.accessListeners, new AccessEvent(this, 2, n));
            }
            this.open = false;
            bl2 = true;
            this.dataSetStore.removeStorageDataChangeListener(this);
            this.dataSetStore.removeStorageStatusListener(this);
            this.dataSetStore.closeIndex(this);
            if (!bl) {
                this.dataSetStore.removeStorageAccessListener(this);
            }
            this.index = null;
            if (this.dataSetStore == this) {
                this.dataSetStore.closeStorage(n);
            }
            if (this.detailIndex != null) {
                this.detailIndex.close(this, bl);
                this.detailIndex = null;
            }
            if (this.openListener != null) {
                this.openListener.closed(this);
            }
        } else if (this.dataSetStore != null && !bl) {
            this.dataSetStore.removeStorageAccessListener(this);
        }
        return bl2;
    }

    static void dispatchOpenAccessEvent(EventMulticaster eventMulticaster, Object object, AccessEvent accessEvent) throws DataSetException {
        if (eventMulticaster != null) {
            accessEvent = accessEvent == null ? new AccessEvent(object, 1) : new AccessEvent(object, accessEvent);
            DataSet.dispatchAccessEvent(eventMulticaster, accessEvent);
        }
    }

    static void dispatchAccessEvent(EventMulticaster eventMulticaster, AccessEvent accessEvent) throws DataSetException {
        if (eventMulticaster != null) {
            eventMulticaster.dispatch(accessEvent);
            if (accessEvent.getExceptionChain() != null) {
                DataSetException.throwException(61, Res.getString(52), accessEvent.getExceptionChain());
            }
        }
    }

    public boolean open() throws DataSetException {
        return this.open(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean open(AccessEvent accessEvent) throws DataSetException {
        if (this.isOpen()) {
            return false;
        }
        if (this.openListener != null) {
            this.openListener.opening(this);
        }
        DataSet dataSet = this;
        synchronized (dataSet) {
            try {
                if (this.dataSetStore != null) {
                    this.dataSetStore.removeStorageAccessListener(this);
                }
                if (this.dataSetStore != null) {
                    boolean bl = false;
                    try {
                        this.open = true;
                        this.dataSetStore.openStorage(this, accessEvent);
                        this.dataSetStore = this.dataSetStore;
                        if (this.masterDetailDescriptor != null && this.masterDetailDescriptor.getMasterDataSet() != null) {
                            this.detailIndex = new DetailIndex(this);
                            this.index = this.detailIndex;
                        } else {
                            this.dataSetStore.openIndex(this);
                        }
                        this.columnList = this.dataSetStore.columnList;
                        this.readRow = new DataRow(this.dataSetStore);
                        this.editing = false;
                        this.rowDirty = false;
                        this.newRow = false;
                        this.isInBounds = true;
                        this.initRowValues(true);
                        this.dataSetStore.addStorageDataChangeListener(this);
                        this.dataSetStore.addStorageStatusListener(this);
                        this.dataSetStore.addStorageAccessListener(this);
                        this._goToRow(0);
                        bl = true;
                        Object var5_4 = null;
                        if (!bl) {
                            this.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        if (!bl) {
                            this.close();
                        }
                        throw throwable;
                    }
                    DataSet.dispatchOpenAccessEvent(this.accessListeners, this, accessEvent);
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                throw throwable;
            }
        }
        if (this.openListener != null) {
            this.openListener.opened(this);
        }
        return true;
    }

    public final StorageDataSet getStorageDataSet() {
        return this.dataSetStore;
    }

    public final boolean canSet(Column column) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        try {
            this.dataSetStore.startEdit(this, column);
        }
        catch (DataSetException dataSetException) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public final void startEdit(Column column) throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        this.dataSetStore.startEdit(this, column);
        this.editRow();
    }

    final void setVisibleMask(int n, int n2) throws DataSetException {
        boolean bl = false;
        this.failIfOpen();
        DataSet dataSet = this;
        synchronized (dataSet) {
            try {
                if (n != 0 && (n != this.visibleMask || this.invisibleMask != n2)) {
                    this.visibleMask = n;
                    this.invisibleMask = n2;
                }
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
    }

    public final boolean canNavigate(Column column, int n) {
        return !column.readOnly;
    }

    public final int getRow() {
        return this.currentRow;
    }

    public final int row() {
        return this.getRow();
    }

    public final boolean goToRow(int n) throws DataSetException {
        boolean bl;
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                bl = this._goToRow(n);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
        return bl;
    }

    public final boolean goToClosestRow(int n) throws DataSetException {
        boolean bl;
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                bl = this._goToClosestRow(n);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        if (bl) {
            this.rowNavigatedDispatch();
        }
        return bl;
    }

    private final void rowNavigatedDispatch() {
        if (this.navigationListeners != null) {
            this.navigationListeners.dispatch(this.navigationEvent);
        }
    }

    public final void dataChangeListenersDispatch(DataChangeEvent dataChangeEvent) {
        this.dataChangeListeners.dispatch(dataChangeEvent);
    }

    private final void rowAddedDispatch(int n) {
        if (this.dataChangeListeners != null) {
            this.dataChangeListenersDispatch(new DataChangeEvent(this, 1, n));
        }
    }

    private final void rowDeletedDispatch(int n) {
        if (this.dataChangeListeners != null) {
            this.dataChangeListenersDispatch(new DataChangeEvent(this, 2, n));
        }
    }

    public void statusMessage(StatusEvent statusEvent) {
        block7: {
            if (statusEvent.getCode() == 1) {
                try {
                    if (!this.fixRowNeeded()) break block7;
                    StorageDataSet storageDataSet = this.dataSetStore;
                    synchronized (storageDataSet) {
                        try {
                            this._fixRowPosition();
                            Object var4_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var4_5 = null;
                            throw throwable;
                        }
                    }
                }
                catch (DataSetException dataSetException) {
                    // empty catch block
                }
            }
        }
        if (this.statusListeners != null) {
            this.statusListeners.dispatch(statusEvent);
        }
    }

    private void statusMessage(int n, String string) {
        if (this.statusListeners != null) {
            this.statusListeners.dispatch(new StatusEvent(this, n, string));
        }
    }

    final void postDataSet() throws DataSetException {
        try {
            this.post();
        }
        catch (Exception exception) {
            DataSetException.throwException(47, Res.getString(46), exception);
        }
    }

    final void dataChanged(int n, int n2) throws DataSetException {
        if (this.detailIndex != null || this.fixRowNeeded()) {
            StorageDataSet storageDataSet = this.dataSetStore;
            synchronized (storageDataSet) {
                try {
                    if (n2 == this.internalRow && this.editing && !this.newRow) {
                        this._cancel();
                    }
                    if (this.detailIndex != null) {
                        this.relinkDetail(false);
                    }
                    if (this.fixRowNeeded()) {
                        this._fixRowPosition();
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
        if (this.masterNavigateListeners != null) {
            this.masterNavigateListeners.dispatch(this.masterNavigateEvent);
        }
        if (this.dataChangeListeners != null) {
            if (n2 > -1) {
                int n3;
                try {
                    n3 = this.index.findClosest(n2);
                }
                catch (DataSetException dataSetException) {
                    n3 = -1;
                }
                this.dataChangeListenersDispatch(new DataChangeEvent(this, n, n3));
                if (n == 2) {
                    this.rowNavigatedDispatch();
                }
            } else {
                this.dataChangeListenersDispatch(new DataChangeEvent(this, n, -1));
            }
        }
    }

    public synchronized void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.open(accessEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                try {
                    this.close(true, accessEvent.getReason());
                    break;
                }
                catch (DataSetException dataSetException) {
                    accessEvent.appendException(dataSetException);
                }
            }
        }
    }

    final boolean _goToRow(int n) throws DataSetException {
        if (!this.editing || this._post()) {
            if (!this.open) {
                DataSetException.throwDataSetNotOpen();
            }
            if (n < 0 || n > this.index.lastRow() && n != 0) {
                this.isInBounds = false;
            } else {
                if (this.masterNavigateListeners != null) {
                    this.masterNavigating();
                }
                this.isInBounds = true;
                this.currentRow = n;
                this.internalRow = this.index.internalRow(n);
                if (this.masterNavigateListeners != null) {
                    this.masterNavigateListeners.dispatch(this.masterNavigateEvent);
                }
                return true;
            }
        }
        return false;
    }

    public final boolean inBounds() throws DataSetException {
        if (!this.open) {
            DataSetException.throwDataSetNotOpen();
        }
        return this.isInBounds && (this.index.lastRow() > -1 || this.rowCount() > 0);
    }

    public final void resetInBounds() throws DataSetException {
        if (!this.open) {
            this.failIfNotOpen();
        }
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                this.isInBounds = true;
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    private final boolean fixRowNeeded() throws DataSetException {
        return this.currentRow > this.index.lastRow() || this.internalRow != this.index.internalRow(this.currentRow);
    }

    final void _fixRowPosition() {
        if (this.editing && this.newRow) {
            try {
                int n = this.index.lastRow();
                if (this.currentRow > ++n) {
                    this.currentRow = n;
                }
            }
            catch (DataSetException dataSetException) {
                this.currentRow = 0;
            }
        } else {
            try {
                int n = this.index.findClosest(this.internalRow);
                int n2 = this.index.lastRow();
                if (this.internalRow != this.index.internalRow(n)) {
                    n = this.currentRow > n2 ? n2 : this.currentRow;
                }
                this._goToRow(n);
            }
            catch (DataSetException dataSetException) {
                try {
                    this._goToRow(0);
                }
                catch (DataSetException dataSetException2) {
                    // empty catch block
                }
            }
        }
    }

    final boolean _goToClosestRow(int n) throws DataSetException {
        if (this._goToRow(n)) {
            return true;
        }
        if (n < 0 || this.index.lastRow() < 0) {
            return this._goToRow(0);
        }
        return this._goToRow(this.index.lastRow());
    }

    final boolean _post() throws DataSetException {
        if (this.dataChangeListeners != null) {
            try {
                this.dataChangeListeners.exceptionDispatch(new DataChangeEvent(this, 6));
            }
            catch (Exception exception) {
                DataSetException.throwFieldPostError(exception);
            }
        }
        if (this.newRow) {
            if (this.rowDirty) {
                if (this.dataSetStore.editListener == null) {
                    this.postedRow = this.dataSetStore.storageAddRow(this);
                } else {
                    while (true) {
                        try {
                            this.dataSetStore.processAdding(this, this);
                            this.postedRow = this.dataSetStore.storageAddRow(this);
                        }
                        catch (DataSetException dataSetException) {
                            ErrorResponse errorResponse;
                            if ((errorResponse = this.dataSetStore.processAddError(this, this, dataSetException)).isRetry()) continue;
                            if (errorResponse.isAbort()) {
                                throw dataSetException;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        break;
                    }
                }
                this.rowDirty = false;
                this.editing = false;
                if (this.dataSetStore.editListener != null) {
                    this.dataSetStore.processAdded(this);
                }
                if (this.dataChangeListeners != null) {
                    this.dataChanged(1, this.postedRow);
                }
            } else {
                this.editing = false;
                this.rowDeletedDispatch(this.currentRow);
            }
            this.newRow = false;
        } else if (this.rowDirty) {
            if (this.dataSetStore.editListener == null) {
                this.dataSetStore.updateRow(this, this, null);
            } else {
                while (true) {
                    try {
                        this.dataSetStore.updateRow(this, this, null);
                    }
                    catch (DataSetException dataSetException) {
                        ErrorResponse errorResponse;
                        if ((errorResponse = this.dataSetStore.processUpdateError(this, this, dataSetException)).isRetry()) continue;
                        if (errorResponse.isAbort()) {
                            throw dataSetException;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    break;
                }
            }
            this.rowDirty = false;
            this.editing = false;
            this.postedRow = this.internalRow;
            this.dataSetStore.processRowChangePosted(this.internalRow);
            if (this.dataSetStore.editListener != null) {
                this.dataSetStore.processUpdated(this);
            }
        } else {
            this.editing = false;
            this.postedRow = this.internalRow;
        }
        if (this.detailIndex != null && this.dataSetStore.isStorageOpen()) {
            this.relinkDetail(false);
        }
        return true;
    }

    final void _cancel() throws DataSetException {
        if (this.editing) {
            if (this.dataSetStore.editListener != null) {
                this.dataSetStore.processCanceling(this);
            }
            this.editing = false;
            this.rowDirty = false;
        }
    }

    public final DataSetView cloneDataSetView() throws DataSetException {
        DataSetView dataSetView;
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                dataSetView = new DataSetView();
                dataSetView.setStorageDataSet(this.dataSetStore);
                if (this.descriptor != null) {
                    dataSetView.setSort(new SortDescriptor(this.descriptor));
                }
                if (this.rowFilterListener != null) {
                    try {
                        dataSetView.addRowFilterListener(this.rowFilterListener);
                    }
                    catch (TooManyListenersException tooManyListenersException) {
                        // empty catch block
                    }
                }
                if (this.isOpen()) {
                    dataSetView.open();
                    dataSetView._goToRow(this.currentRow);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        return dataSetView;
    }

    public final boolean isEditing() {
        return this.editing;
    }

    public final boolean isEditingNewRow() {
        return this.editing && this.newRow;
    }

    public void masterNavigating(MasterNavigateEvent masterNavigateEvent) throws Exception {
        if (this.masterNavigateListeners != null) {
            this.masterNavigating();
        }
        this.post();
    }

    public void masterNavigated(MasterNavigateEvent masterNavigateEvent) {
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                try {
                    this._cancel();
                }
                catch (DataSetException dataSetException) {
                    // empty catch block
                }
                if (this.detailIndex != null) {
                    this.relinkDetail(true);
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        try {
            this.first();
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    public void setDefaultValues() throws DataSetException {
        super.setDefaultValues();
        if (this.detailIndex != null) {
            this.detailIndex.setDefaultValues(this);
        }
    }

    public void setDefaultValues(DataRow dataRow) throws DataSetException {
        dataRow.setDefaultValues();
        if (this.detailIndex != null) {
            this.detailIndex.setDefaultValues(dataRow);
        }
    }

    private void relinkDetail(boolean bl) {
        this.detailIndex.reLink();
        if (bl) {
            try {
                this._goToRow(this.safeRowCount() - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dataChangeListeners != null) {
            this.dataChangeListenersDispatch(new DataChangeEvent(this, 5));
        }
    }

    private int safeRowCount() {
        try {
            int n = this.rowCount();
            return n;
        }
        catch (DataSetException dataSetException) {
            int n = 0;
            return n;
        }
    }

    final String formatRowValues() {
        if (this.isOpen()) {
            try {
                if (this.rowCount() > 0) {
                    String string = super.formatRowValues();
                    return string;
                }
            }
            catch (DataSetException dataSetException) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized void setMasterLink(MasterLinkDescriptor masterLinkDescriptor) throws DataSetException {
        this.failIfOpen();
        this.masterDetailDescriptor = masterLinkDescriptor;
    }

    public final MasterLinkDescriptor getMasterLink() {
        return this.masterDetailDescriptor;
    }

    final void addMasterUpdateListener(MasterUpdateListener masterUpdateListener) {
        this.dataSetStore.storageAddMasterUpdateListener(masterUpdateListener);
    }

    final void removeMasterUpdateListener(MasterUpdateListener masterUpdateListener) {
        this.dataSetStore.storageRemoveMasterUpdateListener(masterUpdateListener);
    }

    public boolean columnIsVisible(String string) throws DataSetException {
        String[] stringArray;
        if (!this.open) {
            DataSetException.throwDataSetNotOpen();
        }
        Column column = this.getColumn(string);
        switch (column.getVisible()) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        if (column.getCalcType() == 2) {
            return false;
        }
        if (column.isHidden()) {
            return false;
        }
        if (this.masterDetailDescriptor != null && (stringArray = this.masterDetailDescriptor.getDetailLinkColumns()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                return false;
            }
        }
        return true;
    }

    public synchronized Column persistentColumn(String string) {
        Column column = null;
        try {
            column = this.getColumn(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (column == null) {
            try {
                column = new Column(string, null, 16);
                this.dataSetStore.addColumn(column);
                column = this.getColumn(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        column.setPersist(true);
        return column;
    }

    public void goToRow(ReadRow readRow) throws DataSetException {
        if (this.dataSetStore != null && readRow instanceof DataSet) {
            DataSet dataSet = (DataSet)readRow;
            if (this.dataSetStore == dataSet.dataSetStore) {
                this.goToRow(this.index.findClosest(dataSet.internalRow));
                return;
            }
            this.locate(readRow, 32);
        }
    }

    public void saveChanges() throws DataSetException {
        this.failIfNotOpen();
        this.dataSetStore.saveChanges(this);
    }

    public void refresh() throws DataSetException {
        this.failIfNotOpen();
        this.dataSetStore.refresh();
    }

    public final int getInternalRow() throws DataSetException {
        return this.index.internalRow(this.currentRow);
    }

    public final boolean goToInternalRow(int n) throws DataSetException {
        if (this.internalRow != n) {
            StorageDataSet storageDataSet = this.dataSetStore;
            synchronized (storageDataSet) {
                block4: {
                    try {
                        int n2 = this.internalRow;
                        this.internalRow = n;
                        this._fixRowPosition();
                        if (this.internalRow == n) break block4;
                        this.internalRow = n2;
                        this._fixRowPosition();
                        boolean bl = false;
                        Object var6_5 = null;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        throw throwable;
                    }
                }
                Object var6_6 = null;
                {
                }
            }
            this.rowNavigatedDispatch();
        }
        return true;
    }

    void detailsFetched() {
        this.dataSetStore.detailsFetched(this.internalRow);
    }

    public void refetchRow(ReadWriteRow readWriteRow) throws DataSetException {
        if (this.dataSetStore == null || this.dataSetStore == this) {
            DataSetException.throwRefreshRowNotSupported();
        }
        this.dataSetStore.refetchRow(readWriteRow);
    }

    private void freeIndex() throws DataSetException {
        boolean bl = this.close();
        if (this.dataSetStore != null) {
            boolean bl2 = this.dataSetStore.close();
            this.dataSetStore.freeIndex(this);
            if (bl2) {
                this.dataSetStore.open();
            }
        }
        if (bl) {
            this.open();
        }
    }

    public void refilter() throws DataSetException {
        if (this.rowFilterListener != null) {
            this.freeIndex();
        }
    }

    public void dittoRow(boolean bl) throws DataSetException {
        this.failIfNotOpen();
        StorageDataSet storageDataSet = this.dataSetStore;
        synchronized (storageDataSet) {
            try {
                if (!(bl || this.editing && this.newRow)) {
                    ValidationException.throwCannotDittoExisting();
                }
                if (this.currentRow > 0) {
                    Column column;
                    int n = this.columnCount();
                    for (int i = 0; i < n; ++i) {
                        column = this.getColumn(i);
                        if (column.isReadOnly() || column.getCalcType() != 0) continue;
                        this.startEdit(column);
                    }
                    Variant variant = new Variant();
                    for (int i = 0; i < n; ++i) {
                        column = this.getColumn(i);
                        if (column.isReadOnly() || column.getCalcType() != 0) continue;
                        this.dataSetStore.getStorageVariant(this.index.internalRow(this.currentRow - 1), i, variant);
                        this.setVariant(i, variant);
                    }
                }
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                throw throwable;
            }
        }
    }

    public boolean saveChangesSupported() {
        return this.dataSetStore != null ? this.dataSetStore.saveChangesSupported() : false;
    }

    public boolean refreshSupported() {
        return this.dataSetStore != null ? this.dataSetStore.refreshSupported() : false;
    }
}

