/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.AggDescriptor;
import borland.jbcl.dataset.AggOperator;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.CustomAggOperator;
import borland.jbcl.dataset.DataRow;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.ReadRow;
import borland.jbcl.dataset.ReadWriteRow;
import borland.jbcl.dataset.SortDescriptor;
import borland.jbcl.dataset.StorageDataSet;
import borland.jbcl.util.Variant;

class Aggregator {
    private String[] groupColumnNames;
    private AggOperator[] operators;
    private AggOperator[] operatorMap;
    private int operatorCount = 0;
    private StorageDataSet aggDataSet;
    private DataRow searchRow;
    private boolean isUpdatable;

    Aggregator(StorageDataSet storageDataSet, int n) throws DataSetException {
        this.operatorMap = new AggOperator[storageDataSet.columnCount()];
        this.aggDataSet = storageDataSet.createAggDataSet();
        String[] stringArray = storageDataSet.getColumn(n).getAgg().getGroupColumnNames();
        this.groupColumnNames = new String[stringArray == null ? 0 : stringArray.length];
        for (int i = 0; i < this.groupColumnNames.length; ++i) {
            this.groupColumnNames[i] = stringArray[i];
            Column column = storageDataSet.getColumn(this.groupColumnNames[i]);
            this.aggDataSet.addColumn(column.getColumnName(), column.getDataType());
        }
        this.addColumn(storageDataSet, n);
    }

    void open() throws DataSetException {
        this.operators = new AggOperator[this.operatorCount];
        this.aggDataSet.setSort(new SortDescriptor(this.groupColumnNames, false, false));
        this.aggDataSet.open();
        this.searchRow = new DataRow((DataSet)this.aggDataSet, this.groupColumnNames);
        int n = -1;
        this.isUpdatable = false;
        for (int i = 0; i < this.operatorMap.length; ++i) {
            if (this.operatorMap[i] == null) continue;
            this.operators[++n] = this.operatorMap[i];
            this.operators[n].open(this.aggDataSet);
            if (!this.operators[n].isUpdatable()) continue;
            this.isUpdatable = true;
        }
    }

    void addColumn(StorageDataSet storageDataSet, int n) throws DataSetException {
        ++this.operatorCount;
        Column column = storageDataSet.getColumn(n);
        AggDescriptor aggDescriptor = column.getAgg();
        Column column2 = new Column(column.getColumnName(), column.getCaption(), column.getDataType());
        this.aggDataSet.addColumn(column2);
        this.operatorMap[n] = aggDescriptor.getAggOperator();
        this.operatorMap[n] = this.operatorMap[n] == null ? new CustomAggOperator() : (AggOperator)this.operatorMap[n].clone();
        Column column3 = aggDescriptor.getAggColumnName() == null && this.operatorMap[n] instanceof CustomAggOperator ? column : storageDataSet.getColumn(aggDescriptor.getAggColumnName());
        this.operatorMap[n].init(storageDataSet, this.aggDataSet, column2, column3);
    }

    private boolean locateNewRow(ReadRow readRow) throws DataSetException {
        if (!this.locate(readRow)) {
            readRow.copyTo(this.searchRow);
            this.aggDataSet.addRow(this.searchRow);
            this.locate(readRow);
            return true;
        }
        return false;
    }

    void add(ReadRow readRow, int n) throws DataSetException {
        if (this.isUpdatable) {
            boolean bl = this.locateNewRow(readRow);
            for (int i = 0; i < this.operators.length; ++i) {
                if (this.operators[i] == null) continue;
                this.operators[i].add(readRow, n, bl);
            }
            this.aggDataSet.post();
        }
    }

    void delete(ReadRow readRow, int n) throws DataSetException {
        if (this.isUpdatable) {
            this.locate(readRow);
            for (int i = 0; i < this.operators.length; ++i) {
                if (this.operators[i] == null) continue;
                this.operators[i].delete(readRow, n);
            }
            this.aggDataSet.post();
        }
    }

    void update(ReadRow readRow, ReadRow readRow2, int n) throws DataSetException {
        if (this.isUpdatable) {
            this.delete(readRow, n);
            this.add(readRow2, n);
        }
    }

    void updateCustomAggs(ReadRow readRow, ReadWriteRow readWriteRow) throws DataSetException {
        this.locateNewRow(readRow);
        int n = this.aggDataSet.columnCount();
        for (int i = 0; i < this.operatorMap.length; ++i) {
            Column column = readRow.getColumn(i);
            if (this.operatorMap[i] == null || readWriteRow.isUnassignedNull(column.getColumnName())) continue;
            this.operatorMap[i].set(readWriteRow.getVariantStorage(column.getColumnName()));
        }
        this.aggDataSet.post();
    }

    void getVariant(ReadRow readRow, int n, Variant variant) throws DataSetException {
        if (this.operatorMap[n] != null) {
            this.locate(readRow);
            this.operatorMap[n].get(variant);
        }
    }

    void getRowData(ReadRow readRow, ReadWriteRow readWriteRow) throws DataSetException {
        this.locate(readRow);
        Column[] columnArray = readWriteRow.columnList.getScopedColumns();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            if (this.operatorMap[column.ordinal] == null) continue;
            this.operatorMap[column.ordinal].get(readWriteRow.getVariantStorage(i));
        }
    }

    private boolean locate(ReadRow readRow) throws DataSetException {
        readRow.copyTo(this.searchRow);
        return this.aggDataSet.locate(this.searchRow, 32);
    }

    String[] getGroupColumnNames() {
        return this.groupColumnNames;
    }
}

