/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.Res;
import borland.jbcl.dataset.AccessEvent;
import borland.jbcl.dataset.AccessListener;
import borland.jbcl.dataset.Column;
import borland.jbcl.dataset.DataChangeEvent;
import borland.jbcl.dataset.DataChangeListener;
import borland.jbcl.dataset.DataSet;
import borland.jbcl.dataset.DataSetException;
import borland.jbcl.dataset.NavigationEvent;
import borland.jbcl.dataset.NavigationListener;
import borland.jbcl.dataset.SingletonDataSetManager;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.BlackBox;
import borland.jbcl.view.TextAreaView;
import java.awt.event.KeyEvent;

public class TextAreaControl
extends TextAreaView
implements NavigationListener,
DataChangeListener,
AccessListener,
WritableSingletonModel,
BlackBox {
    private DataSet dataSet;
    private String columnName;
    private boolean initialized = false;

    public TextAreaControl() {
        this.setModel(new BasicSingletonContainer());
    }

    public void setModel(SingletonModel singletonModel) {
        if (singletonModel == this) {
            throw new IllegalArgumentException(Res.getString(67));
        }
        super.setModel(singletonModel);
    }

    public void accessChange(AccessEvent accessEvent) {
        switch (accessEvent.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception exception) {
                    accessEvent.appendException(exception);
                }
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void navigated(NavigationEvent navigationEvent) {
        this.updateText();
    }

    public void dataChanged(DataChangeEvent dataChangeEvent) {
    }

    public void postRow(DataChangeEvent dataChangeEvent) throws Exception {
        String string;
        Object object = this.get();
        String string2 = string = object != null ? object.toString() : "";
        if (!string.equals(this.getText())) {
            this.postText();
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.openDataSet(dataSet);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
        this.bindDataSet();
    }

    public void addNotify() {
        super.addNotify();
        if (!this.initialized) {
            this.initialized = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    private void openDataSet(DataSet dataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeNavigationListener(this);
            this.dataSet.removeDataChangeListener(this);
            this.dataSet.removeAccessListener(this);
        }
        this.dataSet = dataSet;
        if (this.dataSet == null) {
            this.setModel(new BasicSingletonContainer());
        } else if (this.initialized || this.dataSet.isOpen()) {
            if (!this.dataSet.isOpen()) {
                try {
                    this.dataSet.open();
                }
                catch (DataSetException dataSetException) {
                    DataSetException.handleException(this.dataSet, this, dataSetException);
                    this.setModel(new BasicSingletonContainer());
                    return;
                }
                this.initialized = true;
            }
            this.dataSet.addAccessListener(this);
            this.dataSet.addNavigationListener(this);
            this.dataSet.addDataChangeListener(this);
            this.bindDataSet();
        }
    }

    private void bindDataSet() {
        Column column;
        if (this.dataSet != null && (column = this.dataSet.hasColumn(this.columnName)) != null) {
            this.setModel(new SingletonDataSetManager(this.dataSet, column));
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.getID() != 401 || keyEvent.isConsumed() || this.dataSet == null || !this.dataSet.isOpen()) {
            return;
        }
        try {
            switch (keyEvent.getKeyCode()) {
                case 155: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.insertRow(false);
                    break;
                }
                case 34: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.next();
                    break;
                }
                case 33: {
                    if (this.postOnFocusLost) {
                        this.postText();
                    }
                    this.dataSet.prior();
                }
            }
        }
        catch (DataSetException dataSetException) {
            // empty catch block
        }
    }

    public Object get() {
        return this.getModel().get();
    }

    public boolean canSet(boolean bl) {
        return this.getWriteModel() != null ? this.getWriteModel().canSet(bl) : false;
    }

    public void set(Object object) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().set(object);
        }
    }

    public void touched() {
        if (this.getWriteModel() != null) {
            this.getWriteModel().touched();
        }
    }

    public void enableModelEvents(boolean bl) {
        if (this.getWriteModel() != null) {
            this.getWriteModel().enableModelEvents(bl);
        }
    }
}

