// DNSEntry.java
// $Id: DNSEntry.java,v 1.1 1999/03/16 16:55:14 ylafon Exp $
// (c) COPYRIGHT MIT, INRIA and Keio, 1996-1999.
// Please first read the full copyright statement in file COPYRIGHT.html

package org.w3c.tools.log;

import java.lang.*;
import java.io.*;

public class DNSEntry implements Serializable {
    String  host     = null;
    boolean resolved = false;
    int     tries    = 0;

    boolean isResolved() {
	return resolved;
    }

    synchronized void notFound() {
	tries++;
	if (tries > 4) // enough is enough ;)
	    resolved = true;
    }

    void setHost(String host) {
	// has been resolved
	this.host = host;
	resolved  = true;
    }

    public DNSEntry(String host, boolean resolved) {
	this.host     = host;
	this.resolved = resolved;
	this.tries    = 0;
    }

    public DNSEntry(String host) {
        this.host     = host;
        this.resolved = true;
    }
}

