/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.attributes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;
import org.w3c.www.mime.MimeType;

public class MimeTypeAttributeEditor
extends AttributeEditor {
    protected MimeTypeAttributeComponent comp = null;
    protected boolean hasChanged = false;
    protected String oldvalue = null;

    public void clearChanged() {
        this.hasChanged = false;
    }

    protected void createComponent(String string) {
        if (this.comp == null) {
            this.comp = new MimeTypeAttributeComponent(this, string);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public Object getValue() {
        try {
            return new MimeType(this.comp.getText());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute, Object object, Properties properties) throws RemoteAccessException {
        MimeType mimeType = (MimeType)object;
        if (object == null) {
            this.oldvalue = "*none*";
            this.createComponent(this.oldvalue);
        } else {
            this.createComponent(mimeType.toString());
            this.oldvalue = mimeType.toString();
        }
    }

    public void resetChanges() {
        this.hasChanged = false;
        this.comp.setText(this.oldvalue);
    }

    protected void setModified() {
        this.hasChanged = true;
    }

    public void setValue(Object object) {
        this.oldvalue = (String)object;
        this.comp.setText(this.oldvalue);
    }

    class MimeTypeAttributeComponent
    extends JPanel
    implements ActionListener,
    DocumentListener {
        protected JTextField type = null;
        protected MimeTypeAttributeEditor editor = null;

        MimeTypeAttributeComponent(MimeTypeAttributeEditor mimeTypeAttributeEditor2, String string) {
            this.editor = mimeTypeAttributeEditor2;
            this.build(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string != null) {
                this.type.setText(string);
            }
        }

        private void addMenuListener(JMenuItem jMenuItem, String string) {
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand(string);
        }

        protected void build(String string) {
            JMenuBar jMenuBar = null;
            JMenu jMenu = null;
            JMenuItem jMenuItem = null;
            Hashtable hashtable = null;
            Enumeration enumeration = null;
            String[] stringArray = null;
            this.type = new JTextField(20);
            this.type.setBorder(BorderFactory.createLoweredBevelBorder());
            this.type.setText(string);
            this.type.getDocument().addDocumentListener(this);
            jMenuBar = new JMenuBar();
            jMenuBar.setBorderPainted(false);
            jMenu = new JMenu("MimeTypes");
            jMenuBar.setAlignmentX(0.0f);
            jMenuBar.setAlignmentY(0.0f);
            hashtable = PropertyManager.getPropertyManager().getMimeTypes();
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                JMenu jMenu2 = new JMenu(string2);
                jMenu2.addActionListener(this);
                stringArray = (String[])hashtable.get(string2);
                int n = 0;
                while (n < stringArray.length) {
                    jMenuItem = new JMenuItem(stringArray[n]);
                    this.addMenuListener(jMenuItem, String.valueOf(string2) + "/" + stringArray[n]);
                    jMenu2.add(jMenuItem);
                    ++n;
                }
                jMenu.add(jMenu2);
            }
            jMenuBar.add(jMenu);
            this.setLayout(new BorderLayout());
            this.add((Component)this.type, "West");
            this.add((Component)jMenuBar, "Center");
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            MimeTypeAttributeEditor.this.setModified();
        }

        public String getText() {
            return this.type.getText();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            MimeTypeAttributeEditor.this.setModified();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MimeTypeAttributeEditor.this.setModified();
        }

        public void setText(String string) {
            this.type.setText(string);
            this.editor.setModified();
        }
    }
}

