#include "jabber.h"

void deliver_local(char *to, char *packet)
{
	char *buff = NULL;

	buff = strgrow(buff,"<r from='",1,0);
	buff = strgrow(buff,pair_getval(etc.vars, "name"),1,0);
	buff = strgrow(buff,"' to='",1,0);
	buff = strgrow(buff,to,1,0);
	buff = strgrow(buff,"'>",1,0);
	buff = strgrow(buff,packet,1,0);
	buff = strgrow(buff,"</r>",1,0);
	transport->packets = packet_add(transport->packets,buff,"");
	free(buff);
}

void deliver_message(	char *from_id,
			char *from_user,
			char *to_id,
			char *to_user,
			char *subject,
			char *say,
			char *thread,
			char *ext,
			int priority)
{
	session *s, *best;
	char *str = NULL, *server;
	module **m;
	int i;
	pair *par;

	DBUG("Delivering Message, to",to_id)

	if(strstr(to_id,"@") == NULL)
	{
		best = session_lookup(NULL,to_id,to_user);
		if(best == NULL) /* sending directly to known session */
		{
			best = s = session_lookup(NULL,to_id,NULL);
			while(s != NULL)
			{
				if(s->priority > best->priority)
					best = s;
				s = s->lookup_next;
			}
		}
		if(best != NULL) /* sending to best-guess session for same user*/
		{
			/* special situation, if we recieve an "invite" message to this user, we might be able to automatically add them to this users roster and tell this user we just did so */
			if(ext != NULL && strcmp(ext,"invite") == 0 && best->security >= SEC_SAFE)
			{
				str = print_message(from_id,from_user,
					"Added to your list","Note: This message was automatically generated by the system.\n\nThis user added you to their list, and was automatically added to your Roster in the 'others' group.",
					NULL,NULL,0,best->id,best->user,best->c->type);
				if(best->mod != MOD_NONE && modules[best->mod]->roster != NULL)
					modules[best->mod]->roster(ROSTER_ADD,best->id,from_id,"others");
				if(best->flag_status != STATUS_OFFLINE)
					deliver_status(best->id,best->user,from_id,best->say,best->status,best->flag_status);

			}else{
				str = print_message(from_id,from_user,subject,say,thread,ext,priority,best->id,best->user,best->c->type);
			}
			best->c->packets = packet_add(best->c->packets,str,"");
			free(str);
			return;
		}
		i = 0;
		for(m = modules; *m != NULL; m++)
		{
			if((*m)->offline_message != NULL)
			{
				par = pair_add(NULL,strdup("from"),from_id);
				par = pair_add(par,strdup("subject"),subject);
				par = pair_add(par,strdup("say"),say);
				par = pair_add(par,strdup("thread"),thread);
				par = pair_add(par,strdup("ext"),ext);
				par = pair_add(par,strdup("priority"),NULL);
				par->flag = priority;
				if((*m)->offline_message(to_id,par))
				{
					/* stored message till user comes back online */
					DBUG("Recipient offline, message stored","")
					i = 1;
					break;
				}
			}
		}
		/* couldn't deliver message, tell someone who might care */
		if(i == 0)
		{
			DBUG("Local Delivery Failed","")
			if(ext != NULL && strcmp(ext,"error") == 0) /* bail out, don't create a loop */
				return;
			str = strgrow(str,"Your message",1,0);
			if(to_id != NULL)
			{
				str = strgrow(str," to ",1,0);
				str = strgrow(str,tag_escape(to_id),1,1);
			}
			str = strgrow(str," could not be delivered, either the recipient doesn't exist, or it couldn't be stored until they return online.\n\nMessage:\n",1,0);
			if(say != NULL)
				str = strgrow(str,tag_escape(say),1,1);
			deliver_message("system",NULL,from_id,from_user,"Message Rejected",str,thread,"error",0);
			free(str);
			return;
		}
	}else{ /* forward this message on to the right server */
		server = strstr(to_id,"@");
		*server = '\0'; /* cut off just the username and leave it in to_id */
		++server; /* it's now the server address */

		DBUG("Forwarding message to remote server",server)

		str = print_message(from_id,from_user,subject,say,thread,ext,priority,to_id,to_user,CONN_LOCAL);
		deliver_local(server, str);
		free(str);
	}
}

char *print_message(	char *from_id,
			char *from_user,
			char *subject,
			char *say,
			char *thread,
			char *ext,
			int priority,
			char *to_id,
			char *to_user,
			int flag)
{
	char *ret = NULL;
	char intbuff[20];
	pair *par;
	tag *t;

	DBUG("Printing Message","")
	ret = strgrow(ret,"<j type='message'",1,0);
	if(flag == CONN_LOCAL && from_id != NULL)
	{
		ret = strgrow(ret," from='",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"@",1,0);
		ret = strgrow(ret,pair_getval(etc.vars, "name"),1,0);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_LOCAL && from_user != NULL)
	{
		ret = strgrow(ret," nick='",1,0);
		ret = strgrow(ret,tag_escape(from_user),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_MULTI && to_id != NULL)
	{
		ret = strgrow(ret," for='",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	ret = strgrow(ret,">",1,0);
	if(flag == CONN_LOCAL && to_id != NULL)
	{
		ret = strgrow(ret,"<to",1,0);
		if(to_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(to_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"</to>",1,0);
	}
	if((flag == CONN_MULTI || flag == CONN_NORMAL) && from_id != NULL)
	{
		par = NULL;
		if(from_user != NULL)
		{
			par = pair_new(NULL,"name",from_user,0);
		}
		t = tag_new("from", par, from_id, 1);
		ret = strgrow(ret,tag2str(t,1),1,1);
		free_tag(t);
		free_pair(par);
	}
	if(priority != 0)
	{
		sprintf(intbuff,"%d",priority);
		ret = strgrow(ret,make_tag_quick("priority",intbuff),1,1);
	}
	ret = strgrow(ret,make_tag_quick("thread",thread),1,1);
	if(ext != NULL)
	{
		ret = strgrow(ret,"<ext>",1,0);
		ret = strgrow(ret,ext,1,0);
		ret = strgrow(ret,"</ext>",1,0);
	}
	ret = strgrow(ret,make_tag_quick("subject",subject),1,1);
	ret = strgrow(ret,make_tag_quick("say",say),1,1);
	ret = strgrow(ret,"</j>",1,0);

	return ret;
}


void deliver_status(char *from_id, char *from_user, char *to, char *say, char *status, int type)
{
	session *s;
	char *str = NULL, *server;
	int i = 0;

	DBUG("Delivering Status to",to)
	if(to == NULL || from_id == NULL || from_user == NULL)
		return;

	if(strstr(to,"@") == NULL)
	{
		s = session_lookup(NULL,to,NULL);
		if(s == NULL)
			return;
		if(	type == STATUS_ONLINE &&
			 strstr(from_id,"@") != NULL)
		{
			/* ask the module if we can tell others the status */
			/* also tells the module to update this remote user for future normal status updates */
			if(s->mod != MOD_NONE && modules[s->mod]->notify != NULL)
				i = modules[s->mod]->notify(from_id, type);
		}
		while(s != NULL)
		{
			DBUG("Looping through users sessions",s->user)
			if(s->flag_status != STATUS_OFFLINE && type == STATUS_ONLINE)
			{ /* When a new user comes online, we want to send them our status */
				if(strstr(from_id,"@") != NULL)
				{
					/* be extra careful it it's a remote user */
					if(i == 1 || s->security >= SEC_SAFE)
					{
						DBUG("Bouncing status to remote user",from_id)
						deliver_status(s->id, s->user, from_id, s->say, s->status, STATUS_NORMAL);
					}
				}else{
					DBUG("Bouncing status to local user",from_id)
					deliver_status(s->id, s->user, from_id, s->say, s->status, STATUS_NORMAL);
				}
			}

			if(s->flag_sendstatus == 1)
			{ /* deliver to a local WAITING user */
				/* make sure we don't deliver to the same session! */
				if(!(s->id != NULL && strcmp(s->id,from_id) == 0 && s->user != NULL && strcmp(s->user,from_user) == 0))
				{
					DBUG("Status s->id",s->id)
					DBUG("Status from_id",from_id)
					DBUG("Status s->user",s->user)
					DBUG("Status from_user",from_user)
					/* we only deliver !STATUS_ONLINE to local clients, STATUS_ONLINE is incoming from clients and outgoing for transports only */
					if(type == STATUS_ONLINE)
						str = print_status(from_id,from_user,say,status,STATUS_NORMAL,to,s->c->type);
					else
						str = print_status(from_id,from_user,say,status,type,to,s->c->type);
					s->c->packets = packet_add(s->c->packets,str,"");
					free(str);
				}
			}
			s = s->lookup_next;
		}
	}else{
		server = strstr(to,"@");
		*server = '\0'; /* cut off just the username and leave it in to */
		++server; /* it's now the server address */

		DBUG("Forwarding status to remote server",server)

		str = print_status(from_id,from_user,say,status,type,to,CONN_LOCAL);
		deliver_local(server, str);
		free(str);
	}
	DBUG("Done Delivering Status to",to)
}


char *print_status(char *from_id, char *from_user, char *say, char *status, int type, char *to_id, int flag)
{
	char *ret = NULL;

	DBUG("Printing Status from",from_id)
	ret = strgrow(ret,"<j type='status'",1,0);
	if(flag == CONN_LOCAL && from_id != NULL)
	{
		ret = strgrow(ret," from='",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"@",1,0);
		ret = strgrow(ret,pair_getval(etc.vars, "name"),1,0);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_LOCAL && from_user != NULL)
	{
		ret = strgrow(ret," nick='",1,0);
		ret = strgrow(ret,tag_escape(from_user),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	if(flag == CONN_MULTI && to_id != NULL)
	{
		ret = strgrow(ret," for='",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	ret = strgrow(ret,">",1,0);
	if(flag == CONN_LOCAL && to_id != NULL)
	{
		ret = strgrow(ret,"<to>",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"</to>",1,0);
	}
	if((flag == CONN_MULTI || flag == CONN_NORMAL) && from_id != NULL)
	{
		ret = strgrow(ret,"<from",1,0);
		if(from_user != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(from_user),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(from_id),1,1);
		ret = strgrow(ret,"</from>",1,0);
	}
	if(say != NULL)
	{
		ret = strgrow(ret,"<say",1,0);
		if(type != STATUS_NORMAL)
		{
			ret = strgrow(ret," type='",1,0);
			if(type == STATUS_OFFLINE)
				ret = strgrow(ret,"offline",1,0);
			if(type == STATUS_ONLINE)
				ret = strgrow(ret,"online",1,0);
			ret = strgrow(ret,"'",1,0);
		}
		ret = strgrow(ret,">",1,0);
		ret = strgrow(ret,tag_escape(say),1,1);
		ret = strgrow(ret,"</say>",1,0);
	}
	if(status != NULL)
	{
		ret = strgrow(ret,"<status>",1,0);
		ret = strgrow(ret,tag_escape(status),1,1);
		ret = strgrow(ret,"</status>",1,0);
	}
	ret = strgrow(ret,"</j>",1,0);

	return ret;
}



void deliver_roster(char *to_id, char *to_user, pair *par)
{
	session *s;
	char *ret = NULL;

	DBUG("Delivering Roster to ",to_id)
	s = session_lookup(NULL, to_id, to_user);
	if(s == NULL)
		return;

	ret = strgrow(ret,"<j type='roster'",1,0);
	if(s->c->type == CONN_MULTI && to_id != NULL)
	{
		ret = strgrow(ret," for='",1,0);
		ret = strgrow(ret,tag_escape(to_id),1,1);
		ret = strgrow(ret,"'",1,0);
	}
	ret = strgrow(ret,">",1,0);
	while(par != NULL)
	{
		ret = strgrow(ret,"<group",1,0);
		if(par->val != NULL)
		{
			ret = strgrow(ret," name='",1,0);
			ret = strgrow(ret,tag_escape(par->val),1,1);
			ret = strgrow(ret,"'",1,0);
		}
		if(par->key == NULL)
		{
			ret = strgrow(ret,"/>",1,0);
		}else{
			ret = strgrow(ret,">",1,0);
			ret = strgrow(ret,tag_escape(par->key),1,1);
			ret = strgrow(ret,"</group>",1,0);
		}
		par = par->next;
	}
	ret = strgrow(ret,"</j>",1,0);
	s->c->packets = packet_add(s->c->packets,ret,"");
	free(ret);
}



void deliver_connection(conn *c, char *to)
{
	char *buff = NULL;

	DBUG("Delivering Connection information to ",c->name)
	buff = strgrow(buff,"<j type='connection'><name>",1,0);
	buff = strgrow(buff,pair_getval(etc.vars, "name"),1,0);
	buff = strgrow(buff,"</name><ver>",1,0);
	buff = strgrow(buff,VERSION,1,0);
	buff = strgrow(buff,"</ver><protocol>",1,0);
	buff = strgrow(buff,PROTOCOL,1,0);
	buff = strgrow(buff,"</protocol></j>",1,0);
	if(c->type == CONN_LOCAL)
		deliver_local(buff, to);
	else
		c->packets = packet_add(c->packets,buff,"");
	free(buff);
}

