package Juno2;


import java.io.Serializable;
import java.util.HashMap;


public class PositionListCVO implements Serializable
{
	private LoginVO lvo;
	private AccountVO avo;
	private HashMap positionList;
	private HashMap equityList;
	
    public PositionListCVO()	{
		this.positionList = new HashMap();
		this.equityList = new HashMap();		
	}
    public PositionListCVO(AccountVO avo)	{
		this.positionList = new HashMap();
		this.equityList = new HashMap();			
		setAccountVO(avo);
	}
    public PositionListCVO(LoginVO lvo)	{
		this.positionList = new HashMap();
		this.equityList = new HashMap();			
		setLoginVO(lvo);
	}	
	public boolean addPosition(PositionVO pvo) {
		positionList.put(pvo.getSymbol(), pvo);
		return true;
	}
	public boolean addPositionList(HashMap hm) {
		positionList = hm;
		return true;
	}


	public boolean addEquity(EquityVO evo) {
		equityList.put(evo.getSymbol(), evo);
		return true;
	}
	public boolean addEquityList(HashMap hm) {
		equityList = hm;
		return true;
	}
	
	public boolean getLoginState() {
		return(lvo.getLoginState());
	}
	
	public String getAccountId() {
		return(avo.getAccountId());
	}
	public String getUserId() {
		return(lvo.getUserId());
	}
	public float getAccountBalance(){
		return(avo.getAccountBalance());
	}
    public String getAccountDescription(){
		return(avo.getAccountDescription());
	}
	public HashMap getPositionList() {
		return(positionList);
	}
	public HashMap getEquityList() {
		return(equityList);
	}	
	public void setAccountVO(AccountVO avo){
		this.avo = avo;
	}
	public void setLoginVO(LoginVO lvo){
		this.lvo = lvo;
	}
    public String toString(){
        return this.getClass().getName() + ":" +
	        lvo + " " +
			avo + ", " +
			positionList + ", " +			
			equityList;
    }
}


