/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.upload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.struts.upload.FormFile;

public class DiskFile
implements FormFile {
    protected String filePath;
    protected String contentType;
    protected int fileSize;
    protected String fileName;

    public DiskFile(String filePath) {
        this.filePath = filePath;
    }

    public byte[] getFileData() throws FileNotFoundException, IOException {
        byte[] bytes = new byte[this.getFileSize()];
        FileInputStream fis = new FileInputStream(this.filePath);
        fis.read(bytes);
        fis.close();
        return bytes;
    }

    public byte[] getFileData(int bufferSize) throws FileNotFoundException, IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        FileInputStream fis = new FileInputStream(this.filePath);
        int readLength = 0;
        int totalLength = 0;
        int offset = 0;
        byte[] bytes = new byte[bufferSize];
        while ((readLength = fis.read(bytes, offset, bufferSize)) != -1) {
            byteStream.write(bytes, offset, bufferSize);
            totalLength += readLength;
            offset += readLength;
        }
        bytes = byteStream.toByteArray();
        fis.close();
        byteStream.close();
        return bytes;
    }

    public void destroy() {
        File tempFile = new File(this.filePath);
        if (tempFile.exists()) {
            tempFile.delete();
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFileName(String filename) {
        this.fileName = filename;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        return new FileInputStream(this.filePath);
    }
}

