/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.taglib.template;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.struts.taglib.template.InsertTag;
import org.apache.struts.taglib.template.util.Content;

public class PutTag
extends BodyTagSupport {
    private String name;
    private String role;
    private String content = null;
    private String direct = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDirect(String direct) {
        this.direct = direct;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getDirect() {
        if (this.hasBody()) {
            return "true";
        }
        return this.direct == null ? "false" : "true";
    }

    public int doEndTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        if (this.role != null && !request.isUserInRole(this.role)) {
            return 6;
        }
        InsertTag insertTag = (InsertTag)this.getAncestor("org.apache.struts.taglib.template.InsertTag");
        if (insertTag == null) {
            throw new JspException("PutTag.doEndTag(): No InsertTag ancestor");
        }
        insertTag.put(this.name, new Content(this.getActualContent(), this.getDirect()));
        return 6;
    }

    public void release() {
        super.release();
        this.role = null;
        this.direct = null;
        this.content = null;
        this.name = null;
    }

    private String getActualContent() throws JspException {
        boolean contentSpecified;
        String bodyAndContentMismatchError = "Please specify template content in this tag's body or with the content attribute, but not both.";
        String bodyAndDirectMismatchError = "If content is specified in the tag body, the direct attribute must be true.";
        boolean hasBody = this.hasBody();
        boolean bl = contentSpecified = this.content != null;
        if (hasBody && contentSpecified || !hasBody && !contentSpecified) {
            throw new JspException(bodyAndContentMismatchError);
        }
        if (hasBody && this.direct != null && this.direct.equalsIgnoreCase("false")) {
            throw new JspException(bodyAndDirectMismatchError);
        }
        return hasBody ? this.bodyContent.getString() : this.content;
    }

    private boolean hasBody() {
        if (this.bodyContent == null) {
            return false;
        }
        return !this.bodyContent.getString().equals("");
    }

    private TagSupport getAncestor(String className) throws JspException {
        Class<?> klass = null;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            this.pageContext.setAttribute("org.apache.struts.action.EXCEPTION", (Object)ex, 2);
            throw new JspException(ex.getMessage());
        }
        return (TagSupport)TagSupport.findAncestorWithClass((Tag)this, klass);
    }
}

