/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.rowset;

import java.io.Serializable;
import java.sql.SQLException;
import javax.sql.RowSetMetaData;
import sun.jdbc.rowset.ColInfo;

public class RowSetMetaDataImpl
implements RowSetMetaData,
Serializable {
    private int colCount;
    private ColInfo[] colInfo;

    private void checkColRange(int n) throws SQLException {
        if (n <= 0 || n > this.colCount) {
            throw new SQLException("Invalid column index");
        }
    }

    public String getCatalogName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].catName;
    }

    public String getColumnClassName(int n) throws SQLException {
        return null;
    }

    public int getColumnCount() throws SQLException {
        return this.colCount;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnDisplaySize;
    }

    public String getColumnLabel(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnLabel;
    }

    public String getColumnName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].columnName;
    }

    public int getColumnType(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colType;
    }

    public String getColumnTypeName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colTypeName;
    }

    public int getPrecision(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colPrecision;
    }

    public int getScale(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].colScale;
    }

    public String getSchemaName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].schemaName;
    }

    public String getTableName(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].tableName;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].autoIncrement;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].caseSensitive;
    }

    public boolean isCurrency(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].currency;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        return true;
    }

    public int isNullable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].nullable;
    }

    public boolean isReadOnly(int n) throws SQLException {
        this.checkColRange(n);
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].searchable;
    }

    public boolean isSigned(int n) throws SQLException {
        this.checkColRange(n);
        return this.colInfo[n].signed;
    }

    public boolean isWritable(int n) throws SQLException {
        this.checkColRange(n);
        return false;
    }

    public void setAutoIncrement(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].autoIncrement = bl;
    }

    public void setCaseSensitive(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].caseSensitive = bl;
    }

    public void setCatalogName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].catName = new String(string);
    }

    public void setColumnCount(int n) throws SQLException {
        if (n <= 0) {
            throw new SQLException("Invalid column count");
        }
        this.colCount = n;
        this.colInfo = new ColInfo[this.colCount + 1];
        int n2 = 1;
        while (n2 <= this.colCount) {
            this.colInfo[n2] = new ColInfo();
            ++n2;
        }
    }

    public void setColumnDisplaySize(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnDisplaySize = n2;
    }

    public void setColumnLabel(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnLabel = new String(string);
    }

    public void setColumnName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].columnName = new String(string);
    }

    public void setColumnType(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colType = n2;
    }

    public void setColumnTypeName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colTypeName = new String(string);
    }

    public void setCurrency(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].currency = bl;
    }

    public void setNullable(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].nullable = n2;
    }

    public void setPrecision(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colPrecision = n2;
    }

    public void setScale(int n, int n2) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].colScale = n2;
    }

    public void setSchemaName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].schemaName = new String(string);
    }

    public void setSearchable(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].searchable = bl;
    }

    public void setSigned(int n, boolean bl) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].signed = bl;
    }

    public void setTableName(int n, String string) throws SQLException {
        this.checkColRange(n);
        this.colInfo[n].tableName = string != null ? new String(string) : new String("");
    }
}

