/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.primitives.AbstractIntArrayList;

public class UnsignedShortArrayList
extends AbstractIntArrayList
implements List,
Serializable {
    private transient short[] _data = null;
    private int _size = 0;
    public static final int MAX_VALUE = 65535;
    public static final int MIN_VALUE = 0;

    public UnsignedShortArrayList() {
        this(8);
    }

    public UnsignedShortArrayList(int n) {
        this._data = new short[n];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public int getInt(int n) {
        this.checkRange(n);
        return this.toInt(this._data[n]);
    }

    public boolean containsInt(int n) {
        this.assertValidUnsignedShort(n);
        return -1 != this.indexOfInt(n);
    }

    public int indexOfInt(int n) {
        this.assertValidUnsignedShort(n);
        short s = this.fromInt(n);
        int n2 = 0;
        while (n2 < this._size) {
            if (s == this._data[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOfInt(int n) {
        this.assertValidUnsignedShort(n);
        short s = this.fromInt(n);
        int n2 = this._size - 1;
        while (n2 >= 0) {
            if (s == this._data[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public int setInt(int n, int n2) {
        this.assertValidUnsignedShort(n2);
        this.checkRange(n);
        int n3 = this.toInt(this._data[n]);
        this._data[n] = this.fromInt(n2);
        return n3;
    }

    public boolean addInt(int n) {
        this.assertValidUnsignedShort(n);
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = this.fromInt(n);
        return true;
    }

    public void addInt(int n, int n2) {
        this.assertValidUnsignedShort(n2);
        this.checkRangeIncludingEndpoint(n);
        this.ensureCapacity(this._size + 1);
        int n3 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n3);
        this._data[n] = this.fromInt(n2);
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public int removeIntAt(int n) {
        this.checkRange(n);
        ++this.modCount;
        int n2 = this.toInt(this._data[n]);
        int n3 = this._size - n - 1;
        if (n3 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n3);
        }
        --this._size;
        return n2;
    }

    public boolean removeInt(int n) {
        this.assertValidUnsignedShort(n);
        int n2 = this.indexOfInt(n);
        if (-1 == n2) {
            return false;
        }
        this.removeIntAt(n2);
        return true;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            short[] sArray = this._data;
            this._data = new short[n2 < n ? n : n2];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            short[] sArray = this._data;
            this._data = new short[this._size];
            System.arraycopy(sArray, 0, this._data, 0, this._size);
        }
    }

    private final int toInt(short s) {
        return s & 0xFFFF;
    }

    private final short fromInt(int n) {
        return (short)(n & 0xFFFF);
    }

    private final void assertValidUnsignedShort(int n) throws IllegalArgumentException {
        if (n > 65535) {
            throw new IllegalArgumentException(n + " > " + 65535);
        }
        if (n < 0) {
            throw new IllegalArgumentException(n + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeShort(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new short[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readShort();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

