/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.primitives.AbstractLongArrayList;

public class UnsignedIntArrayList
extends AbstractLongArrayList
implements List,
Serializable {
    private transient int[] _data = null;
    private int _size = 0;
    public static final long MAX_VALUE = 0xFFFFFFFFL;
    public static final long MIN_VALUE = 0L;

    public UnsignedIntArrayList() {
        this(8);
    }

    public UnsignedIntArrayList(int n) {
        this._data = new int[n];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public long getLong(int n) {
        this.checkRange(n);
        return this.toLong(this._data[n]);
    }

    public boolean containsLong(long l) {
        this.assertValidUnsignedInt(l);
        return -1 != this.indexOfLong(l);
    }

    public int indexOfLong(long l) {
        this.assertValidUnsignedInt(l);
        int n = this.fromLong(l);
        int n2 = 0;
        while (n2 < this._size) {
            if (n == this._data[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOfLong(long l) {
        this.assertValidUnsignedInt(l);
        int n = this.fromLong(l);
        int n2 = this._size - 1;
        while (n2 >= 0) {
            if (n == this._data[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public long setLong(int n, long l) {
        this.assertValidUnsignedInt(l);
        this.checkRange(n);
        long l2 = this.toLong(this._data[n]);
        this._data[n] = this.fromLong(l);
        return l2;
    }

    public boolean addLong(long l) {
        this.assertValidUnsignedInt(l);
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = this.fromLong(l);
        return true;
    }

    public void addLong(int n, long l) {
        this.assertValidUnsignedInt(l);
        this.checkRangeIncludingEndpoint(n);
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = this.fromLong(l);
        ++this._size;
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public long removeLongAt(int n) {
        this.checkRange(n);
        ++this.modCount;
        long l = this.toLong(this._data[n]);
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return l;
    }

    public boolean removeLong(long l) {
        this.assertValidUnsignedInt(l);
        int n = this.indexOfLong(l);
        if (-1 == n) {
            return false;
        }
        this.removeLongAt(n);
        return true;
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            int[] nArray = this._data;
            this._data = new int[n2 < n ? n : n2];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            int[] nArray = this._data;
            this._data = new int[this._size];
            System.arraycopy(nArray, 0, this._data, 0, this._size);
        }
    }

    private final long toLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private final int fromLong(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    private final void assertValidUnsignedInt(long l) throws IllegalArgumentException {
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(l + " > " + 0xFFFFFFFFL);
        }
        if (l < 0L) {
            throw new IllegalArgumentException(l + " < " + 0L);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeInt(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new int[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readInt();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

