/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;

public class FloatArrayList
extends AbstractList
implements List,
Serializable {
    private transient float[] _data = null;
    private int _size = 0;

    public FloatArrayList() {
        this(8);
    }

    public FloatArrayList(int n) {
        this._data = new float[n];
    }

    public int capacity() {
        return this._data.length;
    }

    public int size() {
        return this._size;
    }

    public Object get(int n) {
        this.checkRange(n);
        return new Float(this._data[n]);
    }

    public float getFloat(int n) {
        this.checkRange(n);
        return this._data[n];
    }

    public boolean containsFloat(float f) {
        return -1 != this.indexOfFloat(f);
    }

    public int indexOfFloat(float f) {
        int n = 0;
        while (n < this._size) {
            if (f == this._data[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int lastIndexOfFloat(float f) {
        int n = this._size - 1;
        while (n >= 0) {
            if (f == this._data[n]) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public float setFloat(int n, float f) {
        this.checkRange(n);
        float f2 = this._data[n];
        this._data[n] = f;
        return f2;
    }

    public Object set(int n, Object object) {
        Float f = (Float)object;
        return new Float(this.setFloat(n, f.floatValue()));
    }

    public boolean addFloat(float f) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size++] = f;
        return true;
    }

    public void addFloat(int n, float f) {
        this.checkRangeIncludingEndpoint(n);
        this.ensureCapacity(this._size + 1);
        int n2 = this._size - n;
        System.arraycopy(this._data, n, this._data, n + 1, n2);
        this._data[n] = f;
        ++this._size;
    }

    public void add(int n, Object object) {
        this.addFloat(n, ((Float)object).floatValue());
    }

    public void clear() {
        ++this.modCount;
        this._size = 0;
    }

    public float removeFloatAt(int n) {
        this.checkRange(n);
        ++this.modCount;
        float f = this._data[n];
        int n2 = this._size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this._data, n + 1, this._data, n, n2);
        }
        --this._size;
        return f;
    }

    public boolean removeFloat(float f) {
        int n = this.indexOfFloat(f);
        if (-1 == n) {
            return false;
        }
        this.removeFloatAt(n);
        return true;
    }

    public Object remove(int n) {
        return new Float(this.removeFloatAt(n));
    }

    public void ensureCapacity(int n) {
        ++this.modCount;
        if (n > this._data.length) {
            int n2 = this._data.length * 3 / 2 + 1;
            float[] fArray = this._data;
            this._data = new float[n2 < n ? n : n2];
            System.arraycopy(fArray, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        ++this.modCount;
        if (this._size < this._data.length) {
            float[] fArray = this._data;
            this._data = new float[this._size];
            System.arraycopy(fArray, 0, this._data, 0, this._size);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._data.length);
        int n = 0;
        while (n < this._size) {
            objectOutputStream.writeFloat(this._data[n]);
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._data = new float[objectInputStream.readInt()];
        int n = 0;
        while (n < this._size) {
            this._data[n] = objectInputStream.readFloat();
            ++n;
        }
    }

    private final void checkRange(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + n);
        }
    }

    private final void checkRangeIncludingEndpoint(int n) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + n);
        }
    }
}

