/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.commons.collections.FactoryUtils;
import org.apache.commons.collections.SimpleObjectFactory;

public class LazyCollections {
    public static Map lazyMap(Map map, SimpleObjectFactory simpleObjectFactory) {
        return new LazyMap(map, simpleObjectFactory);
    }

    public static Map lazyMap(Map map, Class clazz) {
        SimpleObjectFactory simpleObjectFactory = FactoryUtils.createStandardFactory(clazz);
        return new LazyMap(map, simpleObjectFactory);
    }

    public static Map lazyMap(Map map, Class clazz, Class[] classArray, Object[] objectArray) {
        SimpleObjectFactory simpleObjectFactory = FactoryUtils.createStandardFactory(clazz, classArray, objectArray);
        return new LazyMap(map, simpleObjectFactory);
    }

    public static SortedMap lazySortedMap(SortedMap sortedMap, SimpleObjectFactory simpleObjectFactory) {
        return new LazySortedMap(sortedMap, simpleObjectFactory);
    }

    public static SortedMap lazySortedMap(SortedMap sortedMap, Class clazz) {
        SimpleObjectFactory simpleObjectFactory = FactoryUtils.createStandardFactory(clazz);
        return new LazySortedMap(sortedMap, simpleObjectFactory);
    }

    public static SortedMap lazySortedMap(SortedMap sortedMap, Class clazz, Class[] classArray, Object[] objectArray) {
        SimpleObjectFactory simpleObjectFactory = FactoryUtils.createStandardFactory(clazz, classArray, objectArray);
        return new LazySortedMap(sortedMap, simpleObjectFactory);
    }

    public static List lazyList(List list, SimpleObjectFactory simpleObjectFactory) {
        return new LazyList(list, simpleObjectFactory);
    }

    public static List lazyList(List list, Class clazz) {
        SimpleObjectFactory simpleObjectFactory = FactoryUtils.createStandardFactory(clazz);
        return new LazyList(list, simpleObjectFactory);
    }

    public static List lazyList(List list, Class clazz, Class[] classArray, Object[] objectArray) {
        SimpleObjectFactory simpleObjectFactory = FactoryUtils.createStandardFactory(clazz, classArray, objectArray);
        return new LazyList(list, simpleObjectFactory);
    }

    public static void clean(List list) {
        int n = list.size() - 1;
        while (n >= 0) {
            if (list.get(n) == null) {
                list.remove(n);
            }
            --n;
        }
    }

    private static class LazySortedMap
    extends LazyMap
    implements SortedMap {
        public LazySortedMap(SortedMap sortedMap, SimpleObjectFactory simpleObjectFactory) {
            super(sortedMap, simpleObjectFactory);
        }

        public Comparator comparator() {
            return ((SortedMap)this.mapImpl).comparator();
        }

        public SortedMap subMap(Object object, Object object2) {
            SortedMap sortedMap = ((SortedMap)this.mapImpl).subMap(object, object2);
            return new LazySortedMap(sortedMap, this.factory);
        }

        public SortedMap headMap(Object object) {
            SortedMap sortedMap = ((SortedMap)this.mapImpl).headMap(object);
            return new LazySortedMap(sortedMap, this.factory);
        }

        public SortedMap tailMap(Object object) {
            SortedMap sortedMap = ((SortedMap)this.mapImpl).tailMap(object);
            return new LazySortedMap(sortedMap, this.factory);
        }

        public Object firstKey() {
            return ((SortedMap)this.mapImpl).firstKey();
        }

        public Object lastKey() {
            return ((SortedMap)this.mapImpl).lastKey();
        }
    }

    private static class LazyMap
    implements Map {
        protected Map mapImpl;
        protected SimpleObjectFactory factory;

        public LazyMap(Map map, SimpleObjectFactory simpleObjectFactory) {
            this.mapImpl = map;
            this.factory = simpleObjectFactory;
        }

        public Object get(Object object) {
            Object object2 = this.mapImpl.get(object);
            if (object2 == null) {
                object2 = this.factory.createObject();
                this.mapImpl.put(object, object2);
            }
            return object2;
        }

        public int size() {
            return this.mapImpl.size();
        }

        public boolean isEmpty() {
            return this.mapImpl.isEmpty();
        }

        public boolean containsKey(Object object) {
            return this.mapImpl.containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.mapImpl.containsValue(object);
        }

        public Object put(Object object, Object object2) {
            return this.mapImpl.put(object, object2);
        }

        public Object remove(Object object) {
            return this.mapImpl.remove(object);
        }

        public void putAll(Map map) {
            this.mapImpl.putAll(map);
        }

        public void clear() {
            this.mapImpl.clear();
        }

        public Set keySet() {
            return this.mapImpl.keySet();
        }

        public Collection values() {
            return this.mapImpl.values();
        }

        public Set entrySet() {
            return this.mapImpl.entrySet();
        }

        public boolean equals(Object object) {
            return this.mapImpl.equals(object);
        }

        public int hashCode() {
            return this.mapImpl.hashCode();
        }
    }

    private static class LazyList
    implements List {
        private List listImpl;
        private SimpleObjectFactory factory;

        public LazyList(List list, SimpleObjectFactory simpleObjectFactory) {
            this.listImpl = list;
            this.factory = simpleObjectFactory;
        }

        public Object get(int n) {
            if (n < this.listImpl.size() - 1) {
                Object object = this.listImpl.get(n);
                if (object == null) {
                    object = this.factory.createObject();
                    this.listImpl.set(n, object);
                    return object;
                }
                return object;
            }
            int n2 = this.listImpl.size();
            while (n2 < n) {
                this.listImpl.add(null);
                ++n2;
            }
            Object object = this.factory.createObject();
            this.listImpl.add(object);
            return object;
        }

        public List subList(int n, int n2) {
            return new LazyList(this.listImpl.subList(n, n2), this.factory);
        }

        public int size() {
            return this.listImpl.size();
        }

        public boolean isEmpty() {
            return this.listImpl.isEmpty();
        }

        public boolean contains(Object object) {
            return this.listImpl.contains(object);
        }

        public Iterator iterator() {
            return this.listImpl.iterator();
        }

        public Object[] toArray() {
            return this.listImpl.toArray();
        }

        public Object[] toArray(Object[] objectArray) {
            return this.listImpl.toArray(objectArray);
        }

        public boolean add(Object object) {
            return this.listImpl.add(object);
        }

        public boolean remove(Object object) {
            return this.listImpl.remove(object);
        }

        public boolean containsAll(Collection collection) {
            return this.listImpl.containsAll(collection);
        }

        public boolean addAll(Collection collection) {
            return this.listImpl.addAll(collection);
        }

        public boolean addAll(int n, Collection collection) {
            return this.listImpl.addAll(n, collection);
        }

        public boolean removeAll(Collection collection) {
            return this.listImpl.removeAll(collection);
        }

        public boolean retainAll(Collection collection) {
            return this.listImpl.retainAll(collection);
        }

        public void clear() {
            this.listImpl.clear();
        }

        public Object set(int n, Object object) {
            return this.listImpl.set(n, object);
        }

        public void add(int n, Object object) {
            this.listImpl.add(n, object);
        }

        public Object remove(int n) {
            return this.listImpl.remove(n);
        }

        public int indexOf(Object object) {
            return this.listImpl.indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return this.listImpl.lastIndexOf(object);
        }

        public ListIterator listIterator() {
            return this.listImpl.listIterator();
        }

        public ListIterator listIterator(int n) {
            return this.listImpl.listIterator(n);
        }
    }
}

