/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class FastTreeMap
extends TreeMap {
    protected TreeMap map = null;
    protected boolean fast = false;

    public FastTreeMap() {
        this.map = new TreeMap();
    }

    public FastTreeMap(Comparator comparator) {
        this.map = new TreeMap(comparator);
    }

    public FastTreeMap(Map map) {
        this.map = new TreeMap(map);
    }

    public FastTreeMap(SortedMap sortedMap) {
        this.map = new TreeMap(sortedMap);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.clear();
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        FastTreeMap fastTreeMap = null;
        if (this.fast) {
            fastTreeMap = new FastTreeMap((SortedMap)this.map);
        } else {
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                fastTreeMap = new FastTreeMap((SortedMap)this.map);
            }
        }
        fastTreeMap.setFast(this.getFast());
        return fastTreeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Comparator comparator() {
        if (this.fast) {
            return this.map.comparator();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Comparator comparator = this.map.comparator();
            return comparator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object object) {
        if (this.fast) {
            return this.map.containsKey(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.containsKey(object);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        if (this.fast) {
            return this.map.containsValue(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.containsValue(object);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.fast) {
            return this.map.entrySet();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Set set = this.map.entrySet();
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (this.fast) {
            if (map.size() != this.map.size()) {
                return false;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
            return true;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            if (map.size() != this.map.size()) {
                boolean bl = false;
                return bl;
            }
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (v == null) {
                    if (map.get(k) == null && map.containsKey(k)) continue;
                    boolean bl = false;
                    return bl;
                }
                if (v.equals(map.get(k))) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object firstKey() {
        if (this.fast) {
            return this.map.firstKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k = this.map.firstKey();
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        if (this.fast) {
            return this.map.get(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v = this.map.get(object);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            return n;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n = 0;
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                n += ((Object)iterator.next()).hashCode();
            }
            int n2 = n;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap headMap(Object object) {
        if (this.fast) {
            return this.map.headMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.headMap(object);
            return sortedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.map.isEmpty();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        if (this.fast) {
            return this.map.keySet();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Set set = this.map.keySet();
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object lastKey() {
        if (this.fast) {
            return this.map.lastKey();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object k = this.map.lastKey();
            return k;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object object3 = treeMap.put(object, object2);
                this.map = treeMap;
                Object object4 = object3;
                return object4;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object object5 = this.map.put(object, object2);
            return object5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                treeMap.putAll(map);
                this.map = treeMap;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.putAll(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        if (this.fast) {
            FastTreeMap fastTreeMap = this;
            synchronized (fastTreeMap) {
                TreeMap treeMap = (TreeMap)this.map.clone();
                Object v = treeMap.remove(object);
                this.map = treeMap;
                Object v2 = v;
                return v2;
            }
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Object v = this.map.remove(object);
            return v;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.map.size();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n = this.map.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap subMap(Object object, Object object2) {
        if (this.fast) {
            return this.map.subMap(object, object2);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.subMap(object, object2);
            return sortedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedMap tailMap(Object object) {
        if (this.fast) {
            return this.map.tailMap(object);
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            SortedMap sortedMap = this.map.tailMap(object);
            return sortedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        if (this.fast) {
            return this.map.values();
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Collection collection = this.map.values();
            return collection;
        }
    }
}

