/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastArrayList
extends ArrayList {
    protected ArrayList list = null;
    protected boolean fast = false;

    public FastArrayList() {
        this.list = new ArrayList();
    }

    public FastArrayList(int n) {
        this.list = new ArrayList(n);
    }

    public FastArrayList(Collection collection) {
        this.list = new ArrayList(collection);
    }

    public boolean getFast() {
        return this.fast;
    }

    public void setFast(boolean bl) {
        this.fast = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.add(object);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.add(object);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.add(n, object);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.add(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.addAll(collection);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.addAll(n, collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.addAll(n, collection);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.clear();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        FastArrayList fastArrayList = null;
        if (this.fast) {
            fastArrayList = new FastArrayList((Collection)this.list);
        } else {
            ArrayList arrayList = this.list;
            synchronized (arrayList) {
                fastArrayList = new FastArrayList((Collection)this.list);
            }
        }
        fastArrayList.setFast(this.getFast());
        return fastArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (this.fast) {
            return this.list.contains(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.contains(object);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        if (this.fast) {
            return this.list.containsAll(collection);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.containsAll(collection);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCapacity(int n) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.ensureCapacity(n);
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.ensureCapacity(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.fast) {
            ListIterator listIterator = this.list.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext() && listIterator2.hasNext()) {
                Object e = listIterator.next();
                Object e2 = listIterator2.next();
                if (e != null ? e.equals(e2) : e2 == null) continue;
                return false;
            }
            return !listIterator.hasNext() && !listIterator2.hasNext();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = this.list.listIterator();
            ListIterator listIterator3 = list.listIterator();
            while (listIterator.hasNext() && listIterator3.hasNext()) {
                Object e = listIterator.next();
                Object e3 = listIterator3.next();
                if (e != null ? e.equals(e3) : e3 == null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !listIterator.hasNext() && !listIterator3.hasNext();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        if (this.fast) {
            return this.list.get(n);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e = this.list.get(n);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        if (this.fast) {
            int n = 1;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            return n;
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = 1;
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                n = 31 * n + (e == null ? 0 : e.hashCode());
            }
            int n2 = n;
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        if (this.fast) {
            return this.list.indexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.indexOf(object);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        if (this.fast) {
            return this.list.isEmpty();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.isEmpty();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        if (this.fast) {
            return this.list.iterator();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Iterator iterator = this.list.iterator();
            return iterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object object) {
        if (this.fast) {
            return this.list.lastIndexOf(object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.lastIndexOf(object);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        if (this.fast) {
            return this.list.listIterator();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = this.list.listIterator();
            return listIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int n) {
        if (this.fast) {
            return this.list.listIterator(n);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            ListIterator listIterator = this.list.listIterator(n);
            return listIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                Object e = arrayList.remove(n);
                this.list = arrayList;
                Object e2 = e;
                return e2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object e = this.list.remove(n);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.remove(object);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.remove(object);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.removeAll(collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.removeAll(collection);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                boolean bl = arrayList.retainAll(collection);
                this.list = arrayList;
                boolean bl2 = bl;
                return bl2;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            boolean bl = this.list.retainAll(collection);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        if (this.fast) {
            return this.list.set(n, object);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object object2 = this.list.set(n, object);
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        if (this.fast) {
            return this.list.size();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            int n = this.list.size();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int n, int n2) {
        if (this.fast) {
            return this.list.subList(n, n2);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            List list = this.list.subList(n, n2);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        if (this.fast) {
            return this.list.toArray();
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray = this.list.toArray();
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        if (this.fast) {
            return this.list.toArray(objectArray);
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            Object[] objectArray2 = this.list.toArray(objectArray);
            return objectArray2;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("FastArrayList[");
        stringBuffer.append(this.list.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize() {
        if (this.fast) {
            FastArrayList fastArrayList = this;
            synchronized (fastArrayList) {
                ArrayList arrayList = (ArrayList)this.list.clone();
                arrayList.trimToSize();
                this.list = arrayList;
            }
        }
        ArrayList arrayList = this.list;
        synchronized (arrayList) {
            this.list.trimToSize();
        }
    }
}

