/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.collections.SimpleObjectFactory;

public class FactoryUtils {
    public static SimpleObjectFactory createStandardFactory(Class clazz) {
        return new StandardFactory(clazz);
    }

    public static SimpleObjectFactory createStandardFactory(Class clazz, Class[] classArray, Object[] objectArray) {
        return new StandardFactory(clazz, classArray, objectArray);
    }

    private static class StandardFactory
    implements SimpleObjectFactory {
        private Class classDefinition;
        private Class[] argTypes;
        private Object[] argObjects;

        public StandardFactory(Class clazz) {
            this.classDefinition = clazz;
        }

        public StandardFactory(Class clazz, Class[] classArray, Object[] objectArray) {
            this(clazz);
            this.argTypes = classArray;
            this.argObjects = objectArray;
        }

        public Object createObject() {
            Object var1_1 = null;
            String string = null;
            try {
                if (this.argTypes == null || this.argObjects == null) {
                    var1_1 = this.classDefinition.newInstance();
                } else {
                    Constructor constructor = this.classDefinition.getConstructor(this.argTypes);
                    var1_1 = constructor.newInstance(this.argObjects);
                }
            }
            catch (InstantiationException instantiationException) {
                string = instantiationException.getMessage();
            }
            catch (IllegalAccessException illegalAccessException) {
                string = illegalAccessException.getMessage();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = illegalArgumentException.getMessage();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                string = noSuchMethodException.getMessage();
            }
            catch (InvocationTargetException invocationTargetException) {
                string = invocationTargetException.getMessage();
            }
            if (string != null) {
                throw new NullPointerException("Failed object creation :: " + string + "\n");
            }
            return var1_1;
        }
    }
}

