/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Validator;

public class ValidatorAction
implements Serializable {
    private String name = null;
    private String classname = null;
    private String method = null;
    private String methodParams = Validator.BEAN_KEY + "," + Validator.VALIDATOR_ACTION_KEY + "," + Validator.FIELD_KEY;
    private String depends = null;
    private String msg = null;
    private String jsFunctionName = null;
    private String javascript = null;
    private Object instance = null;
    private FastHashMap hDependencies = new FastHashMap();
    private List lMethodParams = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String string) {
        this.classname = string;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getMethodParams() {
        return this.methodParams;
    }

    public void setMethodParams(String string) {
        this.methodParams = string;
    }

    public List getMethodParamsList() {
        return Collections.unmodifiableList(this.lMethodParams);
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String string) {
        this.depends = string;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String string) {
        this.msg = string;
    }

    public String getJsFunctionName() {
        return this.jsFunctionName;
    }

    public void setJsFunctionName(String string) {
        this.jsFunctionName = string;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public void setJavascript(String string) {
        this.javascript = string;
    }

    public Object getClassnameInstance() {
        return this.instance;
    }

    public void setClassnameInstance(Object object) {
        this.instance = object;
    }

    public synchronized void process(Map map) {
        String string;
        StringTokenizer stringTokenizer;
        if (this.getDepends() != null) {
            if (this.hDependencies == null) {
                this.hDependencies = new FastHashMap();
            }
            stringTokenizer = new StringTokenizer(this.getDepends(), ",");
            string = "";
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2 == null || string2.length() <= 0) continue;
                this.hDependencies.put((Object)string2, (Object)string);
            }
            this.hDependencies.setFast(true);
        }
        if (this.getMethodParams() != null) {
            if (this.lMethodParams == null) {
                this.lMethodParams = new ArrayList();
            }
            stringTokenizer = new StringTokenizer(this.getMethodParams(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (string == null || string.length() <= 0) continue;
                this.lMethodParams.add(string);
            }
        }
    }

    public boolean isDependency(String string) {
        if (this.hDependencies != null) {
            return this.hDependencies.containsKey((Object)string);
        }
        return false;
    }

    public Collection getDependencies() {
        return Collections.unmodifiableMap(this.hDependencies).keySet();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ValidatorAction: ");
        stringBuffer.append(this.name);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

