/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.lang.CharSetUtils;
import org.apache.commons.lang.NumberUtils;

public class StringUtils {
    public static int CHAR_BUFFER_SIZE = 4096;

    private StringUtils() {
    }

    public static String clean(String str) {
        return str == null ? "" : str.trim();
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String deleteWhitespace(String str) {
        return CharSetUtils.delete(str, " \t\r\n\b");
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static int indexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = Integer.MAX_VALUE;
        int tmp = 0;
        int i = 0;
        while (i < sz) {
            tmp = str.indexOf(searchStrs[i]);
            if (tmp != -1 && tmp < ret) {
                ret = tmp;
            }
            ++i;
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public static int lastIndexOfAny(String str, String[] searchStrs) {
        if (str == null || searchStrs == null) {
            return -1;
        }
        int sz = searchStrs.length;
        int ret = -1;
        int tmp = 0;
        int i = 0;
        while (i < sz) {
            tmp = str.lastIndexOf(searchStrs[i]);
            if (tmp > ret) {
                ret = tmp;
            }
            ++i;
        }
        return ret;
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return null;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return "";
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return null;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String left(String str, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str == null || str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    public static String right(String str, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str == null || str.length() <= len) {
            return str;
        }
        return str.substring(str.length() - len);
    }

    public static String mid(String str, int pos, int len) {
        if (pos < 0 || str != null && pos > str.length()) {
            throw new StringIndexOutOfBoundsException("String index " + pos + " is out of bounds");
        }
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        if (str == null) {
            return null;
        }
        if (str.length() <= pos + len) {
            return str.substring(pos);
        }
        return str.substring(pos, pos + len);
    }

    public static String[] split(String text) {
        return StringUtils.split(text, null, -1);
    }

    public static String[] split(String text, String separator) {
        return StringUtils.split(text, separator, -1);
    }

    public static String[] split(String text, String separator, int max) {
        StringTokenizer tok = null;
        tok = separator == null ? new StringTokenizer(text) : new StringTokenizer(text, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        while (tok.hasMoreTokens()) {
            if (max > 0 && i == listSize - 1) {
                StringBuffer buf = new StringBuffer(1 * text.length() * (listSize - i) / listSize);
                while (tok.hasMoreTokens()) {
                    buf.append(tok.nextToken());
                    if (!tok.hasMoreTokens()) continue;
                    buf.append(separator);
                }
                list[i] = buf.toString();
                break;
            }
            list[i] = tok.nextToken();
            ++i;
        }
        return list;
    }

    public static String concatenate(Object[] array) {
        return StringUtils.join(array, "");
    }

    public static String join(Object[] array, String separator) {
        int arraySize;
        if (separator == null) {
            separator = "";
        }
        int bufSize = (arraySize = array.length) == 0 ? 0 : (array[0].toString().length() + separator.length()) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        int i = 0;
        while (i < arraySize) {
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(array[i]);
            ++i;
        }
        return buf.toString();
    }

    public static String join(Iterator iterator, String separator) {
        if (separator == null) {
            separator = "";
        }
        StringBuffer buf = new StringBuffer(256);
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtils.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max == 0) break;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String overlayString(String text, String overlay, int start, int end) {
        return new StringBuffer(start + overlay.length() + text.length() - end + 1).append(text.substring(0, start)).append(overlay).append(text.substring(end)).toString();
    }

    public static String center(String str, int size) {
        return StringUtils.center(str, size, " ");
    }

    public static String center(String str, int size, String delim) {
        int sz = str.length();
        int p = size - sz;
        if (p < 1) {
            return str;
        }
        str = StringUtils.leftPad(str, sz + p / 2, delim);
        str = StringUtils.rightPad(str, size, delim);
        return str;
    }

    public static String chomp(String str) {
        return StringUtils.chomp(str, "\n");
    }

    public static String chomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx);
        }
        return str;
    }

    public static String chompLast(String str) {
        return StringUtils.chompLast(str, "\n");
    }

    public static String chompLast(String str, String sep) {
        if (str.length() == 0) {
            return str;
        }
        String sub = str.substring(str.length() - sep.length());
        if (sep.equals(sub)) {
            return str.substring(0, str.length() - sep.length());
        }
        return str;
    }

    public static String getChomp(String str, String sep) {
        int idx = str.lastIndexOf(sep);
        if (idx == str.length() - sep.length()) {
            return sep;
        }
        if (idx != -1) {
            return str.substring(idx);
        }
        return "";
    }

    public static String prechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(idx + sep.length());
        }
        return str;
    }

    public static String getPrechomp(String str, String sep) {
        int idx = str.indexOf(sep);
        if (idx != -1) {
            return str.substring(0, idx + sep.length());
        }
        return "";
    }

    public static String chop(String str) {
        if ("".equals(str)) {
            return "";
        }
        if (str.length() == 1) {
            return "";
        }
        int lastIdx = str.length() - 1;
        String ret = str.substring(0, lastIdx);
        char last = str.charAt(lastIdx);
        if (last == '\n' && ret.charAt(lastIdx - 1) == '\r') {
            return ret.substring(0, lastIdx - 1);
        }
        return ret;
    }

    public static String chopNewline(String str) {
        int lastIdx = str.length() - 1;
        char last = str.charAt(lastIdx);
        if (last == '\n') {
            if (str.charAt(lastIdx - 1) == '\r') {
                --lastIdx;
            }
        } else {
            ++lastIdx;
        }
        return str.substring(0, lastIdx);
    }

    public static String escape(String str) {
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(2 * sz);
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (ch > '\u0fff') {
                buffer.append("\\u" + Integer.toHexString(ch));
            } else if (ch > '\u00ff') {
                buffer.append("\\u0" + Integer.toHexString(ch));
            } else if (ch > '\u007f') {
                buffer.append("\\u00" + Integer.toHexString(ch));
            } else if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00" + Integer.toHexString(ch));
                            break;
                        }
                        buffer.append("\\u000" + Integer.toHexString(ch));
                        break;
                    }
                }
            } else {
                switch (ch) {
                    case '\'': {
                        buffer.append('\\');
                        buffer.append('\'');
                        break;
                    }
                    case '\"': {
                        buffer.append('\\');
                        buffer.append('\"');
                        break;
                    }
                    case '\\': {
                        buffer.append('\\');
                        buffer.append('\\');
                        break;
                    }
                    default: {
                        buffer.append(ch);
                    }
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        int i = 0;
        while (i < repeat) {
            buffer.append(str);
            ++i;
        }
        return buffer.toString();
    }

    public static String rightPad(String str, int size) {
        return StringUtils.rightPad(str, size, " ");
    }

    public static String rightPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = str + StringUtils.repeat(delim, size);
        }
        return str;
    }

    public static String leftPad(String str, int size) {
        return StringUtils.leftPad(str, size, " ");
    }

    public static String leftPad(String str, int size, String delim) {
        if ((size = (size - str.length()) / delim.length()) > 0) {
            str = StringUtils.repeat(delim, size) + str;
        }
        return str;
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String delim) {
        str = StringUtils.stripStart(str, delim);
        return StringUtils.stripEnd(str, delim);
    }

    public static String[] stripAll(String[] strs) {
        return StringUtils.stripAll(strs, null);
    }

    public static String[] stripAll(String[] strs, String delimiter) {
        if (strs == null || strs.length == 0) {
            return strs;
        }
        int sz = strs.length;
        String[] newArr = new String[sz];
        int i = 0;
        while (i < sz) {
            newArr[i] = StringUtils.strip(strs[i], delimiter);
            ++i;
        }
        return newArr;
    }

    /*
     * Unable to fully structure code
     */
    public static String stripEnd(String str, String strip) {
        block3: {
            if (str == null) {
                return null;
            }
            end = str.length();
            if (strip != null) ** GOTO lbl10
            while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --end;
lbl10:
                // 2 sources

                ** while (end != 0 && strip.indexOf((int)str.charAt((int)(end - 1))) != -1)
            }
        }
        return str.substring(0, end);
    }

    public static String stripStart(String str, String strip) {
        if (str == null) {
            return null;
        }
        int start = 0;
        int sz = str.length();
        if (strip == null) {
            while (start != sz && Character.isWhitespace(str.charAt(start))) {
                ++start;
            }
        } else {
            char chr = strip.charAt(0);
            while (start != sz && strip.indexOf(str.charAt(start)) != -1) {
                ++start;
            }
        }
        return str.substring(start);
    }

    public static String upperCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toUpperCase();
    }

    public static String lowerCase(String str) {
        if (str == null) {
            return null;
        }
        return str.toLowerCase();
    }

    public static String uncapitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        return new StringBuffer(str.length()).append(Character.toLowerCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String capitalise(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return "";
        }
        return new StringBuffer(str.length()).append(Character.toTitleCase(str.charAt(0))).append(str.substring(1)).toString();
    }

    public static String swapCase(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        boolean whitespace = false;
        char ch = '\u0000';
        char tmp = '\u0000';
        int i = 0;
        while (i < sz) {
            ch = str.charAt(i);
            tmp = Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isTitleCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? (whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch)) : ch));
            buffer.append(tmp);
            whitespace = Character.isWhitespace(ch);
            ++i;
        }
        return buffer.toString();
    }

    public static String capitaliseAllWords(String str) {
        if (str == null) {
            return null;
        }
        int sz = str.length();
        StringBuffer buffer = new StringBuffer(sz);
        boolean space = true;
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
            } else if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String getNestedString(String str, String tag) {
        return StringUtils.getNestedString(str, tag, tag);
    }

    public static String getNestedString(String str, String open, String close) {
        int end;
        if (str == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static int countMatches(String str, String sub) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static boolean isAlpha(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetter(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphaSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetter(str.charAt(i)) && str.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphanumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetterOrDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAlphanumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isLetterOrDigit(str.charAt(i)) && str.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumericSpace(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        int i = 0;
        while (i < sz) {
            if (!Character.isDigit(str.charAt(i)) && str.charAt(i) != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String defaultString(String str) {
        return StringUtils.defaultString(str, "");
    }

    public static String defaultString(String str, String defaultString) {
        return str == null ? defaultString : str;
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuffer(str).reverse().toString();
    }

    public static String reverseDelimitedString(String str, String delimiter) {
        Object[] strs = StringUtils.split(str, delimiter);
        StringUtils.reverseArray(strs);
        return StringUtils.join(strs, delimiter);
    }

    private static void reverseArray(Object[] array) {
        int i = 0;
        int j = array.length - 1;
        while (j > i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
            --j;
            ++i;
        }
    }

    public static String stackTrace(Throwable throwable) {
        String trace = null;
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintWriter(buf, true));
            trace = buf.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return trace;
    }

    public static int getLevenshteinDistance(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= m) {
            d[0][j] = j;
            ++j;
        }
        i = 1;
        while (i <= n) {
            char s_i = s.charAt(i - 1);
            j = 1;
            while (j <= m) {
                char t_j = t.charAt(j - 1);
                int cost = s_i == t_j ? 0 : 1;
                d[i][j] = NumberUtils.minimum(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
                ++j;
            }
            ++i;
        }
        return d[n][m];
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        pw.close();
        return sw.toString();
    }
}

