/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

public class HashCodeUtils {
    private static final int CONSTANT = 37;

    private HashCodeUtils() {
    }

    public static int buildHashCode(int totalSoFar, Object object) {
        if (object == null) {
            return totalSoFar * 37;
        }
        return totalSoFar * 37 + object.hashCode();
    }

    public static int buildHashCode(int totalSoFar, long value) {
        return totalSoFar * 37 + (int)(value ^ value >> 32);
    }

    public static int buildHashCode(int totalSoFar, int value) {
        return totalSoFar * 37 + value;
    }

    public static int buildHashCode(int totalSoFar, short value) {
        return totalSoFar * 37 + value;
    }

    public static int buildHashCode(int totalSoFar, char value) {
        return totalSoFar * 37 + value;
    }

    public static int buildHashCode(int totalSoFar, byte value) {
        return totalSoFar * 37 + value;
    }

    public static int buildHashCode(int totalSoFar, double value) {
        return HashCodeUtils.buildHashCode(totalSoFar, Double.doubleToLongBits(value));
    }

    public static int buildHashCode(int totalSoFar, float value) {
        return totalSoFar * 37 + Float.floatToIntBits(value);
    }

    public static int buildHashCode(int totalSoFar, boolean value) {
        return totalSoFar * 37 + (value ? 0 : 1);
    }

    public static int buildHashCode(int totalSoFar, Object[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, long[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, int[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, short[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, char[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, byte[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, double[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, float[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    public static int buildHashCode(int totalSoFar, boolean[] array) {
        if (array == null) {
            return totalSoFar * 37;
        }
        int i = 0;
        while (i < array.length) {
            totalSoFar = HashCodeUtils.buildHashCode(totalSoFar, array[i]);
            ++i;
        }
        return totalSoFar;
    }

    static {
        CONSTANT = 37;
    }
}

