/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.jdbc2pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.jdbc2pool.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected KeyedObjectPool _pool = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcKeyMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((KeyedPoolableObjectFactory)this);
        this._validationQuery = validationQuery;
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public synchronized void setPool(KeyedObjectPool pool) throws SQLException {
        if (null != this._pool && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        this._pool = pool;
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object key) {
        UserPassKey upkey = (UserPassKey)key;
        upkey.setReusable(false);
        String username = upkey.getUsername();
        PooledConnection pc = null;
        try {
            pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, upkey.getPassword());
            pc.addConnectionEventListener(this);
            this.pcKeyMap.put(pc, key);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return pc;
    }

    public void destroyObject(Object key, Object obj) {
        if (obj instanceof PooledConnection) {
            try {
                ((PooledConnection)obj).close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean validateObject(Object key, Object obj) {
        boolean valid;
        block24: {
            valid = false;
            if (obj instanceof PooledConnection) {
                PooledConnection pconn = (PooledConnection)obj;
                String query = this._validationQuery;
                if (null != query) {
                    ResultSet rset;
                    Statement stmt;
                    Connection conn;
                    block20: {
                        conn = null;
                        stmt = null;
                        rset = null;
                        this.validatingMap.put(pconn, null);
                        conn = pconn.getConnection();
                        stmt = conn.createStatement();
                        rset = stmt.executeQuery(query);
                        if (rset.next()) {
                            valid = true;
                            break block20;
                        }
                        valid = false;
                    }
                    Object var11_9 = null;
                    try {
                        rset.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    try {
                        conn.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.validatingMap.remove(pconn);
                    {
                        break block24;
                        catch (Exception e) {
                            valid = false;
                            Object var11_10 = null;
                            try {
                                rset.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            try {
                                stmt.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            try {
                                conn.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                            this.validatingMap.remove(pconn);
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        try {
                            rset.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            stmt.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        try {
                            conn.close();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        this.validatingMap.remove(pconn);
                        throw throwable;
                    }
                }
                valid = true;
            } else {
                valid = false;
            }
        }
        return valid;
    }

    public void passivateObject(Object key, Object obj) {
    }

    public void activateObject(Object key, Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        if (!this.validatingMap.containsKey(pc)) {
            Object key = this.pcKeyMap.get(pc);
            if (key == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(key, (Object)pc);
            }
            catch (Exception e) {
                this.destroyObject(key, pc);
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            pc.removeConnectionEventListener(this);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        Object key = this.pcKeyMap.get(pc);
        if (key == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        this.destroyObject(key, pc);
    }

    static {
        NO_KEY_MESSAGE = NO_KEY_MESSAGE;
    }
}

