/*

  REXX Script to create the InJoy desktop folder

*/

if RxFuncQuery('SysLoadFuncs') then do
   call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   call SysLoadFuncs
end

say "Creating Desktop Folder..."

dir = directory() || '\'

say "Creating folder"
call SysCreateObject "WPFolder", "InJoy Internet Dialer", "<WP_DESKTOP>", "OBJECTID=<INJOYFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=10.Helv;BACKGROUND=" || dir || "back.bmp,T;ICONFILE=" || dir || "FOLDER.ICO", "replace"
call SysCreateObject "WPFolder", "Extras", "<INJOYFOLDER>", "OBJECTID=<INJOYEXTRASFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Packet Tracing", "<INJOYFOLDER>", "OBJECTID=<INJOYTRACEFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Tools", "<INJOYFOLDER>", "OBJECTID=<INJOYUTILFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Log Files", "<INJOYFOLDER>", "OBJECTID=<INJOYLOGFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"
call SysCreateObject "WPFolder", "Information", "<INJOYFOLDER>", "OBJECTID=<INJOYINFOFOLDER>;ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=NO;ICONFONT=8.Helv;BACKGROUND=" || dir || "back.bmp,T", "replace"

say "Creating program objects..."


/* Extras */
call SysCreateObject "WPProgram", "IP Forwarding" || d2c(10) || "(Disable)", "<INJOYEXTRASFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "ipgate off" || '"', "replace"
call SysCreateObject "WPProgram", "IP Forwarding" || d2c(10) || "(Enable)", "<INJOYEXTRASFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "ipgate on" || '"', "replace"


/* Tools */
call SysCreateObject "WPProgram", "Reload DHCP Server" || d2c(10) || "Configuration", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-dhcpd", "replace"
call SysCreateObject "WPProgram", "Reload IPSec" || d2c(10) || "Configuration", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-ipsec", "replace"
call SysCreateObject "WPProgram", "Disconnect InJoy", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SETJOY.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-D", "replace"
call SysCreateObject "WPProgram", "Connect InJoy", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "SETJOY.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-CONNECT", "replace"
call SysCreateObject "WPProgram", "KillJoy", "<INJOYUTILFOLDER>", "EXENAME=" || dir || "KILLJOY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"


/* TRACE */
call SysCreateObject "WPProgram", "Delete Trace File", "<INJOYTRACEFOLDER>", "EXENAME=CMD.EXE;PARAMETERS=" || "/C " || '"' || "del " || dir || "packet.trc" || '"', "replace"
call SysCreateObject "WPProgram", "Format Trace" || d2c(10) || "(to Screen)", "<INJOYTRACEFOLDER>", "EXENAME=" || dir || "IPFORMAT.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-r packet.trc", "replace"
call SysCreateObject "WPProgram", "IP Trace" || d2c(10) || "(Stop)", "<INJOYTRACEFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-off:logbin", "replace"
call SysCreateObject "WPProgram", "IP Trace" || d2c(10) || "(Start)", "<INJOYTRACEFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-on:logbin", "replace"


/* LOG FILES */
call SysCreateObject "WPProgram", "DHCPd Logs", "<INJOYLOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\DHCPD.INI", "replace"
call SysCreateObject "WPProgram", "IPSec Logs", "<INJOYLOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\IPSEC.INI", "replace"
call SysCreateObject "WPProgram", "InJoy Logs", "<INJOYLOGFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\INJOY.INI", "replace"


/* Information */
/*
call SysCreateObject "WPProgram", "License"  || d2c(10) || "Agreement", "<INJOYINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "LICENSE.TXT", "replace"
call SysCreateObject "WPProgram", "FAQ", "<INJOYINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "FAQ.TXT", "replace"
call SysCreateObject "WPProgram", "Firewall" || d2c(10) || "Plugin", "<INJOYINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "FIREWALL.TXT", "replace"
call SysCreateObject "WPProgram", "IPSec" || d2c(10) || "Plugin", "<INJOYINFOFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "file:///" || dir || "docs\ipsec\welcome.htm", "replace"
call SysCreateObject "WPProgram", "Users Guide", "<INJOYINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "USERGUID.TXT", "replace"
call SysCreateObject "WPProgram", "Readme", "<INJOYINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\" || "README.TXT", "replace"
call SysCreateObject "WPProgram", "Readme First", "<INJOYINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || dir || "DOCS\"  || "README.1ST", "replace"
call SysCreateObject "WPProgram", "F/X Communications" || d2c(10) || "(www.fx.dk)", "<INJOYINFOFOLDER>", "EXENAME=NETSCAPE.EXE;PARAMETERS=" || "http://www.fx.dk", "replace"
*/


call SysCreateObject "WPProgram", "Reload Firewall" || d2c(10) || "Configuration", "<INJOYFOLDER>", "EXENAME=" || dir || "SYNC.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "-firewall", "replace"
call SysCreateObject "WPProgram", "Security Logs", "<INJOYFOLDER>", "EXENAME=" || dir || "LOGVIEW.EXE;STARTUPDIR=" || dir || ";PARAMETERS=" || "LVIEW\FIREWALL.INI", "replace"
call SysCreateObject "WPProgram", "InJoy Dialer", "<INJOYFOLDER>", "EXENAME=" || dir || "IN-JOY.EXE;STARTUPDIR=" || dir || ";ICONVIEW=FLOWED,NORMAL;ALWAYSSORT=YES;"
say "Folder creation completed!"
