/*--------------------------------------------------------------------------*/
/*                              INFOMTCH.CMD                                */
/*                                  v1.5                                    */
/*                                                                          */
/*                 Attachment script for Infomatch Internet                 */
/*--------------------------------------------------------------------------*/
/* Created from the sample ANNEX.CMD script distributed with IBM OS/2 Warp  */
/* and it's Internet Access Kit.  Changes to original script made by Graham */
/* TerMarsch.                                                               */
/*--------------------------------------------------------------------------*/
/* Portions of this script written by Harold Roussel, who can be reached at */
/* roussel@physics.mcgill.ca.                                               */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* Please refer to the INFOMTCH.DOC and the README file for information on  */
/* the distribution of this script, its usage, and restrictions.            */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* Graham is available for contract work involving OS/2.  He has been an    */
/* avid user since 1992, and was involved in all of the beta programs since */
/* then.  A registered OS/2 DAP member, Graham does most of his work in     */
/* C/C++.  Being a starving student, Graham is almost always available for  */
/* programming/installation/support work.  Contact him at 604-689-2073 or   */
/* gtermars@infomatch.com for more information.                             */
/*--------------------------------------------------------------------------*/
/*                              DISCLAIMER                                  */
/*                                                                          */
/* You were waiting for this weren't you?  Well, it's a standard disclaimer;*/
/* I've managed to get this working on my machine and have thus provided it */
/* to others.  By use of this script you acknowledge that I am not          */
/* responsible for any damages that may be incurred through it's use.  Yes, */
/* I am available to answer your questions if you have a problem but I take */
/* no responsibility for your actions.  You downloaded it, and if you use   */
/* it you take full responsibility into your own hands.  If you do not      */
/* agree with this then discontinue your use of this script.                */
/*--------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------*/
/* Define and initialize all variables:                                     */
/*                                                                          */
/* cr                  - ASCII code for carriage return.                    */
/* lf                  - ASCII code for line feed.                          */
/* crlf                - ASCII code for carriage return and line feed.      */
/* max_attempts        - Maximum number of redial attempts to make.  A      */
/*                       value of zero means dial until connection is made. */
/* curr_attempt        - Current dialing attempt number.                    */
/* username            - User name to log in with.                          */
/* password            - Password to log in with.                           */
/* should_beep         - Should the bell be sounded upon connection or      */
/*                       failure to connect?  A value of zero means NO, and */
/*                       a value of one means YES.                          */
/* should_autostart    - Should the LOGGEDIN.CMD file be run upon a         */
/*                       successful connection?  A value of zero means NO,  */
/*                       and a value of one means YES.                      */
/* os2_address         - Dotted decimal notation for the IP address that    */
/*                       this OS/2 machine will have when a connection has  */
/*                       been made.                                         */
/* how_many_numbers    - Number of phone numbers in the dialing list.       */
/* phone_number        - Array containing the dialing list of numbers.      */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/
cr = '0d'x
lf = '0a'x
crlf = '0d0a'x
max_attempts = 0
curr_attempt = 0
username = ''
password = ''
should_beep = 1
should_autostart = 1
how_many_numbers = 6
phone_number.0 = "421-3288"
phone_number.1 = "421-3957"
phone_number.2 = "421-3914"
phone_number.3 = "421-3886"
phone_number.4 = "421-0411"
phone_number.5 = "421-3277"

/*--------------------------------------------------------------------------*/
/* Parse the command line options.  Keep in mind that while parsing the     */
/* arguments, if an error is found the program will abort; we will NOT end  */
/* up back here with any error conditions to check.                         */
/*--------------------------------------------------------------------------*/
parse arg interface, arguments
call parse_arguments arguments

/*--------------------------------------------------------------------------*/
/* Load any of the RexxUtil functions that we might require later.          */
/*--------------------------------------------------------------------------*/
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
call RxFuncAdd 'SysDropFuncs', 'RexxUtil', 'SysDropFuncs'

/*--------------------------------------------------------------------------*/
/* Say hello to the user and provide author information.                    */
/*--------------------------------------------------------------------------*/
say ''
say 'INFOMTCH - Infomatch Internet SLIP login interface, version 1.5'
say 'Written by Graham TerMarsch, 604-689-2073, gtermars@infomatch.com'
say 'Portions by Harold Roussel, roussel@physics.mcgill.ca' || cr

/*--------------------------------------------------------------------------*/
/* Prompt the user for any information that might have been missing from    */
/* the command line.                                                        */
/*--------------------------------------------------------------------------*/
if (os2_address  = '') then do
        call charout , 'Your IP address: '
        parse pull os2_address
end

if ( (username = '') | (username = '*') ) then do
        call charout , 'User Name: '
        parse pull username
end

if ( (password = '') | (password = '*') ) then do
        call charout , 'Password: '
        password = readpass()
end

/*--------------------------------------------------------------------------*/
/* Flush any left over stuff from previous COM activity.                    */
/*--------------------------------------------------------------------------*/
call flush_receive

/*--------------------------------------------------------------------------*/
/* Reset the modem to it's factory default settings.                        */
/*--------------------------------------------------------------------------*/
call charout , cr || 'Resetting modem to factory defaults...'
call send '+++'
call send 'AT&F' || cr
call waitfor 'OK', 5
call flush_receive 'echo'

if (RC = 1) then do
        call lineout , 'Modem not resetting... Trying again'
        call send '+++'
        call waitfor 'OK'
        call send 'ATHZ' || cr
        call waitfor 'OK', 3
end

/*--------------------------------------------------------------------------*/
/* Now we'll attempt to do the dialing.  We'll continue to dial until we    */
/* get connected.                                                           */
/*--------------------------------------------------------------------------*/
which_number = 0                       /* Which number should I be dialing? */

do while ( (max_attempts = 0) | (curr_attempt < max_attempts) )
        curr_attempt = curr_attempt + 1

        /*------------------------------------------------------------------*/
        /* Wait a bit to be polite to the rest of the system.               */
        /*------------------------------------------------------------------*/
        SysSleep( 1 )

        /*------------------------------------------------------------------*/
        /* Hang up on any existing call.                                    */
        /*------------------------------------------------------------------*/
        call send '+++'
        call send 'ATHZ' || cr
        call waitfor 'OK', 3
        call send 'ATM0' || cr
        call waitfor 'OK', 3

        /*------------------------------------------------------------------*/
        /* Dial the remote server.                                          */
        /*------------------------------------------------------------------*/
        call charout , cr || 'Now Dialing...'

        /*------------------------------------------------------------------*/
        /* Choose the number to call and dial it.                           */
        /*------------------------------------------------------------------*/
        call send 'ATDT' || phone_number.which_number || cr
        which_number = which_number + 1

        if (which_number = how_many_numbers) then
                which_number = 0

        /*------------------------------------------------------------------*/
        /* Wait for either a connection or an error message.  The return    */
        /* value will come back through the variable 'stringchosen'.        */
        /*------------------------------------------------------------------*/
        call waitfor3 'CONNECT', 'BUSY', 'NO CARRIER'
        call flush_receive

        /*------------------------------------------------------------------*/
        /* If we've successfully connected, get out of the while loop.      */
        /* 'stringchosen' represents which string from the last call to     */
        /* waitfor3 that was detected; a value of 1 means that we got a     */
        /* 'CONNECT'.                                                       */
        /*------------------------------------------------------------------*/
	if (stringchosen = 1) then leave	
end     /* end of 'do while...' */

/*--------------------------------------------------------------------------*/
/* Check to see why we ended up out of the previous dialing loop.  Was it   */
/* because we have a connection or because we ran out of dialing attempts.  */
/*--------------------------------------------------------------------------*/
if (stringchosen > 1) then do
        /*------------------------------------------------------------------*/
        /* Inform the user that we have reached the maximum number of       */
        /* dialing attempts.                                                */
        /*------------------------------------------------------------------*/
        say cr || 'Reached maximum dialing attempts.' || cr

        /*------------------------------------------------------------------*/
        /* If we are supposed to sound a bell to let the user know that an  */
        /* error occured, sound the bell.                                   */
        /*------------------------------------------------------------------*/
        if (should_beep = 1) then call failure_beep 1

        return_value = 1
end
else do
        /*------------------------------------------------------------------*/
        /* Now that we have a connection at the other end of the line, try  */
        /* to do the login.  Wait for the standard strings, and then flush  */
        /* everything else that we do not need (trailing spaces, etc.).     */
        /*------------------------------------------------------------------*/
        call waitfor 'login:'
        call flush_receive 'echo'
        call send username || cr

        call waitfor 'Password:'
        call flush_receive 'echo'
        call send password || cr

        /*------------------------------------------------------------------*/
        /* Wait for the connection established notification from the server.*/
        /*------------------------------------------------------------------*/
        call waitfor 'starting slip login for'
        call flush_receive 'echo'

        /*------------------------------------------------------------------*/
        /* Now we check to ensure that we've connected properly.  If so,    */
        /* set the IP address and add the name server to our routing table. */
        /* Otherwise, display an error message to the user.                 */
        /*------------------------------------------------------------------*/
        say ''
        if RC = 0 then do
                'ifconfig sl0' os2_address '199.60.99.1 netmask 255.255.255.0'
                'route add default 199.60.99.1 1'
                say cr || 'SLIP Connection Established!' || cr

                /*----------------------------------------------------------*/
                /* If we are supposed to autostart any other applications,  */
                /* start the LOGGEDIN.CMD script file.                      */
                /*----------------------------------------------------------*/
                if (should_autostart = 1) then detach LOGGEDIN.CMD

                /*----------------------------------------------------------*/
                /* If we are supposed to sound a bell to let the user know  */
                /* that a successful connection has been made, sound the    */
                /* bell.                                                    */
                /*----------------------------------------------------------*/
                if (should_beep = 1) then call success_beep 3

                return_value = 0
        end
        else do
                say cr || 'ERROR:  NO Connection Established!' || cr

                /*----------------------------------------------------------*/
                /* If we are supposed to sound a bell to let the user know  */
                /* that an error occured, sound the bell.                   */
                /*----------------------------------------------------------*/
                if (should_beep = 1) then call failure_beep 1

                return_value = 1
        end
end

/*--------------------------------------------------------------------------*/
/* At this point, we are finished; we've either ran out of dial attempts,   */
/* made a successful connection, or failed in a connection.  So, clean up   */
/* any REXX functions that we loaded and exit the script.                   */
/*--------------------------------------------------------------------------*/
call SysDropFuncs
exit return_value






/*--------------------------------------------------------------------------*/
/*                         success_beep ( numTimes )                        */
/*..........................................................................*/
/*                                                                          */
/* Routine to beep several times to indicate a successful connection.       */
/*                                                                          */
/*--------------------------------------------------------------------------*/
success_beep:
        parse arg numTimes

        do while (numTimes > 0)
                call beep 580, 90
                call beep 650, 90
                call beep 800, 80
                numTimes = numTimes - 1
        end
return


/*--------------------------------------------------------------------------*/
/*                         failure_beep ( numTimes )                        */
/*..........................................................................*/
/*                                                                          */
/* Routine to beep several times to indicate a failed connection.           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
failure_beep:
        parse arg numTimes

        do while (numTimes > 0)
                call beep 600, 90
                call beep 500, 90
                call beep 300, 300
                numTimes = numTimes - 1
        end
return


/*--------------------------------------------------------------------------*/
/*                            send ( sendstring )                           */
/*..........................................................................*/
/*                                                                          */
/* Routine to send a character string off to the modem.                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/
send:
        parse arg sendstring
        call slip_com_output interface , sendstring
return


/*--------------------------------------------------------------------------*/
/*                       parse_arguments ( arguments )                      */
/*..........................................................................*/
/*                                                                          */
/* Parses the command line arguments to this script file.  Any known        */
/* arguments will set the appropriate variables in the program.  If we      */
/* encounter an invalid argument or an argument without a value, display an */
/* error message and abort the script completely.                           */
/*                                                                          */
/*--------------------------------------------------------------------------*/
parse_arguments:
        parse arg argument arg_value arguments

        /*------------------------------------------------------------------*/
        /* If we have no argument, then simply return.  This is required as */
        /* this routine is called recursively.                              */
        /*------------------------------------------------------------------*/
        if (argument = '') then return

        /*------------------------------------------------------------------*/
        /* Translate the argument into upper case so it will be easeir to   */
        /* parse.                                                           */
        /*------------------------------------------------------------------*/
        argument = translate( argument )

        /*------------------------------------------------------------------*/
        /* Depending on which command line argument we have, set the        */
        /* appropriate variable.  If the value given either doesn't exist   */
        /* or is invalid, display an error message to the user and abort.   */
        /*------------------------------------------------------------------*/
        SELECT
                WHEN (argument = '-ATTEMPTS') then do
                        /*--------------------------------------------------*/
                        /* Check to see that we have a numeric value here.  */
                        /* If not, display an error message and quit.       */
                        /*--------------------------------------------------*/
                        if (arg_value \= '') then do
                                if (datatype( arg_value ) = 'NUM') then do
                                        max_attempts = arg_value
                                end
                                else do
                                        say 'Attempts requires a numeric parameter.' || cr
                                        exit 1
                                end
                        end
                        else do
                                say 'Attempts requires a parameter.' || cr
                                exit 1
                        end
                end
                WHEN (argument = '-NAME') then do
                        /*--------------------------------------------------*/
                        /* Check to see that we have been given a username. */
                        /* If not, display an error message and quit.       */
                        /*--------------------------------------------------*/
                        if (arg_value = '') then do
                                say 'Name requires a username parameter.' || cr
                                exit 1
                        end
                        else do
                                username = arg_value
                        end
                end
                WHEN (argument = '-PASSWORD') then do
                        /*--------------------------------------------------*/
                        /* Check to seee that we have been given a password.*/
                        /* If not, display an error message and quit.       */
                        /*--------------------------------------------------*/
                        if (arg_value = '') then do
                                say 'Password requires a password parameter.' || cr
                                exit 1
                        end
                        else do
                                password = arg_value
                        end
                end
                WHEN (argument = '-BEEP') then do
                        /*--------------------------------------------------*/
                        /* Translate the argument value into uppercase.     */
                        /*--------------------------------------------------*/
                        arg_value = translate( arg_value )

                        /*--------------------------------------------------*/
                        /* Check to see that the given parameter is either  */
                        /* ON or OFF.  If not, display an error message and */
                        /* quit.                                            */
                        /*--------------------------------------------------*/
                        if (arg_value = 'ON') then do
                                should_beep = 1
                        end
                        else do
                                if (arg_value = 'OFF') then do
                                        should_beep = 0
                                end
                                else do
                                        say 'Beep requires either ON or OFF as a parameter.' || cr
                                        exit 1
                                end
                        end
                end
                WHEN (argument = '-AUTOSTART') then do
                        /*--------------------------------------------------*/
                        /* Translate the argument value into uppercase.     */
                        /*--------------------------------------------------*/
                        arg_value = translate( arg_value )

                        /*--------------------------------------------------*/
                        /* Check to see that the given parameter is either  */
                        /* ON or OFF.  If not, display an error message and */
                        /* quit.                                            */
                        /*--------------------------------------------------*/
                        if (arg_value = 'ON') then do
                                should_autostart = 1
                        end
                        else do
                                if (arg_value = 'OFF') then do
                                        should_autostart = 0
                                end
                                else do
                                        say 'Autostart requires either ON or OFF as a parameter.' || cr
                                        exit 1
                                end
                        end
                end
                WHEN (argument = '-ADDRESS') then do
                        /*--------------------------------------------------*/
                        /* Unfortunately, I can't do much error checking    */
                        /* here.  So, we'll at least ensure that we have    */
                        /* been given a value and that it is a string.  If  */
                        /* not, display an error message and quit.          */
                        /*--------------------------------------------------*/
                        if ( (arg_value \= '') & (datatype(arg_value) = 'CHAR') ) then do
                                os2_address = arg_value
                        end
                        else do
                                say 'Address requires a dotted decimal notation address as a parameter.' || cr
                                exit 1
                        end
                end
        OTHERWISE do
                say 'Invalid command line argument: ' || argument || cr
                exit 1
        end     /* END for the OTHERWISE statement                         */
        END     /* END for the SELECT statement                            */

        /*------------------------------------------------------------------*/
        /* Recurse to parse any remaining command line arguments.           */
        /*------------------------------------------------------------------*/
        call parse_arguments( arguments )
return


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied string to show up in the COM input.  All input    */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                         */
/*                                                                          */
/*--------------------------------------------------------------------------*/
waitfor:
        parse arg waitstring , timeout

        if timeout = '' then timeout = 5000  /* LONG delay if not specified */

        waitfor_buffer = ''
        done = -1
        curpos = 1
        ORI_TIME=TIME('E')

        if (remain_buffer = 'REMAIN_BUFFER') then do
                remain_buffer = ''
        end

        do while (done = -1)
                if (remain_buffer \= '') then do
                        line = remain_buffer
                        remain_buffer = ''
                end
                else do
                        line = slip_com_input(interface,,10)
                end

                waitfor_buffer = waitfor_buffer || line
                index = pos(waitstring,waitfor_buffer)

                if (index > 0) then do
                        remain_buffer = substr(waitfor_buffer,index+length(waitstring))
                        waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
                        done = 0
                end

                call charout , substr(waitfor_buffer,curpos)
                curpos = length(waitfor_buffer)+1

                if ((done \= 0) & (TIME('E')>timeout)) then do
                        done = 1
                end
        end     /* end of 'while done = -1' */

        timeout=0
        RC=done
return RC



/*--------------------------------------------------------------------------*/
/*                               readpass ()                                */
/*..........................................................................*/
/*                                                                          */
/* Routine used to read a password from the user without echoing the        */
/* password to the screen.                                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/
readpass:
        answer = ''

        do until key = cr
                key = slip_getch()

                if key \= cr then do
                        answer = answer || key
                end
        end

        say ''
return answer


/*--------------------------------------------------------------------------*/
/*                             flush_receive ()                             */
/*..........................................................................*/
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/* The optional echo argument, if 1, says to echo flushed information.      */
/*                                                                          */
/*--------------------------------------------------------------------------*/
flush_receive:
        parse arg echo

        /* If echoing the flush - take care of waitfor remaining buffer     */
        if (echo \= '') & (length(remain_buffer) > 0) then do
                call charout , remain_buffer
                remain_buffer = ''
        end

        /* Eat anything left in the modem or COM buffers.  Stop when        */
        /* new appears for 100ms.                                           */
        do until line = ''
                line = slip_com_input(interface,,100)
                if echo \= '' then call charout , line
        end
return



/*--------------------------------------------------------------------------*/
/* NOTE: The following two procedures (waitfor3, waitfor2) were written by  */
/*       Harold Roussel (roussel@physics. mcgill.ca).                       */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*    waitfor3 ( waitstring1 , waitstring2 , waitstring3)                   */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied strings to show up in the COM input.  All input   */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* modified to accomodate three strings                                     */
/* this functions returns 1, 2, or 3 depending on which string was received */
/* first                                                                    */
/*--------------------------------------------------------------------------*/
waitfor3:
        parse arg waitstring1 , waitstring2 , waitstring3 , timeout

        waitfor_buffer = ''
        done = 0
        curpos = 1

        if (remain_buffer = 'REMAIN_BUFFER') then do
                remain_buffer = ''
        end

        do while done = 0
                if (remain_buffer \= '') then do
                        line = remain_buffer
                        remain_buffer = ''
                end
                else do
                        line = slip_com_input(interface)
                end

                waitfor_buffer = waitfor_buffer || line
                index1 = pos(waitstring1,waitfor_buffer)
                index2 = pos(waitstring2,waitfor_buffer)
                index3 = pos(waitstring3,waitfor_buffer)

                if (index1 > 0) then do
                        remain_buffer = substr(waitfor_buffer,index1+length(waitstring1))
                        waitfor_buffer = delstr(waitfor_buffer,index1+length(waitstring1))
                        stringchosen = 1
                        done = 1
                end
                else do
                        if (index2 > 0) then do
                                remain_buffer = substr(waitfor_buffer,index2+length(waitstring2))
                                waitfor_buffer = delstr(waitfor_buffer,index2+length(waitstring2))
                                stringchosen = 2
                                done = 1
                        end
                        else do
                                if (index3 > 0) then do
                                        remain_buffer = substr(waitfor_buffer,index3+length(waitstring3))
                                        waitfor_buffer = delstr(waitfor_buffer,index3+length(waitstring3))
                                        stringchosen = 3
                                        done = 1
                                end
                        end
                end

                call charout , substr(waitfor_buffer,curpos)
                curpos = length(waitfor_buffer)+1
        end
return



/*--------------------------------------------------------------------------*/
/*    waitfor2 ( waitstring1 , waitstring2 )                                */
/*..........................................................................*/
/*                                                                          */
/* Waits for the supplied strings to show up in the COM input.  All input   */
/* from the time this function is called until the string shows up in the   */
/* input is accumulated in the "waitfor_buffer" variable.                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/* modified to accomodate a second string                                   */
/* this functions returns 1 or 2 depending on which string was received     */
/* first                                                                    */
/*--------------------------------------------------------------------------*/
waitfor2:
        parse arg waitstring1 , waitstring2 , timeout

        waitfor_buffer = ''
        done = 0
        curpos = 1

        if (remain_buffer = 'REMAIN_BUFFER') then do
                remain_buffer = ''
        end

        do while done = 0
                if (remain_buffer \= '') then do
                        line = remain_buffer
                        remain_buffer = ''
                end
                else do
                        line = slip_com_input(interface)
                end

                waitfor_buffer = waitfor_buffer || line
                index1 = pos(waitstring1,waitfor_buffer)
                index2 = pos(waitstring2,waitfor_buffer)

                if (index1 > 0) then do
                        remain_buffer = substr(waitfor_buffer,index1+length(waitstring1))
                        waitfor_buffer = delstr(waitfor_buffer,index1+length(waitstring1))
                        stringchosen = 1
                        done = 1
                end
                else do
                        if (index2 > 0) then do
                                remain_buffer = substr(waitfor_buffer,index2+length(waitstring2))
                                waitfor_buffer = delstr(waitfor_buffer,index2+length(waitstring2))
                                stringchosen = 2
                                done = 1
                        end
                end

                call charout , substr(waitfor_buffer,curpos)
                curpos = length(waitfor_buffer)+1
        end
return
