/* Steward Digest Version 1.7.1 */
/*
 * A digest processor for Steward in Rexx by Paul Hethmon
 *
 */

/* variable declarations */

Steward = 'Steward'
StewardVersion = 'Version 1.7.1'
StewardDate = '16 March 1998'
uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lowercase = 'abcdefghijklmnopqrstuvwxyz'
Env = 'OS2ENVIRONMENT'
FALSE = 0
TRUE = 1

/* Variables normally read from the configuration file */
/* These values are provided as defaults only */
HomeDir = 'c:'
LogDir = 'c:'
ListDir = 'c:'
Mailer = 'hmailer'
WhereAmI = 'example.com'
WhoAmI = Steward
WhoAmIOwner = 'postmaster@'WhereAmI
MasterPassword = 'steward'

/* The following are set on a per list basis */
AdminPassword = 'steward-list'
Administrivia = 0
Owner = WhoAmIOwner
Advertise = '*'
ApprovePassword = 'steward-list'
DoArchive = 0
Moderated = 0
NoList = 0
Precedence = 1
ListHeader = 1
DoDigest = 0
DigestVolume = 0
DigestIssue = 0
DigestName = 'steward-digest'
DigestRmHeader = 1
DigestFronter = 'digest.fronter'
DigestFooter = 'digest.footer'
SubscribePolicy = 'open'
ReplyTo = ''
SubjectPrefix = 'Steward-List: '
DigestSubs = TRUE
DigestDelete = TRUE

/* The external functions we need */
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call RxFuncAdd 'SysFileDelete', 'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

/* Find the temporary directory to use */
TmpDir = value('STEWARD_TMP',,Env)
if TmpDir = '' then
  do
  TmpDir = value('TMP',,Env)
  end

/* start main function */
/* The argument to Digest is the digest listname to send out */
parse arg Digest

say 'digest starting'
/* Read the master configuration file now */
call ReadMasterCf

/* change to the Steward Home Directory */
Junk = directory(HomeDir)

/* Read the list configuration file */
/*parse var Digest ListName '-' Other*/
parse var Digest ListName '-digest'
call ReadListCf(ListName)

/* Now send out the digest to the digest list members
 * We're going to send yesterday's digest since today's
 * is still being compiled.
 */

DigestDay = ''
DigestMon = ''
DigestYear = ''
DigestDate = ''

call GetDigestDate

/* Check whether anything exists to send first */
FileName = ListDir'\'ListName'\Digests\'DigestYear'.'DigestMon'.'DigestDay
rc = SysFileTree(FileName, s., 'FO')
if rc = 0 & s.0 = 0 then do
  /* No digest material for today. Do nothing. */
  say 'No digest to send out'
  exit
  end

/* create a temp file for the outgoing message */
OutFile = SysTempFileName(TmpDir'\dig?????.tmp', '?');
rc = stream(OutFile, 'C', 'OPEN WRITE')  /* open the file for writing */

call WriteHeaders

/* Write out a banner line with the digest date */
rc = lineout(OutFile, '**************************************************', )
rc = lineout(OutFile, '', )
rc = lineout(OutFile, DigestName ' Volume' DigestVolume ' Issue' DigestIssue, )
rc = lineout(OutFile, 'Digest Date ' DigestDate, )
rc = lineout(OutFile, '', )
rc = lineout(OutFile, '**************************************************', )
rc = lineout(OutFile, '', )

/* Write out the subject lines if requested */
if DigestSubs = TRUE then
  do
  FileName = ListDir'\'ListName'\Digests\'DigestYear'.'DigestMon'.'DigestDay'.subs'
  /* make sure there is a file for email addresses */
  rc = SysFileTree(FileName, s., 'F')
  if rc = 0 & s.0 = 1 then do
    rc = LockOpen(FileName 'READ')
    if rc = TRUE then do
      rc = lineout(OutFile, "Today's Subjects ---", )
      do while lines(FileName) <> 0         /* until end of file */
        Line = linein(FileName)             /* get a line of the file */
        rc = lineout(OutFile, Line, )       /* output it */
      end
      rc = lineout(OutFile, '', )
      rc = LockClose(FileName)
    end
  end
end


/* See if there is a fronter to prepend to the digest */
if DigestFronter <> '' then do
  FileName = ListDir'\'ListName'\Digests\'DigestFronter
  rc = LockOpen(FileName 'READ')
  if rc = TRUE then do
    do while lines(FileName) <> 0         /* until end of file */
      Line = linein(FileName)             /* get a line of the file */
      rc = lineout(OutFile, Line, )       /* output it */
    end
    rc = LockClose(FileName)
  end
end

/* Now the digest file */
DigestFile = ListDir'\'ListName'\Digests\'DigestYear'.'DigestMon'.'DigestDay
/* open the file */
rc = LockOpen(DigestFile 'READ')
do while lines(DigestFile) <> 0         /* until end of file */
  Line = linein(DigestFile)             /* get a line of the file */
  rc = lineout(OutFile, Line, )       /* output it */
end
rc = LockClose(DigestFile)

/* See if there is a footer to append to the digest */
if DigestFooter <> '' then do
  FileName = ListDir'\'ListName'\Digests\'DigestFooter
  rc = LockOpen(FileName 'READ')
  if rc = TRUE then do
    do while lines(FileName) <> 0         /* until end of file */
      Line = linein(FileName)             /* get a line of the file */
      rc = lineout(OutFile, Line, )       /* output it */
    end
    rc = LockClose(FileName)
  end
end

rc = stream(OutFile, 'C', 'CLOSE')  /* close the output file */

/* now create the file with the email addresses in it */
FileName = ListDir'\'ListName'\'ListName'.digest'
/* make sure there is a file for email addresses */
rc = SysFileTree(FileName, s., 'F')
if rc = 0 & s.0 = 0 then do
  say 'Nobody to send digest to.'
  call IncrementIssue(DigestIssue)
  call SysFileDelete(OutFile)
  if DigestDelete = TRUE then
    do
    rc = SysFileDelete(DigestFile)
    FileName = DigestFile'.subs'
    rc = SysFileDelete(FileName)
    end
  exit
  end
/* make sure there are addresses in it */
parse var s.1 ddate dtime dsize drest
if dsize < 1 then do
  say 'No one to send digest to'
  call IncrementIssue(DigestIssue)
  call SysFileDelete(OutFile)
  if DigestDelete = TRUE then
    do
    rc = SysFileDelete(DigestFile)
    FileName = DigestFile'.subs'
    rc = SysFileDelete(FileName)
    end
  exit
  end

/* create a temp file for the email addresses */
EmailFile = SysTempFileName(TmpDir'\e?????.tmp', '?');
/* copy the list's email addresses to the temporary name */
rc = CopyLock(FileName EmailFile)

/* start the mail program to send the message out */
Mailer ListName'-owner@'WhereAmI EmailFile OutFile

/* Now increment the issue number in the list configuration file */
call IncrementIssue(DigestIssue)

if DigestDelete = TRUE then
  do
  rc = SysFileDelete(DigestFile)
  FileName = DigestFile'.subs'
  rc = SysFileDelete(FileName)
  end

exit

/* ------------------------------------------------------------------ */
/*
 * Write out our standard headers for a digest
 *
 */

WriteHeaders:  /* note that we have full access to all globals here */

TimeZone = value( 'TZ', , Env)
TmpTime = time('N')
DayOfWeek = date('W')
DayOfWeek = left(DayOfWeek, 3)
TmpDate = date('N')

rc = lineout(OutFile, 'Date:' DayOfWeek',' TmpDate TmpTime TimeZone, )
rc = lineout(OutFile, 'Sender:' ListName'-owner' '<'ListName'-owner@'WhereAmI'>', )
rc = lineout(OutFile, 'From:' Digest '<'Digest'@'WhereAmI'>', )
rc = lineout(OutFile, 'Reply-To:' Digest '<'Digest'@'WhereAmI'>', )
rc = lineout(OutFile, 'Subject:' DigestName, )
if ListHeader = TRUE then
  rc = lineout(OutFile, 'X-ListName:' DigestName, )
rc = lineout(OutFile, '', )

return

/* ------------------------------------------------------------------ */

GetDigestDate: procedure expose DigestDay DigestMon DigestYear DigestDate

/* Today's date */
TmpDate = date('S')
TmpYear = substr(TmpDate, 1, 4, ' ')
TmpMon = substr(TmpDate, 5, 2, ' ')
TmpDay = substr(TmpDate, 7, 2, ' ')

/* We must check the single digit dates because simple math
 * will make them single digits and we'll get the wrong filename.
 */
select
  when TmpDay = '01' then DigestDay = '00'  /* We'll catch it below */
  when TmpDay = '02' then DigestDay = '01'
  when TmpDay = '03' then DigestDay = '02'
  when TmpDay = '04' then DigestDay = '03'
  when TmpDay = '05' then DigestDay = '04'
  when TmpDay = '06' then DigestDay = '05'
  when TmpDay = '07' then DigestDay = '06'
  when TmpDay = '08' then DigestDay = '07'
  when TmpDay = '09' then DigestDay = '08'
  when TmpDay = '10' then DigestDay = '09'
  otherwise DigestDay = TmpDay - 1
end

DigestMon = TmpMon
DigestYear = TmpYear

if DigestDay < 1 then do
  select
    when TmpMon = '01' then do  /* January */
      DigestYear = TmpYear - 1
      DigestMon = '12'          /* December */
      DigestDay = '31'
      end
    when TmpMon = '02' then do  /* February */
      DigestMon = '01'          /* January */
      DigestDay = '31'
      end
    when TmpMon = '03' then do  /* March */
      DigestMon = '02'          /* February */
      if ( (0 = (DigestYear // 4)) & (0 <> (DigestYear // 100)) ) |,
         ( (0 = (DigestYear // 400)) ) then
        DigestDay = '29'
      else
        DigestDay = '28'
      end
    when TmpMon = '04' then do  /* April */
      DigestMon = '03'          /* March */
      DigestDay = '31'
      end
    when TmpMon = '05' then do  /* May */
      DigestMon = '04'          /* April */
      DigestDay = '30'
      end
    when TmpMon = '06' then do  /* June */
      DigestMon = '05'          /* May */
      DigestDay = '31'
      end
    when TmpMon = '07' then do  /* July */
      DigestMon = '06'          /* June */
      DigestDay = '30'
      end
    when TmpMon = '08' then do  /* August */
      DigestMon = '07'          /* July */
      DigestDay = '31'
      end
    when TmpMon = '09' then do  /* September */
      DigestMon = '08'          /* August */
      DigestDay = '31'
      end
    when TmpMon = '10' then do  /* October */
      DigestMon = '09'          /* September */
      DigestDay = '30'
      end
    when TmpMon = '11' then do  /* November */
      DigestMon = '10'          /* October */
      DigestDay = '31'
      end
    when TmpMon = '12' then do  /* December */
      DigestMon = '11'          /* November */
      DigestDay = '30'
      end
    otherwise
      nop
  end  /* select */
end  /* endif */

TmpWkDay = date('W')

select
  when TmpWkDay = 'Sunday' then
    TmpWkDay = 'Saturday'
  when TmpWkDay = 'Monday' then
    TmpWkDay = 'Sunday'
  when TmpWkDay = 'Tuesday' then
    TmpWkDay = 'Monday'
  when TmpWkDay = 'Wednesday' then
    TmpWkDay = 'Tuesday'
  when TmpWkDay = 'Thursday' then
    TmpWkDay = 'Wednesday'
  when TmpWkDay = 'Friday' then
    TmpWkDay = 'Thursday'
  when TmpWkDay = 'Saturday' then
    TmpWkDay = 'Friday'
  otherwise
    TmpWkDay = ''
end

select
  when DigestMon = '01' then
    TmpMon = 'January'
  when DigestMon = '02' then
    TmpMon = 'February'
  when DigestMon = '03' then
    TmpMon = 'March'
  when DigestMon = '04' then
    TmpMon = 'April'
  when DigestMon = '05' then
    TmpMon = 'May'
  when DigestMon = '06' then
    TmpMon = 'June'
  when DigestMon = '07' then
    TmpMon = 'July'
  when DigestMon = '08' then
    TmpMon = 'August'
  when DigestMon = '09' then
    TmpMon = 'September'
  when DigestMon = '10' then
    TmpMon = 'October'
  when DigestMon = '11' then
    TmpMon = 'November'
  when DigestMon = '12' then
    TmpMon = 'December'
  otherwise
    TmpMon = DigestMon
end

DigestDate = TmpWkDay DigestDay TmpMon DigestYear

return

/* ------------------------------------------------------------------ */
/*
 * Read the master configuration file
 *
 */

ReadMasterCf: procedure expose HomeDir LogDir ListDir Mailer WhereAmI WhoAmI ,
              WhoAmIOwner MasterPassword Env TRUE FALSE

/* Find out where the configuration file should be */
StewardCf = value('steward_cf',,Env)

/* If its not defined then assume wherever we are */
if StewardCf = '' then do
  StewardCf = '.'
  end

FileName = StewardCf'\steward.cf'

rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Line '#' Comment     /* separate out any comments */
  if Line <> '' then do               /* if not null */
    parse var Line Key '=' Val        /* find the key and value */
    if Key <> '' then do
      Val = strip(Val, 'B', ' ')      /* remove any blanks */
      Key = strip(Key, 'B', ' ')
/*      say Key '=' Val */
      select
        when Key = 'HomeDir' then
          HomeDir = Val
        when Key = 'LogDir' then
          LogDir = Val
        when Key = 'ListDir' then
          ListDir = Val
        when Key = 'Mailer' then
          Mailer = Val
        when Key = 'WhereAmI' then
          WhereAmI = Val
        when Key = 'WhoAmI' then
          WhoAmI = Val
        when Key = 'WhoAmIOwner' then
          WhoAmIOwner = Val
        when Key = 'MasterPassword' then
          MasterPassword = Val
        otherwise nop
        end   /* select */
      end     /* if Key <> '' */
    end       /* if Line <> '' */

  Key = ''

end /* end do while */

rc = LockClose(FileName)

return TRUE

/* ------------------------------------------------------------------ */
/*
 * Read the per list configuration file
 *
 */

ReadListCf: procedure expose ListDir AdminPassword ListOwner Administrivia,
            Advertise ApprovePassword DoArchive Moderated NoList Precedence,
            ListHeader SubscribePolicy ReplyTo SubjectPrefix TRUE FALSE,
            DoDigest DigestRmHeader DigestVolume DigestIssue DigestFronter,
            DigestFooter DigestName DigestSubs DigestDelete WhereAmI

parse arg ListName

FileName = ListDir'\'ListName'\'ListName'.cf'
rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Line '#' Comment     /* separate out any comments */
  if Line <> '' then do               /* if not null */
    parse var Line Key '=' Val        /* find the key and value */
    if Key <> '' then do
      Val = strip(Val, 'B', ' ')      /* remove any blanks */
      Key = strip(Key, 'B', ' ')
/*      say Key '=' Val */
      select
        when Key = 'AdminPassword' then
          AdminPassword = Val
        when Key = 'ListOwner' then
          ListOwner = Val
        when Key = 'Administrivia' then
          Administrivia = Val
        when Key = 'Advertise' then
          Advertise = Val
        when Key = 'ApprovePassword' then
          ApprovePassword = Val
        when Key = 'DoArchive' then
          DoArchive = Val
        when Key = 'Moderated' then
          Moderated = Val
        when Key = 'NoList' then
          NoList = Val
        when Key = 'Precedence' then
          Precedence = Val
        when Key = 'ListHeader' then
          ListHeader = Val
        when Key = 'SubscribePolicy' then
          SubscribePolicy = Val
        when Key = 'ReplyTo' then
          ReplyTo = Val
        when Key = 'SubjectPrefix' then
          SubjectPrefix = Val
        when Key = 'DoDigest' then
          DoDigest = Val
        when Key = 'DigestRmHeader' then
          DigestRmHeader = Val
        when Key = 'DigestVolume' then
          DigestVolume = Val
        when Key = 'DigestIssue' then
          DigestIssue = Val
        when Key = 'DigestName' then
          DigestName = Val
        when Key = 'DigestFronter' then
          DigestFronter = Val
        when Key = 'DigestFooter' then
          DigestFooter = Val
        when Key = 'DigestSubs' then
          DigestSubs = Val
        when Key = 'DigestDelete' then
          DigestDelete = Val
        when Key = 'WhereAmI' then
          WhereAmI = Val
        otherwise nop
        end   /* select */
      end     /* if Key <> '' */
    end       /* if Line <> '' */

  Key = ''

end /* end do while */

rc = LockClose(FileName)

return TRUE

/* ------------------------------------------------------------------ */

IncrementIssue: procedure expose TRUE FALSE ListDir ListName

parse arg CurIssue

NextIssue = CurIssue + 1

/* create a temp file for the outgoing message */
TmpFile = SysTempFileName('t?????.tmp', '?');
rc = stream(TmpFile, 'C', 'OPEN WRITE')  /* open the file for writing */

FileName = ListDir'\'ListName'\'ListName'.cf'
rc = LockOpen(FileName 'READ')  /* open the file locking it */
if rc = FALSE then
  return FALSE                   /* return FALSE if cannot open */

/* now read the configuration file */
do while lines(FileName) <> 0         /* until end of file */
  Line = linein(FileName)             /* get a line of the file */
  parse var Line Key '=' Val '#' Comment
  Key = strip(Key, 'B', ' ')
  if Key = 'DigestIssue' then
    rc = lineout(TmpFile, 'DigestIssue =' NextIssue, )
  else
    rc = lineout(TmpFile, Line, )
end

/* Close the files in current mode */
rc = LockClose(FileName)
rc = stream(TmpFile, 'C', 'CLOSE')

rc = CopyLock(TmpFile FileName)

rc = SysFileDelete(TmpFile)

return

/* ------------------------------------------------------------------ */




