/* ice4ward.cmd */
/* master routine for mail forwarding */
/* invoke this as ice4ward 2>&1 | tee ice4ward.log   */
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

trace r

/* dependencies:  (all must be reachable by the PATH except for mailto.exe)
   zip.exe     infozip zip utility
   mailto.exe  (in mr2ice directory; need one later than 1.26 that
                doesn't have a length limitation)
   killem.exe   kills process by name of executable (orprocess #)
   uuencode.exe standard utility available from various sources
*/
parmfile=ice4ward.prm
msgfil= 'ice4msg.fil'
counterfil='ice4cou.fil'

/* parameterized (but not tested as such) */


call readparms

/* this is the outer timing loop */
do forever
dat= date('s')
t=time('M')
/* next line is for test */
select
when params.test=1 then w=0
/* need to overhaul this approach */
when t<params.t1 then w=params.t1-t
when t<params.t2 then w=params.t2-t
when t<params.t3 then w=params.t3-t
when t<params.t4 then w=params.t4-t
when t<params.t5 then w=params.t5-t
otherwise w= (24*60)+params.t1-t    /* next day */
end    /* select */

say 'waiting ' w ' minutes'
s=syssleep(w*60)

xs=stream('i4wtime.log','c','open write');
xs=stream('i4wtime.log','c','seek<0');
xs=lineout('i4wtime.log',date('s') time());
xs=stream('i4wtime.log','c','close');

call forward
if params.test=1 then leave   /* for testing */
end  /* do forever */

/* leave comes here */
'echo FINI ----------' dat time() ' >> i4wtime.log'
exit

forward: procedure expose params.
/*   this is the procedure that calls the ISP and collects the messages */
/* strategy:
   1.  call ISP
   2.  wait 1 min
   3.  invoke mr2i /x (gets mail, then exits)
   4.  call msgmake (builds msgcat, zip, uuencode and msgfil)
   5.  mailto
   5a.  long wait for mailto to complete 
   6.  killem ppp
   7.  end and go back into outer loop to wait for next trigger     */


mydir=directory()   /* save current directory for later */
xx=directory(params.tcp)
/* 1. call epix */
/* params.dialup */
'@start' params.dialup 

/* wait a bit */
say 'waiting' params.wait1 'sec to ensure connection'
s=SysSleep(params.wait1)

/* 3.  callauto - get ice mail */
/* call mr2ice */
xx = directory(params.icedir)
'mr2i.exe /t /x'

/* 4. msgmake builds the messages */
here:
xx=directory(mydir)
call msgmake

/* 5. mailto */
params.icedir||"\mailto" msgfil params.to params.mailhost

/* rc = -4 if no connection */

/*  6.  wait a bit then knock down ppp */
say 'waiting' params.wait2 'sec before killing ppp'
s=SysSleep(params.wait2)
'killem ppp'
return         /* end of forward procedure */


msgmake: procedure expose params.
/* this collects the messages and packages them for sending  */
'xcopy '||params.folder||'*.rcv .' 
'erase '||params.folder||'*.rcv'

'rxqueue /clear'
'dir /b *.rcv | rxqueue'
work= queued()
say ' processing ' work ' messages'
if work>0 then do
msgno=linein(counterfil)
if msgno='' then msgno=1
is=stream(counterfil,'c','close')
'@erase' counterfil
is=stream(counterfil,'c','open write')
is=lineout(counterfil,msgno+1)
is=stream(counterfil,'c','close')

'zip mz'||msgno||' *.rcv' 
do while queued()>0
   parse pull filnam
   'echo =+=+=+=+ ' filnam '>>mcat'||msgno
   'type' filnam '>> mcat'||msgno
   end

'erase autm*.zip'
'zip autm'||msgno 'mcat'||msgno
'erase *.rcv'
'erase mcat'||msgno
end /* work >0 */

'@erase' msgfil
os=lineout(msgfil,params.from) /* 'From: JT autosend <jt@epix.net>')  */
dayte=date()
dow=date('W')
tim=time()
parse var dayte da rest
if da<10 then da='0'||da
datlin='Date: '||left(dow,3)||', '||da rest tim params.tzx
os=lineout(msgfil,datlin)
os=lineout(msgfil,'To: '||params.to)
os=lineout(msgfil,'Subject: autobatch number '||msgno)
os=lineout(msgfil,' ')
os=lineout(msgfil,' ')
os=lineout(msgfil,work 'messages this batch')
if work>0 then do
   os=stream(msgfil,'c','close')
   'uuencode autm'||msgno||'.zip autm'||msgno||'.zip >>' msgfil
    os=lineout('spaces','     ')
    os=lineout('spaces')
    'type spaces >>' msgfil
    'erase spaces'
    os=stream(msgfil,'c','open')
    os=stream(msgfil,'c','seek <0')
    end
os=lineout(msgfil,' ')
os=lineout(msgfil,'  - - - - - end msg batch  - - - -')
os=stream(msgfil,'c','close')

return /* end of msgmake procedure */


/* read params  */
readparms: procedure  expose params. parmfile

params.='***'
is=stream(parmfile,'c','open read')

do while lines(parmfile)
   line=strip(linein(parmfile)) 
   if line='' then iterate
   if left(line,2) = '/'||'*' then iterate
   if left(line,1) = ';' then iterate
   parse var line parm '=' value
   parm=strip(translate(parm))
   params.parm=strip(value)
   end
is=stream(parmfile,'c','close') 
return
