/*
 *      README.CMD - Internet Assistant for OS/2 V1.10 - C.Langanke 2001
 *      for Team OS/2 Deutschland e.V.
 *
 *      Syntax: README
 */

 rc      = 0;
 env     = 'OS2ENVIRONMENT';
 CallDir = GetCallDir();

 call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
 call SysLoadFuncs

 LanguageStem = GetLanguageStem();
 '@start view  inf\ia'LanguageStem '"Internet"'

 EXIT(rc);

/* ------------------------------------------------------------------------- */
GetCalldir: PROCEDURE
PARSE SOURCE . . CallName
 CallDir = FILESPEC('Drive', CallName)||FILESPEC('Path', CallName);
 RETURN(LEFT(CallDir, LENGTH(CallDir) - 1));

/* ------------------------------------------------------------------------- */
GetInstDrive: PROCEDURE EXPOSE env
 ARG DirName, EnvVarName

 IF (DirName = '') THEN DirName = '\OS2';

 IF (EnvVarName = '') THEN EnvVarName = 'PATH';

 PathValue = TRANSLATE(VALUE(EnvVarName,,env));

 DirName = TRANSLATE(':'DirName';');
 EntryPos = POS(DirName, PathValue) - 1;
 IF (EntryPos = -1) THEN
    RETURN('');
 InstDrive = SUBSTR(PathValue, EntryPos, 2);
 RETURN(InstDrive);

/* ========================================================================= */
GetLanguageStem: PROCEDURE EXPOSE env

 ValidLanguageCodes = '0   U   G   D   F   H   S   I   W   N   F   J   P   B   C   T   O';
 ValidLanguageStems = 'ENG ENG DEU DAN FRA NDL ESP ITA SVE NOR FIN JPN PTG PTB FRC TWN POL';

 LanguageStem = SysIni(, 'iaos2', 'LANGUAGESTEM');
 IF (LanguageStem = 'ERROR:') THEN
 DO
    BootDrive    = GetInstDrive();
    SyslevelFile = BootDrive'\OS2\INSTALL\SYSLEVEL.OS2';
    LanguageCode = CHARIN( SyslevelFile, 47, 1);
    rcx = STREAM( SyslevelFile, 'C', 'CLOSE');
    index = WORDPOS( LanguageCode, ValidLanguageCodes);
    IF (index > 0) THEN
       LanguageStem = WORD( ValidLanguageStems, index);
    ELSE
       LanguageStem = 'eng';
 END;
 ELSE
    LanguageStem = LEFT( LanguageStem, POS( D2C( 0), LanguageStem) - 1);

 RETURN( LanguageStem);

