/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import rb.util.IDCollection;
import rb.util.IDDictionaryElementRB;
import rb.util.IDDictionaryEnumeratorRB;

public abstract class IDDictionaryClass
extends IDCollection {
    IDDictionaryElementRB[][] contents;
    int elementCount = 0;
    int capacity;
    static final long IDFilter = 0xFFFFFFFFL;
    static final long IDIncrement = 0x100000000L;
    static final int IndexShift = 16;
    static final int IndexFilter = 65535;
    static final int maxBucketSize = 65536;
    static final int startCapacity = 20;
    static final int growthFactor = 20;

    public IDDictionaryClass() {
        this(20);
    }

    public IDDictionaryClass(int n) {
        this.contents = new IDDictionaryElementRB[1][n];
        this.capacity = n;
    }

    public final int capacity() {
        return this.capacity;
    }

    public IDDictionaryElementRB elementAt(long l) {
        return this.get(l);
    }

    public IDDictionaryEnumeratorRB elements() {
        return new IDDictionaryEnumeratorRB(this);
    }

    public synchronized void ensureCapacity(int n) {
        IDDictionaryElementRB[] iDDictionaryElementRBArray;
        int n2;
        if (n <= this.capacity) {
            return;
        }
        int n3 = this.contents.length - 1;
        int n4 = this.contents[n3].length;
        int n5 = n - this.capacity;
        n5 += 20 + this.elementCount * 20 / 100;
        if (n4 < 65536) {
            n2 = Math.min(n4 + n5, 65536);
            iDDictionaryElementRBArray = new IDDictionaryElementRB[n2];
            System.arraycopy(this.contents[n3], 0, iDDictionaryElementRBArray, 0, n4);
            this.contents[n3] = iDDictionaryElementRBArray;
            n5 -= n2 - n4;
            this.capacity += n2 - n4;
        }
        if (n5 <= 0) {
            return;
        }
        n2 = n3 + 1 + (n5 - 1) / 65536;
        iDDictionaryElementRBArray = new IDDictionaryElementRB[n2 + 1][];
        System.arraycopy(this.contents, 0, iDDictionaryElementRBArray, 0, n3 + 1);
        this.contents = iDDictionaryElementRBArray;
        ++n3;
        while (n3 <= n2) {
            this.contents[n3] = new IDDictionaryElementRB[65536];
            ++n3;
        }
        this.capacity = (n2 + 1) * 65536;
    }

    public synchronized IDDictionaryElementRB get(long l) {
        IDDictionaryElementRB iDDictionaryElementRB;
        int n = (int)(l & 0xFFFFFFFFL);
        try {
            iDDictionaryElementRB = this.contents[n >> 16][n & 0xFFFF];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        if (iDDictionaryElementRB == null || iDDictionaryElementRB.getID() != l) {
            return null;
        }
        return iDDictionaryElementRB;
    }

    public synchronized long indexOf(IDDictionaryElementRB iDDictionaryElementRB) {
        long l = iDDictionaryElementRB.getID();
        if (this.get(l) == iDDictionaryElementRB) {
            return l;
        }
        return -1L;
    }

    public synchronized IDDictionaryElementRB remove(long l) {
        IDDictionaryElementRB iDDictionaryElementRB;
        int n = (int)(l & 0xFFFFFFFFL);
        try {
            iDDictionaryElementRB = this.contents[n >> 16][n & 0xFFFF];
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        if (iDDictionaryElementRB == null || iDDictionaryElementRB.getID() != l) {
            return null;
        }
        this.contents[n >> 16][n & 0xFFFF] = null;
        --this.elementCount;
        return iDDictionaryElementRB;
    }

    public synchronized boolean removeElement(IDDictionaryElementRB iDDictionaryElementRB) {
        long l = this.indexOf(iDDictionaryElementRB);
        if (l < 0L) {
            return false;
        }
        this.remove(l);
        return true;
    }

    public IDDictionaryElementRB removeElementAt(long l) {
        return this.remove(l);
    }

    public int size() {
        return this.elementCount;
    }

    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        IDDictionaryEnumeratorRB iDDictionaryEnumeratorRB = this.elements();
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = iDDictionaryEnumeratorRB.nextElement();
            ++n;
        }
        return objectArray;
    }
}

