/*
** RCS_ID = $Id: defs.h,v 1.3 1999/02/25 17:59:20 siebert Exp $
**
** defs.h	common definitions for http-analyze.
**
** Copyright  1996-1998 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
*/

/*
** The following macros are used to replace calls to islower() and
** friends for the sake of speed. Because this works only in ASCII
** environments, the program isn't strictly ANSI-conforming anymore.
** Let FAST_CTYPE undefined to switch back to islower from the stdlib.
**
** -------------------------------------------------------------
** WARNING: all macros evaluate their parameters more than once!
** -------------------------------------------------------------
*/
#if defined(FAST_CTYPE)
# define is_print(c)	((c) >= ' ' && (c) <= '~')
# define is_digit(c)	((c) >= '0' && (c) <= '9')
# define is_lower(c)	((c) >= 'a' && (c) <= 'z')
# define is_upper(c)	((c) >= 'A' && (c) <= 'Z')
# define to_upper(c)	((c)-('a'-'A'))
# define to_lower(c)	((c)+('a'-'A'))
#else
# define is_print(c)	isprint(c)
# define is_digit(c)	isdigit(c)
# define is_lower(c)	islower(c)
# define is_upper(c)	isupper(c)
# define to_upper(c)	toupper(c)
# define to_lower(c)	tolower(c)
#endif

#if !defined(MIN)
# define MIN(a,b)	((a)<(b) ? (a) : (b))
#endif

#if !defined(MAX)
# define MAX(a,b)	((a)>(b) ? (a) : (b))
#endif

/*
** Compatibility kludges.
*/
#if defined(WIN32)
# define strncasecmp	strnicmp 
# define strcasecmp	stricmp 
# define mkdir(a,b)	mkdir(a)

#elif defined(__EMX__)
# define strncasecmp	strnicmp 
# define strcasecmp	stricmp 

#elif defined(NETWARE)
# define strncasecmp	strnicmp 
# define strcasecmp	stricmp 
# define mkdir(a,b)	mkdir(a)
#endif

/*
** Macros to be defined in strict ANSI and pre-ANSI
** environments (mostly from unistd.h).
*/
#if !defined(F_OK)	/* symbolic constants for the access() function */
# define R_OK	004	/* read permission */
# define W_OK	002	/* write permission */
# define X_OK	001	/* execute permission */
# define F_OK	000	/* existence of File */
#endif

#if !defined(WEXITSTATUS)
# define WEXITSTATUS(stat) (((stat)>>8)&0377)
#endif

/* To simplify porting we use MAX_FNAMELEN for filename buffers,
** since on some older platforms FILENAME_MAX may be too small.
*/
#define MAX_FNAMELEN	1024

#define streq(s1,s2)	(!strcasecmp((s1), (s2)))
#define strneq(s1,s2,n)	(!strncasecmp((s1), (s2), (n)))

#define SMALLSIZE	100
#define MEDIUMSIZE	512
#define BIGSIZE		10240	/* set to 10K again for huge logfile entries */
#define LBUFSIZE	4096	/* use smaller size for other line buffers */

#define TIME_FMT	"%02hu/%3.3s/%04hu"
#define EPOCH(yr)	((yr) >= 2000 ? (yr)-2000 : (yr)-1900)
#define TABSIZE(arr)	(sizeof(arr)/sizeof(arr[0]))

#define MAX_HPNAMES	10	/* maximum # of hompages incl. index.html */
#define MAX_PGTYPE	10	/* maximum # of page type suffixes */

/* Index values for HTML strings in array html_str[] */
#define HTML_HEADPFX	0
#define HTML_HEADSFX	1
#define HTML_TRAILER	2
#define HTML_STRSIZE	3

/* VRML values */
#define OLD_LAYOUT	0x04	/* use old layout (two separate bar charts) */
#define BG_COLOR	0x08	/* generate background colors */

/* Logfile formats (not all are available yet) */
#define LOGF_UNKNOWN	0	/* try to recognize CLF or ELF automatically */
#define LOGF_CLF	1	/* strict Common Logfile Format (CLF) */
#define LOGF_MSCLF	2	/* bogus MickeySoft CLF format (date wrong) */
#define LOGF_ELF	10	/* Extended Logfile Format (ELF) */
#define LOGF_NCSA	11	/* NCSA ELF format (uag/ref in double quotes) */

/*
** Macros for the response code according to HTTP/1.1 (RFC2068).
*/
#define RES_CONTINUE		100
#define RES_SWITCH_PROTO	101
#define RES_OK			200
#define RES_CREATED		201
#define RES_ACCEPTED		202
#define RES_NON_AUTH		203
#define RES_NO_CONTENT		204
#define RES_RSET_CONTENT	205
#define RES_PART_CONTENT	206
#define RES_MULT_CHOICES	300
#define RES_MOVED_PERM		301
#define RES_MOVED_TEMP		302
#define RES_SEE_OTHER		303
#define RES_NOT_MODIFIED	304
#define RES_USE_PROXY		305
#define RES_BAD_REQUEST		400
#define RES_UNAUTHORIZED	401
#define RES_PAYMENT_REQ		402
#define RES_FORBIDDEN		403
#define RES_NOT_FOUND		404
#define RES_METHOD_NALLOWED	405
#define RES_NOT_ACCEPTABLE	406
#define RES_PROXY_AUTHREQ	407
#define RES_REQ_TIMEOUT		408
#define RES_CONFLICT		409
#define RES_GONE		410
#define RES_LENGTH_REQ		411
#define RES_PRECOND_FAILED	412
#define RES_REQ_TOOLARGE	413
#define RES_REQ_TOOLONG		414
#define RES_UNSUPPORTED		415
#define RES_SERVER_ERROR	500
#define RES_NOT_IMPLEMENTED	501
#define RES_BAD_GATEWAY		502
#define RES_SERVICE_UNAVAIL	503
#define RES_GATEWAY_TIMEOUT	504
#define RES_VERS_NSUPPORTED	505

/*
** Indexes into the RespCode table in http-analyze.c.
*/
#define IDX_UNKNOWN		 0	/* unknown response */
#define IDX_CONTINUE		 1	/* Code 100 Continue */
#define IDX_SWITCH_PROTO	 2	/* Code 101 Switch Protocols */
#define IDX_OK			 3	/* Code 200 OK */
#define IDX_CREATED		 4	/* Code 201 Created */
#define IDX_ACCEPTED		 5	/* Code 202 Accepted */
#define IDX_NON_AUTH		 6	/* Code 203 Non-Authoritative Information */
#define IDX_NO_CONTENT		 7	/* Code 204 No Content */
#define IDX_RSET_CONTENT	 8	/* Code 205 Reset Content */
#define IDX_PART_CONTENT	 9	/* Code 206 Partial Content */
#define IDX_MULT_CHOICES	10	/* Code 300 Multiple Choices */
#define IDX_MOVED_PERM		11	/* Code 301 Moved Permanently */
#define IDX_MOVED_TEMP		12	/* Code 302 Moved Temporarily */
#define IDX_SEE_OTHER		13	/* Code 303 See Other */
#define IDX_NOT_MODIFIED	14	/* Code 304 Not Modified */
#define IDX_USE_PROXY		15	/* Code 305 Use Proxy */
#define IDX_BAD_REQUEST		16	/* Code 400 Bad Request */
#define IDX_UNAUTHORIZED	17	/* Code 401 Unauthorized */
#define IDX_PAYMENT_REQ		18	/* Code 402 Payment Required */
#define IDX_FORBIDDEN		19	/* Code 403 Forbidden */
#define IDX_NOT_FOUND		20	/* Code 404 Not Found */
#define IDX_METHOD_NALLOWED	21	/* Code 405 Method Not Allowed */
#define IDX_NOT_ACCEPTABLE	22	/* Code 406 Not Acceptable */
#define IDX_PROXY_AUTHREQ	23	/* Code 407 Proxy Authentication Required */
#define IDX_REQ_TIMEOUT		24	/* Code 408 Request Timeout */
#define IDX_CONFLICT		25	/* Code 409 Conflict */
#define IDX_GONE		26	/* Code 410 Gone */
#define IDX_LENGTH_REQ		27	/* Code 411 Length Required */
#define IDX_PRECOND_FAILED	28	/* Code 412 Precondition Failed */
#define IDX_REQ_TOOLARGE	29	/* Code 413 Request Entity Too Large */
#define IDX_REQ_TOOLONG		30	/* Code 414 Request-URI Too Long */
#define IDX_UNSUPPORTED		31	/* Code 415 Unsupported */
#define IDX_SERVER_ERROR	32	/* Code 500 Internal Server Error */
#define IDX_NOT_IMPLEMENTED	33	/* Code 501 Not Implemented */
#define IDX_BAD_GATEWAY		34	/* Code 502 Bad Gateway */
#define IDX_SERVICE_UNAVAIL	35	/* Code 503 Service Unavailable */
#define IDX_GATEWAY_TIMEOUT	36	/* Code 504 Gateway Timeout */
#define IDX_VERS_NSUPPORTED	37	/* Code 505 HTTP Version Not Supported */
#define IDX_MAXSIZE		38	/* size of RespCode table */

/* Codes for isHiddenItem() */
#define HIDDEN_SITES	0
#define HIDDEN_ITEMS	1
#define HIDDEN_REFERS	2
#define HIDDEN_AGENTS	3
#define IGNORED_SITES	4
#define IGNORED_ITEMS	5
#define SELF_REF	IGNORED_ITEMS

/* Codes for request method and file type */
#define METHOD_UNKNOWN	0
#define METHOD_GET	1
#define METHOD_POST	2
#define METHOD_HEAD	3
#define METHOD_PUT	4
#define METHOD_OPTIONS	5
#define METHOD_BROWSE	6
#define METHOD_DELETE	7
#define METHOD_TRACE	8
#define METHOD_MASK	0x0F

#define TYPE_PGVIEW	(1U<<8)
#define TYPE_NODNS	(1U<<9)

#define IS_METHOD(what, which)	(((what) & METHOD_MASK) == (which))
#define IS_TYPE(what, which)	(((what) & (which)) == (which))

/*
** Macros for converting time into LOGENT.ltick.
** Ticks are made up of:
**   seconds [0,61]
**   minutes [0,59]
**   hours   [0,23]
**   days    [1,31]
**   months  [0,11]
**   years   years from 01/Jan/1990 00:00:00.
**/
#define TICKS_PSEC(sec)	((u_long)sec)
#define TICKS_PMIN(min)	((u_long)(min)     * 62LU)
#define TICKS_PHOUR(hr)	((u_long)(hr)      * 60LU * 62LU)
#define TICKS_PDAY(day)	((u_long)(day)     * 24LU * 60LU * 62LU)
#define TICKS_PMON(mon)	((u_long)(mon)     * 31LU * 24LU * 60LU * 62LU)
#define TICKS_PYEAR(yr)	((u_long)(yr-1990) * 12LU * 31LU * 24LU * 60LU * 62LU)

/* Font definitions for FONTDEF lists */
#define FONT_HEAD	0	/* the font defs for headers */
#define FONT_TEXT	1	/* the font defs for regular text */
#define FONT_SMALL	2	/* the font defs for small text */
#define FONT_LISTS	3	/* the font defs for text in lists */
#define FONT_VAR	4	/* variable font */
#define FONT_MAX	5	/* the max no. of font defs */

/* Default serif-less font for various platforms */
#define DEF_FONT	"Helvetica,Arial,Geneva,sans-serif"

/* Special codes for variable sized font (mapped to FONT_VAR) */
#define FONT_HEAD1	71	/* 1 pt size FONT_SMALL */
#define FONT_HEAD2	72	/* 2 pt size FONT_SMALL */
#define FONT_HEAD3	73	/* 3 pt size FONT_HEAD */
#define FONT_HEAD4	74	/* 4 pt size FONT_HEAD */

/* System info */
typedef struct {
	char *hostname;		/* hostname (FQDN or nodename) */
	char *sysname;		/* system name */
	char *release;		/* OS release */
	char *version;		/* version number */
	char *machine;		/* machine type */
} SRVINFO;

/* Time format */
typedef struct {
	u_short mday;		/* day of month [1..31] */
	u_short mon;		/* month of year [0..11] */
	u_short year;		/* year [1900..2048] */
	u_short hour;		/* hour [0..23] */
	u_short min;		/* min [0..59] */
	u_short sec;		/* sec [0..61] */
} LOGTIME;

/* Time period */
typedef struct {
	LOGTIME start, end;	/* start/end of period */
	LOGTIME ignore, brk;	/* start/end of window */
	LOGTIME current;	/* current time */
} PERIOD;

typedef struct {
	char *str;		/* the string */
	size_t len;		/* the string length */
	u_int hval;		/* the hash value */
} HSTRING;

typedef struct {
	char *face;		/* the HTML font name(s) */
	u_short fsize;		/* the HTML font size */
} FONTDEF;

typedef struct {
	HSTRING sitename;	/* the sitename */
	HSTRING request;	/* the requested URL */
	HSTRING uagent;		/* the user agent */
	HSTRING refer;		/* the referrer */
	HSTRING authuser;	/* authentication was required */
	HSTRING virthost;	/* virtual hostname */
	HSTRING tldomain;	/* 2nd level domain */
	HSTRING uatype;		/* user agent type */
	HSTRING refhost;	/* referrer host */
	LOGTIME tm;		/* timestamp */
	size_t respidx;		/* server response index */
	u_long reqsize;		/* size of request */
	u_long ltick;		/* last tick */
	u_int ftype;		/* ftype flags (TYPE_*) */
} LOGENT;

/* Hash list element */
typedef struct NLIST {
	char *str;		/* URL of request or sitename */
	size_t len;		/* length of string */
	size_t sslen;		/* node-specific substring length */
	int ishidden;		/* set if hidden (must be signed) */
	u_int ftype;		/* ftype flags (TYPE_*) */
	u_long ltick;		/* last tick */
	u_long count;		/* hits */
	u_long nomod;		/* 304's */
	u_long size;		/* size of document if known */
	float bytes;		/* total transfer count */
	struct NLIST *next;
} NLIST;

/* HTTP response codes */
typedef struct {
	u_long count;		/* total count */
	float bytes;		/* total transfer count */
	char *msg;		/* message if any */
} RESPONSE;

/* Country code table */
typedef struct {
	u_long code;		/* two-letter country code */
	char *name;		/* country name */
	char *pfx;		/* NULL if ISO country code */
	size_t plen;		/* prefix length */
	u_long count;		/* counters */
	u_long nomod;
	float bytes;
} COUNTRY;

/* Hidden items */
typedef struct {
	char *pfx;		/* prefix to compare (descr. is in col.str) */
	char *sref;		/* node-specific info: page rating/country info/referal link */
	size_t len;		/* string length of pfx (will be initialized) */
	NLIST *col;		/* collector for data */
} ITEM_LIST;

/* License info */
typedef struct {
	char *company;		/* company name */
	char *regID;		/* registration ID */
} LIC_INFO;

typedef struct {
	ITEM_LIST *tab;		/* ptr into item list */
	char *what;		/* name of list */
	size_t t_start;		/* start of dynamic entries */
	size_t t_count;		/* # of entries used */
	size_t t_avail;		/* # of available slots */
	size_t t_errmsg;	/* flag for error message */
} HIDE_TAB;

/* Hit counters */
typedef struct {
	u_long hits;		/* hits */
	u_long files;		/* files */
	u_long nomod;		/* 304's */
	u_long views;		/* pageviews */
	u_long other;		/* other responses */
	u_long sessions;	/* user sessions */
	float bytes;		/* bytes */
} COUNTER;

/* Top hits counters */
typedef struct {
	u_long count;		/* hits */
	u_long nomod;		/* 304 requests */
	float bytes;		/* bytes sent */
	LOGTIME tm;		/* timestamp */
} TOP_COUNTER;

/* Definitions for small icons and logos */
#define SQICON_GREEN	icon_tab[0].name
#define SQICON_BLUE	icon_tab[1].name
#define SQICON_RED	icon_tab[2].name
#define SQICON_ORANGE	icon_tab[3].name
#define SQICON_YELLOW	icon_tab[4].name
#define SQICON_MAGENTA	icon_tab[5].name
#define SQICON_GREY	icon_tab[6].name

#define BTN_NETSTORESW	0
#define BTN_NETSTORESB	1
#define BTN_RAGSW	2
#define BTN_RAGSB	3
#define BTN_YEAR	4
#define BTN_TOTALS	5
#define BTN_DAYS	6
#define BTN_CUSTOMW	7
#define BTN_CUSTOMB	8
#define BTN_AVLOAD	9
#define BTN_TOPURL	10
#define BTN_TOPDOM	11
#define BTN_TOPUAG	12
#define BTN_TOPREF	13
#define BTN_COUNTRY	14
#define BTN_FILES	15
#define BTN_RFILES	16
#define BTN_SITES	17
#define BTN_RSITES	18
#define BTN_AGENTS	19
#define BTN_REFER	20
#define BTN_MAX		21

typedef struct {
	char *name;
	int color[3];
} ICON_TAB;

/* Definitions for buttons and images */
typedef struct {
	char *name;	/* name of image */
	char *text;	/* ALT text, BORDER etc. */
	int r, g, b;	/* color value */
	int wid, ht;	/* dimensions */
} BTN_TAB;

/* Global variables and functions in http-analyze.c */
extern int verbose;		/* be verbose */
extern int nopageviews;		/* if set suppress pageviews and show 304's instead */

extern char *monnam[];		/* list of month names */
extern char *daynam[];		/* list of day names */
extern char *creator;		/* creator of 3D models */

extern COUNTER daily[];		/* hits per day */
extern COUNTER avg_day;		/* average hits per day */
extern COUNTER max_day;		/* max hits per day */
extern u_long wh_hits[][24];	/* hits per weekday & hour */
extern u_long avg_whour[];	/* avg hits per weekhour */
extern u_long avg_wday[];	/* avg hits per weekday */
extern u_long max_avdhits;	/* max # of avg hits per weekday */
extern u_long max_avhhits;	/* max # of avg hits per weekhour */
extern u_long max_whhits;	/* max hits per weekday & hour */
extern size_t wdtab[31];	/* list of weekdays for this month */

extern ICON_TAB icon_tab[];	/* names for small icons in images.c */
extern BTN_TAB buttons[];	/* names for buttons in images.c */

/* Functions in cntrycode.c */
u_int addCountry(HIDE_TAB *const, NLIST *const, NLIST **const, size_t const);
COUNTRY *nextCountry(int const);
void clearCountry(void);
void addTLD(char *const, char *const);
void initTLD(char *const);

/* Graphic functions in images.c */
int graph(COUNTER *const, char **const, int, int, int const, u_short const, char *const);
int mn_bars(int const, int const, int const, COUNTER *const, u_short const, u_short const,
	    char *const, char *const);
int wd_bars(int const, int const, int const, COUNTER *const, COUNTER *const, 
	    u_short const, char *const);
int hr_bars(int const, int const, int const, u_long *const, u_long const, char *const);
int c_chart(int const, int const, int const, char *const,
	    COUNTRY **const, NLIST **const, size_t const, u_long const, char *const);
void checkForIcons(void);
int checkForLogos(char *const);

/* Variables and utilities in utils.c */
char *strsave(char *);
SRVINFO *myHostName(void);
LIC_INFO *getRegID(char *const, char *const, char *const);
int saveRegID(char *const, char *const, char *const);
int setDate(LOGTIME *const, char const *);
int getargs(char *, char **, int const);
int compress(char *const);
void prmsg(int const, char *const, ...);

#if defined(NEED_GETOPT)
extern int getopt(int argc, char *const argv[], const char *optstring);
extern char *optarg;
extern int optind;
#endif

#if defined(NEED_STRCASECMP)
extern int strcasecmp (const char *s1, const char *s2);
extern int strncasecmp (const char *s1, const char *s2, size_t n);
#endif

#if defined(NEED_STRERROR)
extern char *strerror(int errnum);
#endif

