/*
** RCS_ID = $Id: cntrycode.h,v 1.1.1.2 1999/02/25 16:42:55 siebert Exp $
**
** Country codes for http-analyze
**
** Copyright  1996-1998 by Stefan Stapelberg, <stefan@rent-a-guru.de>
**
*/

/*
** Macros for country management.
*/
#define CC_CHR(c1)		((u_long)((c1)-'a'+1))
#define CC_PAIR(c1,c2)		((CC_CHR(c1)<<5L)|CC_CHR(c2))
#define CC_PAIR3(c1,c2,c3)	((CC_PAIR(c1,c2)<<5L)|CC_CHR(c3))
#define CC_PAIR4(c1,c2,c3,c4)	((CC_PAIR3(c1,c2,c3)<<5L)|CC_CHR(c4))
#define CC_PAIR5(c1,c2,c3,c4)	((CC_PAIR4(c1,c2,c3,c4)<<5L)|CC_CHR(c5))

/*
** Default list of all valid top-level domains.
*/
static COUNTRY def_country[] = {
	/* International ISO two-letter country codes */
	{ CC_PAIR('a', 'd'), "Andorra",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'e'), "United Arab Emirates",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'f'), "Afghanistan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'g'), "Antigua and Barbuda",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'i'), "Anguilla",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'l'), "Albania",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'm'), "Armenia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'n'), "Netherlands Antilles",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'o'), "Angola",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'q'), "Antarctica",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'r'), "Argentina",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 's'), "American Samoa",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 't'), "Austria",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'u'), "Australia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'w'), "Aruba",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('a', 'z'), "Azerbaijan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'a'), "Bosnia and Herzegovina",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'b'), "Barbados",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'd'), "Bangladesh",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'e'), "Belgium",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'f'), "Burkina Faso",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'g'), "Bulgaria",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'h'), "Bahrain",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'i'), "Burundi",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'j'), "Benin",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'm'), "Bermuda",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'n'), "Brunei Darussalam",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'o'), "Bolivia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'r'), "Brazil",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 's'), "Bahamas",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 't'), "Bhutan",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'v'), "Bouvet Island",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'w'), "Botswana",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'y'), "Belarus",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('b', 'z'), "Belize",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'a'), "Canada",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'c'), "Cocos (Keeling) Islands", NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'd'), "Democratic Republic of the Congo",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'f'), "Central African Republic",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'g'), "Congo",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'h'), "Switzerland",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'i'), "Cote D'Ivoire (Ivory Coast)",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'k'), "Cook Islands",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'l'), "Chile",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'm'), "Cameroon",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'n'), "China",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'o'), "Colombia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'r'), "Costa Rica",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 's'), "Czechoslovakia (former)", NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'u'), "Cuba",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'v'), "Cape Verde",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'x'), "Christmas Island",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'y'), "Cyprus",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('c', 'z'), "Czech Republic",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'e'), "Germany",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'j'), "Djibouti",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'k'), "Denmark",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'm'), "Dominica",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'o'), "Dominican Republic",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('d', 'z'), "Algeria",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'c'), "Ecuador",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'e'), "Estonia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'g'), "Egypt",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'h'), "Western Sahara",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 'r'), "Eritrea",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 's'), "Spain",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('e', 't'), "Ethiopia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'i'), "Finland",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'j'), "Fiji",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'k'), "Falkland Islands (Malvinas)",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'm'), "Micronesia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'o'), "Faroe Islands",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'r'), "France",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('f', 'x'), "France, Metropolitan",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'a'), "Gabon",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'b'), "Great Britain (UK)",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'd'), "Grenada",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'e'), "Georgia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'f'), "French Guiana",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'h'), "Ghana",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'i'), "Gibraltar",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'l'), "Greenland",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'm'), "Gambia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'n'), "Guinea",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'p'), "Guadeloupe",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'q'), "Equatorial Guinea",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'r'), "Greece",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 's'), "S. Georgia and S. Sandwich Isls.",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 't'), "Guatemala",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'u'), "Guam",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'w'), "Guinea-Bissau",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('g', 'y'), "Guyana",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'k'), "Hong Kong",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'm'), "Heard and McDonald Islands",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'n'), "Honduras",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'r'), "Croatia (Hrvatska)",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 't'), "Haiti",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('h', 'u'), "Hungary",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'd'), "Indonesia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'e'), "Ireland",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'l'), "Israel",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'n'), "India",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'o'), "British Indian Ocean Territory",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'q'), "Iraq",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 'r'), "Iran",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 's'), "Iceland",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('i', 't'), "Italy",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('j', 'm'), "Jamaica",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('j', 'o'), "Jordan",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('j', 'p'), "Japan",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'e'), "Kenya",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'g'), "Kyrgyzstan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'h'), "Cambodia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'i'), "Kiribati",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'm'), "Comoros",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'n'), "Saint Kitts and Nevis", NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'p'), "Korea (North)",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'r'), "Korea (South)",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'w'), "Kuwait",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'y'), "Cayman Islands",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('k', 'z'), "Kazakhstan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'a'), "Laos",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'b'), "Lebanon",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'c'), "Saint Lucia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'i'), "Liechtenstein",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'k'), "Sri Lanka",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'r'), "Liberia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 's'), "Lesotho",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 't'), "Lithuania",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'u'), "Luxembourg",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'v'), "Latvia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('l', 'y'), "Libya",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'a'), "Morocco",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'c'), "Monaco",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'd'), "Moldova",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'g'), "Madagascar",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'h'), "Marshall Islands",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'k'), "Macedonia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'l'), "Mali",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'm'), "Myanmar",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'n'), "Mongolia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'o'), "Macau",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'p'), "Northern Mariana Islands",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'q'), "Martinique",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'r'), "Mauritania",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 's'), "Montserrat",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 't'), "Malta",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'u'), "Mauritius",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'v'), "Maldives",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'w'), "Malawi",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'x'), "Mexico",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'y'), "Malaysia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('m', 'z'), "Mozambique",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'a'), "Namibia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'c'), "New Caledonia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'e'), "Niger",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'f'), "Norfolk Island",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'g'), "Nigeria",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'i'), "Nicaragua",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'l'), "Netherlands",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'o'), "Norway",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'p'), "Nepal",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'r'), "Nauru",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 't'), "Neutral Zone",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'u'), "Niue",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('n', 'z'), "New Zealand (Aotearoa)",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('o', 'm'), "Oman",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'a'), "Panama",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'e'), "Peru",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'f'), "French Polynesia",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'g'), "Papua New Guinea",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'h'), "Philippines",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'k'), "Pakistan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'l'), "Poland",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'm'), "St. Pierre and Miquelon",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'n'), "Pitcairn",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'r'), "Puerto Rico",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 't'), "Portugal",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'w'), "Palau",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('p', 'y'), "Paraguay",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('q', 'a'), "Qatar",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'e'), "Reunion",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'o'), "Romania",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'u'), "Russian Federation",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('r', 'w'), "Rwanda",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'a'), "Saudi Arabia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'b'), "Solomon Islands",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'c'), "Seychelles",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'd'), "Sudan",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'e'), "Sweden",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'g'), "Singapore",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'h'), "St. Helena",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'i'), "Slovenia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'j'), "Svalbard and Jan Mayen Islands",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'k'), "Slovak Republic",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'l'), "Sierra Leone",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'm'), "San Marino",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'n'), "Senegal",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'o'), "Somalia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'r'), "Suriname",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 't'), "Sao Tome and Principe",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'u'), "USSR (former)",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'v'), "El Salvador",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'y'), "Syria",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('s', 'z'), "Swaziland",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'c'), "Turks and Caicos Islands",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'd'), "Chad",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'f'), "French Southern Territories",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'g'), "Togo",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'h'), "Thailand",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'j'), "Tajikistan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'k'), "Tokelau",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'm'), "Turkmenistan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'n'), "Tunisia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'o'), "Tonga",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'p'), "East Timor",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'r'), "Turkey",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 't'), "Trinidad and Tobago",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'v'), "Tuvalu",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'w'), "Taiwan",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('t', 'z'), "Tanzania",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'a'), "Ukraine",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'g'), "Uganda",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'k'), "United Kingdom",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'm'), "US Minor Outlying Islands",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 's'), "United States",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'y'), "Uruguay",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('u', 'z'), "Uzbekistan",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'a'), "Vatican City State (Holy See)",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'c'), "Saint Vincent and the Grenadines",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'e'), "Venezuela",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'g'), "Virgin Islands (British)",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'i'), "Virgin Islands (U.S.)",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'n'), "Viet Nam",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('v', 'u'), "Vanuatu",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('w', 'f'), "Wallis and Futuna Islands",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('w', 's'), "Samoa",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('y', 'e'), "Yemen",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('y', 't'), "Mayotte",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('y', 'u'), "Yugoslavia",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'a'), "South Africa",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'm'), "Zambia",			NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'r'), "Zaire (former)",		NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR('z', 'w'), "Zimbabwe",		NULL, 0, 0L, 0L, 0.0 },

	/* well-known TLDs */
	{ CC_PAIR3('n', 'e', 't'), "Network",	 	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('i', 'n', 't'), "International",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('o', 'r', 'g'), "Non-Profit Organization",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('c', 'o', 'm'), "US Commercial",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('e', 'd', 'u'), "US Educational",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('g', 'o', 'v'), "US Government",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('m', 'i', 'l'), "US Military",  	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR4('a', 'r', 'p', 'a'), "Old style Arpanet",NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR4('n', 'a', 't', 'o'), "Nato field",	NULL, 0, 0L, 0L, 0.0 },

	/* new CORE TLDs */
	{ CC_PAIR3('w', 'e', 'b'), "WWW Provider",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('r', 'e', 'c'), "Recreation",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR3('n', 'o', 'm'), "Personal WWW",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR4('f', 'i', 'r', 'm'), "Company/Firm", NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR4('i', 'n', 'f', 'o'), "Information",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR4('s', 'h', 'o', 'p'), "Online Shop",	NULL, 0, 0L, 0L, 0.0 },
	{ CC_PAIR4('a', 'r', 't', 's'), "Arts",		NULL, 0, 0L, 0L, 0.0 }
};
