/*
**     Extract title from HTML document and set file name & WPS title to match.
**
** On a FAT drive, the file name probably won't change, and an
** ignorable SYS0206 error will be displayed by 'rename'
**
** On both FAT and HPFS drives, the .LONGNAME EA will be set to match
** the <title> tag (if present) ane will be display by WPS.
**
** Create a program object for this rountine, and just drag a .htm file
** to it to rename/retitle.
*/

rc = RxFuncAdd('SysSearchPath', 'RexxUtil', 'SysSearchPath')
rc = RxFuncAdd('SysFileTree', 'RexxUtil', 'SysFileTree')
rc = RxFuncAdd('SysPutEA', 'RexxUtil', 'SysPutEA')

parse arg fspec
if fspec = '' then fspec = "*.htm"

/* remove any quotes from fspec */
loc = pos('"', fspec)
do while loc <> 0
       fspec = delstr(fspec, loc, 1)
       loc = pos('"', fspec)
       end

/* get list of matching files */
rc = SysFileTree(fspec, file, 'FO')
if file.0 = 0 then
       do
       say 'no files matching' '|'fspec'|'
       exit
       end

orgdir = directory()

/* loop thru file list */
do j = 1 to file.0
       say 'processing' file.j
       dir = FILESPEC("drive", file.j)||FILESPEC("path", file.j)
       len = length(dir)
       if substr(dir, len, 1, ' ') = '\' then
               dir = left(dir, len-1)
       name = FILESPEC("name", file.j)
       newdir = directory(dir)

       /* look for <TITLE> tag */
       do while lines(name)
               line = linein(name)
               loc = pos("<TITLE>", line)
               if loc = 0 then
                       loc = pos("<title>", line)

               if loc <> 0     then
                       do

                       title = substr(line, loc + 7)
                       loc = pos("</TITLE>", title)
                       if loc = 0 then
                               loc = pos("</title>", title)

                       do while loc = 0
                               if 0 = lines(name) then
                                       do
                                       say 'mal-formed title in' file.j
                                       leave
                                       end
                               line = linein(name)
                               title = title||line
                               loc = pos("</TITLE>", title)
                               if loc = 0 then
                                       loc = pos("</title>", title)
                               end

                       rc = stream(name, 'C', 'CLOSE')

                       if loc <> 0 then
                               title = substr(title, 1, loc - 1)

                       if title = '' then do
                               say 'No title found in' file.j
                               leave
                               end

                       LongName = title||".htm"
                       /* map real file name to valid characters */
                       title = strip(title,, '.')
                       title = strip(title,, ' ')
                       title = translate(title, '!!!!!!_ ', ':"\/<>|.')
                       newname = title||".htm"

                       if name <> newname then
                               do

                               /* generate unique name */
                               do i = 1 to 100 while '' <> stream(newname, 'c', 'query exists')
                                       newname = title||"!"||i||".htm"
                                       end

                               /* change the real file name */
                               /*
                               RC = FileMoveFile(name, newname)
                               */

                               '@rename' '"'||name||'"' '"'||newname||'"'
                               if RC = 2 then
                                       /* we're probably on a FAT partition */
                                       newname = name

                               if (RC <> 0) & (RC <> 2) then
                                       say 'error' RC 're-naming' name 'to' newname
                               else do
                                       /* change the LONGNAME */
                                       say '.LONGNAME('||name||') ->' LongName
                                       size= Length(LongName)
                                       /* Set up the data for the call to SysPutEA */
                                       /* Note: the FDFF is the value for length-proceeded ASCII from the */
                                       if size > 255 then
                                               EA_Data = 'FDFF'x || reverse(d2c(Size))  || LongName
                                       else
                                               EA_Data = 'FDFF'x || d2c(Size) || d2c(0) || LongName

                                       /* Call the REXX function SysPutEA to write the icon data */
                                       result = SysPutEA(newname, ".LONGNAME", EA_Data)

                                       /* Inform the user of the result code */
                                       if result <> 0 then
                                               say 'Error' result 'setting .LONGNAME to' LongName
                                       end
                               end
                       LEAVE
                       end
               end
               rc = stream(name, 'C', 'CLOSE')
       end
orgdir = directory(orgdir)
exit
