/* Creates automatically HTML-mirror pages of hobbes archives.      */
/* ================================================================ */
/* Written by Michael Warmuth for OS/2 Forum Austria.               */
/* (E-mail: Michael.Warmuth@wu-wien.ac.at).                         */
/* For using and copiing see the file copyright.doc.                */
/* ================================================================ */
/* Version: 0.96 (06/04/95)                                         */

parse arg conf_file

/* Load REXX utility functions */
if RxFuncQuery('SysLoadFuncs') then do
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
end  /* Do */

/* Load REXX TCP-SOCKET functions */
if RxFuncQuery("SockLoadFuncs") then do
   call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
   call SockLoadFuncs
end  /* Do */


/* Read configuration file into stem */
do i=1 to 9999999 until \lines(conf_file)
   do until next_line\='' | \lines(conf_file)
      parse value linein(conf_file) with next_line '#' .
      next_line = strip(next_line)
   end /* do */
   conf_line.i = next_line
end /* do */
conf_line.0 = i

/* Process settings */
do i=1 to conf_line.0 while translate(conf_line.i)\='[SETTINGS]'
end /* do */
do j=i+1 to conf_line.0 while translate(conf_line.j)\='[URLS]'
   interpret conf_line.j
end /* do */
j = j+1

/* Do with all urls */
do i=j to conf_line.0
   /* Set url specific vars */
   g.ftp_url = word(conf_line.i,1)
   g.html_dir = word(conf_line.i,2)
   g.url_head = left(g.ftp_url,lastpos('/',g.ftp_url))
   g.list_file = substr(g.ftp_url,lastpos('/',g.ftp_url)+1)
   g.tmp_file = g.html_dir||g.list_file

   g.log_file = g.html_dir||g.ftp_log
   parse var g.url_head 'ftp://' ftp_host '/' ftp_dir
   ftp_dir = '/'left(ftp_dir,length(ftp_dir)-1)

   /* Try as often as specified if ftp fails */
   do g.retry_numbe until ftp_ok\=0

      /* look if log file exists */
      if stream(g.log_file,'c','query exists')='' then do
         g.old_date = 'Jan 00'
         g.old_time = '00:00'
         call stream g.log_file, 'c', 'open'
         call lineout g.log_file, '      Local             Index File     Ping                   Info or'
         call lineout g.log_file, '  Date       Time      Date    Time    msecs   ftp secs       Errors    '
         call lineout g.log_file, '========================================================================'
      end  /* Do */
      else do
         call stream g.log_file, 'c', 'open'      /* Open stream */
         log_size = stream(g.log_file,'c','query size') /* Get size */
         if log_siez>200 then do                /* Long stream: get last 200 chars */
            call stream g.log_file, 'c', 'seek <200'
            log_tail = charin(g.log_file,,198)
         end  /* Do */
         else do                                /* Short stream: get whole stream */
            log_tail = charin(g.log_file,1,log_size-2)
         end  /* Do */
   
         /* Get old index file date and time */
         parse value substr(log_tail,lastpos('0d0a'x,log_tail)+2) with,
               . '|' . '| ' g.old_date ' | ' g.old_time ' |' .
   
         /* Go to the end of the stream */
         call stream g.log_file, 'c', 'seek <0'
         
      end  /* Do */
      g.sys_date = date('u')
      g.sys_time = time()
      g.ping_time = left('',5)
      g.ftp_time = left('',9)
      g.ftp_info = left('UNDEFINED ERR',13)
   
      /* Do the whole ftp stuff */
      ftp_ok = do_ftp()
   
      /* Logoff */
      call FtpLogoff
   
      /* Ftp was ok, so ... */
      if ftp_ok=1 then do
         /* Build the html pages */
         call makeurl
   
         g.old_date = g.new_date
         g.old_time = g.new_time
         g.ftp_info = left('update done',13)
      end  /* Do */
   
      /* Write log file */
      call writelog
   end /* do */

end /* do */

exit


/* ---------------------------------------------------------------- */
/* Ping the remote host and do the rest                             */
do_ftp:

/* Ping host */
retc = FtpPing(ftp_host,'64')
if pos(left(retc,1),'-'xrange('A','Z'))\=0 | retc=-1 then do
   g.ftp_info = left(retc,13)
   return 0
end  /* Do */
/* Correct bug of FtpPing */
if right(retc,4)='0000' then do
   g.ping_time = right(left(retc,length(retc)-2),5)
end  /* Do */
else do
   g.ping_time = right(retc,5)
end  /* Do */

return do_setuser()


/* ---------------------------------------------------------------- */
/* Logon to the remote host and do the rest                         */
do_setuser:

/* Host login */
if \FtpSetUser(ftp_host,'anonymous',g.webma_email,) then do
   g.ftp_info = left('LOGIN ERROR',13)
   return 0
end  /* Do */

return do_chdir()


/* ---------------------------------------------------------------- */
/* Change remote directory and do the rest                          */
do_chdir:

/* Change directory */
retc = FtpChDir(ftp_dir)
if retc\=0 then do
   g.ftp_info = left(retc,13)
   return 0
end  /* Do */

return do_dir()


/* ---------------------------------------------------------------- */
/* Check remote index file and do the rest                          */
do_dir:

/* Get directory listing of index file */
/* '-r--r--r--   1 os2-adm  archive   256809 Apr 11 19:14 00indexd.txt' */
retc = FtpDir(g.list_file,'rem_files.')
if retc\=0 then do
   g.ftp_info = left(retc,13)
   return 0
end  /* Do */
if rem_files.0\=1 then do
   g.ftp_info = left('FILENO ERROR',13)
   return 0
end  /* Do */
g.new_date = subword(rem_files.1,6,2)
g.new_time = word(rem_files.1,8)

/* Check if an update is neccessary */
if g.old_date=g.new_date & g.old_time=g.new_time then do
   g.ftp_info = left('not needed',13)
   return 2
end  /* Do */

return do_get()


do_get:

/* Get remote file */
call time 'r'                             /* Reset timer */
retc = FtpGet(g.tmp_file,g.list_file,'Ascii')
g.ftp_time = time('e')                    /* Get elapsed time */
parse var g.ftp_time g.ftp_time '.' .
g.ftp_time = right(g.ftp_time,9)
if retc\=0 then do
   g.ftp_info = left(retc,13)
   return 0
end  /* Do */

return 1



/* ================================================================ */
/* Global procedures                                                */
/* ================================================================ */



/* ---------------------------------------------------------------- */
/* Write to the log file                                            */
writelog: procedure expose g.

call lineout g.log_file, g.sys_date '|' g.sys_time '|' g.old_date '|' g.old_time '|',
      g.ping_time '|' g.ftp_time '|' g.ftp_info
call stream g.log_file, 'c', 'close'

return 0


/* ---------------------------------------------------------------- */
/* Create the all html files for the current url                    */
makeurl: procedure expose g.

/* Delete entries of session queue */
do queued()
   pull .
end /* do */

/* Delete archive attribute of all existing files (except log and index file) */
call SysFileTree g.html_dir||'*', 'dummy.', 'F', , '-****'
call SysFileTree g.log_file, 'dummy.', 'F', , '+****'
call SysFileTree g.tmp_file, 'dummy.', 'F', , '+****'

/* Initial file name */
g.act_dir = ''
g.html_file = g.html_dir || g.ind_file       /* file for save */

/* Do with all lines of the file */
do while lines(g.tmp_file)
   /* Make one directory */
   do until right(file,1)=':' | \lines(g.tmp_file)
      do until line\='' | \lines(g.tmp_file)
         line = strip(linein(g.tmp_file))    /* Get next line */
      end /* do */
      /* Get filename */
      file = word(line,1)

      /* Not the start of a new directory */
      if right(file,1)\=':' then do
         /* Break line */
         size = word(line,2)
         if size='-' | size='=' then size = ''
         if words(line)<6 then da_ti = ''
         else da_ti = subword(line,3,3)
         if words(line)<7 then info = ''
         else info = subword(line,6)

         /* Build URL */
         if right(file,1)='/' then do        /* Directory */
            url = translate(g.act_dir,'_','/') || left(file,length(file)-1)||'.html'
         end  /* Do */
         else do                             /* File */
            url = g.url_head||g.act_dir||file
         end  /* Do */

         /* Queue all parts */
         queue url
         queue file
         queue size
         queue da_ti
         queue info
      end  /* Do */
      else do
         if left(file,2)='./' then file = substr(file,3) /* Correction for hobbes */
         call makefile g.html_file g.url_head||g.act_dir /* Make file for this directory */
         g.act_dir = left(file,length(file)-1)  /* remote dir */
         g.html_file = g.html_dir || translate(g.act_dir,'_','/') || '.html'  /* file for save */
         g.act_dir = g.act_dir'/'
      end  /* Do */
   end /* do */
end /* do */

if queued()\=0 then do
   call makefile g.html_file g.url_head||g.act_dir /* Make file for this directory */
end  /* Do */

/* Delete all files without archive attribute - they are obsolete */
call SysFileTree g.html_dir||'*', 'files.', 'FO', '-****'
do i=1 to files.0
   call SysFileDelete files.i
end /* do */

return 0



/* ---------------------------------------------------------------- */
/* Create one directory file                                        */
makefile: procedure expose g.

parse arg file sel .


/* Delete old directory index */
call SysFileDelete file

/* Create header of directory index */
call lineout file, '<HEAD><TITLE>Index of 'sel'</TITLE></HEAD>'
call lineout file, '<BODY>'
call lineout file, '<CENTER><H5>Index of 'sel'</H5></CENTER>'
call lineout file, '<PRE>'
call lineout file, '<IMG SRC="'g.icons_direc||'blk.gif" ALT="     " ALIGN=MIDDLE',
      'WIDTH='g.direc_width' HEIGHT='g.direc_heigh'>',
      center('Name',g.direc_name) center('Date',g.direc_date),
      center('Size',g.direc_size) left('Info',g.direc_info)
call lineout file, '<HR>'

select
   when filespec('name',file)=g.ind_file then url = g.home_url
   when pos('_',filespec('name',file))=0 then url = './'
   otherwise url = left(filespec('name',file),lastpos('_',filespec('name',file))-1)'.html'
end  /* select */
act_file = '..'
size = ''
file_fill = copies(' ',g.direc_name-length(strip(left(act_file,g.direc_name))))
call lineout file, '<IMG SRC="'g.icons_direc||icontype('.!!!')||,
      '" ALT="'alttype('.!!!')'" ALIGN=MIDDLE WIDTH='g.direc_width,
      'HEIGHT='g.direc_heigh'> <A HREF="'url'">'||,
      strip(right(act_file,g.direc_name))'</A>'file_fill

/* Create entries for files */
do while queued()>=5
   /* Get values from queue */
   parse pull url
   parse pull act_file
   parse pull size
   parse pull da_ti
   parse pull info

   /* Only files without leading dot (.) */
      if right(act_file,1)='/' then do       /* This is a directory */
         icon = icontype('.!!!')             /* Get icon to use */
         type = alttype('.!!!')              /* Get ALT to use */
      end  /* Do */
      else do
         icon = icontype(act_file)           /* Get icon to use */
         type = alttype(act_file)            /* Get ALT to use */
      end  /* Do */
      file_fill = copies(' ',g.direc_name-length(strip(right(act_file,g.direc_name))))
      call lineout file, '<IMG SRC="'g.icons_direc||icon'" ALT="'type,
            '"ALIGN=MIDDLE WIDTH='g.direc_width' HEIGHT='g.direc_heigh'>',
            '<A NAME="'act_file'" HREF="'url'">'||,
            strip(right(act_file,g.direc_name))'</A>'file_fill,
            left(da_ti,g.direc_date),
            right(size,g.direc_size) left(info,g.direc_info)
end /* do */

/* Create tail */
call lineout file, '</PRE>'
call lineout file, '</BODY>'
call stream file, 'c', 'close'

return 0



/* ----------------------------------------------------------------------- */
/* ICONTYPE: Return the name of the icon for directory indexing.           */
/* ----------------------------------------------------------------------- */
icontype: procedure expose g.

/* First get the extension; this assumes filenames have at least one '.' */
???=translate(substr(arg(1), lastpos('.',arg(1))+1))
if symbol('g.direc_.???')='LIT' then ???=''

return word(g.direc_.???,1)


/* ----------------------------------------------------------------------- */
/* ALTTYPE: Return the alternate for icon for directory indexing.          */
/* ----------------------------------------------------------------------- */
alttype: procedure expose g.

/* First get the extension; this assumes filenames have at least one '.' */
???=translate(substr(arg(1), lastpos('.',arg(1))+1))
if symbol('g.direc_.???')='LIT' then ???=''

return word(g.direc_.???,2)

