/* REXX script for extended GoServe filter.                         */
/* This script moves GoServe audit file to the archive and creates  */
/* a server statistic in HTML format.                               */
/* (Uses goremote.cmd, rxSock.dll)                                  */
/* ================================================================ */
/* Syntax: gostat <configuration file>                              */
/* Where:  configuration file...full filename of configuration      */
/*                              file for gostat.cmd                 */
/* ================================================================ */
/* Written by Michael Warmuth for OS/2 Forum Austria.               */
/* (E-mail: Michael.Warmuth@wu-wien.ac.at).                         */
/* For using and copiing see the file copyright.doc.                */

/* Load REXX utility functions */
if RxFuncQuery('SysLoadFuncs') then do
   CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
   CALL SysLoadFuncs
end  /* Do */

/* Load REXX TCP-SOCKET functions */
if RxFuncQuery("SockLoadFuncs") then do
   call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
   call SockLoadFuncs
end  /* Do */

/* Get arguments */
parse arg conffile .
do while lines(conffile)\=0
   parse value linein(conffile) with line '#' .
   parse var line key '=' value
   if key\='' then do
      k = key "= '"strip(value)"'"
      interpret k
   end  /* Do */
end /* do */

/* Set global variables */
env = "OS2ENVIRONMENT"                       /* For environment access */
parse source . . def_path                    /* Path of this procedure */
def_path = substr(def_path,1,lastpos('\',def_path))
transfile = def_path'transtbl.txt'           /* Table for char translation */
temppath = value('TEMP',,env)                /* Get path for temp files */
tempfile = SysTempFileName(temppath'\WWW?????.TMP')   /* Get unique filename */
etc = value('ETC',,env)                      /* Get path for tcpip's etc directory */

crlf='0d0a'x                                 /* often useful */

/* Change to directory where this code resides */
call directory left(def_path,length(def_path)-1)

/* Move GoServe archive */
if goremote(server command username password)\=0 then exit

/* Check if audfile exists */
if stream(audfile,'c','query exists')='' then exit 1

m = 0                                        /* Counter for months */
d = 0                                        /* Counter for days */
i = 0
n = 0
month = '00/0000'
old_date = ''
do until lines(audfile)=0
   parse value linein(audfile) with ltime ltyp lnum linfo

   select
      /* New date */
      when ltyp='D' then do
         linfo = word(linfo,1)               /* Get date */
         if linfo\=old_date then do
            old_date = linfo
            if d_count.d\=0 then do
               d = d+1                       /* Increment day */
               d_count.d = 0                 /* Connections counter */
            end  /* Do */
            /* Check for new month */
            if month\=substr(linfo,5,2)'/'left(linfo,4) then do
               if m_count.m\=0 then do
                  m = m+1                    /* Increment month */
                  m_count.m  = 0             /* Connections counter */
               end  /* Do */
               month = substr(linfo,5,2)'/'left(linfo,4)
               m_month.m = month
            end  /* Do */
            d_date.d = right(linfo,2) || '.' || translate(m_month.m,'.','/')
         end  /* Do */
      end  /* Do */

      /* Next address */
      when ltyp='A' then do
         i = i+1

         a_time.i = ltime                    /* Build stem item */
         a_typ.i  = ltyp
         a_num.i  = lnum
         parse var linfo linfo .
         a_info.i = linfo
         a_date.i = d_date.d

         d_count.d = d_count.d+1             /* Increment counters */
         m_count.m = m_count.m+1

         if symbol('i_count.'linfo)='LIT' then do
            n = n+1
            i_count.linfo = 1
            i_ips.n = linfo
         end  /* Do */
         else do
            i_count.linfo = i_count.linfo+1
         end  /* Do */

      end  /* Do */
   otherwise
      nop
   end  /* select */
end /* do */

a_time.0 = i                                 /* Get numbers */
a_typ.0  = i
a_num.0  = i
a_info.0 = i
a_date.0 = i
d_count.0 = d
d_date.0  = d
m_count.0 = m
m_month.0 = m
i_ips.0 = n

'@copy' stathead htmlfile '> nul'

call lineout htmlfile, '<CENTER><H5>Erstellt/Created:' translate(date('e'),'.','/')
call lineout htmlfile, '('date('u')') um/at' time('N') '</H5></CENTER><HR>'
call lineout htmlfile, 'Bitte beachten: Hier wird jeder Zugriff gez&auml;hlt. (Beispiel:'
call lineout htmlfile, 'Eine Seite mit f&uuml;nf Graphiken sind somit sechs Zugriffe)<P>'
call lineout htmlfile, 'Keep in mind: Every access counts. (Example: A page with five'
call lineout htmlfile, 'images counts for 6 accesses)'

call lineout htmlfile, '<HR>'
call lineout htmlfile, '<H4>Per Monat/Month:</H4><BR><PRE>'
call lineout htmlfile, ' Monat      Anzahl der Zugriffe'
call lineout htmlfile, ' Month      Number of accesses'
call lineout htmlfile, '-------------------------------'
summ = 0
do i=1 to m_count.0
   call lineout htmlfile, m_month.i right(m_count.i,15)
   summ = summ+m_count.i
end /* do */
call lineout htmlfile, '-------------------------------'
call lineout htmlfile, right(summ,23)
call lineout htmlfile, '</PRE>'

call lineout htmlfile, '<HR>'
call lineout htmlfile, '<H4>Per Tag/Day:</H4><BR><PRE>'
call lineout htmlfile, '   Date           Number of accesses'
call lineout htmlfile, '   Datum          Anzahl der Zugriffe'
call lineout htmlfile, '-------------------------------------'
summ = 0
do i=1 to d_count.0
   call lineout htmlfile, d_date.i right(d_count.i,20)
   summ = summ+d_count.i
end /* do */
call lineout htmlfile, '-------------------------------------'
call lineout htmlfile, right(summ,31)
call lineout htmlfile, '</PRE>'

/* Make short statistics file */
if htmlshort\='' then
   '@type' htmlfile '>' htmlshort

/* Get host names and build string for order */
i_nams.0 = i_ips.0
i_srtnams.0 = i_ips.0
i_ctries.0 = i_ips.0
do i=1 to i_ips.0
   ipno = i_ips.i
   if \SockGetHostByAddr(ipno,'addrstr.') then do
      i_nams.i = ipno
      i_ctries.i = ''
      parse var ipno a '.' b '.' c '.' d .
      i_srtnams.i = right(a,3,'0')'.'right(b,3,'0')'.'||,
         right(c,3,'0')'.'right(d,3,'0')
   end  /* Do */
   else do
      i_nams.i = addrstr.name
      i_ctries.i = translate(substr(addrstr.name,lastpos('.',addrstr.name)+1))
      tmp_addr = addrstr.name
      i_srtnams.i = ''
      do while pos('.',tmp_addr)\=0
         parse var tmp_addr next_word '.' tmp_addr
         i_srtnams.i = '.'next_word||i_srtnams.i
      end /* do */
      i_srtnams.i = translate(tmp_addr||i_srtnams.i)
   end  /* Do */
end /* do */

/* Order host names */
sort.0 = i_srtnams.0
do i=1 to sort.0
   sort.i = i
end /* do */
/* One of Knuth's sort algorithms */
/* define M for passes */
M = 1
DO WHILE (9 * M + 4) < i_srtnams.0
   M = M * 3 + 1
END
/* sort stem */
DO WHILE M > 0
   K = i_srtnams.0 - M
   DO J = 1 TO K
      Q = J
      DO WHILE Q > 0
         L = Q + M
         IF i_srtnams.Q <= i_srtnams.L THEN LEAVE

         /* switch elements */
         tmp               = i_srtnams.Q
         i_srtnams.Q       = i_srtnams.L
         i_srtnams.L       = tmp
         tmp               = sort.Q
         sort.Q            = sort.L
         sort.L            = tmp
         Q = Q - M
      END
   END
   M = M % 3
END

/* Write out statistics */
call lineout htmlfile, '<HR>'
call lineout htmlfile, '<H4>Per Rechner/Client:</H4><PRE>'
call lineout htmlfile, 'Land/'
call lineout htmlfile, 'Typ      Name/IP-Adresse             Anzahl der Zugriffe'
call lineout htmlfile, 'Country/'
call lineout htmlfile, 'Type     Name/IP-Address             Number of accesses'
call lineout htmlfile, '--------------------------------------------------------'
sum = 0
sum_ctry = 0
ind = sort.1
cntr = ''
do i=1 to sort.0
   ind = sort.i
   ip = i_ips.ind
   if i_ctries.ind=cntr then do
      sum_ctry = sum_ctry + i_count.ip
   end  /* Do */
   else do
      if i\=1 then do
         call lineout htmlfile, left('',50,'-')
         call lineout htmlfile, left(cntr,39) right(sum_ctry,10)
         call lineout htmlfile, left('',39) left('',10,'-')
         call lineout htmlfile, ''
      end  /* Do */
      cntr = i_ctries.ind
      sum_ctry = i_count.ip
      if ctry\='' then do
         call lineout htmlfile, left(cntr,3)':'
         call lineout htmlfile, '----'
      end  /* Do */
   end  /* Do */
   call lineout htmlfile, '         'left(i_nams.ind,30) right(i_count.ip,10)
   sum = sum + i_count.ip
end /* do */
call lineout htmlfile, left('',50,'-')
call lineout htmlfile, left(cntr,39) right(sum_ctry,10)
call lineout htmlfile, '--------------------------------------------------------'
call lineout htmlfile, right(sum,50)
call lineout htmlfile, '</PRE>'

do while lines(statfoot)\=0
   call lineout htmlfile, linein(statfoot)
end /* do */

if htmlshort\='' then do
   do while lines(shortfoot)\=0
      call lineout htmlshort, linein(shortfoot)
   end /* do */
end  /* Do */

return
