/* GOREMOTE.CMD -- remote control of a GoServe server                  */
/* ------------------------------------------------------------------- */
/* This sample command program sends a HTTP (Web) request to a server, */
/* with the default being the '!save' request that the sample filter   */
/* uses to trigger a Move Audit command.  Easily modified for other    */
/* remote control actions, or to be a general 'home page retriever'.   */
/* ------------------------------------------------------------------- */
/* Call as:  GOREMOTE serveraddress requeststring [username password]  */
/* ------------------------------------------------------------------- */
/* This program requires that the RxSock.DLL be in your LIBPATH (it is */
/* usually in your \TCPIP\DLL directory.  It was shipped with the      */
/* August 1994 CSD for the TCP/IP base (UN64092).                      */
/* This program uses b64en.cmd for username/password encoding.         */
/* ------------------------------------------------------------------- */
/* Modified by Michael Warmuth for OS/2 Forum Austria                  */

call load /* load functions if necessary */

parse arg server request user pwd .
if server=''  then exit 1
if request='' then exit 2
if user='' then auth = ''
else auth = b64en(user':'pwd)

crlf    ='0d0a'x                        /* constants */
family  ='AF_INET'
httpport=80

rc=sockgethostbyname(server, "serv.0")  /* get dotaddress of server */
if rc=0 then do; say 'Unable to resolve "'server'"'; exit; end
dotserver=serv.0addr                    /* .. */

gosaddr.0family=family                  /* set up address */
gosaddr.0port  =httpport
gosaddr.0addr  =dotserver

gosock = SockSocket(family, "SOCK_STREAM", "IPPROTO_TCP")

/* Set up request [HTTP 0.9 style, for all servers] */
message= "GET /"request' HTTP/1.0'crlf ||,
        'Authorization: Basic' auth || crlf ||,
        crlf

rc = SockConnect(gosock,"gosaddr.0")
if rc<0 then do; say 'Unable to connect to "'server'"'; exit 3; end
rc = SockSend(gosock, message)

/* Now wait for the response */
/* got='' */
do r=1 by 1
  rc = SockRecv(gosock, "response", 1000)
  /* got=got||response */
  /* say '>'rc'>' response */
  if r=1 & pos(' 200 ',response)=0 then exit 4
  if rc<=0 then leave
  end r
rc = SockClose(gosock)

/* say 'Got' length(got) 'bytes of response:'
say got */
exit 0

/* --- Load the function library, if necessary --- */
load:
if \RxFuncQuery("SockLoadFuncs") then return      /* already there */
call RxFuncAdd "SockLoadFuncs","rxSock","SockLoadFuncs"
call SockLoadFuncs
return
