/* BASE 64 encoding   */
/* By Michael Warmuth */

/* Get arguments <input_string> */
parse arg g.in_str

/* Set global vars */
g.b64_table = xrange('A','Z')xrange('a','z')xrange('0','9')'+/='
g.col = 0
g.chr = 0
g.len = length(g.in_str)
g.out_str = ''

/* Do with all chars of input file */
do until char=-1
   sum = 0                                   /* Sum of next three chars */
   no = 4                                    /* Number of chars to write */
   do i=1 to 3
      char = next_chr()                      /* Get next char */
      if char=-1 then do                     /* End of file: leave */
         no = ((i - 1) * 8) % 6              /* Correct number of chars to write */
         if (((i - 1) * 8) // 6)\=0 then no = no + 1
         do 4-i
            sum = sum * 256
         end /* do */
         leave                               /* leave loop */
      end  /* Do */
      else sum = sum * 256 + c2d(char)       /* Calculate sum of chars */
   end /* do */
 
   do i=1 to 4                               /* Produce chars to write out */
      out.i = sum // 64
      sum = sum % 64
   end /* do */
   if no\=0 then do
      do i=1 to (4-no)
         out.i = 64                          /* Fill with '=' at end of file */
      end /* do */
      do i=4 to 1 by -1
         call writeb64 out.i
      end /* do */
   end  /* Do */
end /* do */

exit g.out_str



/* Get next char */
next_chr: procedure expose g.

g.chr = g.chr + 1
if g.chr>g.len then retc = -1
else retc = substr(g.in_str,g.chr,1)

return retc



/* Write out one char */
writeb64: procedure expose g.

parse arg chrno

/* Write char */
g.out_str = g.out_str || substr(g.b64_table,chrno+1,1)

g.col = g.col + 1                            /* Increment column counter */
if g.col=76 then do                          /* Width reached: new line */
   g.out_str = g.out_str || '0d0a'x
   g.col = 0
end  /* Do */

return
