/* OS/2 Rexx Script for MR/2 ICE     */
/* by William H. Geiger III 07 Apr 96 */
/* Geiger Consulting                    */
/* whgiii@amaranth.com                */
/* this script will convert the Date: stamp in the header of messages */
parse arg msg_filename                          /* get filename */
st=stream(msg_filename,'c','open')            /* open file */
cnt=0                                             /* initialize vars. */
/* local time zone stamp 
enter your local time zone stamp here must be in the format of +1200 to -1200 or GMT */
tz1='-0600'
/* end local time zone stamp */
xx4=0
xx6='Old TimeStamp:'
yy1='Date:'
yy2='X-Mailer:'
yy3='From:'
yy4='MR/2'
lin=''
gb=0
day_of_week="Sun Mon Tue Wed Thu Fri Sat"
month_of_year="Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec"
days_31="Jan Mar May Jul Aug Oct Dec"
days_30="Apr Jun Sep Nov"
nxy=1
do forever while (length(linein(msg_filename))>0)                        /* pull info from file header */
nxx=stream(msg_filename,'c','seek +0')                                   /* get read pointer */
nxx_rs=stream(msg_filename,'c','seek =' nxy)                            /* reset read pointer */
xx1=0
xx2=0
xx3=0
xx7=0
cnt=cnt+1
lin=linein(msg_filename)
nxy=stream(msg_filename,'c','seek +0')
xx1=pos(yy1,lin,1)
xx2=pos(yy2,lin,1)
xx3=pos(yy3,lin,1)
xx7=pos(xx6,lin,1)
If xx1>0 then do
          dt=lin
          dt_no=cnt
          end
If xx2>0 then mail=lin
If xx3>0 then from=lin
If xx7>0 then do
   goodby='already done!!!'
   gb=1
   st1=stream(msg_filename,'c','close')
   call goodby
end  /* Do */
end
st1=stream(msg_filename,'c','close')
parse value dt with xx5 dowt date mont yr tm tz tzt
if words(dt)<7 then do
   goodby='words'
   gb=0
   call goodby
end  /* Do */
if pos(',',dowt)=0 then do
   goodby='no day of week'
   gb=0
   call goodby
end  /* Do */
dowt=substr(dowt,(length(dowt)-3),3)                           /* remove coma from day of week */
dow=wordpos(dowt,day_of_week)                /* convert day of week to # */
mon=wordpos(mont,month_of_year)              /* convert month to # */
if trunc(yr/4)=(yr/4) then leap=1                /* calc last day of month from source */
else leap=0
if wordpos(mont,days_31)>0 then ld=31
else if wordpos(mont,days_30)>0 then ld=30
     else ld=28+leap
if mon=1 then mon_prv=12
else mon_prv=mon-1
mont_1=word(month_of_year,(mon_prv))          /* calc last day of previous month from source */
if wordpos(mont_1,days_31)>0 then ld_1=31
else if wordpos(mont_1,days_30)>0 then ld_1=30
     else ld_1=28+leap
if datatype(tz,'N')=1 then do       /* check timzone stamp */
    if tz=0 then tz=0
      else tz=strip(tz,t,0)
      end  /* Do */
    else if translate(tz)=='GMT' then tz=0
         else if translate(tz)=='UTC' then tz=0
         else if translate(tz)=='UT' then tz=0
         else if translate(tz)=='EST' then tz=-05
         else if translate(tz)=='EDT' then tz=-05
         else if translate(tz)=='CST' then tz=-06
         else if translate(tz)=='CDT' then tz=-06
         else if translate(tz)=='MST' then tz=-07
         else if translate(tz)=='MDT' then tz=-07
         else if translate(tz)=='PST' then tz=-08
         else if translate(tz)=='PDT' then tz=-08
         else do
            goodby="bad TZ =" tz
            gb=0
            call goodby
         end  /* Do */
if datatype(tz1,'N')=1 then do
   if tz1=0 then tz1=0
      else tz1=strip(tz1,t,0)
   end
   else if tz1=='GMT' then tz1=0
         else if translate(tz)=='UTC' then tz=0
         else if translate(tz)=='UT' then tz=0
         else if translate(tz)=='EST' then tz=-05
         else if translate(tz)=='EDT' then tz=-05
         else if translate(tz)=='CST' then tz=-06
         else if translate(tz)=='CDT' then tz=-06
         else if translate(tz)=='MST' then tz=-07
         else if translate(tz)=='MDT' then tz=-07
         else if translate(tz)=='PST' then tz=-08
         else if translate(tz)=='PDT' then tz=-08
         else do
            goodby= 'bad TZ1=' tz1
            gb=0
            call goodby
         end  /* Do */
parse value tm with hr ':' mn ':' sc                               /* parse time into hrs, mins, secs */
hr1=hr-tz+tz1                                   /* calc new time */
if hr1<0 then call new_day
   else if hr1>23 then call old_day
   else do
      dow1=dow
      date1=date
      mon1=mon
      yr1=yr
   end
mn1=mn
sc1=sc
if length(hr1)=1 then hr1=insert('0',hr1)
tm1=''                                                  /* combine vars to create tm1 (new time) */
tm1=insert(sc1,tm1)
tm1=insert(':',tm1)
tm1=insert(mn1,tm1)
tm1=insert(':',tm1)
tm1=insert(hr1,tm1)
mont1=word(month_of_year,mon1)                     /* convert month # to text */
dowt1_tmp=word(day_of_week,dow1)                  /* convert day of week # to text */
dowt1=','
dowt1=insert(dowt1_tmp,dowt1)
tz1_tmp='00'
tz1=insert(tz1,tz1_tmp)
tz=insert(tz,tz1_tmp)
If length(date1)=1 then date1=insert('0',date1)
If length(yr1)=1 then yr1=insert('0',yr1)
dt1=''
dt1=xx5 dowt1 date1 mont1 yr1 tm1 tz1
dt2=xx6 dowt',' date mont yr tm tz
dttm=date('N') Time() msg_filename
'@echo off'
copy msg_filename 'temp.msg' '>>null'
'@echo off'
erase msg_filename '>>null'
st3=stream('temp.msg','c','open')               /* re-write msg file with new timestamp */
st4=stream(msg_filename,'c','open')
wrt1=0
do forever while lines('temp.msg')>0
   wrt1=wrt1+1
   lnin = linein('temp.msg')
      If wrt1=dt_no then do
              call lineout msg_filename,dt1
              call lineout msg_filename,dt2 
              wrt1=wrt1+1
         end
   else call lineout msg_filename,lnin
end /* do */
st3=stream('temp.msg','c','close')
st4=stream(msg_filename,'c','close')
erase 'temp.msg >> null'
goodby= 'all done'
gb=1
call goodby

old_day:                                        /* subtract a day routine */
hr1=hr1-24
dow1=dow-1                                   /* calc day of week */
if dow1=0 then dow1=7
If date>1 then do
      date1=date-1
      mon1=mon
      yr1=yr
   end
   else call old_month
return

new_day:                                       /* add a day routine */
hr1=hr1+24
dow1=dow+1
if dow1=8 then dow1=1
if date<ld then do
   date1=date+1
   mon1=mon
   yr1=yr
end  /* Do */
else call new_month
return

old_month:                                    /* subtract a month routine */
date1=ld_1
if mon=1 then do                              /* If source month is Jan the change month */
   mon1=12                                    /* to Dec and subtract 1 year */
   yr1=yr-1
end  
else do
   mon1=mon-1                          /* Otherwise subtract 1 month */
   yr1=yr
end  
return

new_month:                                   /* add a month routine */
date1=1
if mon=12 then do
   mon1=1
   yr1=yr+1
end  /* Do */
else do
   mon1=mon+1
   yr1=yr
end  /* Do */
return

goodby:                                       /* exit routine */
stm_gb=stream(msg_filename,'c','close')
if gb=0 then do
   gb_nm_err= date('N') time() goodby msg_filename
   call lineout 'error.log', gb_nm_err
end  /* Do */
exit
