/* Off-line Time/Date Stamp Modifyer for MR/2 ICE */
/* ********************************* */
/*   By: Jetnick Enterprise          */
/*       Don E. Groves, Jr.          */
/*   Contact Information:            */
/*     E-mail: jetnick@erols.com     */
/*        CIS: 71310,3702             */
/* Date: 27 Aug 1996                  */
/* ********************************** */

 /* Requires */
parse source . invhow myName
wrk = myname~substr(1,myname~lastpos('\'))
tz1File = wrk~''('tz1File.cmd')
call (tz1File)

RtCode = 0
if invhow == 'COMMAND'
THEN DO
   RtCode = 1
   elsp_counter = .Elasp_Time~NEW
   say time()
   Argv = .ARRAY_CLI~of(ARG(1), .false, .false) /* parse the arguments */
   if Argv~items > 0
   THEN DO
      user_name = Argv[1]     /* get path to folder */
      inbox2_file = .ndx_File~New(user_name~''("\")~''("folder.ndx"))
      if \ inbox2_file~Exist
      THEN inbox2_file = .ndx_File~New(user_name~''("\")~''("mr2i.ndx"))
      if inbox2_file~Exist
      THEN DO
         say 'Working on:'~' '(inbox2_file~Qualify)
         if Argv~items > 1
         THEN fix = Argv[2]
         else fix = ''
         if fix=='fix'
         then worker = .FixTimeZone~new
         else worker = .DoTimeZone~new
         inbox2_file~Doer(worker)   /* do the folder */
         RtCode = 0
      END
      ELSE DO
         SAY 'ERROR:'~' '(user_name)~' '('required  *.NDX file not found.')
      END
   END
   else DO
      /* future message concerning Commandline arguments goes here */
   END
   say elsp_counter
END
return RtCode

/* ************* */
/* I could use the following, but then the support file would have to */
/* be in the current directory or along the PATH. */
/* ::requires Tz1File   */
/* ************* */

::class ndx_File_Base
::method init
  expose fh inbuf curRec updated
  use arg FileName
  fh = .stream~new(FileName)
  inbuf = .Array~new
  updated = .false
  curRec = -1
  outbuf = .Array~NEW
return self
::method Load
  expose fh inbuf curRec updated
  IF curRec = -1
  THEN DO
     curRec = 0
     if self~Exist
     THEN Do
        fh~OPEN('READ')
        inbuf= fh~makearray('LINE')
        fh~close
     END
  END
return (inbuf~items < curRec)
::method available
  expose fh inbuf curRec updated
return (inbuf~items < curRec)
::method Read
  expose fh inbuf curRec updated
  curRec = curRec + 1
return inbuf[curRec - 1]
::method write
  expose fh inbuf curRec updated
  use arg what
  updated = .true
  inbuf[curRec] = what
return what
::method close
  expose fh inbuf curRec updated
  IF updated
  THEN do
     /* make a backup copy of the orginal */
     fn = self~Qualify
     address cmd '@copy "'~''(fn)~''('" "')~''(fn)~''('-baz" >nul')
     /* write out the new file data */
     self~save_ea
     fh~OPEN('WRITE REPLACE')
     su = inbuf~supplier
     do while su~available
        fh~LINEOUT(su~item)
        su~next
     end
     tmp = fh~close
     self~Join_ea
  END
return tmp
::method exist
  expose fh inbuf curRec updated
return (fh~query('exist')~length \= 0)
::method Qualify
  expose fh inbuf curRec updated
return fh~qualify
::method Home
  expose fh inbuf curRec updated
  fn = self~Qualify
return fn~substr(1,fn~lastpos('\'))
::method save_ea private
  expose fh inbuf curRec updated
  FileName = fh~query('exist')
  fh~close
  if FileName~length \= 0
  THEN address cmd '@eautil.exe "'~''(fileName)~''('" "')~''(FileName)~''('-ea" /S')
::method join_ea private
  expose fh inbuf curRec updated
  FileName = fh~query('exist')
  fh~close
  if FileName~length \= 0
  THEN if .Stream~new(FileName~''('-ea'))~Query('exist')~length \= 0
  THEN address cmd '@eautil.exe "'~''(FileName)~''('" "')~''(FileName)~''('-ea" /J')
::method Size
  expose fh inbuf curRec updated
return fh~QUERY('SIZE')

::class ndx_File subclass ndx_File public
::method Doer
  use arg worker
  .output~CharOut(' :')
  IF Self~Load
  THEN DO
     home = Self~Home
     do while self~available
        wrk = 'S'
        ln1 = Self~READ
        /* break out the parts of the record we're interested in, only. */
        name = Ln1~substr(28,8)
        ext  = Ln1~substr(37,3)
        IF ext == 'RCV'
        THEN DO
           /* w4  = Ln1~substr(54,8)  */ /* date yy/mm/dd */
           /* white space */
           /* w5  = Ln1~substr(63,5)  */ /* time hh:mm */
           hDate = worker~work(Home~''(name)~''('.')~''(ext))
           wrk = 'E'
           if hDate \= .nil
           THEN DO
              wrk = '.'
              /* format the DateTime object information into the proper format */
              sda = hDate~DATE('O')~' '(hDate~TIME('N')~SUBSTR(1,5))
              /* check if there not the same */
              IF \ (Ln1~substr(54,14) == sda)
              THEN DO
                 ln1 = Ln1~substr(1,53)~''(sda)~''(Ln1~substr(68))
                 Self~Write(ln1)
                 wrk = '*'
              END
           END
        END
        .output~CharOut(wrk)
     end
     Self~Close
  END
  .output~LineOut('')
return

