/* ********************************** */
/* OS/2 Rexx Script for MR/2 ICE      */
/* ********************************** */
/*   By: Jetnick Enterprise           */
/*       Don E. Groves, Jr.           */
/*   Contact Information:             */
/*     E-mail: jetnick@erols.com      */
/*        CIS: 71310,3702             */
/* Date: 22 Sep 1996                  */
/* ********************************** */
/* Based very losely on the script    */
/* TZ1.CMD and/or TZ1FIX.CMD          */
/* by William H. Geiger III 07 Apr 96 */
/* Geiger Consulting                  */
/* whgiii@amaranth.com                */
/* this script will convert the Date: stamp in the header of messages */
/* ********************************** */

parse source . invhow .
if invhow == 'COMMAND'
THEN DO
   /* elsp_counter = .Elasp_Time~NEW */
   Argv = .ARRAY_CLI~of(ARG(1), .false, .false) /* parse the arguments */
   if Argv~items > 0
   THEN DO
      file_name = Argv[1]     /* get filename */
      if Argv~items > 1
      THEN fix = Argv[2]
      else fix = ''
      if fix=='fix'
      then worker = .FixTimeZone~new
      else worker = .DoTimeZone~new
      hDate = worker~work(file_name)
      /* say 'hDate=' hDate */
      /* IF hDate \= .nil */
      /* THEN say 'record str=['~''(hDate~DATE('O')~' '(hDate~TIME('N')~SUBSTR(1,5)))~''(']') */
   end
   else DO
      /* future message concerning Commandline arguments goes here */
   END
   /* say elsp_counter */
end
return 0

::requires Array_Cli
::requires MyTimeZone
::requires TextStream

::class AdjustTimeStamp
::method init
return self
  /* field names we are interested in the header of RCV file */
::method OldTimeField private
return 'Old-TimeStamp:'
::method DateField private
return 'Date:'
::method work
  use arg filename
  IF FileName~RIGHT(4)~TRANSLATE \== '.OUT'
  THEN DO
     msg_file = .RcvTextStream~new(filename)
     IF msg_file~exist
     THEN do
        fileSize = msg_file~SIZE         /* this is line 59. */
        IF fileSize \= .nil              /* Whatever limit in bytes your */
        THEN IF fileSize <= 65536        /* break off point is. */
        THEN forward message 'work_org' ARRAY (msg_file)
     END
  END
  /* skip .OUT files there correct already */
return .nil                        /* returns a DateTime object or .nil */
::method work_org private   /* This isn't required but complete */
  use arg msg_file          /* the documentation of the class. */
  NOP  /* this is required to be OverRidden */
  /* returns a DateTime object or .nil */

::CLASS DoTimeZone subclass AdjustTimeStamp public
::method work_org private
  use arg msg_file
  /* Convert date field of *.RCV file to Local Time */
  /* returns DateTime object equal to new adjusted DateTime on success. */

  /* say 'DoTimeZone for=' msg_file~Qualify */

  /* Load the file into a list. */
  msg_File~OPEN('READ')
  msg_list = msg_file~MakeList
  msg_File~Close

  NewDate    = .nil  /* new data for 'Date:' field */
  dt_no      = .nil  /* location of 'Date:' information */ 
  hDate      = .nil  /* DateTime object to return to user */
  oTimeStamp = .nil  /* non .nil if 'Old-TimeStamp:' was found */
  OldDate    = .nil  /* save Date to place in 'Old-TimeStamp:' field */
  su         = msg_list~supplier
  do while su~available      /* find field(s) from file header */
     select
       when su~item~strip~length = 0
       then LEAVE  /* Leave the loop when the end of header area is reached */
       when su~item~pos(self~DateField,1) = 1
       THEN DO
          IF hdate = .nil
          THEN if su~item~words > 5
          THEN DO
             dt    = su~item~SUBSTR(self~DateField~length + 1)~strip('L')
             hDate = ParseDateStr( dt )
             if hdate \= .nil
             THEN DO
                dt_no   = su~index
                OldDate = self~OldTimeField~' '(dt)
                hDate   = hDate~MakeLocalTimeStamp /* convert to local ref. */
                NewDate = self~DateField~' '(hDate)
             END
          END
       END
       when su~item~pos(self~OldTimeField,1) = 1
       THEN DO
          oTimeStamp = su~index
          IF hDate \= .nil
          THEN leave /* leave search loop early if all information is found */
       END
       OTHERWISE nop  /* other header fields I don't care about */
     END
     su~next
  end
  drop su
  /* Was the required Date field found and Old-TimeStamp not found */
  if dt_no \= .nil & oTimeStamp = .nil & hDate \= .nil
  THEN DO
     msg_list[dt_no] = NewDate       /* Replace 'Date:' with new data */
     msg_list~insert(oldDate,dt_no)  /* add the 'Old-Timestamp:' field */
     msg_file~OPEN('WRITE REPLACE')
     msg_file~WriteList(msg_list)    /* Write out the new information */
     msg_File~Close
  END
return hDate     /* Tell caller new adjusted dateTime. */

::CLASS FixTimeZone subclass AdjustTimeStamp public
::method work_org private
  use arg msg_file
  /* Restore date field of *.RCV file to Old-TimeStamp */
  /* returns DateTime object equal to Old-Time on sucess. */

  msg_File~OPEN('READ')
  msg_list = msg_file~MakeList
  msg_File~Close
  yyfix     = 'Fixed:'
  xxfix1    = .nil  /* line to remove if yyfix is found */
  old_dt_no = .nil  /* location of 'Old-TimeStamp:' information */
  dt_no     = .nil  /* location of 'Date:' information */ 
  NewDate   = .nil  /* new data for 'Date:' field */
  hDate     = .nil  /* DateTime object to return to user */
  su        = msg_list~supplier
  do while su~available      /* find info from file header */
     select
       when su~item~length = 0
       then LEAVE  /* Leave when end of header area is reached */
       When su~item~pos(yyfix,1) = 1
       then xxfix1= su~index
       When su~item~pos(self~OldTimeField,1) = 1
       then do
          IF hdate = .nil
          THEN if su~item~words > 5
          THEN DO
             dt    = su~item~SUBSTR(self~OldTimeField~length + 1)~strip('L')
             hDate = ParseDateStr( dt )  /* Parse the Date String */
             NewDate   = self~DateField~' '(dt)
             old_dt_no = su~index
             if dt_no \= .nil
             THEN LEAVE  /* Leave when all the information is found */
          END
       end
       when su~item~pos(self~DateField,1) = 1
       THEN do
          IF dt_no = .nil
          then dt_no = su~index
       end
       OTHERWISE nop  /* other header fields I don't care about */
     end
     su~next
  end
  drop su
  /* Where all the required fields found. */
  if old_dt_no \= .nil & dt_no \= .nil
  THEN DO
     IF xxfix1 \= .nil
     THEN msg_list~REMOVE(xxfix1) /* remove 'Fixed:' line */
     msg_list~REMOVE(old_dt_no)   /* remove 'Old-TimeStamp:' line */
     msg_list[dt_no] = NewDate    /* restore the old date */
     msg_file~OPEN('WRITE REPLACE')
     msg_file~WriteList(msg_list) /* Write out the new information */
     msg_File~Close
  END
return hDate     /* Tell caller new dateTime if Old-TimeStamp was found. */

/* ********************************* */
/* ********************************* */
::ROUTINE Dummy
RETURN
/* ********************************* */
/* ********************************* */
