/* ********************************** */
/*   By: Jetnick Enterprise           */
/*       Don E. Groves, Jr.           */
/*   Contact Information:             */
/*     E-mail: jetnick@erols.com      */
/*        CIS: 71310,3702             */
/* Date: 22 Sep 1996                  */
/* ********************************** */
/* A Text Stream Handler              */
parse source . invhow .
if invhow == 'COMMAND'
THEN DO
   .OUTPUT~LineOut('A simple TextStream class')
END
return 0

::class TextStream Subclass Stream public
::method exist
return (self~query('exist')~length \= 0)
::method IsDir
  work = self~Qualify
  if work~Right(1) = '\' & ( work~Length > 3 | work~Substr(2,1) \= ':' )
  THEN DO
     work = work~''('.')
     forward to (self~Class~New(work))
  END
return (self~QUERY('DateTime')~Length \= 0 & (\ self~Exist))
::method IsFile
return self~Exist
::method Size
return self~QUERY('SIZE')
::method WriteList
   use arg inlist, linend, seed
   if arg(2,'O')
   THEN linend = '0D0A'x
   linend = linend~MakeString
   if arg(3,'O')
   THEN seed = '0A'x
   seed = seed~MakeString
   su = inlist~Supplier
   IF Self~State == 'UNKNOWN'
   THEN Self~OPEN('BOTH')
   IF Self~State \== 'READY'
   THEN Self~OPEN('WRITE')
   count = 0
   do while su~Available & Self~State == 'READY'
      Self~CharOut(su~item~MakeString~''(seed)~changeStr(seed,linend))
      count = count + 1
      su~next
   END
return count   /* returns count of ITEMS written */
::method LineOut
   use arg in, linend, seed
   if arg(2,'O')
   THEN linend = '0D0A'x
   linend = linend~MakeString
   if arg(3,'O')
   THEN seed = '0A'x
   seed = seed~MakeString
return (Self~CharOut(in~MakeString~''(seed)~changeStr(seed,linend)) \= 0)
::method MakeList
  forward to (.txt_list~NEW(Self)) message 'Builder'
::method MakeArray
  forward to (.txt_Arry~NEW(Self)) message 'Builder'

::class txt_Parm
::method msgA Attribute
::method init
  expose who
  use arg who, which
  self~msgA = which
return self
::method Append
  expose who
  use arg what
  NOP
::method Builder
  expose who
  use arg linend, trash
  if arg(1,'O')
  THEN linend = '0A'x     /* end of line (record) marker */
  linend = linend~MakeString
  if arg(2,'O')
  THEN trash = '0D'x     /* remove all of these from the input stream */
  trash = trash~MakeString
  rdSize = 2048   /* read a health buffer size */
  msgData = who~CharIn(,rdSize)
  DO WHILE msgData \== ''
     msgData = msgData~ChangeStr(trash,'')
     IF msgData~pos(linend) \= 0 | who~STATE \== 'READY'
     THEN DO
        DO UNTIL msgData~pos(linend) = 0
           parse value msgData with wrk (linend) msgData
           self~Append(wrk)
        END
     END
     msgData = msgData~''(who~CharIn(,rdSize))
  END
RETURN self~msgA

::class txt_list subclass txt_parm
::method init
  use arg who
  forward class (super) Array (who, .list~new)
::method Append
  use arg what
  self~msgA~Insert(what)

::class txt_Arry subclass txt_parm
::method init
  use arg who
  forward class (super) Array (who, .Array~new)
::method Append
  use arg what
  self~msgA[self~msgA~Items + 1]= what

::class OutTextStream Subclass TextStream public
::method LineOut
  forward class (super) ARRAY (ARG(1), '0D0A'x , '0A'x )
::method WriteList
  forward class (super) ARRAY (ARG(1), '0D0A'x , '0A'x )
::method MakeList
  forward class (super) ARRAY ('0A'x , '0D'x )
::method MakeArray
  forward class (super) ARRAY ('0A'x , '0D'x )

::class RcvTextStream Subclass TextStream public
::method LineOut
  forward class (super) ARRAY (ARG(1), '0A'x , '0A'x )
::method WriteList
  forward class (super) ARRAY (ARG(1), '0A'x , '0A'x )
::method MakeList
  forward class (super) ARRAY ('0A'x , '0D'x )
::method MakeArray
  forward class (super) ARRAY ('0A'x , '0D'x )

/* ********************************* */
/* ********************************* */
