/* SAA-portable REXXTRY procedure     11/08/91  version 1.05
  Owned by IBM SAA REXX Development, Endicott, New York.
    Loosely derived from an ancient formulation of Mike Cowlishaw.

  Modified by Don E. Groves, Jr.
 
  This procedure lets you interactively try REXX statements.
    If you run it with no parameter, or with a question mark
    as a parameter, it will briefly describe itself.
  You may also enter a REXX statement directly on the command line
    for immediate execution and exit.  Example:  rexxtry call show

  Enter 'call show' to see user variables provided by REXXTRY.
  Enter '=' to Display History List of commands entered.
  Enter 'call clearhistory' to clear the history list.
    The REXXTRY .Cmdline object is called 'rexxhistrx'.
  Enter 'call Savehistory' to Save the history list to a file.
  Enter 'call Loadhistory' to Load a file into the history list.
  Enter '?' to invoke system-provided online help for REXX.
  The subroutine named 'sub' can be CALLed or invoked as 'sub()'.
  REXXTRY can be run recursively with CALL.
 
  Except for the signal instructions after a syntax error, this
    procedure is an example of structured programming.
  The 'clear' routine illustrates system-specific SAA-portable coding.
*/
  exposelist='exposelist RC result save trace rexxhistrx sysrx procrx promptrx bordrx siglrx1 siglrx2 argrx prev current REMINDRX'
  parse arg argrx                      /* Get user's arg string.    */
  call house                           /* Go do some housekeeping.  */
  select                               /* 3 modes of operation...   */
   when argrx = '?'
    then call tell    /*   1.  Tell user how.      */
   when argrx = ''
    then do           /*   2.  Interactive mode.   */
      call intro ;
      call main ;
     end
    otherwise
     push argrx ;
     call main   /*   3.  One-liner and exit. */
  end
done:
  exit                            /* The only exit. */
 
house: procedure expose (exposelist)        /* Housekeeping. */
  rexxhistrx = .Cmdline~new(3)
  parse source sysrx . procrx .        /* Get system & proc names.  */
  remindrx = "Enter 'exit' to end."    /* How to escape rexxtry.    */
  helprx=''                            /* Null if not CMS or OS/2.  */
  if sysrx = 'CMS' | sysrx = 'OS/2'    /*   Extra reminder for CMS or OS/2 */
  then helprx = "     Or '?' for online REXX help."   /*   Not used in intro.      */
  promptrx=''                          /* Null if not one-liner.    */
  if argrx<>''
  then promptrx=procrx || ' '    /*   Name part of user line. */
  if sysrx = 'OS/2'
  then do            /* OS/2-specific...          */
    posrx = lastpos('\',procrx)        /*   Find name separator.    */
    procrx = substr(procrx,posrx+1)    /*   Pick up the proc name.  */
  end
  temprx = ' ' || procrx || ' on ' || sysrx     /* Make border...  */
  posrx = 69-length(temprx)          /*   where to overlay name,  */
  bordrx = copies('.',68)            /*   background of periods,  */
  bordrx = overlay(temprx,bordrx,posrx)      /*   name right-adjusted.    */
  save = ''                            /* Don't save user input.    */
  trace = 'Off'                        /* Init user trace variable. */
return result                        /* Preserve result contents. */
 
tell: procedure expose (exposelist)
  call clear ;
  do irx = 1 until sourceline(irx)~left(1) = '*'  /* Tell about rexxtry by */
    say sourceline(irx) ;                         /* displaying the prolog. */
  end
return result               /* Preserve result contents. */
 
clear: procedure expose (exposelist)
  select
   when sysrx = 'OS/2'
    then 'CLS'              /*   OS/400 or TSO.          */
   otherwise
    nop ;
  end ;
  say
return result                        /* Preserve result contents. */
 
intro:   /* Display briefintrodory remarks for interactive mode. */
  procedure expose (exposelist)
  say '  ' || procrx || ' lets you interactively try REXX statements.'
  say '    Each string is executed when you hit Enter.'
          /* How to see description.   */
  say "      Enter 'call tell' for a description of the features."
  say '  Go on - try a few...             ' || remindrx
return result                        /* Preserve result contents. */
 
sub:  /* User can CALL this  subroutine or invoke with 'sub()'.  */
  say "  ...test subroutine 'sub'  ...returning 1234..."
return 1234

clearhistory:  procedure expose (exposelist)
  rexxhistrx~ClearHistory
return result

SaveHistory: procedure expose (exposelist)
  use arg name, mode
  work= 'Rexx.History'
  if ARG(1,'E')
  then work= name~request('string')
  if .nil = work
  then say 'ERROR:: First Argument isnot a .String, objectname=' ARG(1)~ObjectName
  else do
    wmode = 'WRITE'
    if ARG(2,'E')
    then do
      if .nil = mode~request('string')
      then do
        say 'ERROR:: Second Argument isnot a .String, objectname=' mode~ObjectName
        return result
      end
      else do
        if mode~makestring~translate~left(1) = 'R'
        then wmode= wmode~' '('REPLACE')
      END
    END
    work= .Stream~new(work)
    if work~OPEN(wmode)~left(5) = 'READY'
    then do
      su=rexxhistrx~supplier;
      do while su~available;
        work~lineout(su~item);
        su~next;
      end;
    end
    else say work~string || ' reported "' || work~state || '"'
    drop su
    work~close
  end
return result
 
LoadHistory: procedure expose (exposelist)
  name= 'Rexx.History'
  if ARG(1,'E')
  then name= ARG(1)~request('string')
  if .nil = name
  then say 'ERROR:: First Argument isnot a .String, objectname=' ARG(1)~ObjectName
  else do
    work= .Stream~new(name)
    if work~OPEN('READ')~left(5) = 'READY'
    then rexxhistrx~HistoryAdd(work~makearray)
    else say work~string || ' reported "' || work~state || '"'
    work~close
  end
return result

main: /* procedure expose (exposelist)  */
  /* signal on Failure name hsyntax */     /* Enable syntax trap.       */
  signal on syntax name hsyntax                     /* Enable syntax trap.       */
  do foreverrx = 1                     /* Loop forever.             */
    prev = inputrx                     /* User can repeat previous. */
    if argrx <> ''
    then parse pull inputrx                 /* Input keyboard or queue.  */
    else inputrx= rexxhistrx~cmdline
    current = inputrx                  /* Current line for 'show'.  */
    if save <> ''
    then call save inputrx    /* Save before interpreting. */
    if argrx <> '' & inputrx = '='
    then inputrx=prev /* '=' means repeat previous */
      rc = 'X'                       /* Make rc change visible.   */
    select
     when inputrx = '='   /* change = to list history */
      then do
        inputrx= rexxhistrx~supplier  /* get a supplier of the history list */
        do while inputrx~available
          say ' '~''(inputrx~item)
          inputrx~next
        end
        inputrx = '='
      end
     when inputrx = ''    /* If null line, remind      */
      then say ' ' procrx':  ' remindrx helprx     /*   user how to escape.     */
     when inputrx='?'
      then call help  /* Request for online help.  */
     otherwise
      call set2 ; trace (trace)      /* Need these on same line.  */
      interpret inputrx              /* Try the user's input.     */
      trace 'Off'                    /* Don't trace rexxtry.      */
    end
    call border                    /* Go write the border.      */
    if argrx <> '' & queued() = 0  /* For one-liner, loop until */
    then leave                     /*   queue is empty.         */
  end ;
return result                      /* Preserve result contents. */
 
set1:  siglrx1 = sigl              /* Save pointer to lineout.  */
return result                      /* Preserve result contents. */
 
set2:  siglrx2 = sigl              /* Save pointer to trace.    */
return result                      /* Preserve result contents. */
 
save: procedure expose (exposelist)     /* Save before interpreting. */
  USE ARG inputrx
  call set1;rcrx=lineout(save,inputrx)  /* Need on same line.        */
  if rcrx <> 0                          /* Catch non-syntax error    */
  then  say "  Error on save=" || save  /*   from lineout.           */
return result                           /* Preserve result contents. */
 
help: procedure expose (exposelist)
  select                          /* Request for online help.  */
   when sysrx = 'OS/2'             /* Invoke OS/2 online REXX reference. */
    then do
      rc= sysOpenObject("<ORX_INFO>","DEFAULT",1)
      if rc
      then rc= sysOpenObject("<ORX_INFO>","DEFAULT",1)
      else address cmd 'view rexx.inf'
    end
   otherwise                         /* Todate, only CMS and OS/2 */
    do
      say '  'sysrx' has no online help for REXX.'  /*   provide online help  */
      rc = 'Sorry !' ;
    end
  end                         /*   for REXX.               */
  /* call border ; */
return result          /* Preserve result contents. */
 
border: procedure expose (exposelist)      /* Display border.           */
  if rc = 'X'
  then say '  'bordrx
  else say '  ' || overlay('rc = 'rc' ',bordrx)
     /* Show return code if it  has changed.            */
return result                        /* Preserve result contents. */
 
hsyntax:  trace 'Off'                   /* Stop any tracing.         */
  /* procedure expose (exposelist) */
  select
   when sigl = siglrx1
    then do        /* User's 'save' value bad.  */
      say "  Invalid 'save' value'" || save || "', resetting to ''."
      save='' ;
    end
   when sigl = siglrx2
    then do        /* User's 'trace' value bad. */
      say "  Invalid 'trace' value'"trace"', resetting to 'Off'." ;
      trace='Off' ;
    end
   otherwise                          /* Some other syntax error.  */
    do                                /* Show the error msg text.  */
      say '  Oooops ! ... try again. ' || errortext(rc)
                                       /* get the secondary message */ 
      secondary = condition('o')~message 
      if .nil <> secondary then        /* get a real one?           */
                                       /* display it also           */ 
        say '            ' || secondary
    end
  end ;
  call border                    /* Go write the border.      */
  if argrx <> '' & queued() = 0  /* One-liner not finished    */
  then signal done               /*   until queue is empty.   */
signal main                   /* Resume main loop.         */
 
exist: procedure expose (exposelist)
  use arg inrx ;
  outrx = 0           /* Assume file is missing.   */
  address command 'ESTATE' inrx        /* Does the file exist ?     */
  if rc = 0
  then outrx = 1             /* estate says it exists.    */
return outrx                         /* 1 makes condition true.   */
 
show: procedure expose (exposelist)
  trace 'Off' ;
  call clear        /* Display user variables provided by rexxtry.    */
  parse version version                /* Fill-in 2 user variables. */
  parse source source                  /*                           */
  say '  'procrx' provides these user variables.'
  say '  The current values are...'    /* Show current values.      */
  say
  say "    'version'   = '"version"'"  /* What level of REXX.       */
  say "    'source'    = '"source"'"   /* What oper system etc.     */
  say "    'result'    = '"result"'"   /* REXX special variable.    */
  say
  say '     Previous line entered by user.  Initial value=INPUTRX.'
  say "    'prev'      = '"prev"'"     /* Previous user statement.  */
  say "    'current'   = '"current"'"  /* Compare curr with prev.   */
  say
  say "     Save your input with save=filespec. Stop saving with save=''."
  say "    'save'      = '"save"'"     /* Filespec for input keep.  */
  say
  say '     Enter trace=i, trace=o  etc. to control tracing.'
  say "    'trace'     = '"trace"'"    /* Trace user statements.    */
return result                        /* Preserve result contents. */

::requires RexxUtil_Req
::requires cmdline

