/* Reply.cmd */
/* OS/2 Rexx Script for MR/2 ICE */
/* by William H. Geiger III 04 May 96 */
/* Geiger Consulting   */
/* whgiii@amaranth.com */
/* this script will add a Reply To stamp in the message header */
/* for message from a list server */

Argv = .ARRAY_CLI~of(ARG(1), .false, .false) /* parse the arguments */
IF Argv~items > 0
THEN DO
       /* assume first parameter is the name of a *.RCV format file */
   msg_file = .RcvTextStream~new(Argv[1])

      /* read the contents into a List */
   msg_file~OPEN('READ')
   msg_List = msg_file~MakeList
   msg_file~CLOSE

      /* These are the two fieldnames where looking for */
   ySender = 'Sender:'
   yReply  = 'Reply-to:'

   snd=''                  /* sender field data */
   rpl= .nil               /* reply to Location */
   lastHeader = .nil       /* location of last Header line */
   su = msg_list~supplier
   do while su~available
      SELECT
        WHEN su~item~Strip~length = 0
        THEN LEAVE      /* when end of header section is reached */
        WHEN su~item~pos(ySender,1) = 1
        THEN DO
           parse value su~item with . ':' snd
           snd = snd~strip('L')
           if snd~pos('owner-') \= 1
           THEN LEAVE
        END
        WHEN su~item~pos(yReply,1) = 1 & rpl = .nil
        THEN rpl= su~index
        OTHERWISE NOP
      END
      lastHeader = su~index
      su~next
   end
     /* If Sender's name start with 'owner-' we've found one to update */
   if snd~pos('owner-') = 1
   THEN DO
      nReply = yReply~' '(snd~substr(7))
      upDate = .TRUE
      SELECT
        WHEN rpl = .nil
        THEN rpl = LastHeader
        WHEN msg_list[rpl] == nReply
        THEN upDate = .False
        OTHERWISE rpl = msg_List~Previous(rpl)
      END
      IF upDate   /* If not already updated */
      THEN DO
         /* add new/additional Reply-to: field in first postion */
         msg_List~insert(nReply,rpl)

            /* Write the updated contents back to the disk */
         msg_file~OPEN('WRITE REPLACE')
         msg_File~WriteList(msg_list)
         msg_file~CLOSE
      END
   END
     /* Are not OREXX List's easy to deal with */
END
return 0

::requires Array_Cli
::requires TextStream

