/* ********************************* */
/*   By: Jetnick Enterprise          */
/*       Don E. Groves, Jr.          */
/*   Contact Information:            */
/*     E-mail: jetnick@erols.com     */
/*        CIS: 71310,3702            */
/* Date: 22 Sep 1996                 */
/* ********************************* */

/* comment to be forward */
/*  Under Object-REXX and Classic-REXX never load RexxUtil.DLL functions */
/* with 'RxFuncAdd' (except for 'SysLoadFuncs'). As some of them don't */
/* work correctly when you do so. */
/* call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree' */
/*  I also recomend that 'SysDropFuncs' NEVER BE CALLED */

/* Completely rewritten for Object-REXX */

tagmarker      = '****->INSERT TAG HERE<-****'
DateTimeMarker = '****->INSERT DATETIME<-****'
RtCode = 8
Argv = .ARRAY_CLI~of(ARG(1), .false, .false) /* parse the arguments */
IF Argv~items > 0
THEN DO
   msg_filename = Argv[1]  /* get the FileName */
   msgSt = .OutTextStream~new(msg_FileName)
   msgSt~OPEN('READ')
   msgA = msgSt~MakeArray
   msgSt~CLOSE
   su = msgA~Supplier
   found = .list~NEW
   dtno = .nil
   do while su~Available
      IF su~ITEM == tagmarker
      THEN found~insert(su~index)
      ELSE IF su~ITEM == DateTimeMarker
      THEN dtno = su~INDEX   /* find the last DateMarker only */
      su~NEXT
   END
   if Found~items > 0 | dtno \= .nil
   THEN DO
      su = Found~Supplier
      do while su~Available
         msgA[su~item] = .GetTagLine~LineFeed('ooRexx Mr2Tag -> ')
         su~NEXT
      end
      IF dtNo \= .nil
      THEN msgA[dtNo] = 'Tagged on:'~' '(.MyTimeZone~MakeString)
      msgSt~OPEN('WRITE REPLACE')
      msgSt~WriteList(msgA)
      msgSt~CLOSE
   END
   RtCode = 0
END
return RtCode

/* ********************************* */
::requires TextStream
::requires GetTagLine
::requires Array_Cli
::requires MyTimeZone

/* ********************************* */

