/* ********************************* */
/*   By: Jetnick Enterprise          */
/*       Don E. Groves, Jr.          */
/*   Contact Information:            */
/*     E-mail: jetnick@erols.com     */
/*        CIS: 71310,3702            */
/* Date: 04 Sep 1996                 */
/* ********************************* */
/* public Classes and Routines       */
/* .GetTagLine   a Tagline generator */
/* GetTagLine()  a Tagline generator */
/* ******************************************************** */
/* Works either as an External Function or ::Requires file  */
/* ******************************************************** */
parse source . invhow myName
RtCode = 0
.local~TagsHome = 'H:\HomeOfTagLines\*.tag'
SELECT
 WHEN invhow == 'FUNCTION'
  THEN RtCode = GetTagLine()
 WHEN invhow == 'COMMAND'
  THEN DO
     .OUTPUT~LineOut('----- Sample TagLine -----')
     IF arg(1)~length \= 0
     THEN DO
        tag = .GetTagLine~TagLine
        .OUTPUT~LineOut('-- At:'~' '(tag~fnam))
        rpt = tag~TheTag
        sep = rpt~LEFT(1)
        rpt = rpt~Substr(2)
        do until rpt == ''
           parse value rpt with rec (sep) rpt
           .OutPut~LineOut(('parse   -> ')~''(rec))
        end

        .OUTPUT~LineOut('  ----- Sample TagLine MakeArray -----')
        su = .GetTagLine~MakeArray~Supplier
        do while su~Available
           .output~LINEOUT('Mkarray ->'~' '(su~item))
           su~Next
        END

        .OUTPUT~LineOut('  ----- Sample TagLine LINEFeed -----')
        rpt = .GetTagLine~LineFeed('LineFeed-> ') /* ~''('0A'x) */
        do until rpt == ''
           parse value rpt with rec '0A'x rpt
           .OutPut~LineOut(rec)
        end

        .OUTPUT~LineOut('  ----- Sample TagLine LINEFeed through CharOut -----')
        .OutPut~CharOut(.GetTagLine~LineFeed('LineFeed-> ')~''('0A'x))

        .OUTPUT~LineOut('  ----- Sample TagLine MakeString -----')
        .OUTPUT~LineOut(.GetTagLine~MakeString)

        .OUTPUT~LineOut('  ----- Sample TagLine MakeString formatted to CharOut -----')
        .OutPut~CharOut(.GetTagLine~MakeString(('0A'x)~''('MakeStr -> '))~SubStr(2)~''('0A'x))

        .OUTPUT~LineOut('  ----- Sample TagLine MakeString Parse to LineOut -----')
        rpt = .GetTagLine~MakeString
        sep = rpt~LEFT(1)
        rpt = rpt~Substr(2)
        do until rpt == ''
           parse value rpt with rec (sep) rpt
           .OutPut~LineOut(('MString -> ')~''(rec))
        end
     END
     ELSE .OutPut~CharOut(.GetTagLine~LineFeed(' -> ')~''('0A'x))
     .OUTPUT~LineOut('----- End of Sample -----')
     .OUTPUT~LineOut('Tag file are located by: ['~''(.local~TagsHome)~''(']'))
  END
 WHEN invhow == 'SUBROUTINE'
  THEN nop  /* happens when '::requires GetTagLine' or 'call GetTagLine' is used */
 OTHERWISE
   nop /* I've no idea, but then maybe everything will work out ok anyway. */
END
Return RtCode

::requires RexxUtil_REQ
::requires TextStream

::class TagLine_Base
::method init
  expose theTag fnam
  use arg theTag, fnam
return self
::method fnam
  expose theTag fnam
  forward to (fnam) message 'MakeString'
::method theTag
  expose theTag fnam
  rpt = TheTag
  if ARG(1,'E')
  THEN rpt = rpt~ChangeStr(rpt~Left(1),ARG(1))
  forward to (rpt) message 'MakeString' Arguments ( .Array~NEW )

::class TagLine subclass TagLine_Base
::method UNKNOWN
  use arg cMsg, ARGS
  forward to (Self~theTag) message (cMsg) arguments (ARGS)
::method String
  forward message 'TheTag'
::method MakeString
  forward message 'String'
::method TagLine          /* Return a NEW TagLine */
  forward to (.gRanDom)
::method MakeTagLine      /* copy myself */
  forward to (Self~Class) message 'NEW' Array (self~theTag, self~fnam)
::method MakeArray
  ar = .Array~NEW
  rpt = Self~TheTag
  sep = rpt~LEFT(1)
  rpt = rpt~Substr(2)
  do until rpt == ''
     parse value rpt with rec (sep) rpt
     ar[ar~size+1] = rec
  end
  return ar
::method LINEFeed
  forward to (Self~MakeString(('0A'x)~''(ARG(1)))) message 'SubStr' Array (2)

::Class GetTagLine public
::method init class
return self
::method init
return self
::method NEW
  forward to (self~Class)
::method TagLine CLASS
  forward to (.gRanDom)
::method TagLine
  forward to (self~Class)
::method MakeTagLine CLASS
  forward message 'TagLine'
::method MakeTagLine
  forward to (self~Class)
::method UNKNOWN CLASS
  use arg cMsg, ARGS
  forward to (self~TagLine) message (cMsg) ARGUMENTS ( ARGS )
::method UNKNOWN
  forward to (self~Class)
::method String     CLASS
  forward message 'UNKNOWN' ARRAY ( 'STRING', ARG(1,'A'))
::method String
  forward to (self~Class)
::method MakeString CLASS
  forward message 'UNKNOWN' ARRAY ( 'MAKESTRING', ARG(1,'A'))
::method MakeString
  forward to (self~Class)


::Class gRanDom       /* a Random Randomizer */
::method init class
  expose seed filtertt
  seed = (Time('S') // Date('B') * 199) % 3
  IF seed = 0
  THEN  seed = ((random(50,500) * 1237) // Date('B') * 199) % 3
  /* filter out all but valid ASCII range */
  filtertt = '.'~COPIES(32)~''(XRANGE('20'X, '7E'X))~''('.'~COPIES(128))
return self
::method RD private class
  expose seed filtertt
  use arg low, high
  q = (((Time('S')+1) * seed) // Date('B') * 199) % 3
  IF q = 0
  THEN  q = ((random(50,500) * 1237) // Date('B') * 199) % 3
  IF seed \= q
  THEN DO
     seed = q
     q = Random(low,high,q)
  END
  ELSE q = Random(low,high)
return q
::method Filter private class
  expose seed filtertt
  use arg wr
return (wr~TRANSLATE(filtertt) == wr)
::method TagLine CLASS
  expose seed filtertt
  tag = ''
  fnam = 'NO FILES FOUND'
  call SysFileTree .local~TagsHome, 'files.', 'OF'
  DO While tag~length = 0 & files.0 > 0
     rnd = Self~RD(1, files.0)
     tf = ''
     do i = rnd to files.0 while tf~length = 0
        tf = files.i
        files.i = ''
     END
     IF tf~length = 0
     THEN DO
        files.0 = rnd - 1
        ITERATE
     END
     tf = .TextStream~NEW(tf)
     fnam = tf~Qualify
     tf~OPEN('READ')
     tagA = tf~MAKEARRAY
     tf~CLOSE
     IF tagA~items > 0
     THEN DO
        items = tagA~items
        low = Self~RD(1, items)
        Do TagA~items until tag~length \= 0 & items > 0
           wr = ''
           do i = low to items until wr~length > 0
              wr = tagA~AT(i)
           end
           if wr~length > 0
           THEN DO
              IF self~Filter(wr)
              THEN tag = wr
              ELSE DO
                 TagA[i] = ''
                 low = Self~RD(1, items)
              END
           END
           else items = low - 1
        END
     END
     ELSE DO
        tag = tag~''("** ERROR ** Somebody stoled the Tag file Data. **`")
        tag = tag~''("** ERROR ** That belong in the file: **`")
        tag = tag~''("** ERROR ** [")~''(tf~Qualify)~''("] **`")
        tag = tag~''("** ERROR ** Put it back, NOW. **")
     END
  END
  if files.0 = 0 & tag~length = 0
  THEN DO
     tag = tag~''("** ERROR ** Somebody stoled the Tag files. **`")
     tag = tag~''("** ERROR ** They belong at **`")
     tag = tag~''("** ERROR ** [")~''(.local~TagsHome)~''("] **`")
     tag = tag~''("** ERROR ** Put them back, NOW. **")
  END
forward to (.TagLine) message 'NEW' array ('`'~''(tag),fnam)

::ROUTINE GetTagLine public
return .GetTagLine~TagLine

/* ********************************* */
