/* ********************************* */
/*   By: Jetnick Enterprise          */
/*       Don E. Groves, Jr.          */
/*   Contact Information:            */
/*     E-mail: jetnick@erols.com     */
/*        CIS: 71310,3702            */
/* Date: 20 Sep 1996                 */
/* ********************************* */

parse source . invhow myName
RtCode = 0
if invhow == 'COMMAND'
THEN DO
   RtCode = 1
   Argv = .ARRAY_CLI~of(ARG(1), .false, .false) /* parse the arguments */
   if Argv~items > 0
   THEN DO
      name = Argv[1]     /* get path to folder */
      msg = .Load_Msg~new(name)
      if msg~Good
      THEN DO
         fMsg = .Forward_Msg~NEW(msg,'jetnick@erols.com (Don E. Groves, Jr.)')
         tmpName = 'ErrorsTo.RCV'
         fh = .Stream~new(tmpName)
         fh~Open('WRITE REPLACE')
         su = fMsg~Supplier
         do while su~Available
            fh~LineOut(su~item)
            su~next
         END
         fh~CLOSE
         address CMD 'mr2i.exe /Q'~''(tmpName)
      END
      RtCode = 0
   END
END
Return RtCode

::requires Array_Cli
::requires MyTimeZone

::class Forward_Msg
::method init
  expose FlC
  use arg msg, FromName
  FlC = .List~NEW
  Flc~insert('From:'~' '(FromName))
  Flc~insert('Reply-to:'~' '(msg~replyTo))
  Flc~insert('Date:'~' '(.MyTimeZone))
  Flc~insert('To:'~' '(msg~msgTo))
  Flc~insert('Subject:'~' '(msg~Subject))
  Flc~insert('')
  Flc~insert('')
  Flc~insert('-------------------------------------------------------------------------')
  Flc~insert('The following message is forwarded to you by'~' '(FromName))
  Flc~insert('(listed as the From user of this message).')
  Flc~insert('The original sender (see the header, below) was'~' '(msg~replyTo))
  Flc~insert('and has been set as the "Reply-To" field of this message.')
  Flc~insert('-------------------------------------------------------------------------')
  su = msg~Supplier
  do while su~Available
     Flc~insert(su~item)
     su~next
  END
  Flc~insert('-------------------------------------------------------------------------')
  Flc~insert('-- End of forwarded message')
  Flc~insert('-------------------------------------------------------------------------')
  Flc~insert('')
  Flc~insert('--')
  Flc~insert('-----------------------------------------------------')
  Flc~insert(FromName)
  Flc~insert('-----------------------------------------------------')
  Flc~insert('****->INSERT DATETIME<-****')
  Flc~insert('****->INSERT TAG HERE<-****')
return self
::method FlC
  expose FlC
return Flc
::method Supplier
  expose FlC
return Flc~Supplier

::class Load_Msg
::method msgTo   Attribute
::method replyTo Attribute
::method Subject Attribute
::method Good Attribute
::method init
  expose msg
  use arg name
  self~Good    = .false
  self~msgTo   = .nil
  self~replyTo = .nil
  self~Subject = .nil
  fh = .Stream~NEW(name)
  fh~OPEN('READ BINARY')
  msgdata = fh~CharIn(1, fh~Query('SIZE'))
  fh~Close
  drop fh
  msg = .Array~New
  DO WHILE msgData \= ''
     wrk = ''
     parse value msgData with wrk '0A'x msgData
     msg[msg~Items + 1] = wrk~ChangeStr('0D'x,'')
  end
  drop msgdata
  su = msg~Supplier
  x = 0
  do while su~Available
     select
       when su~item~length = 0
       then LEAVE  /* Leave when end of header is reached */
       When su~item~pos('From:',1) = 1
       THEN DO
          self~replyTo = su~item~SUBSTR(su~item~pos(':') + 1)~strip('L')
          x = x + 1
       END
       When su~item~pos('Subject:',1) = 1
       THEN DO
          self~Subject = su~item~SUBSTR(su~item~pos(':') + 1)~strip('L')
          x = x + 1
       END
       otherwise nop
     end
     su~next
  end
  if x = 2
  THEN DO
    /* Search the body for the Errors-to: string */
    do while su~Available
      IF su~item~pos('Errors-to:',1) = 1
      THEN DO
         self~msgTo = su~item~SUBSTR(su~item~pos(':') + 1)~strip('L')
         x = x + 1
         LEAVE
       END
       su~next
    end
  end
  self~good = ( x = 3 )
return self
::method Supplier
  expose msg
return msg~Supplier


