/* ********************************************************************* */
/*   By: Jetnick Enterprise                                              */
/*       Don E. Groves, Jr.                                              */
/*   Contact Information:                                                */
/*     E-mail: jetnick@erols.com                                         */
/*        CIS: 71310,3702                                                */
/* Date: 17 Sep 1996                                                     */
/* ********************************************************************* */
/* public Classes and Routines                                           */
/*  .DateTime                Easy way to pass Date and Time as a unit    */
/*  .Elasp_Time              A simple Elapsed time timer.                */
/*  .Clock         Factory for producing current DateTime objects.       */
/* ********************************************************************* */
/* This file is primary intented use is as a ::REQUIRES type file.       */
/* ********************************************************************* */
/*  General Documentation for other Programmer type Users                */
/*                                                                       */
/*   Some Simple Adveration:                                             */
/* N         = Number                                                    */
/* S         = Character or String                                       */
/* DS        = Date String same formatted as produced by the             */
/*             built in DATE('N') function                               */
/* TS        = Time String same formatted as produced be the             */
/*             built in TIME('N') function                               */
/* NTS       = Number of Seconds since '1 Jan 1970 00:00:00'             */
/* DT        = DateTime Object {described below}                         */
/* ********************************************************************* */
/*                                                                       */
/*  Class DateTime                                                       */
/*     Inherates all methods from The Object class.                      */
/*     Objects of this type are useful for passing the Date/Time         */
/*     around  as a unit.  {Pass by value only type object}              */
/*   Public Methods:                                                     */
/*     SecPerDay      Returns number of Seconds in a day                 */
/*     NTS_Base       Return the beginning of TIME <G> Base              */
/*                     currently set to DATE('B','1 Jan 1970','N')       */
/*                                                                       */
/*     INIT( )       Parameters: (optional one of the following)         */
/*            DS, TS   { Date('N') and TIME('N') strings}                */
/*            DT       { another DateTime object }                       */
/*            NTS      { Number of Seconds since '1 Jan 1970 00:00:00' } */
/*                    If No parameters then uses current Date and Time   */
/*                                                                       */
/*     NTS       returns Number of second since  NTS_Base date.          */
/*                                                                       */
/*     compareBy return NTS useful in generic sorts and compares.        */
/*                                                                       */
/*     Elapsed_Seconds       returns number of seconds to/from now       */
/*                   positive means Object is older then now.            */
/*                                                                       */
/*     Date    Parameters:                                               */
/*          (optional same as first parameter to built in DATE())        */
/*          returns Object's DATE value in format requested.             */
/*                                                                       */
/*     DOW     Parameters: NONE                                          */
/*          returns 0 - 6  for Day of week 0= Sunday                     */
/*                                                                       */
/*     Time   Parameters:                                                */
/*          (optional same as first parameter to built in TIME())        */
/*       Returns: Object's TIME value in format requested.               */
/*                                                                       */
/*     Adjust   Parameters: (optional)                                   */
/*          N   { Number of seconds to adjust }                          */
/*                Positive Forwards                                      */
/*                Negitive Backwards.                                    */
/*                Defaults to Zero                                       */
/*       Returns: New DateTime object equal to Current plus Adjustment.  */
/*                                                                       */
/*      +      Parameter:                                                */
/*          N   { Number of seconds to adjust }                          */
/*       Returns: New DateTime object equal to Current plus Adjustment.  */
/*                                                                       */
/*      -      Parameter:                                                */
/*          N   { Number of seconds to adjust }                          */
/*       Returns: New DateTime object equal to Current minus Adjustment. */
/*                                                                       */
/*     String   Parameters: (none)                                       */
/*       Returns:  Date and Time in Message Date format.                 */
/*                                                                       */
/*     MakeString    same as String method.                              */
/*                                                                       */
/*     MakeDateTime   Parameters: (none)                                 */
/*       Returns: New copy of DateTime object equal to current object.   */
/*                                                                       */
/* ********************************************************************* */
/*                                                                       */
/*    Class Clock a DateTime Producer, a factory iows.                   */
/*      This is a Factory for creating 'DateTime' objects, with the      */
/*      current Date and Time. Clock objects themself remain running.    */
/*     All CLASS members are also Instances methods.                     */
/*                                                                       */
/*      Inherates all methods from DateTime class, except all methods    */
/*     information returned is based on the current date and time.       */
/*                                                                       */
/*     MakeDateTime                                                      */
/*       Parameters: (none)                                              */
/*       Returns: New DateTime object equal to current Current DateTime. */
/*                                                                       */
/* ********************************************************************* */
/*                                                                       */
/*    Class Elasp_Time a subclass of DateTime public                     */
/*      Inherates all methods from DateTime.                             */
/*      Overrides                                                        */
/*     String   Parameters: (none)                                       */
/*       Returns: A formatted string equal to the Age of the object.     */
/*                                                                       */
/* ********************************************************************* */
/*  All other classes defined in this file arenot visable outside of it. */
/* ********************************************************************* */
/*                                                                       */
/* ********************************************************************* */
/* ********************************************************************* */
parse source . invhow myname
if invhow == 'COMMAND'
THEN DO
   SAY .Clock
END
return 0

::class DateTime_Const       /* Seperating these constants out saves     */
::method init class          /* running though this 5+ additional times. */
  expose NTS_Base SecPerDay
  NTS_Base  = DATE('B','1 Jan 1970','N')
  SecPerDay = 86400
return self
::method SecPerDay class     /* number of Seconds in a day */
  expose NTS_Base SecPerDay
forward to (SecPerDay) message 'MakeString'
::method NTS_Base  class     /* The Date part of the beginning of TIME */
  expose NTS_Base SecPerDay
forward to (NTS_Base) message 'MakeString'

  /* the common private base of all DateTime type objects */
::class DateTime_Root
::method init
return self
::method init class
return self
    /* Give access to DateTime Constant Data */
::method SecPerDay class  /* number of Seconds in a day */
  forward to (.DateTime_Const)
::method SecPerDay        /* Give instances the same access. */
  forward to (.DateTime_Const)
   /* nts = ( DATE('B') - Nts_Base ) * SecPerDate + Time('S') */
::method NTS_Base  class  /* The Date part of the beginning of TIME */
  forward to (.DateTime_Const)
::method NTS_Base         /* Give instances the same access. */
  forward to (.DateTime_Const)

  /* the common private base of all DateTime instance type objects */
::class DateTime_Base subclass DateTime_Root
::method init
  expose nts
  use arg inDate, inTime
  forward continue class (super)
  if arg() = 1 /* If only one argument then */
  THEN DO
     nts = inDate~Request('DateTime')
     IF nts \= .nil
     THEN nts = nts~nts
     ELSE IF inDate~datatype('W')      /* if Numeric */
     THEN nts = inDate~MakeString      /* then assume NTS value */
     ELSE RAISE syntax 93.904 array(1,indate)
  END
  ELSE DO
     nts = TIME('S',inTime) + ((DATE('B',inDate) - self~NTS_Base ) * self~SecPerDay )
     if ARG() > 2  /* optional Adjustment Amount in seconds */
     THEN nts = nts + ARG(3)
  END
  if nts < 0
  then nts = 0  /* handle before the beginning of time condition. */
return self
::method NTS
  expose nts
   /* Simply put, for current date the nts is           */
   /* ( DATE('B') - Nts_Base ) * SecPerDate + Time('S') */
forward to (nts) message 'MakeString'

  /* Objects of this type are useful for passing the Date/Time around */
::class DateTime subclass DateTime_BASE public
::method init
  if arg() = 0  /* default to current date and time */
  THEN forward class (super) ARRAY ( DATE(), TIME())
  ELSE forward class (super)
::method Elapsed_Seconds    /* returns number of seconds to/from now */
forward to (.Clock~NTS - self~NTS) message 'MakeString'
::method Date
  use arg how
  if ARG() = 0
  then how = 'N'
return Date(how,((self~nts % self~SecPerDay) + self~NTS_Base),'B')
::method Dow   /* Sunday = 0, Monday=1, ... , Saturday=6 */
return (1 + ((self~nts % self~SecPerDay) + self~NTS_Base) // 7) // 7
::method Time
  use arg how
  if ARG(1,'O')
  then how = 'N'
return TIME(how,(self~nts // self~SecPerDay),'S')
::method Adjust
  use arg phrs
  wrk = self~NTS
  IF ARG(1,'E')
  THEN wrk = wrk + phrs
forward to (.DateTime) message 'new' Array (wrk)
::method String
  dt = self~DATE
return DATE('W',dt)~SUBSTR(1,3)~''(',')~' '(DATE('N',dt)~RighT(11))~' '(self~TIME('N'))
::method MakeString
  forward message 'String'
::method MakeDateTime
forward to (.DateTime) message 'new' Array (self~NTS)
::method compareBy
  forward message 'NTS'
::method '+'
  forward message 'Adjust'
::method '-'
  use arg phrs
  IF ARG(1,'O')
  THEN phrs = 0
  forward message 'Adjust' ARRAY ( -1 * phrs )


  /* A handy Elapsed Time Timer with nice String display */
::class Elasp_Time subclass DateTime public
::method String
  sttime = .Clock~MakeDateTime
  elps = stTime~NTS - self~NTS
  if elps < 0
  then DO  /* Handle TIME NOW is before condition. <G> */
     elps = elps~ABS
     rtCode = (elps % self~SecPerDay)~' '('days,')~' '(TIME('N',(elps // self~SecPerDay),'S'))~' '('Until:')~' '(self~String:super)
  END
  ELSE rtCode = sttime~String~' '('Elasped Time:')~' '(elps % self~SecPerDay)~' '('days,')~' '(TIME('N',(elps // self~SecPerDay),'S'))
return rtCode
::method MakeElasp_Time
forward to (.Elasp_Time) message 'new' Array (self~NTS)


 /* This is a Factory for creating 'DateTime' objects, */
 /* with the current Date and Time. */
 /* Clock objects themself remain running. */
::class Clock subclass DateTime_Root Public

::method MakeDateTime class
return .DateTime~NEW
::method MakeDateTime
  forward to (self~class)

::method UNKNOWN  CLASS
  use arg cMsg, ARGS
  /* Create a 'DateTime' and let the resulting object handle */
  /* all other messages. */
  forward to (self~MakeDateTime) message (cMsg) ARGUMENTS (ARGS)
::method UNKNOWN             /* Make instances look the same */
  forward to (self~class)

::method String CLASS
  forward message 'UNKNOWN' ARRAY ( 'STRING', ARG(1,'A'))
::method String              /* Make instances look the same */
  forward to (self~class)

::method MakeString CLASS
  forward message 'UNKNOWN' ARRAY ( 'MAKESTRING', ARG(1,'A'))
::method MakeString          /* Make instances look the same */
  forward to (self~class)

::method NEW                 /* Make instances look the same */
  forward to (self~Class)

::routine Clock public
return .clock

/* ********************************* */
/* ********************************* */

