/* ******************************************************************* */
/* Copyright:                                                          */
/*   By: Jetnick Enterprise                                            */
/*       Don E. Groves, Jr.                                            */
/*       6313 Cider Barrell Ctr.                                       */
/*       Centreville, VA 22020                                         */
/*   Contact Information:                                              */
/*     E-mail: jetnick@erols.com                                       */
/*        CIS: 71310,3702                                              */
/*                                                                     */
/*                                                                     */
/* ******************************************************************* */
/*  Array_CLI.cmd */
/* Command Line Interpreter class */

parse source . a2 .
atRc= 0
SELECT
 WHEN a2 = 'FUNCTION'
  THEN atRc = .ARRAY_CLI~of(ARG(1),ARG(2),ARG(3))
 WHEN a2 = 'COMMAND'
  THEN do
    say 'used as a ' || a2
    say 'Test Array_CLI'
    say 'Args are: ' || ARG(1)
    Argv = .ARRAY_CLI~of(ARG(1), .true, .true)
    sArgv = Argv~supplier

    do while sArgv~Available
      say sArgv~index || ' >' || sArgv~item || '< >' || Argv[sArgv~index]
      if sArgv~item~substr(1,1) = '/'
      then Argv~remove(sArgv~index)
      sArgv~next
    end
    if Argv~first \= .nil
    then say  "Argv's first item is >" || Argv~AT(Argv~first) || "<"

    Argv = Argv~makearray
    sArgv = Argv~supplier
    do while sArgv~Available
      say sArgv~index || ' >' || sArgv~item || '< >' || Argv[sArgv~index]
      sArgv~next
    end
  end
 WHEN a2 = 'SUBROUTINE'
  THEN nop
 OTHERWISE
   nop
end
return atRc

::class ARRAY_single subclass list
::method of class
  use arg args
  data = .Array_single~new
  DO WHILE args \= ''
    data~insert(args~left(1))
    args= args~substr(2)
  end
return data

::class ARRAY_CLI subclass Array public
::method of class
  args = .ARRAY_single~of(ARG(1)~strip)~supplier
  savequotes = (ARG(2) = '1')
  nilargs = (ARG(3) = '1')
  data = Self~new
  single_quote= "'"
  double_quote= '"'
  index = 1
  save = .false
  targv = ''
  quote_state = .nil
  devider = .nil
  endarg = .false
  DO WHILE args~available
    c = args~item
    args~next
    Select
     when c == quote_state
     then do
       save = .true
       IF args~available  /* Handle the case of Two Quotes in a row. */
       THEN do
         if args~item == c
         then do
           targv= c~insert(targv)
           args~next
           IF savequotes
           THEN targv= c~insert(targv)
           save = .false
         end
       end
       if save
       then do
         IF savequotes
         then targv= c~insert(targv)
       end
     end
     /*  Are we in Quote State if so save the character */
     when quote_state \= .nil then targv= c~insert(targv)
     /* Is it the start of quotes state */
     when double_quote = c | single_quote = c
     then do
       if savequotes
       then targv= c~insert(targv)
       quote_state = c
       devider = c
     end
     /* if not in quotestate and not a space or comma the save */
     when ' ,'~pos(c) = 0 then targv= c~insert(targv)
     otherwise do
       /* must be a space or a comma not within quotes */
       if \ endarg
       then do
          save = .true
          if ' ' == c
          then do
             if targv~length = 0
             then save = .false
          end
          else if c \= devider
          then do
             if targv~length = 0
             then IF \ nilargs THEN save = .false
          end
       end
       devider = c
     end
    End
    endarg = save
    if save | \ args~available
    then do
      if quote_state == .nil
      then targv = targv~strip
      IF ( targv~length \= 0 ) | nilargs
      then do
        data~put(targv,index)
        index= index + 1
      end
      targv = ''
      save= .false
      quote_state = .nil
    end
  END
return data

::class ARRAY_ARGS subclass Array public
::method of class
  data = .Array_ARGS~new
  index = 1
  do i= 1 to ARG()
    parm1 = ARG(i)
    d = parm1~request('ARRAY')
    if d = .nil
    then do
      data~put(parm1,index)
      index= index + 1
    end
    else do
      do current = 1 to d~items
        data~put(d[current],index)
        index= index + 1
      end
    end
  end
return data

