/*  Mike Cowlishaw's Server-side includes parser, excerpted from GoRemote.80.   */
/*  ...slightly modified by D.L. Meyer...			*/

/*  Upon call from GoHTTP.v20, the current directory will have been changed 	*/
/*   to the REXX script directory.   Subsequent calls to scripts located there 	*/
/*   need not change directory...				*/

/* ---------------------------------------------------------------- */
/* DOINCL: process a block of html for server-side includes   */
/* ---------------------------------------------------------------- */
/* ARG(1) is block of data                                 */
/*DoIncl: procedure		*/
  parse arg data
  out=''                                     /* result */
  do forever
    parse var data pre '{' expr '}' data     /* find expression */
    out=out''pre                             /* pre-stuff */
    if expr='' then if data='' then leave    /* no more '{' */
    out=out''eval(expr, '')             /* add evaluation */
    end
  return out                                  /* [called as function] */

/* ---------------------------------------------------------------- */
/* EVAL: return an expression evaluation [protected]                */
/* ---------------------------------------------------------------- */
/* ARG(1) is expression to evaluate                                 */
/* ARG(2) is passed from PAGE, usually an arbitrary text message    */
/* An expression starting with '?' is a direct EXTRACT, special-    */
/* cased for simplicity.  ({?foo} == {extract(foo)})                */
eval: procedure                         /* no variables visible */
  if left(strip(arg(1)),1)='?' then return extract(substr(strip(arg(1)),2))
  /* arbitrary expression expected -- assume CRLF and tabs are whitespace */
  signal on syntax name evaloops                       /* handle errors */
  interpret 'result='translate(arg(1),' ','0d0a09'x)   /* evaluate */
  return result                                        /* done */

evaloops: return '[?]'

/* ---------------------------------------------------------------- */
/* IF: select string based on ARG(1)                                */
/* ---------------------------------------------------------------- */
/* Rather like C's "?" operation */
if: if arg(1) then return arg(2); else return arg(3)

/* ---------------------------------------------------------------- */
/* QFLAG:  return 'checked' for a flag that's ON,  null otherwise   */
/* QFLAGN: return 'checked' for a flag that's OFF, null otherwise   */
/* ---------------------------------------------------------------- */
qflag:  if extract(arg(1))='ON'  then return 'checked'; else return ''
qflagn: if extract(arg(1))='OFF' then return 'checked'; else return ''

/* ---------------------------------------------------------------- */
/* GMTWARN: return warning if GMT unavailable, null otherwise       */
/* ---------------------------------------------------------------- */
gmtwarn: if extract('GMTSET')='ON' then return ''
return '[TZ was not set - GMT is <strong>not</strong> available]'

